/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.navigation.OCGotoActionSync;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoRelatedSymbolActionSync
extends OCGotoActionSync<OCSymbolDeclarator<?>> {
    private @NlsContexts.PopupTitle String myPopupTitle = OCBundle.message("action.CIDR.Lang.goto.definition.declaration", new Object[0]);
    private @NlsContexts.Tooltip String myTooltip = OCBundle.message("action.CIDR.Lang.goto.definition.declaration.tooltip", new Object[0]);

    public OCGotoRelatedSymbolActionSync(@NotNull OCSymbolDeclarator<?> element) {
        super(element, CidrLangIcons.AssocFile);
    }

    @Override
    @NotNull
    public String getTooltip() {
        return this.myTooltip;
    }

    @Override
    @NotNull
    public String getPopupTitle() {
        return this.myPopupTitle;
    }

    @NotNull
    protected List<OCSymbol> evaluateTargets(@NotNull OCSymbolDeclarator<?> source) {
        Object symbol = source.getSymbol();
        Project project = source.getProject();
        OCSymbol relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol, project);
        List relatedSymbols = symbol instanceof OCStructSymbol ? OCSearchUtil.getRelatedSymbols((OCStructSymbol)symbol, true, project) : Collections.emptyList();
        this.updatePopupTitleAndTooltip((OCSymbol)symbol, relatedSymbol, relatedSymbols, project);
        return relatedSymbols.isEmpty() ? ContainerUtil.createMaybeSingletonList((Object)relatedSymbol) : relatedSymbols;
    }

    private void updatePopupTitleAndTooltip(@Nullable OCSymbol symbol, @Nullable OCSymbol relatedSymbol, @NotNull List<OCSymbol> relatedSymbols, @NotNull Project project) {
        if (!relatedSymbols.isEmpty()) {
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name1", new Object[0]);
            this.myTooltip = OCBundle.message("goto.related.symbol.name1.tooltip", new Object[0]);
        } else if (symbol == null || relatedSymbol == null) {
            this.myPopupTitle = OCBundle.message("goto.symbol", new Object[0]);
            this.myTooltip = OCBundle.message("goto.symbol", new Object[0]);
        } else if (relatedSymbol.getKind().isClass()) {
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name2", relatedSymbol.getKind().getNameLowercase(), relatedSymbol.getName());
            this.myTooltip = OCBundle.message("goto.related.symbol.name2.tooltip", relatedSymbol.getKind().getNameLowercase(), relatedSymbol.getName());
        } else if (relatedSymbol instanceof OCStructSymbol && relatedSymbol.isPredeclaration()) {
            String relatedSymbolNameWithKindLowercase = relatedSymbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project));
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name3", relatedSymbolNameWithKindLowercase);
            this.myTooltip = OCBundle.message("goto.related.symbol.name3.tooltip", relatedSymbolNameWithKindLowercase);
        } else if (relatedSymbol.getKind() == symbol.getKind()) {
            String relatedSymbolNameWithKindLowercase = relatedSymbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project));
            if (relatedSymbol.isDefinition()) {
                this.myPopupTitle = OCBundle.message("goto.related.symbol.name4", relatedSymbolNameWithKindLowercase);
                this.myTooltip = OCBundle.message("goto.related.symbol.name4.tooltip", relatedSymbolNameWithKindLowercase);
            } else {
                this.myPopupTitle = OCBundle.message("goto.related.symbol.name5", relatedSymbolNameWithKindLowercase);
                this.myTooltip = OCBundle.message("goto.related.symbol.name5.tooltip", relatedSymbolNameWithKindLowercase);
            }
        } else {
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name6", new Object[]{relatedSymbol.getKind()});
            this.myTooltip = OCBundle.message("goto.related.symbol.name6.tooltip", new Object[]{relatedSymbol.getKind()});
        }
    }
}

