/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage;", "", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "Attribute", "None", "intellij.c"})
public interface ModuleMapSerializationStorage {
    @NotNull
    public OutputStream getOutputStream();

    @NotNull
    public InputStream getInputStream();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage$Attribute;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "attribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/newvfs/FileAttribute;)V", "getAttribute", "()Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.c"})
    public static final class Attribute
    implements ModuleMapSerializationStorage {
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final FileAttribute attribute;

        public Attribute(@NotNull VirtualFile virtualFile, @NotNull FileAttribute attribute2) {
            this.virtualFile = virtualFile;
            this.attribute = attribute2;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final FileAttribute getAttribute() {
            return this.attribute;
        }

        @Override
        @NotNull
        public OutputStream getOutputStream() {
            return (OutputStream)this.attribute.writeFileAttribute(this.virtualFile);
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            AttributeInputStream attributeInputStream = this.attribute.readFileAttribute(this.virtualFile);
            return attributeInputStream != null ? (InputStream)attributeInputStream : InputStream.nullInputStream();
        }

        @NotNull
        public final VirtualFile component1() {
            return this.virtualFile;
        }

        @NotNull
        public final FileAttribute component2() {
            return this.attribute;
        }

        @NotNull
        public final Attribute copy(@NotNull VirtualFile virtualFile, @NotNull FileAttribute attribute2) {
            return new Attribute(virtualFile, attribute2);
        }

        public static /* synthetic */ Attribute copy$default(Attribute attribute2, VirtualFile virtualFile, FileAttribute fileAttribute2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = attribute2.virtualFile;
            }
            if ((n & 2) != 0) {
                fileAttribute2 = attribute2.attribute;
            }
            return attribute2.copy(virtualFile, fileAttribute2);
        }

        @NotNull
        public String toString() {
            return "Attribute(virtualFile=" + this.virtualFile + ", attribute=" + this.attribute + ")";
        }

        public int hashCode() {
            int result = this.virtualFile.hashCode();
            result = result * 31 + this.attribute.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Attribute)) {
                return false;
            }
            Attribute attribute2 = (Attribute)other;
            if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)attribute2.virtualFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.attribute, (Object)attribute2.attribute);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage$None;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage;", "()V", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "intellij.c"})
    public static final class None
    implements ModuleMapSerializationStorage {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
        }

        @Override
        @NotNull
        public OutputStream getOutputStream() {
            ModuleMapLog.LOG.error("should not happen. serialize should have been filtered out all \"None\" storages");
            return OutputStream.nullOutputStream();
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            ModuleMapLog.LOG.error("should not happen. deserialize should have been filtered out all \"None\" storages");
            return InputStream.nullInputStream();
        }
    }
}

