/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.light.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.light.lexer.OCLightLexer;
import com.jetbrains.cidr.lang.light.parser.OCLightParser;
import com.jetbrains.cidr.lang.light.psi.OCLightFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCLightParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        return new OCLightLexer(OCLexerSettings.forPreprocessor().build());
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new OCLightParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return OCTokenTypes.OC_LIGHT_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return OCTokenTypes.WHITESPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return OCTokenTypes.LIGHT_COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return OCTokenTypes.ALL_STRINGS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        return new OCLightFile(viewProvider);
    }

    @NotNull
    public static TokenSet toLight(@NotNull TokenSet set) {
        List lightTypes = ContainerUtil.map((Object[])set.getTypes(), type -> ((OCElementType)type).getLightType());
        return TokenSet.create((IElementType[])lightTypes.toArray(IElementType.EMPTY_ARRAY));
    }
}

