/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderGuardDetector {
    private static final Key<Info> CACHE = Key.create((String)"OCHeaderGuardDetector cache");

    @Nullable
    public static String getHeaderGuard(@NotNull Project project, @NotNull VirtualFile file) {
        Info result = (Info)CACHE.get((UserDataHolder)file);
        if (result == null || !result.stamp.isUpToDate(project, file)) {
            FileContentSnapshot snapshot = FileContentSnapshot.get(file, project);
            CharSequence text = snapshot.getText();
            String guard = OCHeaderGuardDetector.detectHeaderGuard(text);
            result = new Info(guard, snapshot.getStamp());
            CACHE.set((UserDataHolder)file, (Object)result);
        }
        return result.guard;
    }

    @Nullable
    public static String detectHeaderGuard(@NotNull CharSequence text) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(text);
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        IElementType it = lexer.getTokenType();
        if (OCTokenTypes.IFNDEF_DIRECTIVE != it) {
            return null;
        }
        lexer.advance();
        IElementType ct = lexer.getTokenType();
        if (OCTokenTypes.DIRECTIVE_CONTENT != ct) {
            return null;
        }
        String content = lexer.getTokenText();
        lexer.advance();
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        String headerGuard = OCHeaderGuardDetector.readHeaderGuard(content, OCLexerSettings.forPreprocessor().build());
        if (headerGuard == null) {
            return null;
        }
        int directiveDepth = 1;
        while (directiveDepth > 0) {
            IElementType tt = lexer.getTokenType();
            if (tt == null) {
                return null;
            }
            if (OCTokenTypes.IF_DIRECTIVES.contains(tt)) {
                ++directiveDepth;
            } else if (OCTokenTypes.ENDIF_DIRECTIVE == tt) {
                --directiveDepth;
            } else if (OCTokenTypes.END_IF_DIRECTIVES.contains(tt) && directiveDepth == 1) {
                return null;
            }
            lexer.advance();
        }
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        return lexer.getTokenType() == null ? headerGuard : null;
    }

    private static void skipWhitespacesAndDirectiveBodies(OCLexer lexer) {
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType()) || OCParsing.isEndOfDirective(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    @Nullable
    private static String readHeaderGuard(String content, CidrLexerSettings settings) {
        OCLexer lexer = new OCLexer(settings);
        lexer.start((CharSequence)content);
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        IElementType tt = lexer.getTokenType();
        if (OCTokenTypes.IDENTIFIER != tt) {
            return null;
        }
        String headerGuard = lexer.getTokenText();
        lexer.advance();
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        return lexer.getTokenType() != null ? null : headerGuard;
    }

    static class Info {
        @Nullable
        final String guard;
        final FileContentSnapshot.Stamp stamp;

        Info(@Nullable String guard, @NotNull FileContentSnapshot.Stamp stamp) {
            this.guard = guard;
            this.stamp = stamp;
        }
    }
}

