/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.legacy.daemon.OCAssignmentChecker;
import com.jetbrains.cidr.lang.legacy.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveExtraInitializersIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompoundInitializerChecker {
    @NotNull
    private final OCCompoundInitializer myCompoundInitializer;
    @Nullable
    private final OCType myTypeToInitialize;
    private final boolean myAllowImplicitConversions;
    @NotNull
    private final OCResolveContext myContext;
    @NotNull
    private final List<OCCompoundInitializerMember> myInitializers;
    @NotNull
    private final List<OCExpression> myInitializerExprs;
    private Boolean myIsAggregate = null;
    private boolean mySingleInitializerTypeCalculated = false;
    @Nullable
    private OCType mySingleInitializerType = null;

    public static OCTypeCheckResult checkCompoundInitializer(OCCompoundInitializer compInitializer, @Nullable OCType type, boolean allowImplicitConversions, @NotNull OCResolveContext context) {
        return new OCCompoundInitializerChecker(compInitializer, type, allowImplicitConversions, context).doCheck();
    }

    public OCCompoundInitializerChecker(@NotNull OCCompoundInitializer initializer, @Nullable OCType typeToInitialize, boolean allowImplicitConversions, @NotNull OCResolveContext context) {
        this.myCompoundInitializer = initializer;
        this.myTypeToInitialize = typeToInitialize;
        this.myAllowImplicitConversions = allowImplicitConversions;
        this.myContext = context;
        this.myInitializers = this.myCompoundInitializer.getInitializers();
        this.myInitializerExprs = this.myCompoundInitializer.getInitializerExpressions();
    }

    private boolean isEmpty() {
        return this.myInitializers.isEmpty();
    }

    private boolean isAggregate() {
        if (this.myIsAggregate == null) {
            this.myIsAggregate = this.myTypeToInitialize != null && TypeProperties.isAggregateType(this.myTypeToInitialize);
        }
        return this.myIsAggregate;
    }

    private boolean isCppStructOrUnion() {
        if (this.myTypeToInitialize instanceof OCStructType && this.myContext.isCpp()) {
            OCSymbolKind kind = ((OCStructType)this.myTypeToInitialize).getKind();
            return kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION;
        }
        return false;
    }

    private OCType getReferencedType() {
        return OCTypeUtils.getCppReferencedType(this.myTypeToInitialize);
    }

    @Nullable
    private OCType getSingleInitializerType() {
        if (!this.mySingleInitializerTypeCalculated) {
            if (this.myInitializers.size() == 1 && this.myInitializers.get(0) instanceof OCTypeOwner) {
                this.mySingleInitializerType = OCTypeUtils.getCppReferencedType(((OCExpression)this.myInitializers.get(0)).getResolvedType(this.myContext));
            }
            this.mySingleInitializerTypeCalculated = true;
        }
        return this.mySingleInitializerType;
    }

    private OCTypeCheckResult doCheck() {
        OCExpression innerMember;
        if (this.myTypeToInitialize instanceof OCEllipsisType) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.myTypeToInitialize instanceof OCMagicType || this.myTypeToInitialize != null && this.myTypeToInitialize.isUnknown()) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.getSingleInitializerType() != null && this.isAggregate() && OCTypeUtils.isSameOrDerivedFrom(this.getSingleInitializerType(), this.myTypeToInitialize, this.myContext)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.myTypeToInitialize != null && this.myTypeToInitialize.isCString() && this.getSingleInitializerType() instanceof OCArrayType && (innerMember = OCParenthesesUtils.diveIntoParentheses(this.myInitializerExprs.get(0))) instanceof OCLiteralExpression) {
            return OCAssignmentChecker.checkAssignment(innerMember, this.myTypeToInitialize, this.getSingleInitializerType(), null, null, true, "", this.myContext);
        }
        if (this.myTypeToInitialize instanceof OCArrayType || this.isAggregate()) {
            if (!(this.myTypeToInitialize instanceof OCStructType) || !((OCStructType)this.myTypeToInitialize).isPredeclaration()) {
                return this.checkAggregate();
            }
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.isEmpty() && this.isCppStructOrUnion() && ((OCStructType)this.myTypeToInitialize).getSymbol().hasDefaultConstructor(this.myContext)) {
            OCTypeCheckResult okResult = new OCTypeCheckResult(OCTypeCheckState.OK);
            okResult.setImplicitConstructor(((OCStructType)this.myTypeToInitialize).getSymbol().getDefaultConstructor(this.myContext));
            return okResult;
        }
        OCType stdInitListParameter = OCCodeInsightUtil.getStdInitializerListTemplateParameter(this.myTypeToInitialize, this.myContext);
        if (stdInitListParameter != null) {
            if (TypeProperties.hasSameUnqualifiedType(this.myTypeToInitialize, this.getSingleInitializerType(), this.myContext)) {
                return OCTypeCheckResultBuilder.createOK();
            }
            OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(this.myInitializerExprs);
            ArrayList<OCTypeCheckResult> results = new ArrayList<OCTypeCheckResult>();
            for (int i = 0; i < argumentsList.getTypes().size(); ++i) {
                OCExpression argument = argumentsList.getExprs().get(i);
                OCType argumentType = argumentsList.getTypes().get(i);
                results.add(OCAssignmentChecker.checkAssignment(argument, stdInitListParameter, argumentType, null, null, true, "Can't create std::initializer_list: ", this.myContext));
            }
            return OCArgumentsChecker.combine(results);
        }
        if (this.isCppStructOrUnion()) {
            if (this.myInitializers.stream().anyMatch(e -> e instanceof OCDesignatedInitializer)) {
                return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.InitializerIssues.class, "CIDR", "Can't use designated initializers for C++ structs", new IntentionAction[0]);
            }
            return this.checkConstructors();
        }
        if (this.getSingleInitializerType() != null && (!(this.myTypeToInitialize instanceof OCCppReferenceType) || OCTypeUtils.isSameOrDerivedFrom(this.getSingleInitializerType(), this.getReferencedType(), this.myContext))) {
            OCTypeCheckResult result = OCTypeCheckResultBuilder.createOK();
            if (this.myTypeToInitialize != null) {
                OCCompoundInitializerMember initializer = this.myInitializers.get(0);
                if (initializer instanceof OCExpression) {
                    result = OCAssignmentChecker.checkAssignment((OCExpression)initializer, this.myTypeToInitialize, ((OCExpression)initializer).getResolvedType(), null, null, true, "Incompatible types in initializer: ", this.myContext);
                }
                if (this.myTypeToInitialize.isScalar() && initializer instanceof OCExpression && this.myCompoundInitializer.getParent() instanceof OCCompoundInitializer) {
                    for (ASTNode child : this.myCompoundInitializer.getNode().getChildren(null)) {
                        if (child.getElementType() != OCTokenTypes.LBRACE && child.getElementType() != OCTokenTypes.RBRACE) continue;
                        String clangId = OCClangMessageFinder.getInstance().getBracesAroundInit();
                        result.addAdditionalProblem(OCTypeCheckResultBuilder.createWarning(child.getPsi(), null, clangId, "Redundant braces", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new IntentionAction[0]));
                    }
                }
            }
            return result;
        }
        if (this.myTypeToInitialize instanceof OCCppReferenceType) {
            boolean isNonConstRvalueRef;
            OCCppReferenceType ref = (OCCppReferenceType)this.myTypeToInitialize;
            boolean bl = isNonConstRvalueRef = !ref.isReferenceToConst() && !ref.isRvalueRef();
            if (isNonConstRvalueRef) {
                if (ref.isCppStructType(this.myContext)) {
                    return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.InitializerIssues.class, "err_lvalue_reference_bind_to_unrelated", "Can't use constructors for initialization of references", new IntentionAction[0]);
                }
                return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", "Expression must be lvalue", new IntentionAction[0]);
            }
            return OCAssignmentChecker.checkAssignment(this.myCompoundInitializer, this.getReferencedType(), this.myCompoundInitializer.getResolvedType(this.myContext), null, null, true, "", this.myContext);
        }
        if (this.isEmpty()) {
            if (!this.myCompoundInitializer.getContainingOCFile().isCpp()) {
                return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.InitializerIssues.class, "err_empty_scalar_initializer", "Empty initializer for scalar type", new IntentionAction[0]);
            }
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.myInitializers.size() > 1 && this.myTypeToInitialize != null && this.myTypeToInitialize.isScalar()) {
            return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.InitializerIssues.class, "err_excess_initializers", "Excess elements in scalar initializer", new IntentionAction[0]);
        }
        return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.InitializerIssues.class, "CIDR", "Invalid list initializer", new IntentionAction[0]);
    }

    @NotNull
    private OCTypeCheckResult checkConstructors() {
        assert (this.myTypeToInitialize instanceof OCStructType);
        OCArgumentsList<OCCompoundInitializer> arguments = new OCArgumentsList<OCCompoundInitializer>(Collections.singletonList(this.myCompoundInitializer.getResolvedType()), Collections.singletonList(this.myCompoundInitializer));
        FindConstructorResult result = ((OCStructType)this.myTypeToInitialize).findConstructor(arguments, this.myContext, this.myCompoundInitializer, this.myAllowImplicitConversions, null, true);
        OCFunctionSymbol constructor = result.getSymbol();
        if (constructor instanceof OCFunctionGroupSymbol) {
            OCFunctionGroupSymbol group = (OCFunctionGroupSymbol)constructor;
            return switch (group.getCause()) {
                case OCFunctionGroupSymbol.Cause.Ambiguous -> OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, null, "err_ovl_ambiguous_call", "Call to \"" + group.getName() + "\" is ambiguous", new IntentionAction[0]);
                case OCFunctionGroupSymbol.Cause.NoViable -> OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, null, "err_ovl_no_viable_member_function_in_call", "No matching constructor", new IntentionAction[0]);
                default -> OCTypeCheckResultBuilder.createOK();
            };
        }
        if (constructor != null) {
            OCTypeCheckResult okResult = OCTypeCheckResultBuilder.createOK();
            okResult.setAnnotationElement(this.myCompoundInitializer);
            okResult.setImplicitConstructor(constructor);
            OCFunctionType functionType = (OCFunctionType)constructor.getType().resolve(this.myContext);
            List<OCExpression> args = result.isExpandedBracedInitList() ? this.myInitializerExprs : Collections.singletonList(this.myCompoundInitializer);
            okResult.addAdditionalProblems(OCArgumentsChecker.checkFunctionArguments(this.myCompoundInitializer, functionType, args, constructor, this.myContext, false));
            return okResult;
        }
        List argumentTypes = ContainerUtil.map(this.myInitializerExprs, e -> OCExpectedTypeUtil.getExpressionType(e, true));
        String message = OCCppChecker.getCantResolveCtorMessage(((OCStructType)this.myTypeToInitialize).getSymbol(), new OCFunctionType(OCVoidType.instance(), argumentTypes), this.myContext);
        return OCTypeCheckResultBuilder.createError(this.myCompoundInitializer, OCInspections.CannotResolve.class, "CIDR", message, new IntentionAction[0]);
    }

    private OCTypeCheckResult checkAggregate() {
        int curInitializerIndex = 0;
        boolean excessInitializers = false;
        HashMap<PsiElement, Pair<OCType, OCSymbol>> childTypes = new HashMap<PsiElement, Pair<OCType, OCSymbol>>();
        childTypes.put(this.myCompoundInitializer, new Pair((Object)this.myTypeToInitialize, null));
        this.myCompoundInitializer.inferChildTypes(childTypes, new HashSet<OCSymbol>());
        ArrayList<OCTypeCheckResult> results = new ArrayList<OCTypeCheckResult>();
        for (OCCompoundInitializerMember member : this.myInitializers) {
            if (member instanceof OCExpression) {
                Pair<OCType, OCSymbol> pair = childTypes.get(member);
                OCType childType = (OCType)Pair.getFirst(pair);
                if (childType != null) {
                    childType = childType.resolve(this.myContext);
                    OCType rType = ((OCExpression)member).getResolvedType();
                    if (member instanceof OCCompoundInitializer) {
                        results.add(OCCompoundInitializerChecker.checkCompoundInitializer((OCCompoundInitializer)member, childType, true, this.myContext));
                    } else {
                        results.add(OCAssignmentChecker.checkAssignment((OCExpression)member, childType, rType, (OCSymbol)pair.second, rType, true, "Incompatible types in initializer: ", this.myContext));
                    }
                } else if (!excessInitializers) {
                    excessInitializers = true;
                    OCRemoveExtraInitializersIntentionAction fix = new OCRemoveExtraInitializersIntentionAction(this.myInitializers, curInitializerIndex);
                    OCTypeCheckResult result = new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Excess elements in initializer", OCInspections.IncompatibleInitializers.class, "err_excess_initializers", new IntentionAction[]{fix}){

                        @Override
                        public boolean canBeCasted(OCType lType, OCType rType, @NotNull OCResolveContext context) {
                            return false;
                        }
                    };
                    result.setAnnotationElement(this.myInitializers.get(curInitializerIndex));
                    results.add(result);
                }
            } else if (member instanceof OCDesignatedInitializer) {
                OCExpression initializer;
                OCDesignatedInitializer fieldInitializer = (OCDesignatedInitializer)member;
                OCSymbol symbol = fieldInitializer.getDesignation().resolveToSymbol();
                if (symbol != null && (initializer = fieldInitializer.getInitializer()) != null) {
                    OCType rType = initializer.getResolvedType().getGuessedType();
                    results.add(OCAssignmentChecker.checkAssignment(initializer, symbol.getResolvedType(this.myContext), rType, symbol, rType, true, "", this.myContext));
                }
            } else {
                results.add(OCTypeCheckResultBuilder.createError(member, OCInspections.InitializerIssues.class, "err_typecheck_convert_incompatible", "Invalid initializer for struct field", new IntentionAction[0]));
            }
            ++curInitializerIndex;
        }
        return OCArgumentsChecker.combine(results);
    }

    private static String getDebugLocation(@NotNull OCElement e) {
        PsiFile file = e.getContainingFile();
        Document d = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        int line = d != null ? d.getLineNumber(e.getTextOffset()) + 1 : -1;
        return file.getName() + ":" + line;
    }
}

