/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.symbols.OCVisibility;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCheckResult {
    private OCTypeCheckState state;
    private String message;
    private Class<? extends OCInspection> inspectionClass;
    private String clangID;
    @NotNull
    private List<IntentionAction> quickFixes = new SmartList();
    private PsiElement myAnnotationElement;
    private boolean myIsWithConversion;
    private OCType myTypeAfterConversion;
    private OCType myTypeBeforeConversion;
    private OCFunctionSymbol myImplicitConstructor;
    private OCType mySourceType;
    private OCType myDestType;
    private OCTypeOwner mySource;
    private OCSymbol myDestSymbol;
    private OCType mySymbolRequiredType;
    private final List<OCTypeCheckResult> myAdditionalProblems = new ArrayList<OCTypeCheckResult>();
    @NotNull
    private String myMessagePrefix = "";
    @NotNull
    private String myForcedMessage = "";
    @Nullable
    private ProblemHighlightType myHighlightType = null;
    private boolean myOnlyWarnings;
    private OCSymbol mySourceSymbol;
    private String mySourceSubject;
    private String myDestSubject;

    public String toString() {
        Object result = this.state.toString();
        if (!this.state.isOK()) {
            result = (String)result + "(" + this.clangID + ") " + this.message + " [fixes:" + this.quickFixes.size() + "]";
        }
        return result;
    }

    public OCTypeCheckResult(OCTypeCheckState state, Class<? extends OCInspection> inspectionClass, String clangID, IntentionAction ... quickFixes) {
        this(state, inspectionClass, clangID, (OCType)null, (OCType)null, quickFixes);
    }

    public OCTypeCheckResult(OCTypeCheckState state, String message, Class<? extends OCInspection> inspectionClass, String clangID, IntentionAction ... quickFixes) {
        this(state, inspectionClass, clangID, (OCType)null, (OCType)null, quickFixes);
        this.message = message;
    }

    public OCTypeCheckResult(OCTypeCheckState state, Class<? extends OCInspection> inspectionClass, String clangID, PsiElement annotationElement, IntentionAction ... quickFixes) {
        this(state, inspectionClass, clangID, (OCType)null, (OCType)null, quickFixes);
        this.myAnnotationElement = annotationElement;
    }

    public OCTypeCheckResult(OCTypeCheckState state, Class<? extends OCInspection> inspectionClass, String clangID, OCType typeBeforeConversion, OCType typeAfterConversion, IntentionAction ... quickFixes) {
        this.state = state;
        this.inspectionClass = inspectionClass;
        this.clangID = clangID;
        this.quickFixes = new ArrayList<IntentionAction>(Arrays.asList(quickFixes));
        this.setConversion(typeBeforeConversion, typeAfterConversion);
    }

    public OCTypeCheckResult(OCTypeCheckState state) {
        this.state = state;
    }

    public OCTypeCheckResult(com.jetbrains.cidr.lang.types.OCTypeCheckResult result, String message) {
        this.state = result.getState();
        this.message = message;
    }

    public OCTypeCheckState getState() {
        return this.state;
    }

    public OCTypeCheckResult setState(OCTypeCheckState state) {
        this.state = state;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Class<? extends OCInspection> getInspectionClass() {
        return this.inspectionClass;
    }

    public OCTypeCheckResult setInspectionClass(Class<? extends OCInspection> inspectionClass) {
        this.inspectionClass = inspectionClass;
        return this;
    }

    public String getClangID() {
        return this.clangID;
    }

    public OCTypeCheckResult setClangID(String clangID) {
        this.clangID = clangID;
        return this;
    }

    @NotNull
    public List<IntentionAction> getQuickFixes() {
        return this.quickFixes;
    }

    @Nullable
    public PsiElement getAnnotationElement() {
        return this.myAnnotationElement;
    }

    public OCTypeCheckResult setAnnotationElement(PsiElement annotationElement) {
        this.myAnnotationElement = annotationElement;
        return this;
    }

    public boolean isWithConversion() {
        return this.myIsWithConversion;
    }

    public OCType getTypeBeforeConversion() {
        return this.myTypeBeforeConversion;
    }

    @Nullable
    public OCType getTypeAfterConversion() {
        return this.myTypeAfterConversion;
    }

    public OCTypeCheckResult setConversion(OCType typeBeforeConversion, OCType typeAfterConversion) {
        this.myIsWithConversion = true;
        this.myTypeAfterConversion = typeAfterConversion;
        this.myTypeBeforeConversion = typeBeforeConversion;
        return this;
    }

    @Nullable
    public OCFunctionSymbol getImplicitConstructor() {
        return this.myImplicitConstructor;
    }

    public OCTypeCheckResult setImplicitConstructor(OCFunctionSymbol implicitConstructor) {
        this.myImplicitConstructor = implicitConstructor;
        return this;
    }

    public boolean canBeCasted(OCType lType, OCType rType, @NotNull OCResolveContext context) {
        if (this.state != OCTypeCheckState.ERROR) {
            return true;
        }
        if (lType.isPointerCompatible(context) && rType.isPointerCompatible(context) && lType.isPointerToObjectCompatible() == rType.isPointerToObjectCompatible()) {
            return true;
        }
        return lType instanceof OCCppReferenceType && ((OCCppReferenceType)lType).isRvalueRef() && ((OCCppReferenceType)lType).getRefType().checkCompatible(rType, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK;
    }

    public OCType getSourceType() {
        return this.mySourceType;
    }

    public OCType getDestType() {
        return this.myDestType;
    }

    public OCTypeOwner getSource() {
        return this.mySource;
    }

    public OCSymbol getDestSymbol() {
        return this.myDestSymbol;
    }

    public OCTypeCheckResult setSourceType(OCType sourceType) {
        this.mySourceType = sourceType;
        return this;
    }

    public OCTypeCheckResult setDestType(OCType destType) {
        this.myDestType = destType;
        return this;
    }

    public OCTypeCheckResult setSource(OCTypeOwner source) {
        this.mySource = source;
        return this;
    }

    public OCType getSymbolRequiredType() {
        return this.mySymbolRequiredType;
    }

    public OCTypeCheckResult setDestSymbol(OCSymbol destSymbol) {
        this.myDestSymbol = destSymbol;
        return this;
    }

    public OCTypeCheckResult setSymbolRequiredType(OCType symbolRequiredType) {
        this.mySymbolRequiredType = symbolRequiredType instanceof OCBracedInitListType ? null : symbolRequiredType;
        return this;
    }

    public List<OCTypeCheckResult> getAdditionalProblems() {
        return this.myAdditionalProblems;
    }

    public void addAdditionalProblems(List<OCTypeCheckResult> additionalProblems) {
        this.myAdditionalProblems.addAll(additionalProblems);
    }

    public void addAdditionalProblem(@NotNull OCTypeCheckResult problem) {
        this.myAdditionalProblems.add(problem);
    }

    public OCTypeCheckResult addQuickFix(@NotNull IntentionAction fix) {
        this.quickFixes.add(fix);
        return this;
    }

    public OCTypeCheckResult setMessagePrefix(@NotNull String messagePrefix) {
        this.myMessagePrefix = messagePrefix;
        return this;
    }

    @NotNull
    public String getMessagePrefix() {
        return this.myMessagePrefix;
    }

    @NotNull
    public String getForcedMessage() {
        return this.myForcedMessage;
    }

    public OCTypeCheckResult setForcedMessage(@NotNull String forcedMessage) {
        this.myForcedMessage = forcedMessage;
        return this;
    }

    @Nullable
    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    public OCTypeCheckResult setHighlightType(@Nullable ProblemHighlightType highlightType) {
        this.myHighlightType = highlightType;
        return this;
    }

    public OCTypeCheckResult setOnlyWarnings(boolean onlyWarnings) {
        this.myOnlyWarnings = onlyWarnings;
        return this;
    }

    public boolean isOnlyWarnings() {
        return this.myOnlyWarnings;
    }

    public OCTypeCheckResult setSourceSymbol(OCSymbol sourceSymbol) {
        this.mySourceSymbol = sourceSymbol;
        return this;
    }

    public OCSymbol getSourceSymbol() {
        return this.mySourceSymbol;
    }

    public OCTypeCheckResult setSourceSubject(String sourceSubject) {
        this.mySourceSubject = sourceSubject;
        return this;
    }

    public String getSourceSubject() {
        return this.mySourceSubject;
    }

    public OCTypeCheckResult setDestSubject(String destSubject) {
        this.myDestSubject = destSubject;
        return this;
    }

    public String getDestSubject() {
        return this.myDestSubject;
    }

    public OCTypeCheckResult annotate(@NotNull OCAnnotatorSink sink) {
        OCFunctionSymbol constructor;
        String message;
        for (OCTypeCheckResult additional : this.getAdditionalProblems()) {
            additional.annotate(sink);
        }
        Annotation annotation = null;
        OCExpression rOperand = (OCExpression)ObjectUtils.tryCast((Object)this.getSource(), OCExpression.class);
        OCType lType = this.getDestType();
        OCType rType = this.getSourceType();
        PsiElement annotationElement = this.getAnnotationElement();
        if (annotationElement == null) {
            return this;
        }
        Class<? extends OCInspection> inspectionClass = this.getInspectionClass();
        String clangID = this.getClangID();
        if (inspectionClass == null) {
            inspectionClass = OCInspections.InitializationIssue.class;
        }
        if ((message = this.getForcedOrDefaultMessage()) != null) {
            if (this.getState().isError(annotationElement)) {
                if (this.isOnlyWarnings()) {
                    annotation = sink.addWarningAnnotation(annotationElement, inspectionClass, clangID, message, this.getHighlightType());
                    if (annotation != null) {
                        annotation.setHighlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                } else {
                    annotation = sink.addErrorAnnotation(annotationElement, inspectionClass, clangID, message, this.getHighlightType());
                }
            } else if (!this.getState().isOK()) {
                if (this.getState().isWarning(annotationElement)) {
                    annotation = sink.addWarningAnnotation(annotationElement, inspectionClass, clangID, message, this.getHighlightType());
                } else if (this.getState() == OCTypeCheckState.INFO) {
                    annotation = sink.addWarningAnnotation(annotationElement, inspectionClass, clangID, message, ProblemHighlightType.WEAK_WARNING);
                }
            }
        }
        if (annotation != null) {
            Object context;
            boolean isBridgeCastNeeded;
            boolean bl = isBridgeCastNeeded = this.getInspectionClass() == OCInspections.BridgeCastIssues.class;
            if (rOperand != null) {
                context = OCResolveContext.forPsi(rOperand);
                if (this.canBeCasted(lType, rType, (OCResolveContext)context) || isBridgeCastNeeded) {
                    OCType castType;
                    OCType oCType = castType = lType.isPointerToObject() && rType.isPointerToObject() && !rType.isCompatible(lType, (OCResolveContext)context) && !lType.isPointerToID() ? OCIdType.pointerToID() : lType;
                    if (!(castType instanceof OCArrayType)) {
                        sink.registerQuickFix(annotation, new OCInsertCastIntentionAction(rOperand, castType, isBridgeCastNeeded));
                    }
                }
                sink.registerQuickFix(annotation, new OCConvertTypeIntentionAction(rOperand, lType));
                OCExpression inner = OCParenthesesUtils.diveIntoParentheses(rOperand);
                if (inner != null) {
                    sink.registerQuickFix(annotation, new OCConvertLiteralIntentionAction(inner, lType, rType));
                }
            }
            for (IntentionAction action : this.getQuickFixes()) {
                sink.registerQuickFix(annotation, action);
            }
            context = OCCompilationContext.create(annotationElement);
            if (this.getDestSymbol() != null && this.getSymbolRequiredType() != null && !(this.getDestType() instanceof OCArrayType)) {
                sink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(this.getDestSymbol(), this.getSymbolRequiredType(), annotationElement instanceof OCReturnStatement, this.getDestSubject(), (OCCompilationContext)context));
            }
            if (this.getSourceSymbol() != null) {
                sink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(this.getSourceSymbol(), lType, this.getSourceSubject(), (OCCompilationContext)context));
            } else if (rOperand != null) {
                OCChangeTypeIntentionAction.registerChangeTypeFix(rOperand, lType, annotation, sink);
            }
        }
        if ((constructor = this.getImplicitConstructor()) != null) {
            OCVisibility.checkFieldVisibility(constructor, annotationElement, null, sink);
        }
        return this;
    }

    private String getForcedOrDefaultMessage() {
        if (!this.getForcedMessage().isEmpty()) {
            return this.getForcedMessage();
        }
        String message = this.getMessage();
        if (message != null) {
            return this.getMessagePrefix() + message;
        }
        return null;
    }
}

