/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCreateMissingSwitchCasesFix
extends OCCreateMissingSwitchCasesIntentionAction {
    private final boolean myDefaultIsMissing;
    private final SmartPsiElementPointer<OCSwitchStatement> mySwitchStatementPtr;

    public OCCreateMissingSwitchCasesFix(OCSwitchStatement switchStatement, boolean defaultIsMissing) {
        this.myDefaultIsMissing = defaultIsMissing;
        this.mySwitchStatementPtr = OCElementUtil.createPsiElementPointer(switchStatement);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        OCSwitchStatement switchStatement = OCElementUtil.getPsiElementByPointer(this.mySwitchStatementPtr);
        return switchStatement != null && OCCodeInsightUtil.isValid(switchStatement) && switchStatement.getBody() instanceof OCBlockStatement;
    }

    @Override
    protected OCSwitchStatement getSwitchStatement(Editor editor, PsiFile file) {
        return OCElementUtil.getPsiElementByPointer(this.mySwitchStatementPtr);
    }

    @Override
    @NotNull
    public String getText() {
        return this.myDefaultIsMissing ? OCInspectionsBundle.message("intentions.create.missing.default.switch.case", new Object[0]) : super.getText();
    }

    @Override
    protected void invoke(OCStatement switchBlock, List<OCDeclaratorSymbol> missingCases) {
        if (this.myDefaultIsMissing) {
            OCChangeUtil.add(switchBlock, OCElementFactory.statementFromText("default:break;", switchBlock));
        } else {
            super.invoke(switchBlock, missingCases);
        }
    }

    @Override
    protected boolean proceedIfDefaultOrUnresolved(boolean defaultOrUnresolved) {
        return !defaultOrUnresolved;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement elementInCopy = OCInspectionUtil.findSameElementInCopy(this.mySwitchStatementPtr, (PsiFile)target);
        return elementInCopy instanceof OCSwitchStatement ? new OCCreateMissingSwitchCasesFix((OCSwitchStatement)elementInCopy, this.myDefaultIsMissing) : null;
    }
}

