/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCCreateFunctionPredeclarationIntentionAction
extends OCCreateDefinitionIntentionAction {
    private final OCFunctionSymbol myFunctionSymbol;

    public OCCreateFunctionPredeclarationIntentionAction(PsiElement usage, OCFunctionSymbol functionSymbol) {
        super(OCSymbolKind.FUNCTION_DECLARATION, usage, null);
        this.myFunctionSymbol = functionSymbol;
    }

    @Override
    protected OCDeclaration getDefinition(Project project, Editor editor, PsiFile file) {
        String signature2 = OCElementUtil.getSignature(this.myFunctionSymbol, project);
        if (StringUtil.isEmpty((String)signature2)) {
            return null;
        }
        return OCElementFactory.declarationFromText(signature2, (PsiElement)file);
    }

    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.predeclare.function", this.myFunctionSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myFunctionSymbol, this.myProject)));
    }
}

