/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCNullAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInputOutputVariablesFinder;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.legacy.dfa.OCEndlessLoopFinder;
import com.jetbrains.cidr.lang.legacy.dfa.OCEscapedValuesChecker;
import com.jetbrains.cidr.lang.legacy.dfa.OCInfiniteRecursionFinder;
import com.jetbrains.cidr.lang.legacy.dfa.OCNotInitializedVarChecker;
import com.jetbrains.cidr.lang.legacy.dfa.OCNotUsedValueChecker;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSendMessageToObjectIntentionAction;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDataFlowAnalyzer {
    private PsiElement[] myCodeFragments;
    private OCControlFlowGraph myGraph;
    private OCControlFlowBuilder myGraphBuilder;
    private OCUnreachableCodeFinder myUnreachableCodeFinder;
    private OCInfiniteRecursionFinder myInfiniteRecursionFinder;
    private OCEndlessLoopFinder myEndlessLoopFinder;
    private OCDataFlowAnalyzer myParentAnalyzer;
    private List<OCDataFlowAnalyzer> myChildAnalyzers = new ArrayList<OCDataFlowAnalyzer>();
    private TextRange mySelection;
    private List<OCSymbol> myInputVariables;
    private List<OCSymbol> myOutputVariables;
    private List<OCSymbol> myWrittenVariables;
    private List<OCSymbol> myEscapedDeclarators;
    private Map<OCSymbol, List<PsiReference>> myVariableUsages;
    @NotNull
    private OCAnnotatorSink mySink;
    private static final Key<CachedValue<Map<OCStructSymbol, Boolean>>> TRIVIAL_DTOR_CACHE = Key.create((String)"TRIVIAL_DTOR_CACHE_IN_FILE");

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull OCAnnotatorSink annotator, @Nullable OCDataFlowAnalyzer parentAnalyzer) {
        this(new PsiElement[]{codeFragment}, annotator, parentAnalyzer, parentAnalyzer != null ? parentAnalyzer.mySelection : null);
        if (parentAnalyzer != null) {
            parentAnalyzer.myChildAnalyzers.add(this);
        }
    }

    public OCDataFlowAnalyzer(PsiElement @NotNull [] codeFragments, @Nullable TextRange selection) {
        this(codeFragments, OCNullAnnotatorSink.INSTANCE, null, selection);
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable TextRange selection) {
        this(new PsiElement[]{codeFragment}, OCNullAnnotatorSink.INSTANCE, null, selection);
    }

    private OCDataFlowAnalyzer(PsiElement @NotNull [] codeFragments, @NotNull OCAnnotatorSink sink, @Nullable OCDataFlowAnalyzer parentAnalyzer, @Nullable TextRange selection) {
        this.mySink = sink;
        this.myCodeFragments = codeFragments;
        this.mySelection = selection;
        this.myParentAnalyzer = parentAnalyzer;
        this.myInputVariables = new ArrayList<OCSymbol>();
        this.myOutputVariables = new ArrayList<OCSymbol>();
        this.myWrittenVariables = new ArrayList<OCSymbol>();
        this.myEscapedDeclarators = new ArrayList<OCSymbol>();
        this.myVariableUsages = new HashMap<OCSymbol, List<PsiReference>>();
    }

    @NotNull
    public OCAnnotatorSink getSink() {
        return this.mySink;
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        return this.myGraph;
    }

    @Nullable
    public OCControlFlowGraph findGraph(@NotNull PsiElement element) {
        if (!this.myGraph.getCodeFragment().getTextRange().contains(element.getTextOffset())) {
            return null;
        }
        for (OCDataFlowAnalyzer analyzer : this.myChildAnalyzers) {
            OCControlFlowGraph graph = analyzer.findGraph(element);
            if (graph == null) continue;
            return graph;
        }
        return this.myGraph;
    }

    @NotNull
    public OCUnreachableCodeFinder getUnreachableCodeFinder() {
        return this.myUnreachableCodeFinder;
    }

    @NotNull
    public List<OCSymbol> getInputVariables() {
        return this.myInputVariables;
    }

    @NotNull
    public List<OCSymbol> getOutputVariables() {
        return this.myOutputVariables;
    }

    @NotNull
    public List<OCSymbol> getWrittenVariables() {
        return this.myWrittenVariables;
    }

    @NotNull
    public List<OCSymbol> getEscapedDeclarators() {
        return this.myEscapedDeclarators;
    }

    public void buildControlFlowGraph() {
        this.myGraph = new OCControlFlowGraph(this.myCodeFragments[0], this.myParentAnalyzer != null ? this.myParentAnalyzer.getGraph() : null);
        this.myGraphBuilder = new OCControlFlowBuilder(this, this.myGraph, this.mySelection);
        boolean isFirst = true;
        for (PsiElement codeFragment : this.myCodeFragments) {
            if (isFirst) {
                this.myGraphBuilder.processFirstCodeFragment(codeFragment);
            } else {
                this.myGraphBuilder.processNextCodeFragment(codeFragment);
            }
            isFirst = false;
        }
        this.myUnreachableCodeFinder = new OCUnreachableCodeFinder(this.myGraph);
        this.myInfiniteRecursionFinder = new OCInfiniteRecursionFinder(this.myGraph);
        this.myEndlessLoopFinder = new OCEndlessLoopFinder(this.myGraph);
        this.myUnreachableCodeFinder.process();
        this.myInfiniteRecursionFinder.process();
        this.myEndlessLoopFinder.process();
    }

    public void analyze() {
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        PsiElement context = firstCodeFragment.getContext();
        Project project = firstCodeFragment.getProject();
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        List<PsiElement> callableIdentifiers = null;
        if (callable instanceof OCMethod) {
            callableIdentifiers = ((OCMethod)callable).getSelectors();
        } else if (callable instanceof OCFunctionDefinition) {
            callableIdentifiers = Collections.singletonList(((OCFunctionDefinition)callable).getNameIdentifier());
        }
        if (this.analyzeNoReturn(callable, firstCodeFragment)) {
            return;
        }
        if (!OCCallableUtil.isNoReturn(callable)) {
            for (OCElementsRange oCElementsRange : this.myEndlessLoopFinder.getEndlessLoops()) {
                this.mySink.addWarningAnnotation((PsiElement)firstCodeFragment.getContainingFile(), oCElementsRange.getTextRange(), OCInspections.EndlessLoop.class, "warn_suggest_noreturn_function", "Endless loop", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
        if (callableIdentifiers != null && !this.myInfiniteRecursionFinder.isExitOrDeadEndReached()) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>(callableIdentifiers);
            elements.addAll(this.myInfiniteRecursionFinder.getRecursiveCalls());
            this.mySink.addWarningAnnotations(elements, OCInspections.InfiniteRecursion.class, "CIDR", callable.getKind() + " '" + callable.getName() + "' recurses infinitely");
        }
        boolean arcEnabled = !OCCompilerFeaturesHelper.isArcDisabled(firstCodeFragment.getContainingFile());
        for (OCSymbol oCSymbol : this.myGraph.getLocalSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotUsed(oCSymbol, context, project);
            this.analyzeInputOutput(oCSymbol);
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            if (arcEnabled) continue;
            this.analyzeNotReleased(oCSymbol, new OCNotReleasedVariablesChecker(this.myGraph, oCSymbol), true);
        }
        for (OCSymbol oCSymbol : this.myGraph.getClosureSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            this.analyzeInputOutput(oCSymbol);
        }
        if (!arcEnabled) {
            for (Pair<OCSendMessageExpression, PsiElement> pair : OCNotReleasedVariablesChecker.getUnreleasedObjects(firstCodeFragment)) {
                OCCallable method;
                OCSymbol symbol;
                Annotation annotation = this.mySink.addWarningAnnotation((PsiElement)pair.getFirst(), OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                PsiElement object = (PsiElement)pair.getSecond();
                this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(object, "autorelease"));
                if (!(object.getParent() instanceof OCReturnStatement) || !((symbol = (method = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)object, OCCallable.class)) != null ? method.getSymbol() : null) instanceof OCMethodSymbol)) continue;
                this.mySink.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(symbol, "ns_returns_retained", "NS_RETURNS_RETAINED", true, this.createResolveContext()));
            }
        }
        this.analyzeEscapedValue();
        for (OCDataFlowAnalyzer oCDataFlowAnalyzer : this.myChildAnalyzers) {
            oCDataFlowAnalyzer.analyze();
            this.myInputVariables.addAll(oCDataFlowAnalyzer.getInputVariables());
            this.myOutputVariables.addAll(oCDataFlowAnalyzer.getOutputVariables());
            this.myEscapedDeclarators.addAll(oCDataFlowAnalyzer.getEscapedDeclarators());
            this.myWrittenVariables.addAll(oCDataFlowAnalyzer.getWrittenVariables());
            for (OCSymbol symbol : oCDataFlowAnalyzer.myVariableUsages.keySet()) {
                if (this.myVariableUsages.containsKey(symbol)) continue;
                this.myVariableUsages.put(symbol, oCDataFlowAnalyzer.myVariableUsages.get(symbol));
            }
        }
        if (this.mySelection != null) {
            Comparator<OCSymbol> comparator = Comparator.comparingInt(OCSymbol::getOffset);
            this.myInputVariables.sort(comparator);
            this.myOutputVariables.sort(comparator);
            this.myWrittenVariables.sort(comparator);
            this.myEscapedDeclarators.sort(comparator);
        }
    }

    private boolean analyzeNoReturn(OCCallable callable, PsiElement firstCodeFragment) {
        if (callable != null && !callable.getReturnType().resolve(callable).isVoid() && this.myUnreachableCodeFinder.isDeadEndReached()) {
            OCBlockStatement body = callable.getBody();
            boolean isConstructor = false;
            if (body == null) {
                return true;
            }
            OCSymbol symbol = callable.getSymbol();
            if (callable.getContainingOCFile().isCpp() && callable instanceof OCFunctionDefinition && symbol != null && symbol.getKind().isConstructorOrDestructor()) {
                isConstructor = true;
            }
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMainFunction()) {
                return true;
            }
            if (!isConstructor) {
                Annotation annotation = null;
                String message = "Control reaches end of non-void " + callable.getKind().toStringLowercase();
                if (callable instanceof OCBlockExpression) {
                    annotation = this.mySink.addErrorAnnotation(body.getClosingBrace(), "err_maybe_falloff_nonvoid_block", message);
                } else {
                    switch (OCCompilerFeaturesHelper.getDiagnosticLevel(body.getContainingOCFile(), OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID)) {
                        case ERROR: {
                            annotation = this.mySink.addErrorAnnotation(body.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message);
                            break;
                        }
                        case WARNING: {
                            annotation = this.mySink.addWarningAnnotation(body.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message);
                            break;
                        }
                    }
                }
                if (annotation != null) {
                    OCResolveContext resolveContext = OCResolveContext.forPsi(body);
                    OCType type = callable.getReturnType().resolve(resolveContext);
                    this.mySink.registerQuickFix(annotation, new OCAddElementIntentionAction(OCInspectionsBundle.message("intention.family.name.add.return.statement", new Object[0]), body, OCElementFactory.statementFromText("return " + type.getDefaultValue(resolveContext) + ";", firstCodeFragment)));
                    OCSymbol callableSymbol = callable.getSymbol();
                    if (callableSymbol != null) {
                        this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(callableSymbol, (OCType)OCVoidType.instance(), true, (OCCompilationContext)resolveContext));
                    }
                }
            }
        }
        return false;
    }

    private void analyzeNotInitialized(@NotNull OCSymbol symbol, boolean arcEnabled) {
        if (symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            return;
        }
        OCResolveContext context = this.createResolveContext();
        OCType resolvedType = symbol.getResolvedType(context);
        if (context.isCpp() && (resolvedType instanceof OCMagicType || resolvedType instanceof OCStructType && ((OCStructType)resolvedType).getSymbol().hasMemberFunctions())) {
            return;
        }
        if (resolvedType instanceof OCStructType) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            for (OCStructSymbol struct : ((OCStructType)resolvedType).getStructs()) {
                if (!struct.processConstructors((Processor<? super OCFunctionSymbol>)finder, context)) break;
                if (!((OCStructType)resolvedType).isEmpty(context)) continue;
                return;
            }
            if (finder.isFound()) {
                return;
            }
        }
        if (arcEnabled && resolvedType.isPointerToObjectCompatible()) {
            return;
        }
        if (symbol instanceof OCDeclaratorSymbol) {
            if (symbol.getType() instanceof OCStructuredBindingType) {
                return;
            }
            if (((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
                return;
            }
        }
        OCNotInitializedVarChecker notInitializedChecker = new OCNotInitializedVarChecker(this.myGraph, symbol);
        notInitializedChecker.process();
        for (PsiElement read : notInitializedChecker.getNotInitializedReads()) {
            OCDeclarator declarator;
            if (OCDataFlowAnalyzer.isComplicatedCppInstruction(read) || OCCodeInsightUtil.isStaticallyEvaluated(read)) continue;
            Annotation annotation = this.addWarningAnnotation(read, symbol, OCInspections.NotInitializedVariable.class, "warn_uninit_var", symbol.getNameWithKindUppercase(OCCompilationContext.create(read)) + " might not have been initialized");
            OCInstruction declInstruction = this.myGraph.getDeclaratorInstruction(symbol);
            if (declInstruction == null) {
                declInstruction = this.myGraph.getClosureVariableDeclaratorGraph(symbol).getDeclaratorInstruction(symbol);
            }
            if ((declarator = (OCDeclarator)declInstruction.getRValue()) == null) continue;
            this.mySink.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, symbol));
        }
    }

    @NotNull
    private OCResolveContext createResolveContext() {
        return OCResolveContext.forPsi(this.myCodeFragments[0]);
    }

    private static boolean isComplicatedCppInstruction(@NotNull PsiElement read) {
        OCResolveContext context = OCResolveContext.forPsi(read);
        if (context.isCpp() && read.getParent() instanceof OCQualifiedExpression) {
            PsiElement parent = read.getParent();
            while (parent instanceof OCQualifiedExpression) {
                OCQualifiedExpression expr = (OCQualifiedExpression)parent;
                if (expr.getResolvedType() instanceof OCMagicType) {
                    return true;
                }
                parent = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{OCParenthesizedExpression.class});
            }
        }
        return false;
    }

    private void analyzeNotUsed(@NotNull OCSymbol symbol, @Nullable PsiElement context, @NotNull Project project) {
        if (this.hasReferenceType(symbol) || project.getUserData(OCFile.DFA_UNUSED_CHECKS) == OCFile.UnusedChecksMode.DISABLED) {
            return;
        }
        OCNotUsedValueChecker notUsedChecker = new OCNotUsedValueChecker(this.myGraph, symbol);
        notUsedChecker.process();
        for (PsiElement write2 : notUsedChecker.getNotUsedWrites()) {
            String text;
            if (OCElementUtil.isPartOfMacroSubstitution(write2.getParent()) || write2.getParent() instanceof OCDeclarator && (!notUsedChecker.isSymbolUsed() || "0".equals(text = OCElementUtil.getTextWithMacros(write2 = ((OCDeclarator)write2.getParent()).getInitializer())) || OCCodeInsightUtil.isLikeNull(text)) || write2 == null) continue;
            Annotation annotation = this.addWarningAnnotation(write2, symbol, OCInspections.UnusedValue.class, "CIDR", "The value is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            PsiElement element = write2.getContext();
            if (element instanceof OCDeclarator) {
                this.mySink.registerQuickFix(annotation, new OCRemoveInitializerIntentionAction((OCDeclarator)element));
                continue;
            }
            this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("statement", element, project));
            this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction("statement", element, project));
        }
        if (!notUsedChecker.isSymbolUsed() && this.enableUnusedCheck(symbol, context)) {
            String clangID;
            Class inspectionClass;
            String messageSuffix = notUsedChecker.isSymbolAssigned() ? " is only assigned but never accessed" : " is never used";
            PsiElement declaratorElement = this.myGraph.getDeclaratorInstruction(symbol).getRValue();
            if (PsiTreeUtil.getParentOfType((PsiElement)declaratorElement, OCTypeElement.class) != null) {
                return;
            }
            if (declaratorElement instanceof OCDeclarator) {
                declaratorElement = ((OCDeclarator)declaratorElement).getNameIdentifier();
            }
            if (symbol.getKind() == OCSymbolKind.PARAMETER) {
                inspectionClass = OCInspections.UnusedParameter.class;
                clangID = "warn_unused_parameter";
            } else if (symbol.getKind() == OCSymbolKind.LABEL) {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_label";
            } else {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_variable";
            }
            if (declaratorElement != null) {
                Annotation annotation = this.addWarningAnnotation(declaratorElement, symbol, inspectionClass, clangID, symbol.getNameWithKindUppercase(OCCompilationContext.create(declaratorElement)) + messageSuffix, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, project));
                this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol, project));
                this.mySink.registerQuickFix(annotation, OCChangeGCCAttributeIntentionAction.unused(symbol, declaratorElement.getContainingFile()));
            }
        }
    }

    private boolean hasReferenceType(@NotNull OCSymbol symbol) {
        OCType resolvedType = symbol.getType().resolve(this.createResolveContext());
        return resolvedType instanceof OCCppReferenceType;
    }

    private boolean enableUnusedCheck(@NotNull OCSymbol symbol, @Nullable PsiElement context) {
        OCType symbolType = symbol.getType().resolve(this.createResolveContext());
        if (symbol.isUnused() || OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(symbolType)) {
            return false;
        }
        return switch (symbol.getKind()) {
            case OCSymbolKind.PARAMETER -> this.enableUnusedCheckForParameter();
            case OCSymbolKind.LOCAL_VARIABLE -> this.enableUnusedCheckForLocalVariable(symbol);
            case OCSymbolKind.CATCH_EXCEPTION_VARIABLE -> false;
            default -> true;
        };
    }

    private static boolean specifiedByUsedOrUnusedAttribute(@NotNull OCType type) {
        if (type instanceof OCStructType) {
            return ((OCStructType)type).getSymbol().isUnused();
        }
        return false;
    }

    private boolean enableUnusedCheckForParameter() {
        OCSymbol parentSymbol;
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        OCSymbol oCSymbol = parentSymbol = callable != null ? callable.getSymbol() : null;
        if (parentSymbol == null || parentSymbol.getKind() == OCSymbolKind.BLOCK || parentSymbol.getKind() == OCSymbolKind.LAMBDA || parentSymbol.hasAttribute("ibaction")) {
            return false;
        }
        if (parentSymbol instanceof OCFunctionSymbol) {
            return !((OCFunctionSymbol)parentSymbol).isMainFunction();
        }
        if (parentSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol method = (OCMethodSymbol)parentSymbol;
            if (method.getParent().getKind() != OCSymbolKind.IMPLEMENTATION) {
                return false;
            }
            Project project = firstCodeFragment.getProject();
            OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method, project);
            searchParameters.setAncestors(true);
            if (OCMemberInheritorsSearch.search(searchParameters).findFirst() != null) {
                return false;
            }
            OCMethodSymbol associatedSymbol = method.getAssociatedSymbol(project);
            if (associatedSymbol != null) {
                method = associatedSymbol;
            }
            GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(project);
            PsiElement methodDefinition = method.locateDefinition(project);
            if (methodDefinition == null) {
                return false;
            }
            ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(methodDefinition, (SearchScope)scope, false);
            return new OCMethodReferencesSearch().execute(parameters, (Processor<? super PsiReference>)((Processor)psiReference -> !(psiReference.getElement() instanceof OCSelectorExpression) && !(psiReference instanceof OCExternalReference)));
        }
        return false;
    }

    private boolean enableUnusedCheckForLocalVariable(@NotNull OCSymbol symbol) {
        if (!(symbol instanceof OCDeclaratorSymbol)) {
            return true;
        }
        OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
        OCType declaratorType = declaratorSymbol.getType().resolve(this.createResolveContext());
        if (declaratorType instanceof OCStructType) {
            OCStructSymbol structSymbol = ((OCStructType)declaratorType).getSymbol();
            return this.hasTrivialDestructor(structSymbol);
        }
        return !(declaratorType instanceof OCMagicType);
    }

    private boolean hasTrivialDestructor(@NotNull OCStructSymbol symbol) {
        OCResolveContext context = this.createResolveContext();
        PsiFile file = context.getFile();
        Map<OCStructSymbol, Boolean> cache = OCDataFlowAnalyzer.getTrivialDtorCache(file);
        if (cache != null && cache.containsKey(symbol)) {
            return cache.get(symbol);
        }
        boolean hasTrivialDestructor = symbol.hasTrivialDestructor(context);
        if (cache != null) {
            cache.put(symbol, hasTrivialDestructor);
        }
        return hasTrivialDestructor;
    }

    private static Map<OCStructSymbol, Boolean> getTrivialDtorCache(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(file.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result(OCTypeUtils.newDeepEqualityMap(), new Object[]{modificationTracker});
        return (Map)manager.getCachedValue((UserDataHolder)file, TRIVIAL_DTOR_CACHE, provider2, false);
    }

    public void analyzeNotReleased(@NotNull OCSymbol symbol, @NotNull OCNotReleasedVariablesChecker checker, boolean processReturns) {
        OCCallable callable;
        if (processReturns) {
            checker.setStartFromReturns(true);
        }
        if (!symbol.getResolvedType(this.createResolveContext()).isPointerToObjectCompatible() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
            return;
        }
        checker.process();
        HashSet<PsiElement> notReleasedElements = new HashSet<PsiElement>();
        for (PsiElement element : checker.getNotReleasedElements()) {
            notReleasedElements.add(element);
            Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
            this.mySink.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element, this.myCodeFragments[0].getProject()));
            this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
        }
        if (processReturns && this.myCodeFragments[0] instanceof OCCallable && !OCElementUtil.isRetainMethod(callable = (OCCallable)this.myCodeFragments[0])) {
            checker.setStartFromReturns(false);
            checker.process();
            for (PsiElement element : checker.getNotReleasedElements()) {
                if (notReleasedElements.contains(element)) continue;
                Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                this.mySink.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element, callable.getProject()));
                this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
                OCSymbol callableSymbol = callable.getSymbol();
                if (callableSymbol == null) continue;
                this.mySink.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(callableSymbol, "ns_returns_retained", "NS_RETURNS_RETAINED", true, this.createResolveContext()));
            }
        }
    }

    private void analyzeEscapedValue() {
        OCEscapedValuesChecker checker = new OCEscapedValuesChecker(this.myGraph);
        checker.process();
        for (PsiElement element : checker.getEscapedVariables()) {
            this.mySink.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, OCClangMessageFinder.getInstance().getReturnStackAddr(), "Local value may escape the method/function");
        }
        for (PsiElement element : checker.getEscapedObjects()) {
            String message = (element instanceof OCBlockExpression ? "Block" : "Value") + " escapes the local scope";
            Annotation annotation = this.mySink.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, OCClangMessageFinder.getInstance().getReturnTempAddr(), message);
            if (!(element instanceof OCBlockExpression)) continue;
            this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "copy"));
        }
    }

    private void analyzeInputOutput(@NotNull OCSymbol symbol) {
        if (this.mySelection == null) {
            return;
        }
        OCInputOutputVariablesFinder finder = new OCInputOutputVariablesFinder(this.myGraph, symbol, this.mySelection);
        finder.process();
        boolean needUsages = false;
        if (finder.isInputVariable()) {
            this.myInputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isOutputVariable()) {
            this.myOutputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isWrittenVariable()) {
            this.myWrittenVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isEscapedDeclarator()) {
            this.myEscapedDeclarators.add(symbol);
            needUsages = true;
        }
        if (needUsages) {
            this.myVariableUsages.put(symbol, finder.getVariableUsages());
        }
    }

    public List<PsiReference> getVariableUsages(@NotNull OCSymbol symbol) {
        return this.myVariableUsages.get(symbol);
    }

    public boolean hasCrossSelectionJumps() {
        return this.myGraphBuilder.hasCrossSelectionJumps();
    }

    public boolean hasDanglingJumps() {
        return this.myGraphBuilder.hasDanglingJumps();
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange != null && !macroRange.mapsToArguments()) {
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (symbol.getOffset() == macroCall.getTextRange().getEndOffset()) {
                return null;
            }
        }
        return this.mySink.addWarningAnnotation(element, inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        return this.addWarningAnnotation(element, symbol, inspectionClass, clangID, message, null);
    }
}

