/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSinkWrapper;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.legacy.daemon.OCFunctionGroupHelperKt;
import com.jetbrains.cidr.lang.legacy.quickfixes.OCAddSuperConstructorCallsFix;
import com.jetbrains.cidr.lang.legacy.quickfixes.OCGenerateConstructorFix;
import com.jetbrains.cidr.lang.legacy.quickfixes.OCRemoveFinalAction;
import com.jetbrains.cidr.lang.legacy.symbols.OCVisibility;
import com.jetbrains.cidr.lang.legacy.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddFieldInitializerFix;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddParametersToConstructorAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeARCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppChecker
extends OCAnnotatorSinkWrapper {
    public OCCppChecker(@NotNull OCAnnotatorSink impl) {
        super(impl);
    }

    public void checkCppFunction(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCExpression initializer = function.getDeclarator().getInitializer();
        if (initializer != null) {
            this.checkPureVirtual(symbol, initializer);
        }
        this.checkOverridden(function, symbol, function.getProject());
        this.checkConstructorDefinition(function, symbol);
        this.checkFunctionReturnTypes(function, symbol);
        this.checkOverrideControls(function, symbol);
    }

    private void checkOverridden(OCFunctionDeclaration function, OCFunctionSymbol symbol, Project project) {
        if (symbol.getKind().isConstructorOrDestructor()) {
            return;
        }
        OCFunctionSymbol candidate = OCCppChecker.findOverriddenCandidate(symbol, project);
        if (candidate == null) {
            return;
        }
        OCCompilationContext compilationContext = OCCompilationContext.create(function);
        if (candidate.isVirtual()) {
            this.checkFunctionReturnTypes(function, symbol, candidate, true, "derived function", "virtual " + symbol.getNameWithKindLowercase(compilationContext), "base function", "err_different_return_type_for_overriding_virtual_function");
        }
    }

    @Nullable
    static OCFunctionSymbol findOverriddenCandidate(OCFunctionSymbol symbol, Project project) {
        final Ref nonVirtualRef = new Ref();
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> virtualFinder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            public boolean process(OCFunctionSymbol symbol) {
                if (symbol.isVirtual()) {
                    return super.process((Object)symbol);
                }
                nonVirtualRef.set((Object)symbol);
                return true;
            }
        };
        new OCFunctionAncestorsQuery(symbol, true, false, project).forEach((Processor)virtualFinder);
        OCFunctionSymbol virtualFunction = (OCFunctionSymbol)virtualFinder.getFoundValue();
        OCFunctionSymbol nonVirtualFunction = (OCFunctionSymbol)nonVirtualRef.get();
        return virtualFunction != null ? virtualFunction : nonVirtualFunction;
    }

    private void checkFunctionReturnTypes(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCSymbol associatedFunction;
        OCCppNamespaceQualifier qualifier = function.getDeclarator().getNamespaceQualifier();
        if (qualifier != null && symbol.isDefinition()) {
            associatedFunction = qualifier.getPredeclarationInParent(symbol, true);
        } else {
            Project project = function.getProject();
            associatedFunction = symbol.getAssociatedSymbol(project);
            if (associatedFunction instanceof OCFunctionSymbol && associatedFunction.isDefinition()) {
                PsiElement element = associatedFunction.locateDefinition(project);
                OCCppNamespaceQualifier oCCppNamespaceQualifier = qualifier = element instanceof OCDeclarator ? ((OCDeclarator)element).getNamespaceQualifier() : null;
                if (qualifier != null) {
                    OCSymbol newSymbol = qualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)associatedFunction, true);
                    OCFunctionSymbol oCFunctionSymbol = symbol = newSymbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)newSymbol : null;
                }
            }
        }
        if (symbol != null && associatedFunction instanceof OCFunctionSymbol) {
            OCCompilationContext context = OCCompilationContext.create(function);
            if (symbol.isDefinition() && !associatedFunction.isDefinition()) {
                this.checkFunctionReturnTypes(function, symbol, (OCFunctionSymbol)associatedFunction, false, "function definition", symbol.getNameWithKindLowercase(context) + " definition", "function declaration", "err_member_def_does_not_match_ret_type");
            } else if (!symbol.isDefinition() && associatedFunction.isDefinition()) {
                this.checkFunctionReturnTypes(function, symbol, (OCFunctionSymbol)associatedFunction, false, "function declaration", symbol.getNameWithKindLowercase(context) + " declaration", "function definition", "err_member_def_does_not_match_ret_type");
            }
        }
    }

    private void checkOverrideControls(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCResolveContext context = OCResolveContext.forPsi(function);
        OCSymbolWithQualifiedName owner = symbol.getResolvedOwner(context);
        if (owner == null || !(owner.getType() instanceof OCMagicType)) {
            Ref isOverridden = Ref.create((Object)false);
            new OCFunctionAncestorsQuery(symbol, true, false, function.getProject()).forEach(baseFunction -> {
                if (!baseFunction.isVirtual()) {
                    return true;
                }
                isOverridden.set((Object)true);
                if (baseFunction.isFinal()) {
                    String message = symbol.getNameWithKindUppercase(context) + " overrides a final function from " + baseFunction.getParent().getNameWithKindLowercase(context);
                    Annotation annotation = this.addErrorAnnotation(function, "err_final_function_overridden", message);
                    this.registerQuickFix(annotation, new OCRemoveFinalAction((OCFunctionSymbol)baseFunction, context.getProject()));
                    this.registerQuickFix(annotation, new OCSafeDeleteIntentionAction((PsiElement)function, symbol.getNameWithKindLowercase(context)));
                    return false;
                }
                return true;
            });
            boolean reported = false;
            List<PsiElement> vs = function.getVirtualSpecifiers();
            for (PsiElement spec : vs) {
                IElementType type = OCElementUtil.getElementType(spec);
                if (reported || ((Boolean)isOverridden.get()).booleanValue() || !OCTokenTypes.CPP_VIRTUAL_SPECIFIERS.contains(type)) continue;
                boolean highlighting = this.highlight(spec, OCHighlightingKeys.OC_KEYWORD);
                if (type == OCTokenTypes.FINAL_CPP_KEYWORD && symbol.isVirtual()) continue;
                String clangID = type == OCTokenTypes.OVERRIDE_CPP_KEYWORD ? "override_keyword_only_allowed_on_virtual_member_functions" : "err_function_marked_override_not_overriding";
                String message = type == OCTokenTypes.OVERRIDE_CPP_KEYWORD ? "Function doesn't override any base member functions" : "Only virtual member functions can be marked 'final'";
                Annotation error = this.addErrorAnnotation(spec, clangID, message);
                this.registerQuickFix(error, new OCRemoveTypeModifierIntentionAction(symbol, (OCElementType)type, context.getProject()));
                reported = true;
                if (!highlighting || error == null) continue;
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes ha = scheme.getAttributes(OCHighlightingKeys.OC_KEYWORD);
                TextAttributes ea = scheme.getAttributes(error.getTextAttributes());
                error.setEnforcedTextAttributes(TextAttributes.merge((TextAttributes)ha, (TextAttributes)ea));
            }
        }
    }

    private void checkPureVirtual(OCFunctionSymbol symbol, @NotNull OCExpression initializer) {
        Annotation annotation;
        if (!OCCallableUtil.resolveIsVirtual(symbol, initializer.getProject())) {
            annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_non_virtual_pure", "Only virtual function can have pure specifier");
            this.registerQuickFix(annotation, new OCMakeFunctionVirtualFix(symbol, false, initializer.getProject()));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, OCInspectionsBundle.message("quick.fix.remove.pure.specifier", new Object[0])));
        }
        if (!(initializer instanceof OCLiteralExpression) || !"0".equals(((OCLiteralExpression)initializer).getUnescapedLiteralText())) {
            annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_member_function_initialization", "Invalid pure specifier");
            OCExpression zero = OCElementFactory.expressionFromText("0", initializer, false);
            this.registerQuickFix(annotation, new OCChangeElementIntentionAction((PsiElement)initializer, (PsiElement)zero, OCInspectionsBundle.message("quick.fix.change.pure.specifier", new Object[0])));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, OCInspectionsBundle.message("quick.fix.remove.pure.specifier", new Object[0])));
        }
    }

    private void checkFunctionReturnTypes(@NotNull OCFunctionDeclaration element, OCFunctionSymbol derivedFunction, OCFunctionSymbol baseFunction, boolean allowCovariance, String derivedSubject, String derivedLongSubject, String baseSubject, String clangID) {
        OCResolveContext context = OCResolveContext.forPsi(element);
        OCType baseType = baseFunction.getType().getReturnType().resolve(context);
        OCType derivedType = derivedFunction.getType().getReturnType().resolve(context);
        String baseTypeName = baseType.getName(element);
        String overriddenTypeName = derivedType.getName(element);
        OCTypeElement annotationElement = element.getTypeElement();
        annotationElement = annotationElement != null ? annotationElement : element;
        Annotation annotation = null;
        if (allowCovariance && (baseType.isPointer() || baseType instanceof OCCppReferenceType) && (derivedType.isPointer() || derivedType instanceof OCCppReferenceType)) {
            String message = "Return type of " + derivedLongSubject + " (" + overriddenTypeName + ") isn't derived from the return type of " + baseSubject + " (" + baseTypeName + ")";
            if (!baseType.getTerminalType().isSuperType(derivedType.getTerminalType(), annotationElement)) {
                annotation = this.addErrorAnnotation(annotationElement, OCInspections.DerivedFunctionsReturnTypeMismatch.class, "err_covariant_return_not_derived", message);
            }
        } else if (!new OCTypeEqualityAfterResolvingVisitor(derivedType, true, true, false, true, context).equal(baseType)) {
            String message = "Return type of " + derivedLongSubject + " (" + overriddenTypeName + ") differs from the return type of " + baseSubject + " (" + baseTypeName + ")";
            annotation = this.addErrorAnnotation(annotationElement, OCInspections.DerivedFunctionsReturnTypeMismatch.class, clangID, message);
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)derivedFunction, baseType, true, derivedSubject, (OCCompilationContext)context));
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseFunction, derivedType, true, baseSubject, (OCCompilationContext)context));
        }
    }

    private static String getMissingDefaultCtorsMessage(Collection<OCStructSymbol> classesMissingDefaultCtors) {
        boolean mutual = classesMissingDefaultCtors.size() > 1;
        return "Base " + (mutual ? StringUtil.pluralize((String)"class") : "class") + " " + StringUtil.join(classesMissingDefaultCtors, symbol -> "'" + symbol.getName() + "'", (String)", ") + (mutual ? " don't" : " doesn't") + " have a default constructor";
    }

    private static List<OCStructSymbol> getBaseClasses(OCStructSymbol symbol, @NotNull OCResolveContext context) {
        ArrayList<OCStructSymbol> baseClasses = new ArrayList<OCStructSymbol>();
        symbol.processBaseClasses(context, (symbol1, visibility) -> {
            if (symbol1 instanceof OCStructSymbol) {
                baseClasses.add((OCStructSymbol)symbol1);
            }
            return true;
        });
        return baseClasses;
    }

    public void checkClass(OCStruct parent) {
        OCCompilationContext context;
        OCStructSymbol symbol = (OCStructSymbol)parent.getSymbol();
        if (symbol == null || symbol.isPredeclaration()) {
            return;
        }
        OCCppBaseClauseList baseClausesList = parent.getBaseClausesList();
        if (baseClausesList != null) {
            context = OCCompilationContext.create(parent);
            for (OCCppBaseClause baseClause : baseClausesList.getBaseClauses()) {
                OCReferenceElement refElement = baseClause.getReferenceElement();
                OCSymbol baseClass = refElement != null ? refElement.resolveToSymbol() : null;
                if (!(baseClass instanceof OCStructSymbol) || !((OCStructSymbol)baseClass).isFinal()) continue;
                Annotation annotation = this.addErrorAnnotation(baseClause, "err_class_marked_final_used_as_base", baseClass.getNameWithKindUppercase(context) + " is marked as final");
                this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)baseClass, (OCElementType)OCTokenTypes.FINAL_CPP_KEYWORD, context.getProject()));
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)baseClause, OCInspectionsBundle.message("quick.fix.remove.from.base.classes.list", baseClass.getName())));
            }
        }
        if (!symbol.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), (OCResolveContext)(context = OCResolveContext.forPsi(parent)))) {
            return;
        }
        List classesMissingDefaultCtors = ContainerUtil.filter(OCCppChecker.getBaseClasses(symbol, (OCResolveContext)context), arg_0 -> OCCppChecker.lambda$checkClass$3((OCResolveContext)context, arg_0));
        if (!classesMissingDefaultCtors.isEmpty()) {
            String message = OCCppChecker.getMissingDefaultCtorsMessage(classesMissingDefaultCtors);
            Annotation annotation = this.addErrorAnnotation(parent.getHeaderRange(), OCInspections.NoDefaultBaseConstructor.class, "err_missing_default_ctor", message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            this.registerQuickFix(annotation, new OCGenerateConstructorFix(symbol, true, ((OCResolveContext)context).getProject()));
            for (OCStructSymbol baseClass : classesMissingDefaultCtors) {
                this.registerQuickFix(annotation, new OCGenerateConstructorFix(baseClass, false, ((OCResolveContext)context).getProject()));
            }
        }
    }

    private void checkConstructorDefinition(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        if (!(symbol.isCppConstructor() && symbol.isDefinition() && function instanceof OCFunctionDefinition)) {
            return;
        }
        final OCResolveContext context = OCResolveContext.forPsi(function);
        OCSymbolWithQualifiedName symbolOwner = symbol.getResolvedOwner(context);
        if (symbolOwner instanceof OCStructSymbol) {
            List classesMissingCtors;
            OCStructSymbol structSymbol = (OCStructSymbol)symbolOwner;
            LinkedHashSet<OCStructSymbol> baseClasses = new LinkedHashSet<OCStructSymbol>(OCCppChecker.getBaseClasses(structSymbol, context));
            CommonProcessors.CollectProcessor<OCDeclaratorSymbol> collector = new CommonProcessors.CollectProcessor<OCDeclaratorSymbol>(){

                protected boolean accept(OCDeclaratorSymbol field) {
                    if (field.getKind() == OCSymbolKind.STRUCT_FIELD && !field.isFriendOrStatic() && !(field.getResolvedType(context) instanceof OCArrayType)) {
                        OCType type = field.getResolvedType(context);
                        return type instanceof OCStructType || type instanceof OCCppReferenceType || field.isConst();
                    }
                    return false;
                }
            };
            structSymbol.processFields((Processor<? super OCDeclaratorSymbol>)collector);
            HashSet fieldsToInitialize = new HashSet(collector.getResults());
            OCConstructorInitializationList initializationList = ((OCFunctionDefinition)function).getConstructorInitializationList();
            if (initializationList != null) {
                for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                    OCReferenceElement referenceElement = initializer.getReferenceElement();
                    if (referenceElement == null) continue;
                    OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(referenceElement);
                    OCSymbolReference.LocalReference localReference = OCSymbolReference.getLocalReference(qualifiedName, (PsiElement)referenceElement);
                    for (OCSymbol initializerSymbol : localReference.resolveToSymbols(true, false, OCResolveContext.forPsi(referenceElement))) {
                        if (initializerSymbol instanceof OCDeclaratorSymbol && fieldsToInitialize.contains(initializerSymbol)) {
                            fieldsToInitialize.remove(initializerSymbol);
                            continue;
                        }
                        if (initializerSymbol instanceof OCFunctionSymbol) {
                            initializerSymbol = ((OCFunctionSymbol)initializerSymbol).getResolvedOwner(context);
                        }
                        if (symbolOwner.equals(initializerSymbol)) {
                            return;
                        }
                        if (!(initializerSymbol instanceof OCStructSymbol)) continue;
                        baseClasses.remove(initializerSymbol);
                    }
                }
            }
            if (!(classesMissingCtors = ContainerUtil.filter(baseClasses, struct -> !struct.hasDefaultConstructor(context))).isEmpty()) {
                String message = OCCppChecker.getMissingDefaultCtorsMessage(classesMissingCtors);
                Annotation annotation = this.addErrorAnnotation(function, OCInspections.NoDefaultBaseConstructor.class, "err_missing_default_ctor", message);
                this.registerQuickFix(annotation, new OCAddSuperConstructorCallsFix(symbol, classesMissingCtors, context.getProject()));
                for (OCStructSymbol baseClass : classesMissingCtors) {
                    this.registerQuickFix(annotation, new OCGenerateConstructorFix(baseClass, false, context.getProject()));
                }
            } else {
                for (OCStructSymbol baseClass : baseClasses) {
                    OCVisibility.checkFieldVisibility(baseClass.getDefaultConstructor(context), function, null, this);
                }
            }
            for (OCDeclaratorSymbol fieldToInitialize : fieldsToInitialize) {
                OCType fieldType = fieldToInitialize.getResolvedType(context);
                OCDeclarator declarator = (OCDeclarator)fieldToInitialize.locateDefinition(function.getProject());
                if (declarator != null && !declarator.getInitializers().isEmpty()) continue;
                if (fieldType instanceof OCStructType) {
                    OCStructSymbol fieldStructSymbol = ((OCStructType)fieldType).getSymbol();
                    OCFunctionSymbol constructor = fieldStructSymbol.getDefaultConstructor(context);
                    if (constructor != null) {
                        OCVisibility.checkFieldVisibility(constructor, function, null, this);
                        continue;
                    }
                    if (fieldStructSymbol.hasDefaultConstructor(context)) continue;
                }
                OCCompilationContext compilationContext = OCCompilationContext.create(function);
                Annotation annotation = this.addErrorAnnotation(function, OCInspections.FieldMustBeInitialized.class, "err_uninitialized_member_in_ctor", fieldToInitialize.getNameWithKindUppercase(compilationContext) + " must be initialized");
                this.registerQuickFix(annotation, new OCAddParametersToConstructorAction(fieldToInitialize, structSymbol, function, symbol));
                if (fieldType instanceof OCCppReferenceType) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(fieldToInitialize, ((OCCppReferenceType)fieldType).getRefType(), context));
                } else {
                    if (!(fieldType instanceof OCStructType)) {
                        this.registerQuickFix(annotation, new OCAddFieldInitializerFix((OCFunctionDefinition)function, fieldToInitialize));
                    }
                    if (OCCompilerFeaturesHelper.supportsInClassInitialization(function.getContainingFile())) {
                        this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, fieldToInitialize));
                    }
                }
                if (fieldToInitialize.isConst()) {
                    this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction(fieldToInitialize, OCTokenTypes.CONST_KEYWORD, context.getProject()));
                }
                if (!(fieldType instanceof OCStructType)) continue;
                this.registerQuickFix(annotation, new OCGenerateConstructorFix(((OCStructType)fieldType).getSymbol(), false, context.getProject()));
            }
        }
    }

    public void checkTypeInitialization(@NotNull OCElement element, @Nullable PsiElement callElement, @NotNull OCArgumentsList<OCExpression> arguments, @Nullable OCSymbol symbol, @NotNull OCType type, boolean isCast, PsiElement expression) {
        List<OCExpression> argumentExprs = arguments.getExprs();
        if (argumentExprs == null) {
            return;
        }
        if (type instanceof OCStructType && !((OCStructType)type).isEnumClass() && !((OCStructType)type).isEnum()) {
            OCFunctionSymbol constructor = ((OCStructType)type).findConstructor(arguments, OCResolveContext.forPsi(element), element, true, null, false).getSymbol();
            this.checkConstructorCall(element, argumentExprs, constructor, (OCStructType)type);
        } else if (argumentExprs.size() > 1 && !(OCTypeUtils.getCppReferencedType(type) instanceof OCMagicType)) {
            this.addErrorAnnotation(argumentExprs.get(1), "err_excess_initializers", "Only one initializer is permitted");
        } else if (argumentExprs.size() == 1) {
            OCExpression argument = argumentExprs.get(0);
            OCType initializerType = argument.getResolvedType();
            OCResolveContext context = OCResolveContext.forPsi(expression);
            if (isCast) {
                this.checkTypeCast(type, initializerType, callElement, argument, expression, context);
            } else {
                OCTypeCompatibilityVisitor.checkConvertible(type, initializerType, argument, element, true, true, context).setDestSymbol(symbol).setSymbolRequiredType(initializerType).annotate(this);
            }
        }
    }

    public boolean checkConstructorCall(@NotNull OCElement element, @NotNull List<OCExpression> arguments, @Nullable OCSymbol constructor, @Nullable OCStructType structHint) {
        OCSymbol structSymbolToFixConstructorFor = null;
        Annotation annotation = null;
        boolean isRecoveringFromOverloadFailure = false;
        if (constructor instanceof OCFunctionSymbol) {
            OCFileSymbols.markSymbolAsUsed(element.getContainingOCFile(), ((OCFunctionSymbol)constructor).getParent(), element);
        }
        if (constructor instanceof OCFunctionGroupSymbol) {
            OCFunctionGroupSymbol groupSymbol = (OCFunctionGroupSymbol)constructor;
            if (groupSymbol.getCause() == OCFunctionGroupSymbol.Cause.Magic) {
                return true;
            }
            if (groupSymbol.getOverloads().size() == 1) {
                constructor = groupSymbol.getOverloads().get(0);
                isRecoveringFromOverloadFailure = true;
            } else {
                structSymbolToFixConstructorFor = ((OCFunctionGroupSymbol)constructor).getParent();
                annotation = OCFunctionGroupHelperKt.annotateAmbig(this, element, groupSymbol, "No matching constructor");
            }
        }
        OCResolveContext context = OCResolveContext.forPsi(element);
        if (structSymbolToFixConstructorFor == null) {
            if (constructor instanceof OCFunctionSymbol) {
                OCFunctionType funcType = (OCFunctionType)constructor.getType().resolve(context);
                boolean result = this.annotateFunctionArguments(element, funcType, arguments, constructor, isRecoveringFromOverloadFailure);
                return result &= OCVisibility.checkFieldVisibility(constructor, element, null, this);
            }
            if (constructor != null && constructor.getKind() == OCSymbolKind.STRUCT) {
                structSymbolToFixConstructorFor = constructor;
            } else if (structHint != null) {
                structSymbolToFixConstructorFor = structHint.getSymbol();
            }
        }
        if (structSymbolToFixConstructorFor != null) {
            List argumentTypes = ContainerUtil.map(arguments, expression -> OCExpectedTypeUtil.getExpressionType(expression, true));
            OCFunctionType type = new OCFunctionType(OCVoidType.instance(), argumentTypes);
            if (annotation == null) {
                annotation = this.addErrorAnnotation(element, OCInspections.CannotResolve.class, "CIDR", OCCppChecker.getCantResolveCtorMessage(structSymbolToFixConstructorFor, type, context));
            }
            if (annotation != null) {
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, element, structSymbolToFixConstructorFor, structSymbolToFixConstructorFor.getName(), type));
            }
            return false;
        }
        return true;
    }

    boolean annotateFunctionArguments(@NotNull OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol, boolean isRecoveringFromOverloadFailure) {
        OCResolveContext context = OCResolveContext.forPsi(element);
        List<OCTypeCheckResult> results = OCArgumentsChecker.checkFunctionArguments(element, funcType, arguments, functionSymbol, context, isRecoveringFromOverloadFailure);
        results.forEach(result -> result.annotate(this));
        return results.stream().allMatch(result -> result.getState().isOK());
    }

    public void checkTypeCast(OCType lType, OCType rType, PsiElement typeElement, OCExpression operand, PsiElement expression, @NotNull OCResolveContext context) {
        OCObjectType rObjectType;
        OCObjectType lObjectType;
        String rTypeName = rType.getName(context);
        String lTypeName = lType.getName(context);
        if (!this.checkARCPointerTypes(lType, typeElement, null)) {
            return;
        }
        OCTypeCheckResult typeCheckResult = OCTypeCompatibilityVisitor.checkConvertible(lType, rType, operand, expression, true, true, context);
        if (!typeCheckResult.canBeCasted(lType, rType, context) || typeCheckResult.getInspectionClass() == OCInspections.BridgeCastIssues.class) {
            String message = "Expression of type '" + rTypeName + "' can't be cast to type '" + lTypeName + "': " + typeCheckResult.getMessage();
            Annotation annotation = this.addErrorAnnotation(typeElement, typeCheckResult.getInspectionClass(), "err_typecheck_expect_scalar_operand", message);
            OCChangeTypeIntentionAction.registerChangeTypeFix(operand, lType, annotation, this);
            for (IntentionAction fix : typeCheckResult.getQuickFixes()) {
                this.registerQuickFix(annotation, fix);
            }
            return;
        }
        if (lType.isPointerToObject() && rType.isPointerToObject() && !(lObjectType = (OCObjectType)lType.getTerminalType()).isAncestorOf(rObjectType = (OCObjectType)rType.getTerminalType()) && !rObjectType.isAncestorOf(lObjectType)) {
            String message = "Casting expression of type '" + rTypeName + "' to incompatible type '" + lTypeName + "'";
            this.addWarningAnnotation(typeElement, OCInspections.IncompatiblePointers.class, "CIDRobjc_incompatible_pointers", message);
            return;
        }
        if (lType.getAliasName() == null && rType.getAliasName() == null && !(operand instanceof OCLiteralExpression)) {
            rType = operand.getResolvedType();
            if (!(!rType.isPointerToID() || lType.isPointerToID() && ((OCObjectType)lType.getTerminalType()).getAllProtocols().isEmpty())) {
                return;
            }
            Annotation annotation = null;
            if (!(!lType.isPointerToObject() || lType.isPointerToID() || typeCheckResult.getState() != OCTypeCheckState.OK || rType instanceof OCPointerType && ((OCPointerType)rType).getRefType() instanceof OCVoidType)) {
                message = "Casting expression of type '" + rTypeName + "' to '" + lTypeName + "' is redundant";
                annotation = this.addWarningAnnotation(typeElement, OCInspections.RedundantCast.class, "CIDR", message, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            } else if (lType.equals(rType, false, context)) {
                message = "Casting expression to '" + lTypeName + "' is redundant";
                annotation = this.addWarningAnnotation(typeElement, OCInspections.RedundantCast.class, "CIDR", message, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            if (annotation != null) {
                OCExpression oldElement = OCParenthesesUtils.topmostParenthesized((OCExpression)expression);
                OCExpression newElement = OCParenthesesUtils.diveIntoParentheses(operand);
                this.registerQuickFix(annotation, new OCChangeElementIntentionAction((PsiElement)oldElement, (PsiElement)newElement, OCInspectionsBundle.message("quick.fix.remove.redundant.cast", new Object[0])));
            }
        }
    }

    public boolean checkARCPointerTypes(@Nullable OCType lType, @Nullable PsiElement element, @Nullable OCSymbol symbol) {
        if (element == null || !OCCompilerFeaturesHelper.isArcEnabled(element.getContainingFile())) {
            return true;
        }
        if (lType instanceof OCPointerType && lType.getTerminalType() instanceof OCObjectType) {
            OCPointerType pointerType = (OCPointerType)lType;
            int numOfExtraRefs = 0;
            boolean wasNotArray = false;
            while (pointerType.getRefType() instanceof OCPointerType && ((OCPointerType)pointerType.getRefType()).getRefType() instanceof OCPointerType) {
                if (!(pointerType instanceof OCArrayType)) {
                    wasNotArray = true;
                }
                pointerType = (OCPointerType)pointerType.getRefType();
                ++numOfExtraRefs;
            }
            if (!(pointerType instanceof OCArrayType && !wasNotArray || !(pointerType.getRefType() instanceof OCPointerType) || pointerType.isPointerToConst() || ((OCPointerType)pointerType.getRefType()).getARCAttribute() != null || symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER)) {
                Annotation annotation = this.addErrorAnnotation(element, OCInspections.ARCIssues.class, "err_arc_indirect_no_ownership", "Pointer to non-const type '" + lType.getName(element) + "' with no explicit lifetime");
                if (symbol != null) {
                    OCCompilationContext context = OCCompilationContext.create(element);
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, OCPointerType.to((OCType)OCPointerType.to(pointerType.getRefType().cloneWithConstModifier(element.getProject()), null), numOfExtraRefs), context));
                    for (ARCAttribute attribute2 : ARCAttribute.values()) {
                        this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, attribute2, context));
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static String getCantResolveCtorMessage(OCSymbol symbol, OCFunctionType type, @NotNull OCResolveContext context) {
        return symbol.getKindUppercase(context) + " '" + symbol.getType().getBestNameInContext(context) + "' doesn't have a constructor '" + OCTypeNameVisitor.getFunctionSignature(context, type, symbol.getName()) + "'";
    }

    private static /* synthetic */ boolean lambda$checkClass$3(OCResolveContext context, OCStructSymbol struct) {
        return !struct.hasDefaultConstructor(context);
    }
}

