/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitIntoSeparateDeclarationsIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.split.into.separate.declarations", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        boolean isInBlock;
        PsiElement element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, file);
        if (!OCCodeInsightUtil.isValid(element)) {
            return false;
        }
        boolean bl = isInBlock = PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class) != null;
        if (element instanceof OCDeclaration) {
            return (!isInBlock || element.getParent().getParent() instanceof OCBlockStatement) && OCSplitIntoSeparateDeclarationsIntentionAction.hasSplittableDeclarators(element);
        }
        if (element instanceof OCDeclarator) {
            return (!isInBlock || element.getParent().getParent().getParent() instanceof OCBlockStatement) && OCSplitIntoSeparateDeclarationsIntentionAction.hasSplittableDeclarators(element.getParent());
        }
        if (element instanceof OCSynthesizeProperty) {
            return OCSplitIntoSeparateDeclarationsIntentionAction.hasSplittableDeclarators(element.getParent());
        }
        return false;
    }

    private static boolean hasSplittableDeclarators(@Nullable PsiElement element) {
        if (element instanceof OCStructuredBindingDeclaration) {
            return false;
        }
        if (element instanceof OCDeclaration) {
            return ((OCDeclaration)element).getDeclarators().size() > 1;
        }
        if (element instanceof OCSynthesizePropertiesList) {
            return ((OCSynthesizePropertiesList)element).getProperties().size() > 1;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(file.getViewProvider().getDocument());
        PsiElement element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, file);
        if (element instanceof OCDeclaration) {
            OCNormalizeUtil.normalizeDeclaration((OCDeclaration)element);
        } else if (element instanceof OCDeclarator) {
            OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
        } else if (element instanceof OCSynthesizeProperty) {
            OCNormalizeUtil.normalizeSynthesizeStatement((OCSynthesizeProperty)element);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static PsiElement getElement(Editor editor, PsiFile file) {
        OCTypeElement typeElement;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class, OCSynthesizeProperty.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration) {
            return typeElement.getParent();
        }
        return declarator;
    }
}

