/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCBraceToggleBaseIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSingleStatementWithBracesIntentionAction
extends OCBraceToggleBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCSingleStatementWithBracesIntentionAction.class);

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.remove.braces.statement", this.getStatementName());
    }

    @Nullable
    private OCBlockStatement getContainedBlockStatement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        PsiElement bodyElement = this.getBodyElement(statement, element);
        if (!(bodyElement instanceof OCBlockStatement)) {
            return null;
        }
        return (OCBlockStatement)bodyElement;
    }

    @Override
    protected void doRun(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement statement = OCSingleStatementWithBracesIntentionAction.getParentStatement(element);
        LOG.assertTrue(statement != null);
        OCBlockStatement blockStatement = this.getContainedBlockStatement(statement, element);
        LOG.assertTrue(blockStatement != null);
        List<OCStatement> statements = blockStatement.getStatements();
        LOG.assertTrue(statements.size() == 1);
        PsiElement bodyStatement = statements.get(0);
        CaretModel caretModel = editor.getCaretModel();
        int moveCaretBy = OCSingleStatementWithBracesIntentionAction.getCaretAdjustment(caretModel, bodyStatement);
        PsiElement newElement = OCSingleStatementWithBracesIntentionAction.replaceElement(blockStatement, bodyStatement);
        OCSingleStatementWithBracesIntentionAction.moveCaret(caretModel, moveCaretBy, newElement);
        OCSingleStatementWithBracesIntentionAction.reformat(project, editor.getDocument(), statement);
    }

    @Override
    protected boolean isValidElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCBlockStatement blockStatement = this.getContainedBlockStatement(statement, element);
        return blockStatement != null && OCParenthesesUtils.canStripBraces(blockStatement);
    }

    @NotNull
    private static PsiElement replaceElement(@NotNull PsiElement oldElement, @NotNull PsiElement replaceElement) {
        PsiElement leftMostSibling = OCSingleStatementWithBracesIntentionAction.getLeftMostMacroCallOrWhiteSpaceSibling(replaceElement);
        PsiElement rightMostSibling = OCSingleStatementWithBracesIntentionAction.getRightMostMacroCallOrWhiteSpaceSibling(replaceElement);
        if (leftMostSibling != replaceElement) {
            oldElement.getParent().addRangeBefore(leftMostSibling, replaceElement.getPrevSibling(), oldElement);
            replaceElement.getParent().deleteChildRange(leftMostSibling, replaceElement.getPrevSibling());
        }
        if (rightMostSibling != replaceElement) {
            oldElement.getParent().addRangeAfter(replaceElement.getNextSibling(), rightMostSibling, oldElement);
            replaceElement.getParent().deleteChildRange(replaceElement.getNextSibling(), rightMostSibling);
        }
        return oldElement.replace(replaceElement);
    }
}

