/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCRemoveUnnecessaryParenthesesIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCParenthesizedExpression expression = (OCParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class);
        if (expression == null || OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression.getOperand()) && !(expression.getParent() instanceof OCParenthesizedExpression)) {
            return false;
        }
        this.setText(this.getFamilyName());
        PsiElement parent = expression.getParent();
        if (parent instanceof OCParenthesizedExpression) {
            return true;
        }
        OCExpression child = expression.getOperand();
        if (child instanceof OCParenthesizedExpression || child instanceof OCSendMessageExpression) {
            return true;
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence((OCExpression)parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(child, false))) {
                return true;
            }
            if (parentPrecedence < destPrecedence) {
                return false;
            }
            if (parent instanceof OCBinaryExpression && expression == ((OCBinaryExpression)parent).getRight()) {
                return !OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, child);
            }
            if (parent instanceof OCAssignmentExpression && expression == ((OCAssignmentExpression)parent).getReceiverExpression()) {
                return !OCParenthesesUtils.isParenthesesNeededInLeftArgument((OCAssignmentExpression)parent, child);
            }
            return true;
        }
        return true;
    }

    private static boolean isAssignmentInCondition(OCExpression parent) {
        return parent instanceof OCAssignmentExpression && OCRemoveUnnecessaryParenthesesIntention.isExpectedBool(parent);
    }

    private static boolean isExpectedBool(@NotNull OCExpression parent) {
        OCResolveContext context = OCResolveContext.forPsi(parent);
        return OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(parent, context), context);
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.remove.unnecessary.parentheses", new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCExpression expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class);
        if (expression == null) {
            return;
        }
        OCExpression parent = expression;
        OCParenthesizedExpression prevParent = (OCParenthesizedExpression)expression;
        while (parent instanceof OCParenthesizedExpression) {
            prevParent = (OCParenthesizedExpression)parent;
            parent = parent.getParent();
        }
        while (expression instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expression)) {
            expression = ((OCParenthesizedExpression)expression).getOperand();
        }
        if (OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression) && expression.getParent() instanceof OCExpression) {
            expression = (OCExpression)expression.getParent();
        }
        if (expression == null) {
            return;
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence(parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(expression, false)) || expression instanceof OCSendMessageExpression) {
                OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
            } else if (parentPrecedence < destPrecedence) {
                OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, true);
            } else if (parent instanceof OCBinaryExpression && prevParent == ((OCBinaryExpression)parent).getRight()) {
                if (OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, expression)) {
                    OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, true);
                } else {
                    OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
                }
            } else if (parent instanceof OCAssignmentExpression && prevParent == ((OCAssignmentExpression)parent).getReceiverExpression()) {
                if (OCParenthesesUtils.isParenthesesNeededInLeftArgument((OCAssignmentExpression)parent, expression)) {
                    OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, true);
                }
            } else {
                OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
            }
        } else {
            OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parent);
    }

    private static void replaceExpression(@NotNull PsiElement topmostParenthesesElement, @NotNull OCExpression expression, boolean appendParentheses) {
        SmartList elementsToPreserveBefore = new SmartList();
        SmartList elementsToPreserveAfter = new SmartList();
        for (OCExpression parentElement = expression; parentElement != topmostParenthesesElement; parentElement = parentElement.getParent()) {
            elementsToPreserveBefore.addAll(0, OCRemoveUnnecessaryParenthesesIntention.getElementsToPreserveBefore(parentElement));
            elementsToPreserveAfter.addAll(OCRemoveUnnecessaryParenthesesIntention.getElementsToPreserveAfter(parentElement));
        }
        if (appendParentheses) {
            OCParenthesizedExpression targetExpression = OCParenthesesUtils.appendParentheses(expression);
            OCExpression targetExpressionOperand = OCParenthesesUtils.diveIntoParentheses(targetExpression);
            if (targetExpressionOperand != null) {
                OCRemoveUnnecessaryParenthesesIntention.copyElementsBefore((List<PsiElement>)elementsToPreserveBefore, targetExpressionOperand);
                OCRemoveUnnecessaryParenthesesIntention.copyElementsAfter((List<PsiElement>)elementsToPreserveAfter, targetExpressionOperand);
            }
            OCChangeUtil.replaceHandlingMacros(topmostParenthesesElement, targetExpression);
        } else {
            OCRemoveUnnecessaryParenthesesIntention.copyElementsBefore((List<PsiElement>)elementsToPreserveBefore, topmostParenthesesElement);
            OCRemoveUnnecessaryParenthesesIntention.copyElementsAfter((List<PsiElement>)elementsToPreserveAfter, topmostParenthesesElement);
            OCChangeUtil.replaceHandlingMacros(topmostParenthesesElement, expression);
        }
    }

    private static List<PsiElement> getElementsToPreserveBefore(@NotNull PsiElement element) {
        PsiElement prevSibling;
        SmartList elements = new SmartList();
        PsiElement elementBefore = element;
        while ((prevSibling = elementBefore.getPrevSibling()) != null && OCTokenTypes.LPAR != prevSibling.getNode().getElementType()) {
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prevSibling.getNode().getElementType())) {
                elements.add(prevSibling);
            }
            elementBefore = prevSibling;
        }
        return elements;
    }

    private static List<PsiElement> getElementsToPreserveAfter(@NotNull PsiElement element) {
        PsiElement nextSibling;
        SmartList elements = new SmartList();
        PsiElement elementAfter = element;
        while ((nextSibling = elementAfter.getNextSibling()) != null && OCTokenTypes.RPAR != nextSibling.getNode().getElementType()) {
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(nextSibling.getNode().getElementType())) {
                elements.add(nextSibling);
            }
            elementAfter = nextSibling;
        }
        return elements;
    }

    private static void copyElementsBefore(@NotNull List<PsiElement> beforeElements, @NotNull PsiElement targetElement) {
        for (PsiElement beforeElement : beforeElements) {
            targetElement.getParent().addBefore(beforeElement, targetElement);
        }
    }

    private static void copyElementsAfter(@NotNull List<PsiElement> afterElements, @NotNull PsiElement targetElement) {
        for (int i = afterElements.size() - 1; i >= 0; --i) {
            targetElement.getParent().addAfter(afterElements.get(i), targetElement);
        }
    }
}

