/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCExtractSuperClassHandler;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCExtractSuperClassIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.extract.super.class", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (OCNewFileActionBase.isNewFileActionSupported((Project)project) && element != null && OCCodeInsightUtil.isValid((PsiElement)file) && (OCElementUtil.getElementType(element) == OCTokenTypes.IDENTIFIER || OCElementUtil.getElementType(element.getPrevSibling()) == OCTokenTypes.IDENTIFIER)) {
            PsiElement parent = element.getParent();
            return parent instanceof OCInterface || parent instanceof OCImplementation;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        new OCExtractSuperClassHandler().invoke(project, editor, file, SimpleDataContext.getProjectContext((Project)project));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

