/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIvarInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertToIvarIntentionAction
extends OCGenerateIvarsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.convert.to.instance.variable", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    public OCPropertySymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class, OCSendMessageExpression.class);
        OCSymbol symbol = null;
        if (parent instanceof OCReferenceElement) {
            symbol = ((OCReferenceElement)parent).resolveToSymbol();
        } else if (parent instanceof OCDeclarator) {
            symbol = ((OCDeclarator)parent).getSymbol();
        } else if (parent instanceof OCQualifiedExpression) {
            symbol = ((OCQualifiedExpression)parent).resolveToSymbol();
        } else if (parent instanceof OCSendMessageExpression) {
            symbol = ((OCSendMessageExpression)parent).getProbableResponders().getKnownResponder();
        }
        if (symbol instanceof OCMethodSymbol) {
            symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
        }
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return OCSearchScope.isInProjectSources(this.locateCandidate(project, editor, file), project);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        OCPropertySymbol property = this.locateCandidate(project, editor, file);
        return property != null ? property.getParent().getMainInterface(project) : null;
    }

    @Override
    protected boolean replaceAllProperties() {
        return true;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project, Editor editor, final @NotNull PsiFile file, final @NotNull OCGenerateIvarsActionContext context, final @NotNull List<OCPropertySymbol> properties) {
        final OCPropertySymbol property = this.locateCandidate(project, editor, file);
        if (property == null) {
            return;
        }
        OCInstanceVariableSymbol associatedIvar = property.getAssociatedIvar(project);
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        final OCElement element = (OCElement)OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class, OCSendMessageExpression.class);
        final String ivarName = associatedIvar != null ? associatedIvar.getName() : OCNameSuggester.getNonCollidingName(property, true, project);
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element);
        OCBaseLocalConvertibleHandler handler = new OCBaseLocalConvertibleHandler(OCRefactoringBundle.message("refactoring.introduce.ivar.name", new Object[0])){

            protected OCIvarInplaceIntroducer createIntroducer(Project project, Editor editor, PsiElement expression, List<PsiElement> occurrences, @NlsContexts.Command String refactoringName) {
                return new OCIvarInplaceIntroducer(project, editor, expression, occurrences, refactoringName){

                    @Override
                    public PsiElement evaluateAnchor() {
                        return element;
                    }

                    public PsiElement[] getOccurrences() {
                        PsiElement[] psiElementArray;
                        PsiElement occurrence = pointer.getElement();
                        if (occurrence != null) {
                            PsiElement[] psiElementArray2 = new PsiElement[1];
                            psiElementArray = psiElementArray2;
                            psiElementArray2[0] = occurrence;
                        } else {
                            psiElementArray = PsiElement.EMPTY_ARRAY;
                        }
                        return psiElementArray;
                    }

                    @Override
                    protected void performIntroduce() {
                        OCConvertToIvarIntentionAction.this.performAction(file, context, properties, this.getInputName(), this.myDeclareInInterfaceCb != null && !this.myDeclareInInterfaceCb.isSelected());
                    }

                    @Override
                    protected boolean askToGenerateProperty() {
                        return false;
                    }

                    @Override
                    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
                        if (!ivarName.equals(property.getName())) {
                            return new String[]{ivarName, property.getName()};
                        }
                        return new String[]{ivarName};
                    }
                };
            }

            @Override
            @NotNull
            protected String getFeatureID() {
                return "refactoring.convertToIvar";
            }
        };
        handler.invoke(project, editor, element, property.getResolvedType(OCResolveContext.forPsi((PsiElement)file)), true, false, ivarName, property.getParent());
    }
}

