/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCSafeDeleteProcessorDelegateBase;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.OCPropertyReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCConceptSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnusedVisitor
extends OCVisitor {
    public static final Key<Boolean> UNUSED_INSPECTION_MODE_KEY = Key.create((String)"UNUSED_INSPECTION_MODE_KEY");
    private final OCInspection myInspection;
    private OCSymbol mySymbol;
    protected boolean myOnTheFly;
    @Nullable
    private ProblemsHolder myHolder;
    @Nullable
    private ProblemDescriptionsProcessor myProcessor;
    @Nullable
    private GlobalInspectionContext myGlobalContext;
    @Nullable
    protected SearchScope myScope;

    public OCUnusedVisitor(OCInspection inspection) {
        this.myInspection = inspection;
    }

    public void setUpForBatchMode(ProblemDescriptionsProcessor processor2, GlobalInspectionContext globalContext, SearchScope scope) {
        this.myProcessor = processor2;
        this.myGlobalContext = globalContext;
        this.myScope = scope;
        this.myOnTheFly = false;
    }

    public void checkFromBatchMode(@NotNull OCSymbol symbol, @NotNull PsiElement declarator) {
        this.mySymbol = symbol;
        declarator.accept((PsiElementVisitor)this);
    }

    public void setHolder(@Nullable ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    @Nullable
    protected OCSymbol getSymbol(OCSymbolDeclarator declarator) {
        return this.mySymbol != null ? this.mySymbol : declarator.getSymbol();
    }

    protected void registerProblem(@Nullable PsiElement element, @Nls String message, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        this.myInspection.registerProblem(this.myHolder, this.myProcessor, this.myGlobalContext, this.myOnTheFly, element, message, "CIDR", highlightType, quickFixes);
    }

    protected void registerProblems(@NotNull List<PsiElement> elements, @Nls String message, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        this.myInspection.registerProblems(this.myHolder, this.myProcessor, this.myGlobalContext, this.myOnTheFly, elements, message, "CIDR", highlightType, quickFixes);
    }

    protected void checkSymbolUsed(PsiElement element, OCSymbol symbol) {
        this.checkSymbolUsed(element, element, symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSymbolUsed(PsiElement element, PsiElement navigationElement, OCSymbol symbol) {
        if (element == null || navigationElement == null) {
            return;
        }
        Project project = element.getProject();
        OCFile.UnusedChecksMode checksMode = (OCFile.UnusedChecksMode)((Object)project.getUserData(OCFile.UNUSED_CHECKS));
        if (symbol == null || checksMode == OCFile.UnusedChecksMode.DISABLED || symbol.isUnused()) {
            return;
        }
        if (!OCSearchScope.isInProjectSources(symbol, project)) {
            return;
        }
        boolean hasWrites = false;
        for (ImplicitUsageProvider usageProvider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (usageProvider.isImplicitUsage(element) || usageProvider.isImplicitRead(element)) {
                return;
            }
            hasWrites |= usageProvider.isImplicitWrite(element);
        }
        PsiFile containingFile = element.getContainingFile();
        SearchScope scope = this.myScope;
        if (scope == null) {
            scope = checksMode == OCFile.UnusedChecksMode.IN_LOCAL_FILE ? new LocalSearchScope((PsiElement)containingFile) : new OCGlobalSearchScopeForUnusedCode(OCSearchScope.getProjectSourcesScope(project));
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        Object subject = symbol.getNameWithKindUppercase(OCCompilationContext.create(element));
        OCRemoveElementsIntentionAction quickFix = new OCSafeDeleteIntentionAction(element, StringUtil.decapitalize((String)subject));
        boolean isAccessorMethod = false;
        if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
            scope = this.getIvarScope((OCInstanceVariableSymbol)symbol, scope, project);
        } else if (symbol.getKind() == OCSymbolKind.PROPERTY) {
            final PsiElement accessor = element;
            finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                protected boolean accept(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    if (element.getParent() instanceof OCSynthesizeProperty) {
                        return false;
                    }
                    if (reference instanceof OCExternalReference) {
                        return true;
                    }
                    return !(accessor instanceof OCMethod) || reference.isReferenceTo(accessor);
                }
            };
            if (element instanceof OCMethod) {
                subject = (OCNameSuggester.isObjCSetter(((OCMethod)element).getSelector()) ? "Setter" : "Getter") + " method for " + symbol.getNameWithKindLowercase(OCCompilationContext.create(element));
                quickFix = new OCRemoveElementsIntentionAction(element, OCInspectionsBundle.message("intention.name.delete", StringUtil.decapitalize((String)subject)), OCInspectionsBundle.message("intention.family.name.delete.method", new Object[0]));
                element = symbol.locateDefinition(project);
                isAccessorMethod = true;
                if (element == null) {
                    return;
                }
            }
        } else {
            if ((symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol) && OCTestFrameworks.isTestClassOrStruct(symbol, navigationElement, project)) {
                return;
            }
            if (symbol.getKind().isStructOrUnion()) {
                final PsiElement struct = element;
                finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                    protected boolean accept(PsiReference reference) {
                        return !OCSafeDeleteProcessorDelegateBase.isSafeToDelete(reference.getElement(), struct);
                    }
                };
                if (element.getParent().getParent() instanceof OCDeclaration && ((OCDeclaration)element.getParent().getParent()).isTypedef()) {
                    return;
                }
            } else {
                if (symbol.getKind() == OCSymbolKind.ENUM) {
                    return;
                }
                if (symbol.getKind() == OCSymbolKind.TYPEDEF && symbol.getType() instanceof OCStructType && ((OCStructType)symbol.getType()).getKind() == OCSymbolKind.ENUM) {
                    return;
                }
            }
        }
        if (scope instanceof GlobalSearchScope && PsiSearchHelper.getInstance((Project)project).isCheapEnoughToSearch(symbol.getName(), (GlobalSearchScope)scope, containingFile, null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return;
        }
        Ref hasWritesRef = new Ref((Object)hasWrites);
        if (scope != null) {
            ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters(element, scope, false);
            try {
                element.putUserData(UNUSED_INSPECTION_MODE_KEY, (Object)Boolean.TRUE);
                if (OCUnusedVisitor.findReferences(symbol, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), (CommonProcessors.FindFirstProcessor<PsiReference>)finder, (Ref<Boolean>)hasWritesRef)) {
                    return;
                }
            }
            finally {
                element.putUserData(UNUSED_INSPECTION_MODE_KEY, null);
            }
            if (symbol.getKind() == OCSymbolKind.PROPERTY && this.performAuxPropertySearches((OCPropertySymbol)symbol, scope, (CommonProcessors.FindFirstProcessor<PsiReference>)finder, searchParameters, (Ref<Boolean>)hasWritesRef)) {
                return;
            }
            if (symbol.getKind().isStructOrUnion() && OCUnusedVisitor.performAuxStructSearches((OCStructSymbol)symbol, scope, project, (CommonProcessors.FindFirstProcessor<PsiReference>)finder, (Ref<Boolean>)hasWritesRef)) {
                return;
            }
            CommonProcessors.FindFirstProcessor macroFinder = new CommonProcessors.FindFirstProcessor();
            ReferencesSearch.SearchParameters macroParameters = new ReferencesSearch.SearchParameters(element, (SearchScope)OCSearchScope.getProjectSourcesScope(project), false);
            new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(macroParameters, (Processor<? super OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)macroFinder);
            if (macroFinder.isFound()) {
                return;
            }
        }
        if (isAccessorMethod && ((Boolean)hasWritesRef.get()).booleanValue()) {
            return;
        }
        if (navigationElement instanceof PsiNameIdentifierOwner && !(navigationElement instanceof OCDefineDirective)) {
            navigationElement = ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier();
        }
        if (navigationElement != null) {
            boolean canSuppress;
            String message = OCInspectionsBundle.message("inspection.message.never.used", subject, (Boolean)hasWritesRef.get() != false ? 0 : 1);
            ArrayList<OCSafeDeleteIntentionAction> fixes = new ArrayList<OCSafeDeleteIntentionAction>(Collections.singletonList(quickFix));
            boolean bl = canSuppress = !(symbol instanceof OCClassSymbol) && !(symbol instanceof OCPropertySymbol) && !(symbol instanceof OCMacroSymbol) && !(symbol instanceof OCTypeParameterSymbol) && !(symbol instanceof OCConceptSymbol);
            if (canSuppress) {
                fixes.add((OCSafeDeleteIntentionAction)((Object)OCChangeGCCAttributeIntentionAction.unused(symbol, element.getContainingFile())));
            }
            this.registerProblem(navigationElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static boolean findReferences(OCSymbol symbol, Query<PsiReference> search, CommonProcessors.FindFirstProcessor<PsiReference> finder, Ref<Boolean> hasWrites) {
        if (OCUnusedVisitor.isWritableSymbol(symbol)) {
            Condition isAccess = reference -> new OCReadWriteAccessDetector().getExpressionAccess(reference.getElement()) != ReadWriteAccessDetector.Access.Write;
            OCCommonProcessors.OrderedProcessor<PsiReference> processor2 = new OCCommonProcessors.OrderedProcessor<PsiReference>((Processor<PsiReference>)finder, (Condition<? super T>[])new Condition[]{isAccess, Conditions.alwaysTrue()});
            search.forEach(processor2);
            processor2.finish();
            if (finder.isFound()) {
                if (isAccess.value((Object)((PsiReference)finder.getFoundValue()))) {
                    return true;
                }
                hasWrites.set((Object)true);
            }
        } else {
            search.forEach(finder);
            if (finder.isFound()) {
                return true;
            }
        }
        return false;
    }

    private static boolean performAuxStructSearches(OCStructSymbol symbol, SearchScope scope, Project project, CommonProcessors.FindFirstProcessor<PsiReference> finder, Ref<Boolean> hasWrites) {
        return !symbol.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)constructor -> {
            OCFunctionDeclaration element = constructor.locateFunctionDefinition(project);
            if (element != null) {
                ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)element, scope, false);
                return !OCUnusedVisitor.findReferences(constructor, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), finder, hasWrites);
            }
            return true;
        }));
    }

    private boolean performAuxPropertySearches(OCPropertySymbol symbol, SearchScope scope, CommonProcessors.FindFirstProcessor<PsiReference> finder, ReferencesSearch.SearchParameters searchParameters, Ref<Boolean> hasWrites) {
        ExecutorsQuery query = new ExecutorsQuery((Object)searchParameters, Collections.singletonList(new OCPropertyReferencesSearch()));
        if (OCUnusedVisitor.findReferences(symbol, (Query<PsiReference>)query, finder, hasWrites)) {
            return true;
        }
        Project project = searchParameters.getProject();
        OCInstanceVariableSymbol ivar = symbol.getAssociatedIvar(project);
        if (ivar != null) {
            if (ivar.getGeneratedFromProperty() == null) {
                return false;
            }
            if ((scope = this.getIvarScope(ivar, scope, project)) == null) {
                return false;
            }
            PsiElement element = ivar.locateDefinition(project);
            if (element == null) {
                element = new OCSymbolHolderVirtualPsiElement(ivar, project);
            }
            searchParameters = new ReferencesSearch.SearchParameters(element, scope, false);
            finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                protected boolean accept(PsiReference reference) {
                    return !(reference.getElement().getParent() instanceof OCSynthesizeProperty);
                }
            };
            if (OCUnusedVisitor.findReferences(ivar, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), finder, hasWrites)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private SearchScope getIvarScope(OCInstanceVariableSymbol symbol, SearchScope scope, Project project) {
        if (symbol.getVisibility() == OCVisibility.PRIVATE) {
            PsiElement implementation;
            OCImplementationSymbol implementationSymbol = symbol.getParent().getImplementation(project);
            PsiElement psiElement = implementation = implementationSymbol != null ? implementationSymbol.locateDefinition(project) : null;
            if (implementation != null) {
                if (this.myScope instanceof GlobalSearchScope && !((GlobalSearchScope)this.myScope).accept(implementationSymbol.getContainingFile())) {
                    return null;
                }
                return new LocalSearchScope(implementation);
            }
            return null;
        }
        return scope;
    }

    private static boolean isWritableSymbol(OCSymbol symbol) {
        return symbol instanceof OCDeclaratorSymbol || symbol instanceof OCPropertySymbol || symbol instanceof OCInstanceVariableSymbol;
    }
}

