/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.inspections.NotImplementedFunctions;
import com.jetbrains.cidr.lang.inspections.OCClangBasedInspections;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInconsistentNamingInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCLegacyObjCLiteralInspection;
import com.jetbrains.cidr.lang.inspections.OCNotLocalizedStringInspection;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedClassInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedConceptInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedGlobalDeclarationInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedInstanceVariableInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedMacroInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedMethodInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedPropertyInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedStructInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTemplateParameterInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTypeAliasInspection;
import com.jetbrains.cidr.lang.legacy.inspections.OCSimplifyInspectionLegacy;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInspectionToolProvider {
    private List<Class<?>> myAnnotatorInspectionClasses = new ArrayList();
    private List<Class<?>> myStandaloneInspectionClasses = new ArrayList();
    private Map<String, Class<?>> myNameToInspectionMap = new HashMap();
    private Map<Class<?>, String> myFakeInspectionsToNameMap = new HashMap();
    private Map<String, Class<?>> myNameToFakeInspectionsMap = new HashMap();
    private Stack<Class<?>> myFakeInspectionsPool = new Stack();
    private static OCInspectionToolProvider instance;

    private OCInspectionToolProvider() {
        for (Class<?> clazz : OCInspections.class.getDeclaredClasses()) {
            this.addInspectionClass(clazz);
        }
        if (PluginUtils.hasAppCode()) {
            for (Class<?> clazz : OCClangBasedInspections.class.getDeclaredClasses()) {
                this.addInspectionClass(clazz);
            }
        }
        this.myStandaloneInspectionClasses.addAll(OCInspectionToolProvider.getStandaloneInspectionClasses());
    }

    private void addInspectionClass(Class<?> clazz) {
        if (Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers())) {
            if (PluginUtils.hasCLion() && OCInspectionToolProvider.isLegacyAnnotatorInspection(clazz) && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myAnnotatorInspectionClasses.add(clazz);
            try {
                if (this.isClangAnalyzerInspection(clazz)) {
                    this.myFakeInspectionsPool.add(clazz);
                } else {
                    this.myNameToInspectionMap.put(((OCInspection)((Object)clazz.newInstance())).getDisplayName(), clazz);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                OCLog.LOG.error((Throwable)e);
            }
        }
    }

    public static OCInspectionToolProvider getInstance() {
        if (instance == null) {
            instance = new OCInspectionToolProvider();
        }
        return instance;
    }

    private static List<Class<?>> getStandaloneInspectionClasses() {
        ArrayList result = new ArrayList();
        result.addAll(Arrays.asList(OCUnusedGlobalDeclarationInspection.class, OCUnusedStructInspection.class, OCUnusedConceptInspection.class, OCUnusedTypeAliasInspection.class, OCUnusedTemplateParameterInspection.class, OCUnusedMacroInspection.class, OCDFAInspection.class, NotImplementedFunctions.class, OCInconsistentNamingInspection.class));
        result.addAll(Arrays.asList(OCUnusedMethodInspection.class, OCUnusedClassInspection.class, OCUnusedInstanceVariableInspection.class, OCUnusedPropertyInspection.class, OCNotReleasedIvarInspection.class, OCNotLocalizedStringInspection.class, OCLegacyObjCLiteralInspection.class));
        if (PluginUtils.hasAppCode() || ApplicationManager.getApplication().isUnitTestMode()) {
            result.add(OCSimplifyInspectionLegacy.class);
        }
        if (PluginUtils.hasCLion() && !ApplicationManager.getApplication().isUnitTestMode()) {
            result.removeIf(c -> OCInspectionToolProvider.isLegacyAnnotatorInspection(c));
        }
        return result;
    }

    public boolean isClangCompilerInspection(Class inspectionClass) {
        return OCClangBasedInspections.ClangCompilerIssues.class.equals(inspectionClass.getSuperclass());
    }

    public boolean isClangAnalyzerInspection(Class inspectionClass) {
        return OCClangBasedInspections.ClangAnalyzerIssue.class.equals(inspectionClass.getSuperclass());
    }

    public static boolean isLegacyAnnotatorInspection(Class<?> clazz) {
        try {
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return instance instanceof OCInspectionBase && !((OCInspectionBase)instance).worksWithClangd();
        }
        catch (Exception e) {
            OCLog.LOG.error((Throwable)e);
            return false;
        }
    }

    @Nullable
    public Class getInspectionByName(String name) {
        return this.myNameToInspectionMap.get(name);
    }

    @Nullable
    public synchronized Class getFakeInspection(String messageGroup) {
        Class clazz = this.myNameToFakeInspectionsMap.get(messageGroup);
        if (clazz != null) {
            return clazz;
        }
        clazz = (Class)this.myFakeInspectionsPool.pop();
        if (clazz != null) {
            this.myFakeInspectionsToNameMap.put(clazz, messageGroup);
            this.myNameToFakeInspectionsMap.put(messageGroup, clazz);
            return clazz;
        }
        OCLog.LOG.error("Too few fake inspections");
        return null;
    }

    @Nullable
    public synchronized String getFakeInspectionName(Class inspectionClass) {
        return this.myFakeInspectionsToNameMap.get(inspectionClass);
    }

    public static final class StandaloneInspectionToolProvider
    implements NotNullProducer<List<Class<?>>> {
        @NotNull
        public List<Class<?>> produce() {
            return OCInspectionToolProvider.getInstance().myStandaloneInspectionClasses;
        }
    }

    public static final class AnnotatorInspectionToolProvider
    implements NotNullProducer<List<Class<?>>> {
        @NotNull
        public List<Class<?>> produce() {
            return OCInspectionToolProvider.getInstance().myAnnotatorInspectionClasses;
        }
    }
}

