/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.CidrInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCGlobalUnusedInspection
extends GlobalSimpleInspectionTool {
    private static Key<Set<VirtualFile>> ANALYZED_FILES = Key.create((String)"ANALYSIS_SCOPE");
    private ProblemsHolder myProblemsHolder;

    @TestOnly
    public OCGlobalUnusedInspection(ProblemsHolder problemsHolder) {
        this.myProblemsHolder = problemsHolder;
    }

    public OCGlobalUnusedInspection() {
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message("inspection.global.unused.analysis", new Object[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return OCInspectionsBundle.message("inspection.group.name.general", new Object[0]);
    }

    public @Nls(capitalization=Nls.Capitalization.Sentence) String @NotNull [] getGroupPath() {
        return new String[]{CidrLangBundle.message((String)"objective.c", (Object[])new Object[0]), this.getGroupDisplayName()};
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Set analysisScope = (Set)file.getProject().getUserData(ANALYZED_FILES);
        if (analysisScope != null && file instanceof OCFile) {
            analysisScope.add(file.getVirtualFile());
        }
    }

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        manager.getProject().putUserData(ANALYZED_FILES, new LinkedHashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionFinished(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Project project = manager.getProject();
        Set analyzedFiles = (Set)project.getUserData(ANALYZED_FILES);
        try {
            ArrayList<OCUnusedVisitor> visitors = new ArrayList<OCUnusedVisitor>();
            if (analyzedFiles == null) {
                return;
            }
            OCGlobalSearchScopeForUnusedCode searchScope = new OCGlobalSearchScopeForUnusedCode(OCSearchScope.getProjectSourcesScope(manager.getProject()));
            for (Class clazz : CidrInspectionToolProvider.getStandaloneInspectionClasses()) {
                OCUnusedVisitor unusedVisitor = null;
                try {
                    if (OCUnusedCppInspection.class.isAssignableFrom(clazz)) {
                        unusedVisitor = ((OCUnusedCppInspection)((Object)clazz.newInstance())).buildVisitor();
                    } else if (OCUnusedObjCInspection.class.isAssignableFrom(clazz)) {
                        unusedVisitor = ((OCUnusedObjCInspection)((Object)clazz.newInstance())).buildVisitor();
                    }
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
                if (unusedVisitor == null) continue;
                unusedVisitor.setUpForBatchMode(problemDescriptionsProcessor, globalContext, (SearchScope)searchScope);
                unusedVisitor.setHolder(this.myProblemsHolder);
                visitors.add(unusedVisitor);
            }
            MultiMap<VirtualFile, OCSymbol> unusedSymbolsPerFile = new MultiMap<VirtualFile, OCSymbol>(){

                @NotNull
                protected Collection<OCSymbol> createCollection() {
                    return new SortedList(Comparator.comparingLong(OCSymbol::getComplexOffset));
                }
            };
            Processor collector = arg_0 -> OCGlobalUnusedInspection.lambda$inspectionFinished$0(analyzedFiles, (MultiMap)unusedSymbolsPerFile, arg_0);
            ApplicationManager.getApplication().runReadAction(() -> OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)collector, null));
            ProgressManager.progress((String)OCInspectionsBundle.message("progress.text.evaluating.unused.symbols", new Object[0]));
            for (VirtualFile eachAnalyzedFile : analyzedFiles) {
                for (OCSymbol symbol : unusedSymbolsPerFile.get((Object)eachAnalyzedFile)) {
                    Ref prevElement = new Ref();
                    ApplicationManager.getApplication().runReadAction(() -> {
                        ProgressManager.checkCanceled();
                        PsiElement definition = symbol.locateDefinition(project);
                        if (definition != null && !definition.equals(prevElement.get())) {
                            prevElement.set((Object)definition);
                            for (OCUnusedVisitor visitor : visitors) {
                                visitor.checkFromBatchMode(symbol, definition);
                            }
                        }
                    });
                }
            }
        }
        finally {
            project.putUserData(ANALYZED_FILES, null);
        }
    }

    @Nullable
    public String getMainToolId() {
        return new DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection().getShortName();
    }

    private static /* synthetic */ boolean lambda$inspectionFinished$0(Set analyzedFiles, MultiMap unusedSymbolsPerFile, OCSymbol symbol) {
        ProgressManager.checkCanceled();
        if (analyzedFiles.contains(symbol.getContainingFile())) {
            unusedSymbolsPerFile.putValue((Object)symbol.getContainingFile(), (Object)symbol);
        }
        return true;
    }
}

