/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.inspections.DFARunner;
import com.jetbrains.cidr.lang.inspections.OCExternalInspections;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.dfa.OCDFAInspectionRunner;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCDFAInspection
extends OCInspections.DataFlowAnalysis {
    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message("inspection.context.sensitive.analysis", new Object[0]);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.NON_SWITCHABLE_WARNING;
    }

    public boolean runForWholeFile() {
        return OCSourceGliderService.isGlobalMode(null);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return OCDFAInspection.getRunner(holder.getFile()).buildVisitor(holder);
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        PsiFile file = session.getFile();
        if (file instanceof OCFile && OCInspectionUtil.isClangdDFAEnabled((PsiElement)file)) {
            DFARunner runner = OCDFAInspection.getRunner(file);
            runner.run((OCFile)file, problemsHolder, this);
        }
    }

    @NotNull
    private static DFARunner getRunner(@NotNull PsiFile file) {
        for (OCExternalInspections externalInspections : OCExternalInspections.EP_NAME.getExtensionList()) {
            DFARunner runner = externalInspections.getDFARunner();
            if (runner == null || !runner.canRun(file)) continue;
            return runner;
        }
        return new OCDFAInspectionRunner();
    }
}

