/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCQNGroup;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import icons.CidrLangIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedNamesNodeProvider
implements Grouper,
FileStructureNodeProvider<OCStructureViewElement>,
PropertyOwner {
    @NonNls
    public static final String QUALIFIED_NAMES_PROVIDER_PROPERTY = "qualified.names.node.provider";
    @NonNls
    public static final String ACTION_ID = "QUALIFIED_NAMES";
    private static final Logger LOG = Logger.getInstance(OCQualifiedNamesNodeProvider.class);
    private String mySeparator = "::";

    @NotNull
    public String getCheckBoxText() {
        return OCBundle.message("action.CIDR.Lang.QualifiedNames.text", new Object[0]);
    }

    public Shortcut @NotNull [] getShortcut() {
        return new Shortcut[]{KeyboardShortcut.fromString((String)(SystemInfo.isMac ? "meta F11" : "control F11"))};
    }

    @NotNull
    public Collection<OCStructureViewElement> provideNodes(@NotNull TreeElement node) {
        return Collections.emptyList();
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(OCBundle.message("action.CIDR.Lang.QualifiedNames.text", new Object[0]), OCBundle.message("action.CIDR.Lang.QualifiedNames.description", new Object[0]), CidrLangIcons.ActionQualifiedNames);
    }

    @NotNull
    public String getName() {
        return ACTION_ID;
    }

    @NotNull
    public String getPropertyName() {
        return QUALIFIED_NAMES_PROVIDER_PROPERTY;
    }

    public void setSeparator(String separator) {
        this.mySeparator = separator;
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
        int parentPrefixLength;
        String parentPrefix;
        ArrayList<Key> keys = new ArrayList<Key>();
        if (parent.getValue() instanceof OCQNGroup) {
            parentPrefix = ((OCQNGroup)parent.getValue()).getPrefix();
            parentPrefixLength = OCQualifiedNamesNodeProvider.splitAccurate(parentPrefix, this.mySeparator).size();
        } else {
            parentPrefix = "";
            parentPrefixLength = 0;
        }
        for (TreeElement element : children) {
            boolean expected;
            String text = OCQualifiedNamesNodeProvider.getFullQNIfAny(element);
            if (text == null) continue;
            boolean bl = expected = text.startsWith(parentPrefix) || text.startsWith(this.mySeparator);
            if (!expected) {
                LOG.error("unexpected text: " + text + "; parentPrefix=" + parentPrefix + "; mySeparator=" + this.mySeparator);
            }
            List<String> words = OCQualifiedNamesNodeProvider.splitAccurate(text, this.mySeparator);
            keys.add(new Key(words, element));
        }
        if (keys.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        keys.sort((k1, k2) -> {
            List<String> o1 = k1.words;
            List<String> o2 = k2.words;
            for (int i = 0; i < Math.max(o1.size(), o2.size()); ++i) {
                String s2;
                if (i == o1.size()) {
                    return 1;
                }
                if (i == o2.size()) {
                    return -1;
                }
                String s1 = o1.get(i);
                int res = s1.compareTo(s2 = o2.get(i));
                if (res == 0) continue;
                return res;
            }
            return 0;
        });
        ArrayList<Group> groups = new ArrayList<Group>();
        int groupStart = 0;
        for (int i = 0; i <= keys.size(); ++i) {
            if (!OCQualifiedNamesNodeProvider.isEndOfGroup(i, keys, parentPrefixLength)) continue;
            List firstKey = groupStart == keys.size() ? Collections.emptyList() : ((Key)keys.get((int)groupStart)).words;
            SmartList groupChildren = new SmartList();
            groupChildren.add(((Key)keys.get((int)groupStart)).node);
            int prefixLen = firstKey.size();
            for (int j = groupStart + 1; j < i; ++j) {
                List<String> prevKey = ((Key)keys.get((int)(j - 1))).words;
                List<String> nextKey = ((Key)keys.get((int)j)).words;
                for (int k = parentPrefixLength; k < prefixLen; ++k) {
                    String wordInPrevKey;
                    String word = k < nextKey.size() ? nextKey.get(k) : null;
                    String string = wordInPrevKey = k < prevKey.size() ? prevKey.get(k) : null;
                    if (Comparing.strEqual((String)word, (String)wordInPrevKey)) continue;
                    prefixLen = k;
                    break;
                }
                groupChildren.add(((Key)keys.get((int)j)).node);
            }
            String[] strings = firstKey.subList(0, prefixLen).toArray(new String[prefixLen]);
            String prefix = StringUtil.join((String[])strings, (String)this.mySeparator);
            String presentableName = prefix.substring(parentPrefix.length());
            if (!(presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator)).isEmpty()) {
                groups.add(new OCQNGroup((Collection<TreeElement>)groupChildren, prefix, presentableName, this.mySeparator));
            } else if (groupStart != keys.size()) {
                TreeElement node = ((Key)keys.get((int)groupStart)).node;
                ((OCStructureViewElement)node).setPresentableQN(presentableName);
            }
            groupStart = i;
        }
        return groups;
    }

    private static boolean isEndOfGroup(int i, @NotNull List<Key> keys, int parentPrefixLength) {
        if (i == keys.size()) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        List<String> words = keys.get((int)i).words;
        List<String> prevWords = keys.get((int)(i - 1)).words;
        if (prevWords.size() == parentPrefixLength) {
            return true;
        }
        if (words.size() == parentPrefixLength) {
            return true;
        }
        return !Comparing.strEqual((String)words.get(parentPrefixLength), (String)prevWords.get(parentPrefixLength));
    }

    @Nullable
    private static String getFullQNIfAny(@NotNull TreeElement element) {
        if (element instanceof OCStructureViewElement && ((OCStructureViewElement)element).getFullQN() != null) {
            return ((OCStructureViewElement)element).getFullQN();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<String> splitAccurate(@NotNull String qName, @NotNull String separator) {
        List plain = StringUtil.split((String)qName, (String)separator);
        ArrayList<String> res = new ArrayList<String>();
        int currentPlainPart = 0;
        while (true) {
            Object qnCandidate;
            block14: {
                if (currentPlainPart >= plain.size()) {
                    return res;
                }
                qnCandidate = (String)plain.get(currentPlainPart);
                int braceCount = 0;
                int posInCandidate = 0;
                Stack<Character> braces = new Stack<Character>();
                while (true) {
                    block15: {
                        if (posInCandidate >= ((String)qnCandidate).length()) break block15;
                        char ch = ((String)qnCandidate).charAt(posInCandidate);
                        switch (ch) {
                            case '(': 
                            case '[': {
                                braces.push(Character.valueOf(ch));
                                break;
                            }
                            case ')': {
                                if (!braces.isEmpty() && ((Character)braces.pop()).equals(Character.valueOf('('))) break;
                                braceCount = -1;
                                break;
                            }
                            case ']': {
                                if (!braces.isEmpty() && ((Character)braces.pop()).equals(Character.valueOf('['))) break;
                                braceCount = -1;
                                break;
                            }
                            case '<': {
                                if (!braces.isEmpty()) break;
                                ++braceCount;
                                break;
                            }
                            case '>': {
                                if (braces.isEmpty()) {
                                    --braceCount;
                                }
                                if (braceCount < 0) break block15;
                            }
                        }
                        ++posInCandidate;
                        continue;
                    }
                    if (braceCount <= 0) break;
                    if (++currentPlainPart < plain.size()) {
                        qnCandidate = (String)qnCandidate + separator + (String)plain.get(currentPlainPart);
                        continue;
                    }
                    break block14;
                    break;
                }
                if (braceCount < 0) {
                    ++currentPlainPart;
                    while (currentPlainPart < plain.size()) {
                        qnCandidate = (String)qnCandidate + separator + (String)plain.get(currentPlainPart);
                        ++currentPlainPart;
                    }
                }
            }
            res.add((String)qnCandidate);
            ++currentPlainPart;
        }
    }

    private static class Key {
        final List<String> words;
        final TreeElement node;

        Key(List<String> words, TreeElement node) {
            this.words = words;
            this.node = node;
        }

        @Contract(pure=true)
        @NotNull
        public String toString() {
            return "Key{words=" + this.words + ", node=" + this.node + "}";
        }
    }
}

