/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeAggregator;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallStructureProvider;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCFunctionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallStructureProvider
implements PolyglotCallStructureProvider<OCCallHierarchyNodeDescriptor> {
    @Override
    @Nullable
    public PsiElement isCallHierarchyAvailable(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class, (boolean)false);
    }

    @Override
    @Nullable
    public PsiElement getElementFromContext(@NotNull DataContext dataContext) {
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    private static OCCallable getImplementationOfMethod(@NotNull OCCallable method) {
        OCSymbol symbol = method.getSymbol();
        if (symbol != null && symbol.isPredeclaration()) {
            PsiElement implElement;
            OCSymbol impl = symbol.getDefinitionSymbol(method.getProject());
            if (impl != null) {
                symbol = impl;
            }
            if ((implElement = symbol.locateDefinition(method.getProject())) instanceof OCCallable) {
                method = (OCCallable)implElement;
            }
            if (implElement != null && implElement.getParent() instanceof OCCallable) {
                method = (OCCallable)implElement.getParent();
            }
        }
        return method;
    }

    @Override
    @NotNull
    public final @NotNull Object @NotNull [] buildCallees(@NotNull OCCallHierarchyNodeDescriptor descriptor) {
        OCBlockStatement body;
        Project myProject = descriptor.getProject();
        if (descriptor.getPossibleResponders().size() > 1) {
            ArrayList<OCCallHierarchyNodeDescriptor> result = new ArrayList<OCCallHierarchyNodeDescriptor>();
            for (OCSymbol symbol : descriptor.getPossibleResponders()) {
                if (symbol.isPredeclaration()) {
                    OCSymbol impl = null;
                    if (myProject != null) {
                        impl = symbol.getDefinitionSymbol(myProject);
                    }
                    if (impl != null) {
                        symbol = impl;
                    }
                }
                PsiElement element = null;
                if (myProject != null) {
                    element = symbol.locateDefinition(myProject);
                }
                if (element == null) continue;
                result.add(new OCCallHierarchyNodeDescriptor(myProject, descriptor, element, false, false));
            }
            return result.toArray();
        }
        ChildrenCalculator calculator = new ChildrenCalculator(descriptor);
        OCCallable enclosingElement = descriptor.getEnclosingElement();
        if (enclosingElement != null && (body = (enclosingElement = OCCallStructureProvider.getImplementationOfMethod(enclosingElement)).getBody()) != null) {
            calculator.visit(body);
        }
        return calculator.getChildren();
    }

    private static boolean processCall(PsiReference psiReference, @NotNull Set<PsiElement> myProcessed, @NotNull SearchScope searchScope, @NotNull OCCallHierarchyNodeAggregator aggregator) {
        PsiElement element = psiReference.getElement();
        String selectorName = null;
        if (element instanceof OCElement && myProcessed.add(element)) {
            OCSymbol parentSymbol;
            if (element instanceof OCSendMessageExpression) {
                OCSendMessageExpression sendMessage = (OCSendMessageExpression)element;
                selectorName = sendMessage.getMessageSelector();
            } else if (element instanceof OCPropertyAttribute) {
                boolean isSetter;
                OCProperty property = ((OCPropertyAttribute)element).getParentProperty();
                String attributeName = ((OCPropertyAttribute)element).getName();
                if (attributeName == null) {
                    return true;
                }
                OCPropertySymbol.PropertyAttribute attr = OCPropertySymbolImpl.parseAttribute(attributeName);
                boolean isGetter = attr == OCPropertySymbol.PropertyAttribute.GETTER;
                boolean bl = isSetter = attr == OCPropertySymbol.PropertyAttribute.SETTER;
                if (property == null) {
                    return true;
                }
                OCDeclaration declaration = property.getDeclaration();
                if (declaration == null) {
                    return true;
                }
                List<OCDeclarator> declarators = declaration.getDeclarators();
                if (declarators.size() != 1) {
                    return true;
                }
                ReferencesSearch.SearchParameters queryParameters = new ReferencesSearch.SearchParameters((PsiElement)declarators.get(0), searchScope, false);
                ReferencesSearch.search((ReferencesSearch.SearchParameters)queryParameters).forEach(reference -> {
                    ReadWriteAccessDetector.Access access;
                    PsiElement element1 = reference.getElement();
                    if ((element1 instanceof OCReferenceElement || element1 instanceof OCQualifiedExpression) && ((access = new OCReadWriteAccessDetector().getExpressionAccess(element1)) == ReadWriteAccessDetector.Access.Read && isGetter || access == ReadWriteAccessDetector.Access.Write && isSetter || access == ReadWriteAccessDetector.Access.ReadWrite && (isGetter || isSetter))) {
                        return OCCallStructureProvider.processCall(reference, myProcessed, searchScope, aggregator);
                    }
                    return true;
                });
                return true;
            }
            OCCallable parent = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
            if (parent != null && (parentSymbol = parent.getSymbol()) != null) {
                aggregator.addNodeDescriptor(parentSymbol, selectorName, element, null);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public final Collection<PolyglotCallHierarchyNodeDescriptor> processCallers(@NotNull List<? extends PsiReference> references, @NotNull PolyglotCallHierarchyNodeDescriptor descriptor, @NotNull SearchScope searchScope) {
        OCCallHierarchyNodeAggregator aggregator = new OCCallHierarchyNodeAggregator(descriptor);
        HashSet myProcessed = new HashSet();
        references.forEach(reference -> OCCallStructureProvider.processCall(reference, myProcessed, searchScope, aggregator));
        return aggregator.getChildrenCollection();
    }

    @Override
    @Nullable
    public Query<PsiReference> getReferencesSearchQuery(@NotNull OCCallHierarchyNodeDescriptor descriptor, @NotNull SearchScope searchScope) {
        PsiElement methodElement;
        OCSymbol symbol;
        OCCallable enclosingElement = descriptor.getEnclosingElement();
        OCSymbol oCSymbol = symbol = enclosingElement != null ? enclosingElement.getSymbol() : null;
        if (symbol != null && descriptor.getProject() != null && (methodElement = symbol.locateDefinition(descriptor.getProject())) != null) {
            return ReferencesSearch.search((PsiElement)methodElement, (SearchScope)searchScope);
        }
        return null;
    }

    @Override
    @NotNull
    public OCCallHierarchyNodeDescriptor createNodeDescriptor(@NotNull Project project, @Nullable PolyglotCallHierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase, boolean navigateToReference) {
        return new OCCallHierarchyNodeDescriptor(project, parentDescriptor, element, isBase, navigateToReference);
    }

    private static final class ChildrenCalculator
    extends OCCallHierarchyNodeAggregator {
        private final boolean myParentIsConstructorDestructor;

        private ChildrenCalculator(OCCallHierarchyNodeDescriptor parentDescriptor) {
            super(parentDescriptor);
            OCFunctionSymbol function;
            OCSymbol symbol;
            OCCallable parent = parentDescriptor.getEnclosingElement();
            this.myParentIsConstructorDestructor = parent != null ? ((symbol = parent.getSymbol()) instanceof OCFunctionSymbol ? (function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor() : false) : false;
        }

        private void visit(@NotNull PsiElement element) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                String selectorName;
                PolyglotCallHierarchyNodeDescriptor desc;
                OCMethodSymbol impl;
                OCSymbol known;
                this.visit(child);
                if (child instanceof OCReferenceElement) {
                    PsiElement parent = child.getParent().getParent();
                    if (!(parent instanceof OCCallExpression) && !(parent instanceof OCCppNewExpression) || !((known = ((OCReferenceElement)child).resolveToSymbol()) instanceof OCFunctionSymbol)) continue;
                    boolean isVirtual = !this.myParentIsConstructorDestructor && ((OCReferenceElement)child).getNamespaceQualifier() == null;
                    this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                    continue;
                }
                if (child instanceof OCQualifiedExpression) {
                    known = ((OCQualifiedExpression)child).resolveToSymbol();
                    if (known instanceof OCMethodSymbol) {
                        this.processMethodSymbol((OCMethodSymbol)known, (OCElement)child);
                        continue;
                    }
                    if (child.getParent() instanceof OCCallExpression && known instanceof OCFunctionSymbol) {
                        boolean isVirtual = !this.myParentIsConstructorDestructor && OCFunctionReferenceSearch.isCallViaReference(((OCQualifiedExpression)child).getQualifier());
                        this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                        continue;
                    }
                    if (!(known instanceof OCPropertySymbol)) continue;
                    OCPropertySymbol property = (OCPropertySymbol)known;
                    ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(child);
                    property.getParent().processMembers(OCMethodSymbol.class, method -> {
                        if (method.getOriginalSymbol() == property) {
                            OCResolveContext context = OCResolveContext.forPsi(element);
                            if (access == ReadWriteAccessDetector.Access.Read && method.isGetter(context) || access == ReadWriteAccessDetector.Access.Write && method.isSetter(context) || access == ReadWriteAccessDetector.Access.ReadWrite) {
                                this.processMethodSymbol((OCMethodSymbol)method, (OCElement)child);
                            }
                        }
                        return true;
                    });
                    continue;
                }
                if (!(child instanceof OCSendMessageExpression)) continue;
                OCSendMessageExpression callExpression = (OCSendMessageExpression)child;
                OCSendMessageExpression.ProbableResponders responders = callExpression.getProbableResponders();
                OCObjectTypeContext receiverContext = callExpression.getReceiverContext();
                if (receiverContext == null) continue;
                OCMethodSymbol known2 = responders.getKnownResponder();
                if (known2 != null && !known2.isDefinition() && (impl = known2.getDefinitionSymbol(element.getProject())) != null) {
                    known2 = impl;
                }
                if ((desc = this.addNodeDescriptor(known2, selectorName = callExpression.getMessageSelector(), child, null)) == null) continue;
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(selectorName, receiverContext.getType().getClassSymbol(), element.getProject(), OCMethodSymbol.class, receiverContext.getStaticMode());
                ChildrenCalculator.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (receiverContext.fitsStaticness((OCMemberSymbol)symbol) && symbol.isDefinition()) {
                        desc.addPossibleInheritor((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void processMethodSymbol(@NotNull OCMethodSymbol known, @NotNull OCElement context) {
            PolyglotCallHierarchyNodeDescriptor desc;
            OCMethodSymbol impl;
            @NotNull Project myProject = context.getProject();
            if (!known.isDefinition() && (impl = known.getDefinitionSymbol(myProject)) != null) {
                known = impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context, null)) != null) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(known, myProject);
                ChildrenCalculator.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (symbol.isDefinition()) {
                        desc.addPossibleInheritor((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void processFunctionSymbol(@NotNull OCFunctionSymbol known, @NotNull OCElement context, boolean virtualCall) {
            PolyglotCallHierarchyNodeDescriptor desc;
            OCSymbol impl;
            @NotNull Project myProject = context.getProject();
            if (known.isPredeclaration() && (impl = known.getDefinitionSymbol(myProject)) instanceof OCFunctionSymbol) {
                known = (OCFunctionSymbol)impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context, null)) != null && virtualCall && OCFunctionAncestorsQuery.findFirstVirtual(known, true, myProject) != null) {
                OCFile file = context.getContainingOCFile();
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(known, file, true);
                HashSet names = new HashSet();
                parameters.setImplementationsThenPredeclarations(true);
                parameters.setIncludeSameSymbols(true);
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                OCFunctionInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (names.add(symbol.getResolvedQualifiedName(resolveContext))) {
                        desc.addPossibleInheritor((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private static void setSearchParameters(@NotNull OCMemberInheritorsSearch.SearchParameters<?> parameters) {
            parameters.setIncludeSelfImplementation(true);
            parameters.setInterfacesThenImplementations(false);
            parameters.setIncludeFromID(true);
            parameters.setInheritors(true);
            parameters.setAncestors(false);
        }
    }
}

