/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCOverrideImplementCppFunctionsHandlerBase;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOverrideImplementCppFunctionsHandler
extends OCOverrideImplementCppFunctionsHandlerBase {
    private static final OCBooleanOption SHOW_NON_VIRTUAL_FUNCTIONS = new OCBooleanOption(OCBundle.message("override.implement.cpp.action.showNonVirtual", new Object[0]));

    @Override
    @Nullable
    public String getActionName() {
        return OCBundle.message("override.implement.cpp.action.name", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("override.implement.cpp.action.memberChooserTitle", new Object[0]);
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCOverrideImplementCppActionContext context) {
        return OCBundle.message("override.implement.cpp.action.noMember", context.getParentNameUppercase());
    }

    @Override
    @NotNull
    protected String getNoParentsMessage() {
        return OCBundle.message("override.implement.cpp.action.noParent", new Object[0]);
    }

    @Override
    protected OCOverrideImplementCppActionContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context) {
        return new OCOverrideImplementCppActionContext(parent, context, false);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        Boolean showNonVirtual = OCOverrideImplementCppFunctionsHandler.getOption(chooser.getOptionSelections(), SHOW_NON_VIRTUAL_FUNCTIONS);
        return super.getChooserNodes(chooser, (Collection<OCFunctionSymbol>)ContainerUtil.filter(candidates, symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return showNonVirtual != false && file != null && file.isWritable() || OCCallableUtil.resolveIsVirtual(symbol, actionContext.getProject());
        }), actionContext, moreNodesLevel);
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCOverrideImplementCppActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_NON_VIRTUAL_FUNCTIONS, (Object)(settings == null || settings.SHOW_NON_VIRTUAL_FUNCTIONS ? 1 : 0)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (optionValues.containsKey(SHOW_NON_VIRTUAL_FUNCTIONS)) {
            settings.SHOW_NON_VIRTUAL_FUNCTIONS = OCOverrideImplementCppFunctionsHandler.getOption(optionValues, SHOW_NON_VIRTUAL_FUNCTIONS);
        }
        super.saveOptions(file, settings, optionValues);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOption option, OCOverrideImplementCppActionContext actionContext) {
        if (SHOW_NON_VIRTUAL_FUNCTIONS.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        super.doPerformAction(project, location, actionContext, (List<OCFunctionSymbol>)ContainerUtil.map(chosenCandidates, symbol -> {
            if (!symbol.isVirtual() && !((OCStructSymbol)actionContext.getParent()).equals(symbol.getParent())) {
                return new OCFunctionSymbol((OCFunctionSymbol)symbol, symbol.getSubstitution(), symbol.getParent()){

                    @Override
                    public boolean isVirtual() {
                        return true;
                    }
                };
            }
            return symbol;
        }));
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{location.getFile()}).run(() -> {
            chosenCandidates.sort((o1, o2) -> o2.getOffset() - o1.getOffset());
            for (OCFunctionSymbol candidate : chosenCandidates) {
                OCMakeFunctionVirtualFix fix = new OCMakeFunctionVirtualFix(candidate, false, project);
                Editor editor = actionContext.getEditor();
                PsiFile file = actionContext.getEditorFile();
                if (((OCStructSymbol)actionContext.getParent()).equals(candidate.getParent()) || OCFunctionAncestorsQuery.findFirstVirtual(candidate, false, project) != null || !fix.isAvailable(project, editor, file)) continue;
                fix.invoke(project, editor, file);
            }
        });
    }
}

