/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCObjCClassTextActionHandlerBase<M extends OCMemberSymbol, C extends OCObjCActionContext<M>>
extends OCClassActionHandlerBase<OCClassSymbol, M, C> {
    protected abstract int getInsertPosition(PsiElement var1, int var2, PsiElement var3, List<M> var4, C var5);

    @NotNull
    protected abstract String getInsertText(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull List<M> var3, @NotNull C var4);

    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        return false;
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        LinkedList<PsiFile> files = new LinkedList<PsiFile>();
        for (PsiElement element : (List)this.getElementsToModify(actionContext).getFirst()) {
            files.add(element.getContainingFile());
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])PsiUtilCore.toPsiFileArray(files)).withName(this.getActionTitle()).run(() -> {
            int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
            PsiElement at = null;
            if (editor != null && (at = file.findElementAt(caretPos)) == null) {
                at = file.getLastChild();
            }
            Pair<List<PsiElement>, Integer> pair = this.getElementsToModify(actionContext);
            List elements = (List)pair.getFirst();
            Integer originalElementIndex = (Integer)pair.getSecond();
            for (PsiElement element : elements) {
                if (FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) continue;
                return;
            }
            for (int i = 0; i < elements.size(); ++i) {
                PsiElement element;
                element = (PsiElement)elements.get(i);
                if (!element.isValid()) continue;
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                if (virtualFile != null) {
                    CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
                }
                if (i == originalElementIndex) {
                    this.performAction(project, element, caretPos, at, chosenCandidates, actionContext);
                    continue;
                }
                this.performAction(project, element, -1, null, chosenCandidates, actionContext);
            }
        });
    }

    private Pair<List<PsiElement>, Integer> getElementsToModify(@NotNull C context) {
        int originalElementIndex = -1;
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        List<OCSymbol> symbols = ((OCObjCActionContext)context).getSymbolsToModify();
        for (int i = 0; i < symbols.size(); ++i) {
            PsiElement declaration;
            OCSymbol symbol = symbols.get(i);
            if (symbol == null || (declaration = symbol.locateDefinition(((OCActionContext)context).getProject())) == null) continue;
            elements.add(declaration);
            if (!symbol.equals(((OCActionContext)context).getParent())) continue;
            originalElementIndex = i;
        }
        return new Pair(elements, (Object)originalElementIndex);
    }

    protected void performAction(@NotNull Project project, @NotNull PsiElement element, int caretPos, @Nullable PsiElement at, @NotNull List<M> members, @NotNull C context) {
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        String insertText = this.getInsertText(element, at, members, context);
        if (insertText.isEmpty()) {
            return;
        }
        int insertOffset = this.getInsertPosition(element, caretPos, at, members, context);
        if (insertOffset == -1) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(insertOffset, insertOffset);
        rangeMarker.setGreedyToRight(true);
        document.insertString(insertOffset, (CharSequence)insertText);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        OCChangeUtil.reformatTextIfNotInjected(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)file, TextRange.create((Segment)rangeMarker));
        OCCodeInsightUtil.showCallableInEditorAndSelectBody(file, (Segment)rangeMarker, (Condition<? super OCBlockStatement>)((Condition)this::shouldSelectResult));
    }
}

