/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.intentions.OCMoveToPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratePropertiesHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCInstanceVariableSymbol, OCGenerateFromIvarsActionContext> {
    private static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption(OCGenerateBundle.message("generate.properties.handler.show.synthesized", new Object[0]));
    private static final OCBooleanOption CONVERT_USAGES = new OCBooleanOption(OCGenerateBundle.message("generate.properties.handler.convert.usages", new Object[0]));

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("generate.properties.handler.members.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        return OCGenerateBundle.message("generate.properties.handler.action.title", new Object[0]);
    }

    @Override
    @NlsContexts.DialogMessage
    protected String getNoMembersMessage(@NotNull OCGenerateFromIvarsActionContext context) {
        String parentName = context.getParentNameUppercase();
        return OCGenerateBundle.message("generate.properties.handler.no.instance.variables", parentName);
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateFromIvarsActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        if (OCCompilerFeaturesHelper.supportsAutosynthesis(file)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)CONVERT_USAGES, (Object)true));
        }
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCGenerateFromIvarsActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        return new OCGenerateFromIvarsActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        return symbol -> symbol.getGeneratedFromProperty() == null;
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCGenerateFromIvarsActionContext context, @NotNull List<OCInstanceVariableSymbol> ivars) {
        this.performAction(file, context, ivars, null, null, false, this.convertUsages(context), false);
    }

    protected boolean convertUsages(OCGenerateFromIvarsActionContext context) {
        Boolean value = this.getOption(context, CONVERT_USAGES);
        return value != null ? value : true;
    }

    protected void performAction(PsiFile file, OCGenerateFromIvarsActionContext context, List<OCInstanceVariableSymbol> ivars, @Nullable String customName, @Nullable OCPropertySymbol.PropertySemantics customSemantics, boolean isReadonly, boolean convertUsages, final boolean putToPrivateCategory) {
        OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        HashMap newNames = new HashMap();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllIvars = this.replaceAllIvars();
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file;
        ArrayList nonReleasedIvars = new ArrayList();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file);
        ApplicationManager.getApplication().runWriteAction(() -> OCGeneratePropertiesHandler.lambda$performAction$1(ivars, context, customName, newNames, convertUsages, interfaceSymbol, (PsiElement)psiContext, customSemantics, file, isReadonly, newDeclarations, existingDeclarations, replaceAllIvars, synthesizes, ivarsInfo, nonReleasedIvars));
        OCReleaseVariablesIntentionAction releaseAction = OCCompilerFeaturesHelper.isArcDisabled(file) && !nonReleasedIvars.isEmpty() ? new OCReleaseVariablesIntentionAction(nonReleasedIvars, context.getProject()) : null;
        OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol>((OCClassSymbol)interfaceSymbol, ivars, newNames, newDeclarations, existingDeclarations, replaceAllIvars ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DOT, this.getActionTitle(), convertUsages, context.getProject()){

            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGeneratePropertiesHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }

            @Override
            protected void performRefactoring(UsageInfo @NotNull [] usages) {
                OCMoveToPrivateCategoryIntentionAction action;
                PsiElement newDeclaration;
                super.performRefactoring(usages);
                PsiElement psiElement = newDeclaration = this.myNewDeclarations.isEmpty() ? null : (PsiElement)this.myNewDeclarations.values().iterator().next();
                if (putToPrivateCategory && newDeclaration instanceof OCProperty && (action = new OCMoveToPrivateCategoryIntentionAction(){

                    @Override
                    protected OCMemberSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
                        return (OCMemberSymbol)((OCProperty)newDeclaration).getDeclaration().getDeclarators().get(0).getSymbol();
                    }
                }).isAvailable(this.myProject, null, newDeclaration.getContainingFile())) {
                    action.invoke(this.myProject, null, newDeclaration.getContainingFile());
                }
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllIvars() {
        return false;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCGenerateFromIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGeneratePropertiesHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        HashSet synthesizedIvars = new HashSet();
        actionContext.getType().processMembers(OCSynthesizeSymbol.class, symbol -> {
            if (symbol.isSynthesize()) {
                synthesizedIvars.add(symbol.getIvarName());
            }
            return true;
        });
        if (OCCompilerFeaturesHelper.supportsAutosynthesis(actionContext.getContext().getContainingFile())) {
            actionContext.getInterfaceSymbol().processMembersInAllCategories(null, OCPropertySymbol.class, propertySymbol -> {
                OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar(actionContext.getProject());
                if (ivar != null) {
                    synthesizedIvars.add(ivar.getName());
                }
                return true;
            }, false, actionContext.getProject());
        }
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, ivar -> !synthesizedIvars.contains(ivar.getName())), actionContext, moreNodesLevel);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCOption option, OCGenerateFromIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    private static /* synthetic */ void lambda$performAction$1(List ivars, OCGenerateFromIvarsActionContext context, String customName, Map newNames, boolean convertUsages, OCInterfaceSymbol interfaceSymbol, PsiElement psiContext, OCPropertySymbol.PropertySemantics customSemantics, PsiFile file, boolean isReadonly, Map newDeclarations, Map existingDeclarations, boolean replaceAllIvars, List synthesizes, OCNotReleasedIvarInspection.IvarsInfo ivarsInfo, List nonReleasedIvars) {
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCType ivarType;
            OCPropertySymbol associatedProperty = ivar.getAssociatedProperty(context.getProject());
            String propName = customName != null ? customName : (associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true, context.getProject()));
            newNames.put(ivar, convertUsages ? propName : OCNameSuggester.getClang4ImplicitIvarName(propName));
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            if (interfaceSymbol != null) {
                interfaceSymbol.processMembers(propName, OCPropertySymbol.class, finder);
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(psiContext);
            if (!finder.isFound()) {
                OCPropertySymbol.PropertySemantics semantics = null;
                OCType type = ivar.getResolvedType(resolveContext);
                if (customSemantics != null) {
                    semantics = customSemantics;
                } else if (OCCompilerFeaturesHelper.isArcEnabled(file) && type.isPointerToObjectCompatible()) {
                    semantics = ivar.getARCAttribute(psiContext, context.getProject()).getPropertyCompatibleSemantics(type, psiContext);
                }
                OCProperty property = OCElementFactory.propertyDeclaration(propName, type, psiContext, semantics, isReadonly);
                newDeclarations.put(ivar, property);
            } else {
                existingDeclarations.put(ivar, (OCMemberSymbol)finder.getFoundValue());
            }
            if (!(replaceAllIvars || OCCompilerFeaturesHelper.supportsAutosynthesis(file) && OCNameSuggester.getClang4ImplicitIvarName(propName).equals(ivar.getName()))) {
                OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", propName, propName.equals(ivar.getName()) ? null : ivar.getName(), psiContext);
                synthesizes.add(synthesize);
            }
            if (!(ivarType = ivar.getResolvedType(resolveContext)).isPointerToObjectCompatible() || ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, file, ivarsInfo)) continue;
            nonReleasedIvars.add(ivar);
        }
    }
}

