/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateComparisonOperatorsContext;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateComparisonOperatorsHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateComparisonOperatorsContext> {
    private static final OCBooleanOption ADDITIONAL_EQ_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.additional.eq.option", new Object[0]));
    private static final OCBooleanOption ADDITIONAL_REL_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.additional.rel.option", new Object[0]));
    private static final OCBooleanOption AS_MEMBER_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.as.member.option", new Object[0]));
    private static final OCBooleanOption USE_STD_TIE_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.use.std.tie", new Object[0]));
    private final EnumSet<Type> myTypes;

    public OCGenerateComparisonOperatorsHandler(@NotNull EnumSet<Type> types) {
        this.myTypes = types;
    }

    @Override
    @NotNull
    protected Collection<OCFunctionSymbol> checkExistingFunctions(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        ArrayList<String> operators = this.getOperatorsToGenerate(actionContext);
        OCStructType selfType = ((OCStructSymbol)actionContext.getParent()).getType();
        List<Pair<String, OCFunctionSymbol>> existing = OCResolveUtil.findExistingFunctions(project, operators, Arrays.asList(selfType, selfType), (OCSymbol)actionContext.getParent(), OCResolveContext.forSymbol((OCSymbol)actionContext.getParent(), actionContext.getProject()));
        actionContext.setExistingOperators(existing.stream().map(p -> (String)p.getFirst()).distinct().collect(Collectors.toList()));
        actionContext.setOperatorsToGenerate(operators);
        return ContainerUtil.map(existing, p -> (OCFunctionSymbol)p.getSecond());
    }

    @Override
    @NotNull
    protected String getSomeDefinedText() {
        return OCBundle.message("generate.comparison.operators.usages.some.defined", new Object[0]);
    }

    @Override
    @NotNull
    protected String getAllDefinedText() {
        return OCBundle.message("generate.comparison.operators.usages.all.defined", new Object[0]);
    }

    @Override
    @NotNull
    protected String getExistingTabName() {
        return OCBundle.message("generate.comparison.operators.usages.existing.text", new Object[0]);
    }

    private @NotNull ArrayList<@NlsSafe String> getOperatorsToGenerate(@NotNull OCGenerateComparisonOperatorsContext context) {
        ArrayList<@NlsSafe String> result = new ArrayList<String>();
        if (this.myTypes.contains((Object)Type.EQUALITY)) {
            result.add("operator==");
            if (this.getOption(context, ADDITIONAL_EQ_OPTION).booleanValue()) {
                result.add("operator!=");
            }
        }
        if (this.myTypes.contains((Object)Type.RELATIONAL)) {
            result.add("operator<");
            if (this.getOption(context, ADDITIONAL_REL_OPTION).booleanValue()) {
                result.add("operator>");
                result.add("operator<=");
                result.add("operator>=");
            }
        }
        return result;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        List all = actionContext.getOperatorsToGenerate();
        List ops = actionContext.isReplaceExisting() ? all : ContainerUtil.filter(all, o -> !actionContext.getExistingOperators().contains(o));
        List symbols = ContainerUtil.map((Collection)ops, s -> OCGenerateComparisonOperatorsHandler.createBinaryOperatorSymbol(location.getProject(), s, actionContext));
        List bodies = ContainerUtil.map((Collection)ops, s -> this.getOperatorBody((String)s, actionContext, fields));
        PsiElement element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject());
        if (!(element instanceof OCStruct)) {
            return Collections.emptyList();
        }
        List<OCGenerateUtil.Replacement> replacements = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, (OCStruct)element, actionContext.getParent(), symbols, bodies, this.getInlinePolicy(actionContext));
        return replacements;
    }

    @NotNull
    @NlsSafe
    private String getOperatorBody(@NlsSafe @NotNull String operator, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        Project project = actionContext.getProject();
        String lhsNameOrThis = OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext);
        String rhsName = OCGenerateComparisonOperatorsHandler.getRhsName(project);
        return switch (operator) {
            case "operator==" -> this.getEqOperatorBody(fields, actionContext);
            case "operator!=" -> String.format("{\n return !(%s == %s);\n}", rhsName, lhsNameOrThis);
            case "operator<" -> this.getLessOperatorBody(fields, actionContext);
            case "operator>" -> String.format("{\n return %s < %s;\n}", rhsName, lhsNameOrThis);
            case "operator<=" -> String.format("{\n return !(%s < %s);\n}", rhsName, lhsNameOrThis);
            case "operator>=" -> String.format("{\n return !(%s < %s);\n}", lhsNameOrThis, rhsName);
            default -> throw new IllegalArgumentException(operator + " should be a comparison operator");
        };
    }

    @NotNull
    private static OCFunctionSymbol createBinaryOperatorSymbol(@NotNull Project project, @NotNull String name, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        boolean isMember = OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext);
        OCCppReferenceType selfCref = OCCppReferenceType.to(((OCStructSymbol)actionContext.getParent()).getType().cloneWithConstModifier(project));
        OCFakeFunctionSymbolBuilder builder2 = new OCFakeFunctionSymbolBuilder(name).setReturnType(OCIntType.BOOL_NATIVE).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setVisibility(OCVisibility.PUBLIC).setIsConst(isMember).setIsFriend(!isMember).setIsOperator(true);
        if (!isMember) {
            builder2.addParam(selfCref, OCGenerateComparisonOperatorsHandler.getLhsName(project));
        }
        builder2.addParam(selfCref, OCGenerateComparisonOperatorsHandler.getRhsName(project));
        return builder2.get();
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    private static String getRhsName(@NotNull Project project) {
        return OCNamingConventionUtil.applyNamingConvention("rhs", OCSymbolKind.PARAMETER, project);
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    private static String getLhsName(@NotNull Project project) {
        return OCNamingConventionUtil.applyNamingConvention("lhs", OCSymbolKind.PARAMETER, project);
    }

    @NotNull
    @NlsSafe
    private static String getLhsNameOrThis(@NotNull OCGenerateComparisonOperatorsContext actionContext) {
        return OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext) ? "*this" : OCGenerateComparisonOperatorsHandler.getLhsName(actionContext.getProject());
    }

    public static boolean shouldBeMember(@NotNull OCGenerateComparisonOperatorsContext actionContext) {
        return actionContext.getOptionValues() != null && OCGenerateComparisonOperatorsHandler.getOption(actionContext.getOptionValues(), AS_MEMBER_OPTION) != false;
    }

    private static void fillLeftsAndRights(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<@NlsSafe String> lefts, @NotNull List<@NlsSafe String> rights) {
        Project project = actionContext.getProject();
        OCResolveContext context = OCResolveContext.forSymbol((OCSymbol)actionContext.getParent(), project);
        ((OCStructSymbol)actionContext.getParent()).processBaseClasses(context, (symbol, visibility) -> {
            String name = symbol.getType().getBestNameInContext(context);
            lefts.add(String.format("static_cast<const %s &>(%s)", name, OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext)));
            rights.add(String.format("static_cast<const %s &>(%s)", name, OCGenerateComparisonOperatorsHandler.getRhsName(project)));
            return true;
        });
        for (OCDeclaratorSymbol field : fields) {
            lefts.add((String)(OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext) ? "" : OCGenerateComparisonOperatorsHandler.getLhsName(project) + ".") + field.getName());
            rights.add(OCGenerateComparisonOperatorsHandler.getRhsName(project) + "." + field.getName());
        }
    }

    @NotNull
    @NlsSafe
    private String getEqOperatorBody(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        ArrayList<String> lefts = new ArrayList<String>();
        ArrayList<String> rights = new ArrayList<String>();
        OCGenerateComparisonOperatorsHandler.fillLeftsAndRights(fields, actionContext, lefts, rights);
        @NlsSafe String retVal = this.getOption(actionContext, USE_STD_TIE_OPTION) != false && lefts.size() > 1 ? String.format("std::tie(%s) == std::tie(%s)", StringUtil.join(lefts, (String)", "), StringUtil.join(rights, (String)", ")) : StringUtil.join((Iterable)ContainerUtil.zip(lefts, rights), pair -> (String)pair.first + " == " + (String)pair.second, (String)" && \n");
        return String.format("{\nreturn %s;\n}", retVal);
    }

    @NotNull
    @NlsSafe
    private String getLessOperatorBody(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        ArrayList<String> lefts = new ArrayList<String>();
        ArrayList<String> rights = new ArrayList<String>();
        OCGenerateComparisonOperatorsHandler.fillLeftsAndRights(fields, actionContext, lefts, rights);
        if (this.getOption(actionContext, USE_STD_TIE_OPTION).booleanValue() && lefts.size() > 1) {
            return String.format("{\nreturn std::tie(%s) < std::tie(%s);\n}", StringUtil.join(lefts, (String)", "), StringUtil.join(rights, (String)", "));
        }
        @NlsSafe StringBuilder result = new StringBuilder("{\n");
        int idx = 0;
        for (Pair pair : ContainerUtil.zip(lefts, rights)) {
            if (idx != lefts.size() - 1) {
                result.append(String.format("if (%s < %s)\nreturn true;\nif (%s < %s)\nreturn false;\n", pair.first, pair.second, pair.second, pair.first));
            } else {
                result.append(String.format("return %s < %s;\n", pair.first, pair.second));
            }
            ++idx;
        }
        result.append("}");
        return result.toString();
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        if (this.myTypes.equals(EnumSet.of(Type.EQUALITY))) {
            return OCBundle.message("generate.comparison.operators.action.title.eq", new Object[0]);
        }
        if (this.myTypes.equals(EnumSet.of(Type.RELATIONAL))) {
            return OCBundle.message("generate.comparison.operators.action.title.rel", new Object[0]);
        }
        return OCBundle.message("generate.comparison.operators.action.title", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("generate.comparison.operators.member.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    protected OCGenerateComparisonOperatorsContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context) {
        return new OCGenerateComparisonOperatorsContext(parent, context);
    }

    @Override
    @NotNull
    protected Collection<OCDeclaratorSymbol> getSelectedCandidates(@NotNull OCGenerateComparisonOperatorsContext actionContext, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<OCDeclaratorSymbol> candidates) {
        return candidates;
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (optionValues.containsKey(AS_MEMBER_OPTION)) {
            settings.GENERATE_OPERATORS_AS_MEMBERS = OCGenerateComparisonOperatorsHandler.getOption(optionValues, AS_MEMBER_OPTION);
        }
        if (optionValues.containsKey(USE_STD_TIE_OPTION)) {
            settings.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE = OCGenerateComparisonOperatorsHandler.getOption(optionValues, USE_STD_TIE_OPTION);
        }
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateComparisonOperatorsContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (this.myTypes.contains((Object)Type.EQUALITY)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)ADDITIONAL_EQ_OPTION, (Object)(settings == null || settings.GENERATE_ADDITIONAL_EQ_OPERATORS ? 1 : 0)));
        }
        if (this.myTypes.contains((Object)Type.RELATIONAL)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)ADDITIONAL_REL_OPTION, (Object)(settings == null || settings.GENERATE_ADDITIONAL_REL_OPERATORS ? 1 : 0)));
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)AS_MEMBER_OPTION, (Object)(settings == null || settings.GENERATE_OPERATORS_AS_MEMBERS ? 1 : 0)));
        options.add((Pair<OCOption, Object>)new Pair((Object)USE_STD_TIE_OPTION, (Object)(settings != null && settings.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE ? 1 : 0)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    public static enum Type {
        EQUALITY,
        RELATIONAL;

    }
}

