/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMemberChooserObject
extends MemberChooserObjectBase
implements ClassMember {
    private OCSymbol mySymbol;
    private Map<OCSymbol, OCSymbol> myParentsMap;
    @NotNull
    private final Project myProject;

    public OCMemberChooserObject(OCSymbol symbol, @NlsContexts.Label String text, Icon icon, @NotNull Project project) {
        super(text, icon);
        this.mySymbol = symbol;
        this.myProject = project;
    }

    private OCMemberChooserObject(OCSymbol symbol, OCSymbol delegateSymbol, Map<OCSymbol, OCSymbol> parentsMap, @NotNull Project project) {
        this(symbol, OCMemberChooserObject.getPresentableText(delegateSymbol), delegateSymbol.getIcon(project), project);
        this.myParentsMap = parentsMap;
    }

    public OCMemberChooserObject(OCSymbol symbol, Icon icon, Map<OCSymbol, OCSymbol> parentsMap, @NotNull Project project) {
        this(symbol, OCMemberChooserObject.getPresentableText(symbol), icon, project);
        this.myParentsMap = parentsMap;
    }

    public OCMemberChooserObject(OCSymbol symbol, Map<OCSymbol, OCSymbol> parentsMap, @NotNull Project project) {
        this(symbol, OCMemberChooserObject.getDelegateSymbol(symbol, project), parentsMap, project);
    }

    private static OCSymbol getDelegateSymbol(OCSymbol symbol, @NotNull Project project) {
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(project)) {
            OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(project);
            return property != null ? property : symbol;
        }
        return symbol;
    }

    @NlsSafe
    private static String getPresentableText(OCSymbol target) {
        if (target instanceof OCFunctionSymbol) {
            return ((OCFunctionSymbol)target).getSignatureWithoutParamNames();
        }
        if (target instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)target).isGlobalNamespace()) {
            VirtualFile file = target.getContainingFile();
            return file != null ? file.getName() : "";
        }
        return target.getPresentableName();
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OCMemberChooserObject that = (OCMemberChooserObject)((Object)o);
        return !(this.mySymbol != null ? !this.mySymbol.equals(that.mySymbol) : that.mySymbol != null);
    }

    public int hashCode() {
        return this.mySymbol != null ? this.mySymbol.hashCode() : 0;
    }

    @Nullable
    public MemberChooserObject getParentNodeDelegate() {
        OCSymbol parent = this.myParentsMap != null ? this.myParentsMap.get(this.mySymbol) : null;
        return parent != null ? new OCMemberChooserObject(parent, this.myParentsMap, this.myProject) : null;
    }
}

