/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCaretLocation {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final PsiElement myElement;
    private final int myOffsetInElement;

    @NotNull
    public static OCCaretLocation byEditor(@NotNull PsiFile file, @Nullable Editor editor) {
        PsiElement element = editor == null ? null : OCGenerateUtil.getElementAt(editor, file);
        int offset = editor == null ? -1 : Math.max(0, editor.getCaretModel().getOffset() - element.getTextRange().getStartOffset());
        return new OCCaretLocation(file, element, offset);
    }

    @NotNull
    public static OCCaretLocation byOffset(@NotNull PsiFile file, int offsetInFile) {
        PsiElement element = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(offsetInFile), (Object)file);
        return new OCCaretLocation(file, element, MathUtil.clamp((int)(offsetInFile - element.getTextRange().getStartOffset()), (int)0, (int)element.getTextRange().getLength()));
    }

    public static OCCaretLocation byFile(@NotNull PsiFile file) {
        return new OCCaretLocation(file, null, -1);
    }

    private OCCaretLocation(@NotNull PsiFile file, @Nullable PsiElement element, int offsetInElement) {
        this.myFile = file;
        this.myElement = element;
        this.myOffsetInElement = offsetInElement;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Integer getOffsetInFile() {
        return this.myElement == null ? null : Integer.valueOf(this.myElement.getTextRange().getStartOffset() + this.myOffsetInElement);
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public Project getProject() {
        return this.myFile.getProject();
    }

    @NotNull
    public OCResolveContext createContext() {
        return OCResolveContext.forPsi((PsiElement)ObjectUtils.notNull((Object)this.myElement, (Object)this.myFile));
    }
}

