/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Formatter;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.formatting.CidrFormattingModelBuilder;
import com.jetbrains.cidr.lang.formatting.OCPsiBasedFormattingModel;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCFormattingModelBuilder
extends CidrFormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        boolean alwaysCreateFullModel;
        PsiFile psiFile = formattingContext.getContainingFile();
        boolean bl = alwaysCreateFullModel = OCFormattingModelBuilder.isAlwaysCreateFullModel() || OCParser.isSimplifiedParsingMode(psiFile) != false;
        if (!alwaysCreateFullModel && DumbService.getInstance((Project)formattingContext.getProject()).isDumb() || OCElementUtil.getElementType(psiFile.getFirstChild()) == OCParsing.DUMB_ELEMENT_TYPE) {
            return Formatter.getInstance().createDummyFormattingModel(formattingContext.getPsiElement());
        }
        PsiFile file = OCLanguageUtils.tryGetOCFile(psiFile);
        return new OCPsiBasedFormattingModel(file, formattingContext.getCodeStyleSettings(), formattingContext.getFormattingMode());
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        PsiFile ocFile = OCLanguageUtils.tryGetOCFile(file);
        OCElement parent = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)ocFile.findElementAt(offset), (Class[])new Class[]{OCMethod.class, OCExpression.class});
        return parent != null ? parent.getTextRange() : null;
    }
}

