/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;

public class OCDoWhileSurrounder
extends OCStatementSurrounder<OCDoWhileStatement> {
    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "do {\n} while (a);";
    }

    @Override
    protected PsiElement getInsertionPlace(OCDoWhileStatement statement) {
        return statement.getBody();
    }

    @Override
    protected TextRange getSelectionRange(OCDoWhileStatement statement) {
        OCExpression condition = statement.getCondition();
        int offset = condition.getRangeWithMacros().getStartOffset();
        OCChangeUtil.delete(condition);
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return OCBundle.message("surround.with.do.while.template", new Object[0]);
    }
}

