/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.cidr.cpp.lexer.CidrPrefixStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.cidr.cpp.lexer.OCRawStringLexerBase;
import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockOwner;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFixer
extends SmartEnterProcessorWithFixers.Fixer<OCSmartEnterProcessor> {
    public static final OCElementType RAW_PSEUDOTYPE = new OCElementType("raw");
    public static final Pattern OLD_END_PREFXIX = Pattern.compile("\\)\\S*\"");

    protected static int startLine(@NotNull Document doc, @NotNull PsiElement psiElement) {
        return doc.getLineNumber(OCChangeUtil.getRangeWithMacros(psiElement).getStartOffset());
    }

    @Nullable
    static PsiErrorElement getErrorElementOffset(@NotNull PsiElement elt) {
        final PsiErrorElement[] result = new PsiErrorElement[]{null};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                result[0] = element;
                this.stopWalking();
            }
        });
        return result[0];
    }

    @Contract(value="null -> false")
    static boolean isCompleteBlockOwner(@Nullable PsiElement psiElement) {
        if (psiElement instanceof OCBlockOwner) {
            return ((OCBlockOwner)psiElement).getOpeningBrace() != null && ((OCBlockOwner)psiElement).getClosingBrace() != null;
        }
        return false;
    }

    static boolean hasNonSpaceChildren(@NotNull OCBlockOwner block) {
        PsiElement end = block.getClosingBrace();
        boolean skip = true;
        for (PsiElement el = block.getOpeningBrace(); el != null && el != end; el = el.getNextSibling()) {
            if (skip) {
                skip = false;
                continue;
            }
            if (el instanceof PsiWhiteSpace) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> true")
    static boolean hasEmptyStatement(@Nullable PsiElement condition) {
        return condition == null || condition.getTextLength() == 0 && (condition.getFirstChild() == null || condition.getFirstChild() == condition.getLastChild() && condition.getFirstChild() instanceof PsiErrorElement);
    }

    @Contract(value="_, null, _ -> false")
    static boolean fixBlockIfNeed(@NotNull Editor editor, @Nullable PsiElement psiElement, boolean atCaret) {
        if (psiElement instanceof OCBlockOwner) {
            OCBlockOwner block = (OCBlockOwner)psiElement;
            PsiElement lbrace = block.getOpeningBrace();
            int caretOffset = editor.getCaretModel().getOffset();
            if (OCFixer.isRealLeafElement(lbrace) && !OCFixer.isGoodEmpty(block) && EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace((Editor)editor, (int)(atCaret ? caretOffset : OCChangeUtil.getRangeWithMacros(lbrace).getEndOffset()), (FileType)psiElement.getContainingFile().getFileType())) {
                List<OCStatement> statements;
                int stopOffset = block instanceof OCBlockStatement ? ((statements = ((OCBlockStatement)block).getStatements()).size() > 0 ? OCChangeUtil.getRangeWithMacros(statements.get(0)).getEndOffset() : OCChangeUtil.getRangeWithMacros(psiElement).getEndOffset()) : OCChangeUtil.getRangeWithMacros(lbrace).getEndOffset();
                Document document = editor.getDocument();
                if (caretOffset > stopOffset && CharArrayUtil.shiftBackward((CharSequence)document.getText(), (int)(caretOffset - 1), (String)" \t") <= stopOffset) {
                    editor.getCaretModel().moveToOffset(stopOffset);
                }
                document.insertString(stopOffset, (CharSequence)"}");
                return true;
            }
        }
        return false;
    }

    public static boolean isGoodEmpty(@NotNull OCBlockOwner block) {
        PsiElement lbrace = block.getOpeningBrace();
        PsiElement rbrace = block.getClosingBrace();
        if (lbrace == null || rbrace == null) {
            return false;
        }
        PsiElement spaceOrRbrace = lbrace.getNextSibling();
        return spaceOrRbrace == rbrace || spaceOrRbrace instanceof PsiWhiteSpace && spaceOrRbrace.getNextSibling() == rbrace;
    }

    @Nullable
    static PsiElement getFirstBodyElement(@NotNull OCBlockOwner block) {
        PsiElement lBrace = block.getOpeningBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement nextSibling = lBrace.getNextSibling();
        return nextSibling == block.getClosingBrace() ? null : nextSibling;
    }

    @Contract(value="_, null -> false")
    public static boolean fixSemicolonAtTheEnd(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        int insertionOffset = OCFixer.getSemicolonInsertionOffset(editor, psiElement);
        if (insertionOffset == -1) {
            return false;
        }
        editor.getDocument().insertString(insertionOffset, (CharSequence)";");
        return true;
    }

    public static int getSemicolonInsertionOffset(@Nullable Editor editor, @Nullable PsiElement psiElement) {
        return OCFixer.getInsertionOffset(editor, psiElement, (IElementType)OCTokenTypes.SEMICOLON);
    }

    public static int getInsertionOffset(@Nullable Editor editor, @Nullable PsiElement psiElement, IElementType elementType) {
        ASTNode leaf;
        if (psiElement == null) {
            return -1;
        }
        ASTNode aSTNode = leaf = psiElement instanceof PsiErrorElement ? psiElement.getNode() : TreeUtil.findLastLeaf((ASTNode)psiElement.getNode());
        if (leaf == null) {
            return -1;
        }
        if (OCElementUtil.getElementType(OCFixer.getNextEssentialLeaf(leaf)) == elementType) {
            return -1;
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(leaf.getElementType()) || leaf instanceof PsiErrorElement) {
            if ((leaf = TreeUtil.prevLeaf((ASTNode)leaf)) != null) continue;
            return -1;
        }
        IElementType leafElementType = leaf.getElementType();
        if (leafElementType == elementType || editor != null && OCFixer.needCorrectionLiteral(editor, leaf, false)) {
            return -1;
        }
        return OCFixer.getRangeWithMacros(leaf).getEndOffset();
    }

    @Nullable
    public static ASTNode getPrevEssentialLeaf(ASTNode leaf) {
        return OCFixer.getNeighborEssentialLeaf(leaf, false);
    }

    @Nullable
    public static ASTNode getNextEssentialLeaf(ASTNode leaf) {
        return OCFixer.getNeighborEssentialLeaf(leaf, true);
    }

    public static boolean isLikeStructVarDeclaration(@NotNull PsiElement structLike) {
        if (!(structLike instanceof OCStructLike) || ((OCStructLike)structLike).getBaseClausesList() != null) {
            return false;
        }
        ASTNode leaf = OCFixer.getNextEssentialLeaf(structLike.getNode());
        if (leaf == null) {
            return false;
        }
        return leaf.getElementType() == OCTokenTypes.IDENTIFIER && (OCFixer.endsTheLine(leaf) || OCElementUtil.getElementType(OCFixer.getNextEssentialLeaf(leaf)) == OCTokenTypes.SEMICOLON);
    }

    public static boolean endsTheLine(@NotNull ASTNode elem) {
        ASTNode leaf = TreeUtil.nextLeaf((ASTNode)elem);
        while (leaf != null) {
            if (leaf instanceof PsiWhiteSpace) {
                if (leaf.textContains('\n')) {
                    return true;
                }
            } else if (!(leaf instanceof PsiComment)) {
                return false;
            }
            leaf = TreeUtil.nextLeaf((ASTNode)leaf);
        }
        return true;
    }

    @Nullable
    public static ASTNode getNeighborEssentialLeaf(ASTNode leaf, boolean next) {
        ASTNode nextLeaf;
        ASTNode aSTNode = nextLeaf = next ? TreeUtil.nextLeaf((ASTNode)leaf) : TreeUtil.prevLeaf((ASTNode)leaf);
        while (nextLeaf != null) {
            IElementType type = nextLeaf.getElementType();
            ASTNode macro = TreeUtil.findParent((ASTNode)nextLeaf, (IElementType)OCElementTypes.MACRO_CALL);
            if (macro != null) {
                nextLeaf = macro;
            } else if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                return nextLeaf;
            }
            nextLeaf = next ? TreeUtil.nextLeaf((ASTNode)nextLeaf) : TreeUtil.prevLeaf((ASTNode)nextLeaf);
        }
        return null;
    }

    @Contract(value="null->false")
    static boolean isRealLeafElement(@Nullable PsiElement element) {
        assert (element == null || element instanceof LeafElement);
        return element != null && !(element instanceof OCMacroForeignLeafElement);
    }

    static boolean hasMacroBasedStatement(@NotNull PsiElement psiElement, @NotNull OCElementType keywordType) {
        ASTNode keyword;
        ASTNode dogNode;
        if (OCTokenTypes.KEYWORDS_WITH_AT.contains((IElementType)keywordType) && (dogNode = psiElement.getNode().findChildByType((IElementType)OCElementTypes.OBJC_KEYWORD)) != null) {
            psiElement = dogNode.getPsi();
        }
        return (keyword = psiElement.getNode().findChildByType((IElementType)keywordType)) == null || keyword instanceof OCMacroForeignLeafElement;
    }

    @Contract(value="_, null, _ -> false")
    public static boolean needCorrectionLiteral(@NotNull Editor editor, @Nullable ASTNode token, boolean fix) {
        IElementType nodeType;
        boolean ret = false;
        if (!(token == null || token instanceof OCMacroForeignLeafElement || (nodeType = token.getElementType()) != OCTokenTypes.STRING_LITERAL && nodeType != OCTokenTypes.CHARACTER_LITERAL && nodeType != OCTokenTypes.WRONG_RAW_STRING_LITERAL)) {
            int endPoint;
            char stopChar = nodeType == OCTokenTypes.CHARACTER_LITERAL ? (char)'\'' : '\"';
            boolean isRaw = OCTokenTypes.RAW_STRING_LITERALS.contains(nodeType);
            CidrPrefixStringLiteralLexer lexer = new CidrPrefixStringLiteralLexer(stopChar, OCTokenTypeProvider.INSTANCE.getRAW_STRING_PREFIX_TYPE(), (LexerBase)(!isRaw ? OCHighlightingLexer.createStringLiteralLexer((char)stopChar, (IElementType)OCTokenTypes.STRING_LITERAL) : new OCRawStringLexerBase((IElementType)RAW_PSEUDOTYPE, (IElementType)OCTokenTypes.STRING_LITERAL)));
            CharSequence docText = editor.getDocument().getCharsSequence();
            int startPoint = token.getStartOffset();
            int removeOffset = -1;
            if (nodeType == OCTokenTypes.WRONG_RAW_STRING_LITERAL) {
                Matcher matcher;
                endPoint = docText.length();
                int endOfLine = StringUtil.indexOf((CharSequence)docText, (char)'\n', (int)startPoint);
                if (endOfLine >= 0) {
                    endPoint = Math.min(endPoint, endOfLine);
                }
                if ((matcher = OLD_END_PREFXIX.matcher(docText.subSequence(startPoint, endPoint))).find() && startPoint + matcher.end(0) <= endPoint) {
                    endPoint = startPoint + matcher.end(0);
                    removeOffset = startPoint + matcher.start(0);
                } else {
                    endPoint = OCFixer.getAdjustedEndPoint(stopChar, docText, startPoint, endPoint, true);
                }
            } else {
                endPoint = OCFixer.getAdjustedEndPoint(stopChar, docText, startPoint, OCFixer.getRangeWithMacros(token).getEndOffset(), false);
            }
            lexer.start(docText, startPoint, endPoint);
            String rawPrefix = null;
            int prefixCount = 0;
            int stringEnd = -1;
            int stringStart = -1;
            boolean badEnd = true;
            while (lexer.getTokenType() != null) {
                IElementType tt = lexer.getTokenType();
                if (tt == RAW_PSEUDOTYPE) {
                    if (prefixCount == 0 && docText.charAt(lexer.getTokenEnd() - 1) == '(' || prefixCount == 1 && docText.charAt(lexer.getTokenStart()) == ')') {
                        rawPrefix = docText.subSequence(lexer.getTokenStart(), lexer.getTokenEnd() - 1).toString();
                        ++prefixCount;
                    }
                } else if (tt == OCTokenTypes.STRING_LITERAL && stringStart == -1) {
                    stringStart = lexer.getTokenStart();
                }
                stringEnd = lexer.getTokenEnd();
                badEnd = tt != OCTokenTypes.STRING_LITERAL;
                lexer.advance();
            }
            if (stringStart != -1 && stringEnd != -1) {
                if (stringStart == stringEnd - 1 || badEnd || docText.charAt(stringEnd - 1) != stopChar) {
                    if (fix) {
                        editor.getDocument().insertString(stringEnd, (CharSequence)String.valueOf(stopChar));
                    }
                    ++stringEnd;
                    ret = true;
                }
                if (isRaw && rawPrefix == null) {
                    rawPrefix = "";
                    if (fix) {
                        editor.getDocument().insertString(stringStart + 1, (CharSequence)"(");
                    }
                    if (removeOffset >= 0) {
                        ++removeOffset;
                    }
                    ++prefixCount;
                    ++stringEnd;
                    ret = true;
                }
                if (prefixCount == 1) {
                    String postfix = ")" + rawPrefix;
                    if (fix) {
                        if (removeOffset >= 0) {
                            editor.getDocument().replaceString(removeOffset, endPoint - 1, (CharSequence)postfix);
                        } else {
                            editor.getDocument().insertString(stringEnd - 1, (CharSequence)postfix);
                        }
                    }
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static int getCompletionPointAfterLPAR(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        int offset = -1;
        if (OCFixer.caretInVerticalRangeOfElement(editor, psiElement)) {
            offset = OCFixer.getCompletionPoint(editor);
        } else {
            ASTNode lpar = psiElement.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
            if (lpar != null) {
                editor.getCaretModel().moveToOffset(OCFixer.getRangeWithMacros(lpar).getEndOffset());
                offset = OCFixer.getCompletionPoint(editor);
            }
        }
        return Math.min(offset, OCChangeUtil.getRangeWithMacros(psiElement).getEndOffset());
    }

    public static boolean caretInVerticalRangeOfElement(@NotNull Editor editor, @NotNull PsiElement element) {
        Document document = editor.getDocument();
        TextRange range = OCChangeUtil.getRangeWithMacros(element);
        int startElementLine = document.getLineNumber(range.getStartOffset());
        int endElementLine = document.getLineNumber(range.getEndOffset());
        int caretOffset = document.getLineNumber(editor.getCaretModel().getOffset());
        return startElementLine <= caretOffset && caretOffset <= endElementLine;
    }

    public static int getCompletionPoint(@NotNull Editor editor) {
        int completionOffset = editor.getCaretModel().getOffset();
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE);
        CharSequence docText = editor.getDocument().getCharsSequence();
        completionOffset = CharArrayUtil.shiftBackward((CharSequence)docText, (int)completionOffset, (String)" \t");
        lexer.start(docText, completionOffset, docText.length());
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (lexer.getTokenText().contains("\n") || tt == OCTokenTypes.SEMICOLON || OCTokenTypes.COMMENTS.contains(tt)) break;
            completionOffset = lexer.getTokenEnd();
            lexer.advance();
        }
        return completionOffset;
    }

    private static int getAdjustedEndPoint(char stopChar, CharSequence docText, int startPoint, int endPoint, boolean checkQuote) {
        int quote = StringUtil.indexOf((CharSequence)docText, (char)stopChar, (int)startPoint, (int)endPoint);
        if (quote >= 0 && (quote = StringUtil.indexOf((CharSequence)docText, (char)stopChar, (int)(quote + 1), (int)endPoint)) >= 0) {
            return checkQuote ? quote + 1 : endPoint;
        }
        int semicolon = StringUtil.indexOf((CharSequence)docText, (char)';', (int)startPoint, (int)endPoint);
        if (semicolon >= 0) {
            return semicolon;
        }
        return endPoint;
    }

    static TextRange getRangeWithMacros(@NotNull ASTNode element) {
        return OCChangeUtil.getRangeWithMacros(element.getPsi());
    }

    static void fixConditionIfNeed(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull ASTNode lParenth, @Nullable PsiElement condition, @Nullable ASTNode rParenth) {
        int endLPar = OCFixer.getRangeWithMacros(lParenth).getEndOffset();
        if (rParenth != null) {
            if (OCFixer.hasEmptyStatement(condition)) {
                processor2.registerUnresolvedError(OCFixer.getRangeWithMacros(rParenth).getStartOffset());
            }
        } else {
            editor.getCaretModel().moveToOffset(endLPar);
            int offset = OCFixer.getCompletionPoint(editor);
            if (offset == endLPar) {
                processor2.registerUnresolvedError(endLPar);
            }
            editor.getDocument().insertString(offset, (CharSequence)")");
        }
    }

    @Nullable
    static PsiErrorElement getNextError(PsiElement atCaret) {
        int offset = OCChangeUtil.getRangeWithMacros(atCaret).getEndOffset();
        PsiElement parent;
        while ((parent = atCaret.getParent()) != null && !(parent instanceof PsiFile) && OCChangeUtil.getRangeWithMacros(parent).getEndOffset() == offset) {
            PsiElement lastChild = parent.getLastChild();
            if (lastChild instanceof PsiErrorElement) {
                return (PsiErrorElement)lastChild;
            }
            atCaret = parent;
        }
        return null;
    }
}

