/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCArgumentListSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof OCArgumentList;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List result = super.select(e, editorText, cursorOffset, editor);
        OCLog.LOG.assertTrue(result != null);
        OCArgumentList al = (OCArgumentList)e;
        PsiElement lPar = al.getLeftPar();
        PsiElement rPar = al.getRightPar();
        if (lPar != null && rPar != null) {
            int afterLPar = lPar.getTextRange().getEndOffset();
            int beforeRPar = rPar.getTextRange().getStartOffset();
            result.add(new TextRange(afterLPar, beforeRPar));
            while (StringUtil.isWhiteSpace((char)editorText.charAt(afterLPar))) {
                ++afterLPar;
            }
            while (beforeRPar > afterLPar && StringUtil.isWhiteSpace((char)editorText.charAt(beforeRPar - 1))) {
                --beforeRPar;
            }
            result.add(new TextRange(afterLPar, beforeRPar));
        }
        return result;
    }
}

