/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.OCFunctionParameterInfoHandler;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCompoundInitializerCallPlace
extends OCFunctionCallPlace<OCCompoundInitializer> {
    public OCCompoundInitializerCallPlace(OCCompoundInitializer initializer) {
        super(initializer);
    }

    @Override
    public void collectCallOptions(@NotNull Collection<OCFunctionCallOption> result) {
        OCCompoundInitializer initializer = (OCCompoundInitializer)this.getElement();
        PsiElement parent = initializer.getParent();
        OCFunctionCallPlace place = null;
        if (parent instanceof OCArgumentList) {
            OCArgumentList argumentList = (OCArgumentList)parent;
            place = new OCArgumentListCallPlace(argumentList);
            OCCompoundInitializerCallPlace.collectUsingFromParentOption(place, initializer, result);
        } else if (parent instanceof OCCompoundInitializer) {
            OCCompoundInitializer i = (OCCompoundInitializer)parent;
            place = new OCCompoundInitializerCallPlace(i);
            OCCompoundInitializerCallPlace.collectUsingFromParentOption(place, initializer, result);
        } else if (parent instanceof OCCppNewExpression) {
            OCCppNewExpression newExpr = (OCCppNewExpression)parent;
            OCType rt = newExpr.getConstructingType().resolve((PsiElement)initializer.getContainingFile());
            OCCompoundInitializerCallPlace.collectInitializationOptions(rt, initializer, result);
        } else {
            OCType type = initializer.inferType();
            if (type != null) {
                OCType rt = type.resolve(initializer);
                OCCompoundInitializerCallPlace.collectInitializationOptions(rt, initializer, result);
            }
        }
    }

    private static void collectUsingFromParentOption(@NotNull OCFunctionCallPlace<? extends PsiElement> place, @NotNull OCCompoundInitializer initializer, @NotNull Collection<OCFunctionCallOption> result) {
        List<OCExpression> expressions = place.getArgumentExpressions();
        int initIdx = expressions.indexOf(initializer);
        assert (initIdx >= 0);
        ArrayList<OCFunctionCallOption> options = new ArrayList<OCFunctionCallOption>();
        place.collectCallOptions(options);
        for (OCFunctionCallOption option : options) {
            OCFunctionType ft = option.getParameterInfo().getType();
            List<OCType> pts = ft.getParameterTypes();
            if (pts.size() <= initIdx || initIdx >= 1 && !OCFunctionParameterInfoHandler.isApplicableBeforeIndex(ft, expressions, initIdx - 1)) continue;
            OCType initType = pts.get(initIdx);
            OCCompoundInitializerCallPlace.collectInitializationOptions(initType, initializer, result);
        }
    }

    @Override
    @NotNull
    public List<OCExpression> getArgumentExpressions() {
        return ((OCCompoundInitializer)this.getElement()).getInitializerExpressions();
    }
}

