/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import icons.CidrLangIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCVariableOfTypeMacro
extends Macro {
    @NlsSafe
    private static final String MACRO_NAME = "variableOfType";

    public String getName() {
        return MACRO_NAME;
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        PsiElement[] variables = OCVariableOfTypeMacro.getVariables(params, context);
        if (variables == null || variables.length == 0) {
            return null;
        }
        return new OCElementResult((OCElement)variables[0]);
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        PsiElement[] variables = OCVariableOfTypeMacro.getVariables(params, context);
        if (variables == null || variables.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            PsiElement var = variables[i];
            items[i] = var instanceof PsiNamedElement ? LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)var)).withIcon(var.getIcon(0)) : LookupElementBuilder.create((String)var.getText()).withIcon(CidrLangIcons.CodeAssistantMember);
        }
        return items;
    }

    protected static PsiElement @Nullable [] getVariables(Expression[] params, ExpressionContext context) {
        OCType type;
        String typeText;
        if (params.length != 1) {
            return null;
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file = place.getContainingFile();
        assert (file != null);
        OCResolveContext resolveContext = OCResolveContext.forPsi(place);
        Result param = params[0].calculateResult(context);
        String string = typeText = param != null ? param.toString() : "";
        if (typeText.isEmpty()) {
            type = null;
        } else {
            OCDeclaration dcl = OCElementFactory.declarationFromText(typeText + "x;", (PsiElement)file);
            List<OCDeclarator> declarators = dcl.getDeclarators();
            if (declarators.size() == 1) {
                OCType unresolved = declarators.get(0).getType();
                type = unresolved.resolve(resolveContext);
            } else {
                type = null;
            }
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, false);
        for (OCDeclaratorSymbol var : variables) {
            PsiElement parent;
            PsiElement def;
            OCType varResolvedType = var.getType().resolve(resolveContext);
            if (type != null && !type.isCompatible(varResolvedType, resolveContext) || (def = var.locateDefinition(context.getProject())) == null || (parent = def.getContext().getContext()) instanceof OCForeachStatement) continue;
            result.add(def);
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

