/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTemplatesUtil {
    private static final Logger LOG = Logger.getInstance(OCTemplatesUtil.class);

    private OCTemplatesUtil() {
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesVisibleAt(PsiElement place, boolean withFields) {
        HashSet names = new HashSet();
        ArrayList<OCDeclaratorSymbol> answer = new ArrayList<OCDeclaratorSymbol>();
        Processor processor2 = symbol -> {
            OCSymbolKind kind;
            if (symbol instanceof OCDeclaratorSymbol && names.add(symbol.getName()) && ((kind = symbol.getKind()).isLocal() || kind == OCSymbolKind.STRUCT_FIELD)) {
                answer.add((OCDeclaratorSymbol)symbol);
            }
            return true;
        };
        if (withFields) {
            OCResolveUtil.processSymbols(null, place, (Processor<OCSymbol>)processor2);
        } else {
            OCResolveUtil.processLocalSymbols(null, place, (Processor<OCSymbol>)processor2, false);
        }
        return answer;
    }

    @Nullable
    public static Collection<String> getNames(ExpressionContext context) {
        Project project = context.getProject();
        int offset = context.getStartOffset();
        Collection<String> names = null;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
            names = OCTemplatesUtil.getNamesForIdentifier(project, element);
        } else {
            PsiFile fileCopy = (PsiFile)file.copy();
            ApplicationManager.getApplication().runWriteAction(() -> {
                BlockSupport blockSupport = BlockSupport.getInstance((Project)project);
                try {
                    blockSupport.reparseRange(fileCopy, offset, offset, (CharSequence)"xxx");
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            PsiElement identifierCopy = fileCopy.findElementAt(offset);
            if (identifierCopy.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
                names = OCTemplatesUtil.getNamesForIdentifier(project, identifierCopy);
            }
        }
        return names;
    }

    @Nullable
    private static Collection<String> getNamesForIdentifier(Project project, PsiElement identifier) {
        OCDeclarator var;
        if (identifier.getParent() instanceof OCDeclarator && identifier.equals((var = (OCDeclarator)identifier.getParent()).getNameIdentifier())) {
            return OCNameSuggester.suggestForDeclaration(var, false, Collections.emptyList());
        }
        return null;
    }

    @NotNull
    public static PsiElement getInsertionPlace(@NotNull ExpressionContext context) {
        Editor editor = context.getEditor();
        OCLog.LOG.assertTrue(editor != null && editor.getProject() != null, (Object)"Template call in undefined editor");
        PsiFile file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        OCLog.LOG.assertTrue(file != null, (Object)"Template call in undefined file");
        PsiElement place = file.findElementAt(context.getStartOffset());
        OCLog.LOG.assertTrue(place != null, (Object)"Template call in undefined context");
        return place;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithBeginEnd(@NotNull ExpressionContext context) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type = var.getResolvedType(OCResolveContext.forPsi(place));
            if (type.isUnresolved(place) || type.isUnknown() || var.isUnnamed()) continue;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file = expr.getContainingOCFile();
            if (!(type instanceof OCStructType) || OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file).getFirst() != OCCodeInsightUtil.MemberBeginEndSearchResult.OK) continue;
            results.add(var);
        }
        return results;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithMethods(@NotNull ExpressionContext context, @NotNull List<String> requiredMethods) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type = var.getResolvedType(OCResolveContext.forPsi(place));
            if (type.isUnresolved(place) || type.isUnknown()) continue;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            if (!(type instanceof OCStructType)) continue;
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file = expr.getContainingOCFile();
            OCStructType structType = (OCStructType)type;
            boolean shouldAdd = true;
            for (String method : requiredMethods) {
                if (OCTemplatesUtil.hasMemberFunction(structType, file, method)) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            results.add(var);
        }
        return results;
    }

    private static boolean hasMemberFunction(@NotNull OCStructType type, @NotNull OCFile file, @NotNull String name) {
        OCResolveContext context = OCResolveContext.forPsi(file);
        return !type.collectMethods(name, context).isEmpty();
    }

    @NotNull
    public static List<String> getStringsList(Expression @NotNull [] params, ExpressionContext context) {
        ArrayList<String> namesList = new ArrayList<String>();
        for (Expression param : params) {
            Result result = param.calculateResult(context);
            if (result == null) continue;
            namesList.add(result.toString());
        }
        return namesList;
    }
}

