/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCSymbolsToLookupConverter
implements Processor<OCSymbol> {
    private final OCSymbolGroupContext myContext;
    private final ConverterState myState;
    private final HashMap<String, Pair<OCSymbol, SystemHeader>> myResultSymbols;
    private final CompletionResultSet myResult;
    private final boolean myAllowAutocomplete;
    private final PsiElement myContextExpression;
    private final Condition<OCSymbol> myCondition;
    private final ArrayList<OCStructSymbol> myAccumulatedStructSymbols;
    private final VirtualFile myContextFile;
    private final boolean myInCpp;
    private final Project myProject;
    private final HashSet<String> myExistingNames;
    private boolean myEmpty = true;
    private Set<String> myIgnoredNames;

    private static String getSymbolSignature(OCSymbol symbol, Project project) {
        return symbol instanceof OCStructSymbol ? symbol.getName() : symbol.getSignature(project);
    }

    public static OCSymbolsToLookupConverter createLookupConverter(OCSymbolGroupContext ctx, ConverterState state, CompletionResultSet result, boolean autocomplete, PsiElement element, Condition<OCSymbol> condition, Project project) {
        return OCSymbolsToLookupConverter.createLookupConverter(ctx, state, result, autocomplete, element, condition, project, null, false);
    }

    public static OCSymbolsToLookupConverter createLookupConverter(OCSymbolGroupContext ctx, ConverterState state, CompletionResultSet result, boolean autocomplete, PsiElement element, Condition<OCSymbol> condition, Project project, Set<String> ignoredNames, boolean excludeSameNames) {
        return new OCSymbolsToLookupConverter(ctx, state, result, autocomplete, element, condition, project, ignoredNames, excludeSameNames);
    }

    public OCSymbolsToLookupConverter(OCSymbolGroupContext ctx, ConverterState state, CompletionResultSet result, boolean allowAutocomplete, PsiElement contextExpression, Condition<OCSymbol> condition, Project project) {
        this(ctx, state, result, allowAutocomplete, contextExpression, condition, project, null, false);
    }

    public OCSymbolsToLookupConverter(OCSymbolGroupContext ctx, ConverterState state, CompletionResultSet result, boolean allowAutocomplete, PsiElement contextExpression, Condition<OCSymbol> condition, Project project, Set<String> ignoredNames, boolean excludeSameNames) {
        OCFile ocFile;
        this.myContext = ctx;
        this.myState = state;
        this.myResult = result;
        this.myResultSymbols = new HashMap();
        this.myAllowAutocomplete = allowAutocomplete;
        this.myContextExpression = contextExpression;
        this.myCondition = condition;
        this.myProject = project;
        this.myIgnoredNames = ignoredNames;
        this.myAccumulatedStructSymbols = new ArrayList();
        this.myInCpp = !OCCodeInsightUtil.isInPlainOldC(contextExpression);
        HashSet hashSet = this.myExistingNames = excludeSameNames ? new HashSet() : null;
        this.myContextFile = this.myContextExpression instanceof OCElement ? ((ocFile = ((OCElement)this.myContextExpression).getContainingOCFile()) != null ? ocFile.getOriginalFile().getVirtualFile() : null) : null;
    }

    public boolean process(OCSymbol symbol) {
        if (this.myIgnoredNames != null && this.myIgnoredNames.contains(symbol.getName())) {
            return true;
        }
        if (this.myExistingNames != null) {
            if (this.myExistingNames.contains(symbol.getName())) {
                return true;
            }
            this.myExistingNames.add(symbol.getName());
        }
        if (!(symbol instanceof OCStructSymbol)) {
            return this.doProcess(symbol, true);
        }
        this.myAccumulatedStructSymbols.add((OCStructSymbol)symbol);
        return true;
    }

    private void addSymbolToResult(OCSymbol symbol) {
        Object lookup = this.myAllowAutocomplete ? this.createLookup(symbol) : this.createLookup(symbol).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        this.myResult.addElement((LookupElement)lookup);
    }

    private void addAllToResult() {
        for (Pair<OCSymbol, SystemHeader> symbol : this.myResultSymbols.values()) {
            this.addSymbolToResult((OCSymbol)symbol.first);
        }
    }

    public boolean finish() {
        for (OCSymbol oCSymbol : this.myAccumulatedStructSymbols) {
            if (this.doProcess(oCSymbol, false)) continue;
            this.addAllToResult();
            return false;
        }
        this.addAllToResult();
        return true;
    }

    private static boolean isNotFromUserHeader(@NotNull OCSymbol symbol, @NotNull VirtualFile contextFile, @NotNull Project project) {
        VirtualFile currentFile = symbol.getContainingFile();
        if (currentFile == null) {
            return false;
        }
        OCAutoImportHelper.ImportSpecification currentFileNameToImport = OCImportSymbolFix.getFileNameToImport(currentFile, contextFile, project);
        return currentFileNameToImport != null && currentFileNameToImport.getKind().isSystemHeaderSearchPath();
    }

    public boolean doProcess(OCSymbol symbol, boolean addToResultSet) {
        if (symbol instanceof OCMethodSymbol) {
            return true;
        }
        if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null) {
            return true;
        }
        if (symbol instanceof OCUsingSymbol) {
            return true;
        }
        if (!OCSymbol.NON_FANTOM_SYMBOL_CONDITION.value((Object)symbol)) {
            return true;
        }
        String name = symbol.getName();
        int spaceIdx = name.lastIndexOf(32);
        if (spaceIdx >= 0) {
            name = name.substring(spaceIdx + 1);
        }
        if (!this.myResult.getPrefixMatcher().prefixMatches(name)) {
            return true;
        }
        if (this.myContext != null && !this.myContext.isSuitableSymbol(symbol)) {
            if (this.myInCpp && (this.myContext.isSuitableSymbolKind(OCSymbolKind.GLOBAL_VARIABLE) || this.myContext.isSuitableSymbolKind(OCSymbolKind.FUNCTION_DECLARATION))) {
                if (!(symbol instanceof OCStructSymbol) && symbol.getKind() != OCSymbolKind.TYPEDEF && symbol.getKind() != OCSymbolKind.TEMPLATE_TYPE_PARAMETER) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.myCondition != null && !this.myCondition.value((Object)symbol)) {
            return true;
        }
        if (symbol.isUnavailable() || symbol.isForbiddenByARC(this.myContextExpression)) {
            return true;
        }
        VirtualFile containingFile = symbol.getContainingFile();
        if (Comparing.equal((Object)containingFile, (Object)this.myContextFile) && this.myContextExpression.getParent().getTextOffset() == symbol.getOffset()) {
            return true;
        }
        if (this.myState.registerSymbol(symbol, this.myProject)) {
            if (addToResultSet) {
                this.addSymbolToResult(symbol);
            } else {
                this.myResultSymbols.put(OCSymbolsToLookupConverter.getSymbolSignature(symbol, this.myProject), (Pair<OCSymbol, SystemHeader>)new Pair((Object)symbol, (Object)SystemHeader.Unknown));
            }
            this.myEmpty = false;
        } else if (!addToResultSet && this.myContextFile != null && OCSymbolsToLookupConverter.isNotFromUserHeader(symbol, this.myContextFile, this.myProject)) {
            String signature2 = OCSymbolsToLookupConverter.getSymbolSignature(symbol, this.myProject);
            Pair existingSymbol = this.myResultSymbols.get(signature2);
            if (existingSymbol == null) {
                this.myResultSymbols.put(signature2, (Pair<OCSymbol, SystemHeader>)new Pair((Object)symbol, (Object)SystemHeader.Yes));
                return true;
            }
            if (existingSymbol.second == SystemHeader.Unknown) {
                existingSymbol = new Pair((Object)((OCSymbol)existingSymbol.first), (Object)(OCSymbolsToLookupConverter.isNotFromUserHeader((OCSymbol)existingSymbol.first, this.myContextFile, this.myProject) ? SystemHeader.Yes : SystemHeader.No));
                if (existingSymbol.second == SystemHeader.Yes) {
                    this.myResultSymbols.put(signature2, (Pair<OCSymbol, SystemHeader>)existingSymbol);
                    return true;
                }
            }
            if (existingSymbol.second == SystemHeader.No) {
                this.myResultSymbols.put(signature2, (Pair<OCSymbol, SystemHeader>)new Pair((Object)symbol, (Object)SystemHeader.Yes));
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    public LookupElementBuilder createLookup(OCSymbol symbol) {
        return SymbolLookupBuilderUtil.lookup(symbol, this.myContextExpression, this.myContext, this.myProject);
    }

    public static class ConverterState {
        private final Set<String> myNames;
        private final Map<String, OCFunctionSymbol> myFunctionNamesToSymbol;
        private final MultiMap<String, String> myFunctionNamesToType = MultiMap.createSet();

        public ConverterState() {
            this.myFunctionNamesToSymbol = new HashMap<String, OCFunctionSymbol>();
            this.myNames = new HashSet<String>();
        }

        boolean registerSymbol(OCSymbol symbol, Project project) {
            String name = symbol.getName();
            if (symbol instanceof OCFunctionSymbol) {
                if (this.myFunctionNamesToSymbol.containsKey(name)) {
                    if (!this.myFunctionNamesToType.containsKey((Object)name)) {
                        this.myFunctionNamesToType.putValue((Object)name, (Object)ConverterState.getTypeSignature(this.myFunctionNamesToSymbol.get(name), project));
                    }
                    Collection types = this.myFunctionNamesToType.get((Object)name);
                    return types.add(ConverterState.getTypeSignature(symbol, project));
                }
                this.myFunctionNamesToSymbol.put(name, (OCFunctionSymbol)symbol);
                return true;
            }
            return this.myNames.add(OCSymbolsToLookupConverter.getSymbolSignature(symbol, project));
        }

        private static String getTypeSignature(OCSymbol symbol, Project project) {
            OCResolveContext context = OCResolveContext.forSymbol(symbol, project);
            return symbol.getResolvedType(context).getCanonicalName(context);
        }
    }

    private static enum SystemHeader {
        Unknown,
        Yes,
        No;

    }
}

