/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCSymbolsToLookupConverter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewExpressionCompletionContributor
extends OCCompletionContributorBase {
    public static final PsiElementPattern.Capture<PsiElement> TYPE_IN_NEW_EXPRESSION = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).with((PatternCondition)new PatternCondition<PsiElement>("TYPE_IN_NEW_EXPRESSION"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof OCReferenceElement)) {
                return false;
            }
            PsiElement superParent = parent.getParent();
            if (!(superParent instanceof OCTypeElement)) {
                return false;
            }
            return superParent.getParent() instanceof OCCppNewExpression;
        }
    });

    public OCNewExpressionCompletionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)TYPE_IN_NEW_EXPRESSION, new InnerCompletionProvider());
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)TYPE_IN_NEW_EXPRESSION, new InnerCompletionProvider());
    }

    private static class InnerCompletionProvider
    extends OCCompletionProvider {
        private InnerCompletionProvider() {
        }

        @Override
        protected void addCompletions(String prefix, @NotNull OCCompletionParameters ps, ProcessingContext c, CompletionResultSet r) {
            PsiElement element = ps.getPosition().getParent();
            int invocationCount = ps.getInvocationCount();
            OCFile file = (OCFile)element.getContainingFile().getOriginalFile();
            OCSymbolsToLookupConverter.ConverterState names = new OCSymbolsToLookupConverter.ConverterState();
            Condition<OCSymbol> condition = InnerCompletionProvider.getInitialCondition(ps, file);
            OCSymbolGroupContext context = InnerCompletionProvider.getSymbolGroupContext();
            OCQualifiedName name = OCSymbolReferenceResolver.getQualifiedName((OCNamespaceQualifierOwner)element).changeName(null);
            OCSymbolReference.LocalReference qualifierRef = OCSymbolReference.getLocalReference(name, element);
            OCSymbolsToLookupConverter processor2 = new OCSymbolsToLookupConverter(context, names, r, true, element, condition, file.getProject());
            qualifierRef.processPossibleSymbols(processor2, OCResolveContext.forPsi(file));
            processor2.finish();
            if (invocationCount == 1) {
                String advertisement = OCBundle.message("completion.press.keyboard.shortcut.for.non.imported.symbols", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion"));
                r.addLookupAdvertisement(advertisement);
            } else if (processor2.isEmpty() && invocationCount >= 2) {
                OCResolveContext resolveContext = OCResolveContext.forPsi(file);
                resolveContext.setProcessNonImported(true);
                Condition inHeader = Conditions.and(condition, symbol -> {
                    OCFile f = symbol.getContainingOCFile(file.getProject());
                    return f != null && f.isHeader();
                });
                OCSymbolsToLookupConverter converter = new OCSymbolsToLookupConverter(context, names, r, false, element, (Condition<OCSymbol>)inHeader, file.getProject());
                ContainerUtil.process(resolveContext.resolveToSymbols(qualifierRef), (Processor)converter);
                converter.finish();
            }
        }

        private static Condition<OCSymbol> getInitialCondition(@NotNull OCCompletionParameters ps, @Nullable OCFile file) {
            OCResolveContext context;
            OCCppNewExpression newExpression;
            OCType expectedType;
            Condition baseCondition = Conditions.alwaysTrue();
            if (ps.getCompletionType() == CompletionType.SMART && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)(newExpression = (OCCppNewExpression)PsiTreeUtil.getContextOfType((PsiElement)ps.getPosition(), (Class[])new Class[]{OCCppNewExpression.class})), context = OCResolveContext.forPsi((PsiElement)ps.getOriginalFile())).resolve(context)) instanceof OCPointerType) {
                Condition typeCondition;
                OCType constructor = ((OCPointerType)expectedType).getRefType();
                if (constructor instanceof OCCppReferenceType) {
                    constructor = ((OCCppReferenceType)constructor).getRefType();
                }
                if (constructor instanceof OCStructType) {
                    OCSmartCompletionContributor.TypeMatchingCondition<OCSymbol> type = new OCSmartCompletionContributor.TypeMatchingCondition<OCSymbol>(ps.getPosition().getParent(), (OCType)OCPointerType.to(constructor)){

                        @Override
                        @Nullable
                        protected OCType getSymbolType(OCSymbol symbol) {
                            OCType type = super.getSymbolType(symbol);
                            return type != null ? OCPointerType.to(type) : null;
                        }
                    };
                    type.acceptTypeDeclarations(true);
                    typeCondition = type;
                } else {
                    typeCondition = symbol -> !(symbol instanceof OCFunctionSymbol);
                }
                return Conditions.and((Condition)baseCondition, (Condition)typeCondition);
            }
            return baseCondition;
        }

        private static OCSymbolGroupContext getSymbolGroupContext() {
            OCSymbolGroupContext context = new OCSymbolGroupContext("constructor", new OCSymbolKind[0]);
            context.addSymbolContexts(OCSymbolGroupContext.CONSTRUCTOR_CONTEXT.getSymbolContexts());
            context.addSymbolContext(OCSymbolKind.NAMESPACE);
            context.addSymbolContext(OCSymbolKind.NAMESPACE_ALIAS);
            context.addSymbolContext(OCSymbolKind.MACRO);
            return context;
        }
    }
}

