/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.colors;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCFileHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    private final CidrLexerSettings mySettings;

    public OCFileHighlighter(CidrLexerSettings settings) {
        this.mySettings = settings;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        return OCFileHighlighter.pack((TextAttributesKey)keys1.get(tokenType));
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new OCHighlightingLexer(this.mySettings);
    }

    static {
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OCTokenTypes.KEYWORDS, (TextAttributesKey)OCHighlightingKeys.OC_KEYWORD);
        OCFileHighlighter.fillMap(keys1, (TokenSet)OCTokenTypes.DIRECTIVES, (TextAttributesKey)OCHighlightingKeys.OC_DIRECTIVE);
        keys1.put((IElementType)OCTokenTypes.HEADER_PATH_LITERAL, OCHighlightingKeys.OC_HEADER_PATH);
        OCFileHighlighter.fillMap(keys1, (TextAttributesKey)OCHighlightingKeys.OC_OPERATION_SIGN, (IElementType[])IElementType.enumerate(type -> type instanceof OCPunctuatorElementType));
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, OCHighlightingKeys.OC_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, OCHighlightingKeys.OC_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, OCHighlightingKeys.OC_INVALID_STRING_ESCAPE);
        keys1.put((IElementType)OCTokenTypes.INTEGER_LITERAL, OCHighlightingKeys.OC_NUMBER);
        keys1.put((IElementType)OCTokenTypes.FLOAT_LITERAL, OCHighlightingKeys.OC_NUMBER);
        keys1.put((IElementType)OCTokenTypes.VERSION_LITERAL, OCHighlightingKeys.OC_NUMBER);
        keys1.put((IElementType)OCTokenTypes.STRING_LITERAL, OCHighlightingKeys.OC_STRING);
        keys1.put((IElementType)OCTokenTypes.AT, OCHighlightingKeys.OC_KEYWORD);
        keys1.put((IElementType)OCTokenTypes.CHARACTER_LITERAL, OCHighlightingKeys.OC_STRING);
        keys1.put((IElementType)OCTokenTypes.LPAR, OCHighlightingKeys.OC_PARENTHS);
        keys1.put((IElementType)OCTokenTypes.RPAR, OCHighlightingKeys.OC_PARENTHS);
        keys1.put((IElementType)OCTokenTypes.LBRACE, OCHighlightingKeys.OC_BRACES);
        keys1.put((IElementType)OCTokenTypes.RBRACE, OCHighlightingKeys.OC_BRACES);
        keys1.put((IElementType)OCTokenTypes.LBRACKET, OCHighlightingKeys.OC_BRACKETS);
        keys1.put((IElementType)OCTokenTypes.RBRACKET, OCHighlightingKeys.OC_BRACKETS);
        keys1.put((IElementType)OCTokenTypes.COMMA, OCHighlightingKeys.OC_COMMA);
        keys1.put((IElementType)OCTokenTypes.DOT, OCHighlightingKeys.OC_DOT);
        keys1.put((IElementType)OCTokenTypes.SEMICOLON, OCHighlightingKeys.OC_SEMICOLON);
        keys1.put((IElementType)OCTokenTypes.BLOCK_COMMENT, OCHighlightingKeys.OC_BLOCK_COMMENT);
        keys1.put((IElementType)OCTokenTypes.EOL_COMMENT, OCHighlightingKeys.OC_LINE_COMMENT);
        keys1.put(TokenType.BAD_CHARACTER, OCHighlightingKeys.OC_BAD_CHARACTER);
        keys1.put((IElementType)OCElementTypes.MACRO_REF, OCHighlightingKeys.MACRONAME);
        keys1.put((IElementType)OCElementTypes.MACRO_PARAMETER, OCHighlightingKeys.MACRO_PARAMETER);
    }
}

