/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @NonNls
    private static final String ourLineEndWhilePasteInString = "\\n\"\n \"";

    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!this.isSupportedFile(file)) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        boolean isLiteral = true;
        for (int i = 0; i < startOffsets.length && isLiteral; ++i) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(document.getCharsSequence(), startOffsets[i], endOffsets[i]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!this.isSupportedFile(file)) {
            return text;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(editor.getDocument().getCharsSequence(), selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i == lines.length - 1) continue;
                buffer.append(ourLineEndWhilePasteInString);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            return OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
        }
        return text;
    }

    protected boolean isSupportedFile(PsiFile file) {
        return file instanceof OCPsiFile;
    }

    @Nullable
    private static IElementType findLiteralTokenType(@NotNull CharSequence documentText, int selectionStart, int selectionEnd) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.maxLanguage()).build());
        lexer.start(documentText);
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if ((tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.CHARACTER_LITERAL) && lexer.getTokenStart() < selectionStart && selectionEnd < lexer.getTokenEnd()) {
                return tokenType;
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        return buffer.toString();
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        return false;
    }
}

