/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.editor.OCTypingActionsExtension;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.HashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCLineIndentProvider
extends JavaLikeLangLineIndentProvider
implements JoinedLinesSpacingCalculator {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap();
    private static final SemanticEditorPosition.Rule LINE_STARTER;
    private static boolean ourCanUseFormatterForIndent;
    private static final SemanticEditorPosition.SyntaxElement[] LEFTS;
    private static final SemanticEditorPosition.SyntaxElement[] RIGHTS;
    private static final IndentCalculator.BaseLineOffsetCalculator STRONG_LINE_BEFORE;

    public static void skipWhiteSpacesInLine(@NotNull HighlighterIterator it, @NotNull CharSequence sequence, boolean forward) {
        while (!it.atEnd() && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType()) && !OCLineIndentProvider.hasNewLine(sequence, it)) {
            if (forward) {
                it.advance();
                continue;
            }
            it.retreat();
        }
    }

    static boolean hasNewLine(@NotNull CharSequence sequence, @NotNull HighlighterIterator it) {
        return OCLineIndentProvider.containsNewLine(sequence, it.getStart(), it.getEnd());
    }

    @Contract(pure=true)
    static boolean containsNewLine(@NotNull CharSequence text, int start, int end) {
        return start < end && StringUtil.contains((CharSequence)text, (int)start, (int)end, (char)'\n');
    }

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        return OCLineIndentProvider.getSyntaxElement(tokenType);
    }

    @Nullable
    public static SemanticEditorPosition.SyntaxElement getSyntaxElement(@Nullable IElementType tokenType) {
        return SYNTAX_MAP.get(tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        return OCLanguageUtils.isSupported(language);
    }

    @Nullable
    protected Indent getIndentInBlock(@NotNull Project project, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        CommonCodeStyleSettings commonCodeStyleSettings;
        SemanticEditorPosition beforeStart = blockStartPosition.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        if (beforeStart.isAtEnd()) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.NORMAL);
        }
        Editor editor = blockStartPosition.getEditor();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        boolean validSource = file != null && OCLanguageUtils.isSupported(language);
        OCCodeStyleSettings codeStyleSettings = validSource ? (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class) : null;
        CommonCodeStyleSettings commonCodeStyleSettings2 = commonCodeStyleSettings = validSource ? CodeStyle.getLanguageSettings((PsiFile)file) : null;
        if (validSource && (beforeStart.isAt((IElementType)OCTokenTypes.RBRACKET) || beforeStart.isAt((IElementType)OCTokenTypes.LPAR) || beforeStart.isAt((IElementType)OCTokenTypes.XOR))) {
            return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_INSIDE_CODE_BLOCK);
        }
        if (beforeStart.isAt((IElementType)OCTokenTypes.EQ) || beforeStart.isAt((IElementType)OCTokenTypes.AT)) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.CONTINUATION);
        }
        if (validSource) {
            OCTypedHandlerDelegate.ContextType blockType = OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(beforeStart));
            switch (blockType) {
                case Namespace: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_NAMESPACE_MEMBERS);
                }
                case ClassCPP: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_CLASS_MEMBERS);
                }
                case StructLike: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_C_STRUCT_MEMBERS);
                }
                case SwitchStatement: {
                    return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonCodeStyleSettings.INDENT_CASE_FROM_SWITCH ? Indent.Type.NORMAL : Indent.Type.NONE));
                }
            }
        }
        return super.getIndentInBlock(project, language, blockStartPosition);
    }

    protected boolean dropIndentAfterReturnLike(@NotNull SemanticEditorPosition statementBeforeSemicolon) {
        return statementBeforeSemicolon.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.ReturnLike);
    }

    protected boolean isColonAfterLabelOrCase(@NotNull SemanticEditorPosition position) {
        return OCLineIndentProvider.isSwitchContext(OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(position));
    }

    @Contract(pure=true)
    private static boolean isSwitchContext(@NotNull Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context) {
        SemanticEditorPosition editorPosition = (SemanticEditorPosition)context.first;
        if (editorPosition == null) {
            return false;
        }
        SemanticEditorPosition.SyntaxElement element = editorPosition.getCurrElement();
        return element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault || element == OCSElement.Identifier && context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement;
    }

    @NotNull
    public static Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> getColonAfterLabelCaseDefaultPublicContext(@NotNull SemanticEditorPosition finPos) {
        if (!finPos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
            return Pair.create(null, null);
        }
        SemanticEditorPosition maybeCaseDefaultPublic = finPos.copy();
        SemanticEditorPosition.SyntaxElement element = maybeCaseDefaultPublic.elementAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault, OCSElement.PublicLike});
        if (element != null) {
            return Pair.create((Object)maybeCaseDefaultPublic, null);
        }
        SemanticEditorPosition maybeLabelId = finPos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
        if (maybeLabelId.getCurrElement() == OCSElement.Identifier && maybeLabelId.before().isAtMultiline(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            SemanticEditorPosition pos = maybeLabelId.copy();
            pos.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            if (!pos.isAtEnd()) {
                return Pair.create((Object)maybeLabelId, (Object)((Object)OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(pos))));
            }
        }
        return Pair.create(null, null);
    }

    @NotNull
    private static HighlighterIterator createEditorIteratorAtPosition(@NotNull SemanticEditorPosition pos) {
        return pos.getEditor().getHighlighter().createIterator(pos.getStartOffset());
    }

    @Nullable
    private static OCLanguageKind getLanguageKind(@NotNull SemanticEditorPosition pos) {
        PsiFile file;
        Editor editor = pos.getEditor();
        if (editor.getProject() != null && editor instanceof EditorEx && ((EditorEx)editor).getVirtualFile() != null && OCLanguageUtils.isSupported(file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument()))) {
            return OCLanguageKindCalculator.calculateLanguageKindFast(((EditorEx)editor).getVirtualFile(), editor.getProject());
        }
        return null;
    }

    protected boolean isInsideForLikeConstruction(@NotNull SemanticEditorPosition finPos) {
        return finPos.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
    }

    @NotNull
    protected SkipDirectivesHighlighterIterator getIteratorAtPosition(@NotNull Editor editor, int offset) {
        return new SkipDirectivesHighlighterIterator(editor, offset);
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        return !position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) || !(!ignoreLabels ? position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{OCSElement.PublicLike, OCSElement.Identifier}) : position.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike));
    }

    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        if (offset > 0) {
            String indent;
            Document document = editor.getDocument();
            int lineStart = DocumentUtil.getLineStartOffset((int)offset, (Document)document);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile source = psiDocumentManager.getPsiFile(document);
            if (source != null && ExternalFormatProcessor.useExternalFormatter((PsiFile)source) && OCTypingActionsExtension.INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)editor.getDocument()) != Boolean.TRUE && (indent = ExternalFormatProcessor.indentLine((PsiFile)source, (int)lineStart)) != null) {
                return indent;
            }
            CharSequence docText = document.getImmutableCharSequence();
            int endIndent = CharArrayUtil.shiftForward((CharSequence)docText, (int)lineStart, (String)" \t");
            if (endIndent < docText.length() && docText.charAt(endIndent) == '#') {
                return null;
            }
            return super.getLineIndent(project, editor, language, offset);
        }
        return "";
    }

    private static boolean isAlignFuncParamsOrArgs(@NotNull OCCodeStyleSettings customSettings, @NotNull SemanticEditorPosition maybeLeft) {
        SemanticEditorPosition beforeLP;
        if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) && (beforeLP = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})).isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Identifier, OCSElement.Gt})) {
            SemanticEditorPosition maybeRight = maybeLeft.copy().after();
            OCLineIndentProvider.moveToRightInBlockParenthesisForwardsSkippingNestedWithPredicate(maybeRight, self -> self.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis));
            if (maybeRight.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                SemanticEditorPosition afterRight = maybeRight.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
                if (afterRight.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    return customSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
                }
                OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(beforeLP, self -> self.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}));
                if (beforeLP.isAtEnd() || beforeLP.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon})) {
                    int offset;
                    OCCodeFragment fragment;
                    PsiElement elemBeforeLPar;
                    CharSequence docText = beforeLP.getEditor().getDocument().getCharsSequence();
                    int offsetBase = beforeLP.isAtEnd() ? 0 : beforeLP.getStartOffset() + 1;
                    String maybeFuncDeclText = docText.subSequence(offsetBase, maybeRight.getStartOffset() + 1).toString();
                    if (beforeLP.getEditor().getProject() != null && (elemBeforeLPar = (fragment = OCElementFactory.codeFragment(maybeFuncDeclText, beforeLP.getEditor().getProject(), null, false, false)).findElementAt(offset = maybeLeft.getStartOffset() - offsetBase)) != null && PsiTreeUtil.getParentOfType((PsiElement)elemBeforeLPar, OCFunctionDeclaration.class) != null) {
                        return customSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
                    }
                }
            }
            return customSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE;
        }
        return false;
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        SemanticEditorPosition maybeLineStarter;
        IndentCalculator indent;
        SemanticEditorPosition pos = this.getPosition(editor, offset);
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Editor)editor);
        OCCodeStyleSettings customSettings = (OCCodeStyleSettings)styleSettings.getCustomSettings(OCCodeStyleSettings.class);
        Document document = editor.getDocument();
        boolean inNewLineSpace = pos.matchesRule(LINE_STARTER);
        SemanticEditorPosition firstTokenAtNewLine = pos.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        if (inNewLineSpace) {
            SemanticEditorPosition secondToken = firstTokenAtNewLine.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if ((firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) && secondToken.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike) || firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike) && secondToken.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) && document.getLineNumber(offset + 1) == document.getLineNumber(firstTokenAtNewLine.getStartOffset())) {
                return this.createInBlockSpaceIndentCalculator(project, editor, customSettings.INDENT_VISIBILITY_KEYWORDS);
            }
        }
        if ((indent = super.getIndent(project, editor, language, offset)) != null) {
            return indent;
        }
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory myFactory = new JavaLikeLangLineIndentProvider.IndentCalculatorFactory(project, editor);
        CommonCodeStyleSettings commonSettings = styleSettings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions options = commonSettings.getIndentOptions();
        if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment) && offset == pos.findStartOf((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
            return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment));
        }
        if (inNewLineSpace) {
            SemanticEditorPosition lastTokenInLine = OCLineIndentProvider.getLastAnchorTokenInPrevLine(pos.before());
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
                return myFactory.createIndentCalculator(Indent.Type.NONE, position -> lastTokenInLine.getStartOffset());
            }
            if (lastTokenInLine.isAtEnd() || lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment)) {
                if (lastTokenInLine.isAtEnd() && this.getIteratorAtPosition(editor, offset).isInDirective()) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_AFTER);
                }
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace})) {
                return this.getIndent(project, editor, language, this.getBlockStatementStartOffset(lastTokenInLine));
            }
            if (lastTokenInLine.isAt((IElementType)OCTokenTypes.STRING_LITERAL) && pos.after().afterOptional((SemanticEditorPosition.SyntaxElement)OCSElement.At).isAt((IElementType)OCTokenTypes.STRING_LITERAL)) {
                return this.getAlignWithPrevLiteralIndent(project, editor, document, lastTokenInLine);
            }
            Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(lastTokenInLine);
            if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                    return this.createInBlockSpaceIndentCalculator(project, editor, customSettings.INDENT_CLASS_MEMBERS);
                }
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.Identifier && options != null) {
                    SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore((SemanticEditorPosition)context.first);
                    if (element != null) {
                        return myFactory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                    }
                    return this.createInBlockSpaceIndentCalculator(project, editor, options.INDENT_SIZE + (context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement && commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0));
                }
            }
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                return myFactory.createIndentCalculator(this.getIndentInBlock(project, language, lastTokenInLine.before()), x$0 -> this.getDeepBlockStatementStartOffset(x$0));
            }
            if (lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.StructLike}) && !lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Typedef})) {
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            SemanticEditorPosition testEqAnchor = lastTokenInLine;
            SemanticEditorPosition maybeLeft = lastTokenInLine.copy();
            maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, self -> self.isAtMultiline());
            if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket)) {
                testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
            } else {
                maybeLeft = lastTokenInLine.copy();
                maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, self -> self.isAtMultiline());
                if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
                }
            }
            if (OCLineIndentProvider.isEqLikeOnLineBefore(testEqAnchor)) {
                IndentCalculator it;
                if (OCLineIndentProvider.isAlignCollectionStarter(commonSettings, maybeLeft) && (it = this.getAlignIndentCalculator(project, editor, document, maybeLeft)) != null) {
                    return it;
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (OCLineIndentProvider.isTemplateLikeOnLineBefore(lastTokenInLine)) {
                SemanticEditorPosition after2 = lastTokenInLine.after().afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
                if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                if (lastTokenInLine.isAt((IElementType)OCTokenTypes.GT) || lastTokenInLine.isAt((IElementType)OCTokenTypes.GTGT)) {
                    if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    if (OCLineIndentProvider.isLikeFunctionDecl(after2)) {
                        return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT && customSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma) || firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
                maybeLeft = OCLineIndentProvider.findLeftBracketInLine(lastTokenInLine);
                if (maybeLeft.isAtAnyOf(LEFTS)) {
                    IndentCalculator it;
                    if ((OCLineIndentProvider.isAlignCollectionStarter(commonSettings, maybeLeft) || OCLineIndentProvider.isAlignFuncParamsOrArgs(customSettings, maybeLeft)) && (it = this.getAlignIndentCalculator(project, editor, document, maybeLeft)) != null) {
                        return it;
                    }
                    return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
        }
        if ((maybeLineStarter = OCLineIndentProvider.getLineStarterBeforeFirstStringOnLine(pos)) != null) {
            return this.getAlignWithPrevLiteralIndent(project, editor, document, maybeLineStarter.before());
        }
        Pair<Boolean, Boolean> needSpecialIndentAndInsideVAR = OCLineIndentProvider.getNeedSpecialIndentAndInsideIVAR(pos);
        if (((Boolean)needSpecialIndentAndInsideVAR.first).booleanValue()) {
            int indentSize = (Boolean)needSpecialIndentAndInsideVAR.second != false && customSettings.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK ? customSettings.INDENT_VISIBILITY_KEYWORDS : customSettings.INDENT_VISIBILITY_KEYWORDS + customSettings.INDENT_INTERFACE_MEMBERS;
            return this.createInBlockSpaceIndentCalculator(project, editor, indentSize);
        }
        Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(pos.copy());
        if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
            if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                return this.createInBlockSpaceIndentCalculator(project, editor, customSettings.INDENT_VISIBILITY_KEYWORDS);
            }
            if (options != null) {
                SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore(((SemanticEditorPosition)context.first).before());
                if (element != null) {
                    return new IndentCalculator(project, editor, STRONG_LINE_BEFORE, OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonSettings.INDENT_CASE_FROM_SWITCH && element == OCSElement.Switch ? Indent.Type.NORMAL : Indent.Type.NONE)));
                }
                if (OCLineIndentProvider.isSwitchContext(context)) {
                    return this.createInBlockSpaceIndentCalculator(project, editor, commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0);
                }
                return options.LABEL_INDENT_ABSOLUTE ? this.createAbsoluteSpaceIndentCalculator(project, editor, options.LABEL_INDENT_SIZE) : this.createInBlockSpaceIndentCalculator(project, editor, options.INDENT_SIZE + options.LABEL_INDENT_SIZE);
            }
        }
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(pos)) ? null : myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
    }

    @NotNull
    public static Pair<Boolean, Boolean> getNeedSpecialIndentAndInsideIVAR(@NotNull SemanticEditorPosition pos) {
        if (pos.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) && pos.before().matchesRule(LINE_STARTER)) {
            SemanticEditorPosition after2 = pos.after();
            SemanticEditorPosition afterWhitespace = after2.afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            boolean isInsideIVAR = pos.beforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace).isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Interface});
            if (afterWhitespace.getCurrElement() == OCSElement.PublicLike || isInsideIVAR && (afterWhitespace.isAtEnd() || after2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && after2.isAtMultiline())) {
                return Pair.create((Object)true, (Object)isInsideIVAR);
            }
        }
        return Pair.create((Object)false, (Object)false);
    }

    private static boolean isAlignCollectionStarter(@NotNull CommonCodeStyleSettings commonSettings, @NotNull SemanticEditorPosition maybeLeft) {
        return maybeLeft.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket}) && commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION;
    }

    @Nullable
    private IndentCalculator getAlignIndentCalculator(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull SemanticEditorPosition anyLeftBracket) {
        HighlighterIterator it = OCLineIndentProvider.createEditorIteratorAtPosition(anyLeftBracket.after());
        OCLineIndentProvider.skipWhiteSpacesInLine(it, anyLeftBracket.getChars(), true);
        if (!it.atEnd() && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType())) {
            return this.createAbsoluteSpaceIndentCalculator(project, editor, OCLineIndentProvider.getOffsetInLine(project, document, it.getStart()));
        }
        return null;
    }

    @NotNull
    private static SemanticEditorPosition findLeftBracketInLine(@NotNull SemanticEditorPosition inSeqPos) {
        SemanticEditorPosition copy2 = inSeqPos.copy();
        OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(copy2, self -> self.isAtAnyOf(LEFTS) || self.isAtMultiline());
        return copy2;
    }

    @NotNull
    private static SemanticEditorPosition getLastAnchorTokenInPrevLine(@NotNull SemanticEditorPosition positionBeforeNewLine) {
        while (!positionBeforeNewLine.isAtEnd() && !positionBeforeNewLine.isAtMultiline() && positionBeforeNewLine.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            positionBeforeNewLine.moveBefore();
        }
        return positionBeforeNewLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) ? positionBeforeNewLine.after() : positionBeforeNewLine;
    }

    protected int getBlockStatementStartOffset(@NotNull SemanticEditorPosition originalPos) {
        if (originalPos.isAtEnd()) {
            return 0;
        }
        SemanticEditorPosition position = originalPos.copy();
        if (originalPos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
            position.moveAfter();
        }
        int originalStatementOffset = super.getBlockStatementStartOffset(position);
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Editor)position.getEditor());
        CommonCodeStyleSettings commonSettings = styleSettings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings customSettings = (OCCodeStyleSettings)styleSettings.getCustomSettings(OCCodeStyleSettings.class);
        SemanticEditorPosition originalBlockAnchor = this.getPosition(position.getEditor(), originalStatementOffset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        if (originalBlockAnchor.isAtEnd() || originalBlockAnchor.before().isAtEnd() || originalPos.getStartOffset() == originalBlockAnchor.getStartOffset()) {
            return originalStatementOffset;
        }
        if (originalBlockAnchor.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
            SemanticEditorPosition ipos = originalPos.copy();
            ipos.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, pos -> pos.getStartOffset() <= originalBlockAnchor.getStartOffset());
            SemanticEditorPosition kpos = ipos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) ? ipos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}) : originalPos.copy();
            SemanticEditorPosition spos = kpos.copy();
            kpos.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, pos -> pos.getStartOffset() <= originalBlockAnchor.getStartOffset() || pos.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis));
            if (kpos.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                while (!kpos.isAtEnd() && kpos.getStartOffset() > originalBlockAnchor.getStartOffset()) {
                    if (kpos.before().matchesRule(LINE_STARTER)) {
                        return kpos.getStartOffset();
                    }
                    kpos.moveBefore();
                }
            } else {
                boolean beforeStruct = false;
                while (!spos.isAtEnd() && spos.getStartOffset() > originalBlockAnchor.getStartOffset()) {
                    if (spos.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        beforeStruct = true;
                    }
                    if (spos.before().matchesRule(LINE_STARTER) && beforeStruct) {
                        return spos.getStartOffset();
                    }
                    spos.moveBefore();
                }
            }
        } else if (originalBlockAnchor.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
            SemanticEditorPosition before = originalBlockAnchor.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if (before.isAtEnd() || before.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace}) || before.getStartOffset() >= position.getStartOffset()) {
                return originalStatementOffset;
            }
            SemanticEditorPosition move = before.copy();
            if (move.after().isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
                move.moveAfter();
            }
            int offset = this.getBlockStatementStartOffset(move);
            SemanticEditorPosition blockAnchor = this.getPosition(position.getEditor(), offset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            int nextLineStyleAfterBrace = blockAnchor.isAtEnd() ? 4 : (blockAnchor.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike) ? commonSettings.CLASS_BRACE_STYLE : (blockAnchor.isAt((IElementType)OCTokenTypes.NAMESPACE_CPP_KEYWORD) ? customSettings.NAMESPACE_BRACE_PLACEMENT : (blockAnchor.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword}) ? commonSettings.BRACE_STYLE : customSettings.FUNCTION_BRACE_PLACEMENT)));
            return nextLineStyleAfterBrace == 4 ? originalStatementOffset : offset;
        }
        return originalStatementOffset;
    }

    @NotNull
    private IndentCalculator getAlignWithPrevLiteralIndent(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull SemanticEditorPosition lastTokenInLine) {
        SemanticEditorPosition maybeAt = lastTokenInLine.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        SemanticEditorPosition anchor = maybeAt.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) ? maybeAt : lastTokenInLine;
        Lexer lexer = OCLineIndentProvider.getLexerAtOffset(anchor.getStartOffset() + 1, document.getCharsSequence());
        return this.createAbsoluteSpaceIndentCalculator(project, editor, OCLineIndentProvider.getOffsetInLine(project, document, lexer.getTokenStart()));
    }

    @TestOnly
    public static boolean setCanUseFormatterForIndent(boolean suggest) {
        boolean oldValue = ourCanUseFormatterForIndent;
        ourCanUseFormatterForIndent = suggest;
        return oldValue;
    }

    static boolean canUseFormatterForIndentProcessing(@Nullable OCLanguageKind kind) {
        if (kind == null || kind.isObjC()) {
            return !Registry.is((String)"cidr.indent.lexer.only.objc");
        }
        return ourCanUseFormatterForIndent && !Registry.is((String)"cidr.indent.lexer.only.cpp");
    }

    private static int getOffsetInLine(@NotNull Project project, @NotNull Document document, int start) {
        CharSequence indent = document.getCharsSequence().subSequence(document.getLineStartOffset(document.getLineNumber(start)), start);
        if (!StringUtil.contains((CharSequence)indent, (CharSequence)"\t")) {
            return start - document.getLineStartOffset(document.getLineNumber(start));
        }
        int tabSize = 4;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null) {
            tabSize = CodeStyle.getIndentOptions((PsiFile)file).TAB_SIZE;
        }
        int size = 0;
        for (int i = 0; i < indent.length(); ++i) {
            size += indent.charAt(i) == '\t' ? tabSize : 1;
        }
        return size;
    }

    private static boolean isLikeFunctionDecl(@NotNull SemanticEditorPosition maybeFuncStart) {
        if (maybeFuncStart.isAtEnd()) {
            return false;
        }
        CharSequence chars = maybeFuncStart.getChars();
        HighlighterIterator position = OCLineIndentProvider.createEditorIteratorAtPosition(maybeFuncStart);
        while (!position.atEnd() && !OCLineIndentProvider.containsNewLine(chars, position.getStart(), position.getEnd())) {
            IElementType type = position.getTokenType();
            if (type == OCTokenTypes.SEMICOLON || type == OCTokenTypes.RPAR) {
                return false;
            }
            if (type == OCTokenTypes.LPAR) {
                return true;
            }
            position.advance();
        }
        return false;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getColonOrSwitchInNonBlockSwitchOnLineBefore(@NotNull SemanticEditorPosition pos) {
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Colon, OCSElement.Switch});
    }

    private static boolean isEqLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{OCSElement.EqualLike, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma}) == OCSElement.EqualLike;
    }

    private static boolean isTemplateLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{OCSElement.TemplateLike, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}) == OCSElement.TemplateLike;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getElementsOnLineBefore(@NotNull SemanticEditorPosition pos, SemanticEditorPosition.SyntaxElement ... syntaxElements) {
        SemanticEditorPosition position = pos.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(position, self -> self.isAtAnyOf(syntaxElements) || self.isAtMultiline());
        return position.isAtAnyOf(syntaxElements) ? position.getCurrElement() : null;
    }

    private static void moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SemanticEditorPosition pos, @NotNull Predicate<SemanticEditorPosition> terminationCondition) {
        block0: while (!pos.isAtEnd() && !terminationCondition.test(pos)) {
            for (int i = 0; i < LEFTS.length; ++i) {
                if (!pos.isAt(RIGHTS[i])) continue;
                pos.moveBeforeParentheses(LEFTS[i], RIGHTS[i]);
                continue block0;
            }
            if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) break;
            pos.moveBefore();
        }
    }

    private static void moveToRightInBlockParenthesisForwardsSkippingNestedWithPredicate(@NotNull SemanticEditorPosition pos, @NotNull Predicate<SemanticEditorPosition> terminationCondition) {
        block0: while (!pos.isAtEnd() && !terminationCondition.test(pos)) {
            for (int i = 0; i < RIGHTS.length; ++i) {
                if (!pos.isAt(LEFTS[i])) continue;
                pos.moveAfterParentheses(LEFTS[i], RIGHTS[i]);
                continue block0;
            }
            if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) break;
            pos.moveAfter();
        }
    }

    @NotNull
    private IndentCalculator createInBlockSpaceIndentCalculator(@NotNull Project project, @NotNull Editor editor, int spaces) {
        return new IndentCalculator(project, editor, x$0 -> this.getDeepBlockStatementStartOffset(x$0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false));
    }

    @NotNull
    private IndentCalculator createAbsoluteSpaceIndentCalculator(@NotNull Project project, @NotNull Editor editor, int spaces) {
        return new IndentCalculator(project, editor, x$0 -> this.getDeepBlockStatementStartOffset(x$0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false)){

            @NotNull
            protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
                return "";
            }
        };
    }

    @NotNull
    public static Lexer getLexerAtOffset(int offset, CharSequence text) {
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE);
        lexer.start(text);
        while (lexer.getTokenEnd() < offset) {
            lexer.advance();
        }
        return lexer;
    }

    @Nullable
    public static SemanticEditorPosition getLineStarterBeforeFirstStringOnLine(@NotNull SemanticEditorPosition pos) {
        SemanticEditorPosition maybeLineStarter = pos.before().beforeOptional((SemanticEditorPosition.SyntaxElement)OCSElement.At);
        return pos.isAt((IElementType)OCTokenTypes.STRING_LITERAL) && maybeLineStarter.matchesRule(LINE_STARTER) && maybeLineStarter.before().isAt((IElementType)OCTokenTypes.STRING_LITERAL) ? maybeLineStarter : null;
    }

    public int getJoinedLinesSpacing(@NotNull Project project, @NotNull Editor editor, Language language, int offset) {
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(this.getPosition(editor, offset))) ? -1 : 0;
    }

    static {
        SYNTAX_MAP.put(TokenType.WHITE_SPACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.SEMICOLON, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.LBRACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.RBRACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.LBRACKET, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.RBRACKET, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.RPAR, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.LPAR, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.COLON, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.CASE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.DEFAULT_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.IF_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.WHILE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.CATCH_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.ELSE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.FOR_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.DO_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.BLOCK_COMMENT, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.COMMA, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.GT, OCSElement.Gt);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.LT, OCSElement.Lt);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.EOL_COMMENT, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.TRY_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.STRUCT_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.CLASS_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.ENUM_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.UNION_KEYWORD, OCSElement.StructLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.INTERFACE_KEYWORD, OCSElement.Interface);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.IDENTIFIER, OCSElement.Identifier);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.RETURN_KEYWORD, OCSElement.ReturnLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.BREAK_KEYWORD, OCSElement.ReturnLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.CONTINUE_KEYWORD, OCSElement.ReturnLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.PUBLIC_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.PROTECTED_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.PRIVATE_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.PACKAGE_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.OPTIONAL_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.REQUIRED_KEYWORD, OCSElement.PublicLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.EOL_ESCAPE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.TYPEDEF_KEYWORD, OCSElement.Typedef);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.SWITCH_KEYWORD, OCSElement.Switch);
        for (IElementType type : OCTokenTypes.ASSIGNMENT_OPERATIONS.getTypes()) {
            SYNTAX_MAP.put(type, OCSElement.EqualLike);
        }
        for (IElementType type : OCFormatterUtil.FORMAT_DIRECTIVES.getTypes()) {
            SYNTAX_MAP.put(type, OCSElement.DirectiveLike);
        }
        SYNTAX_MAP.put((IElementType)OCTokenTypes.TEMPLATE_CPP_KEYWORD, OCSElement.TemplateLike);
        SYNTAX_MAP.put((IElementType)OCTokenTypes.AT, OCSElement.At);
        LINE_STARTER = position -> position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && position.isAtMultiline();
        ourCanUseFormatterForIndent = !ApplicationManager.getApplication().isUnitTestMode();
        LEFTS = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis};
        RIGHTS = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis};
        STRONG_LINE_BEFORE = new IndentCalculator.BaseLineOffsetCalculator(){

            public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
                Document document = currPosition.getEditor().getDocument();
                int lineNo = document.getLineNumber(currPosition.getStartOffset());
                return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)document.getLineEndOffset(lineNo == 0 ? 0 : lineNo - 1), (String)" \t\n\r");
            }
        };
    }

    public static enum OCSElement implements SemanticEditorPosition.SyntaxElement
    {
        StructLike,
        Interface,
        ReturnLike,
        DirectiveLike,
        Identifier,
        PublicLike,
        EqualLike,
        At,
        Lt,
        Gt,
        TemplateLike,
        Switch,
        Typedef;

    }

    protected static class SkipDirectivesHighlighterIterator
    extends HighlighterIteratorWrapper {
        final Editor myEditor;

        SkipDirectivesHighlighterIterator(@NotNull Editor editor, int offset) {
            super(editor.getHighlighter().createIterator(offset));
            this.myEditor = editor;
        }

        public void advance() {
            super.advance();
            CharSequence sequence = this.getDocument().getCharsSequence();
            while (this.isInDirective()) {
                while (this.atTheSameLine(sequence)) {
                    super.advance();
                }
                super.advance();
            }
        }

        public void retreat() {
            super.retreat();
            CharSequence sequence = this.getDocument().getCharsSequence();
            while (this.isInDirective()) {
                while (this.atTheSameLine(sequence)) {
                    super.retreat();
                }
                super.retreat();
            }
        }

        boolean atTheSameLine(CharSequence sequence) {
            return !this.atEnd() && !StringUtil.contains((CharSequence)sequence, (int)this.getStart(), (int)this.getEnd(), (char)'\n');
        }

        boolean isInDirective() {
            HighlighterIterator maybePrevEOL;
            if (this.atEnd()) {
                return false;
            }
            if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(this.getTokenType())) {
                return true;
            }
            Document document = this.getDocument();
            int offset = document.getLineStartOffset(document.getLineNumber(this.getStart()));
            if (offset < 0) {
                return false;
            }
            if (offset - 2 > 0 && !(maybePrevEOL = this.myEditor.getHighlighter().createIterator(offset - 2)).atEnd() && maybePrevEOL.getTokenType() == OCTokenTypes.EOL_ESCAPE) {
                return true;
            }
            HighlighterIterator maybeNextDirective = this.myEditor.getHighlighter().createIterator(offset);
            while (!maybeNextDirective.atEnd() && OCTokenTypes.WHITESPACES.contains(maybeNextDirective.getTokenType())) {
                maybeNextDirective.advance();
            }
            return !maybeNextDirective.atEnd() && OCFormatterUtil.FORMAT_DIRECTIVES.contains(maybeNextDirective.getTokenType());
        }
    }
}

