/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.impl.source.tree.injected.CommentLiteralEscaper;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.editor.OCCommenter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCASTFactory
extends DefaultASTFactoryImpl {
    @NotNull
    public LeafElement createComment(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == OCTokenTypes.EOL_ESCAPE) {
            return new LeafPsiElement(type, text);
        }
        PsiCommentPlaceholder placeholder = OCASTFactory.createForDocumentComment(type, text, () -> new PsiCommentPlaceholder(type, text));
        return placeholder == null ? super.createComment(type, text) : placeholder;
    }

    @Nullable
    public static <T> T createForDocumentComment(@NotNull IElementType type, @NotNull CharSequence text, @NotNull Supplier<T> create) {
        String s = text.toString().trim();
        if (type == OCCommenter.COMMENT_TOKEN_TYPE ? (s.startsWith("/**") || s.startsWith("/*!")) && !s.equals("/**/") : type == OCTokenTypes.EOL_COMMENT && (s.startsWith("///") || s.startsWith("//!"))) {
            return create.get();
        }
        return null;
    }

    public static class PsiCommentPlaceholder
    extends PsiCommentImpl
    implements PsiDocCommentBase,
    InjectionBackgroundSuppressor {
        public PsiCommentPlaceholder(IElementType type, CharSequence text) {
            super(type, text);
        }

        @NotNull
        public LiteralTextEscaper<PsiCommentImpl> createLiteralTextEscaper() {
            return new CommentLiteralEscaper(this){

                public boolean isOneLine() {
                    return false;
                }
            };
        }

        @Nullable
        public PsiElement getOwner() {
            PsiElement parent;
            for (PsiElement child = this.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) continue;
                if (!(child instanceof OCCallable) && !(child instanceof OCDeclaration)) break;
                return child;
            }
            if ((parent = this.getParent()) instanceof OCCallable || parent instanceof OCDeclaration) {
                return parent;
            }
            return null;
        }
    }
}

