/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlHelper {
    @Nls
    @NotNull
    public static String bold(@Nls @NotNull String arg) {
        return HtmlHelper.wrapWithTag("b", arg);
    }

    @Nls
    @NotNull
    public static String code(@Nls @NotNull String arg) {
        return HtmlHelper.wrapWithTag("code", arg);
    }

    @Nls
    @NotNull
    public static String pre(@Nls @NotNull String arg) {
        return HtmlHelper.wrapWithTag("pre", arg);
    }

    @Nls
    @NotNull
    public static String paragraph(@Nls @NotNull String arg) {
        return HtmlHelper.wrapWithTag("p", arg);
    }

    @Contract(pure=true)
    @Nls
    @NotNull
    public static String newLine(@Nls @NotNull String arg) {
        return "<br/>" + arg;
    }

    @Nls
    @NotNull
    public static String wrapWithTag(@NlsSafe @NotNull String tag, @Nls @NotNull String arg) {
        StringBuilder sb = new StringBuilder();
        HtmlHelper.wrapWithTag(sb, tag, arg);
        return sb.toString();
    }

    private static void wrapWithTag(@NotNull StringBuilder sb, @NlsSafe @NotNull String tagWithAttrsAtNewLines, @Nls @NotNull String arg) {
        String[] strings = StringUtil.splitByLines((String)tagWithAttrsAtNewLines);
        sb.append("<").append(StringUtil.join((String[])strings, (String)" "));
        sb.append(">").append(arg).append("</").append(strings[0]).append(">");
    }

    public static class TableRow
    extends HtmlItem {
        @NotNull
        public static TableRow withData(@Nls @NotNull String arg) {
            TableRow raw = new TableRow();
            raw.addData(arg);
            return raw;
        }

        public void addData(@Nls @NotNull String arg) {
            HtmlHelper.wrapWithTag(this.sb, "td", arg);
        }

        @Nls
        public String toString() {
            return "<tr valign=\"top\">" + this.sb + "</tr>";
        }
    }

    public static class Table
    extends HtmlItem {
        public void addRow(@NotNull TableRow element) {
            this.sb.append(element.toString());
        }

        public String toString() {
            return HtmlHelper.wrapWithTag("table", this.sb.toString());
        }
    }

    public static class DL
    extends HtmlItem {
        public void defineTerm(@NotNull @NlsSafe String arg) {
            HtmlHelper.wrapWithTag(this.sb, "dt", arg);
        }

        public void detailedDescription(@NotNull HtmlItem arg) {
            this.detailedDescription(arg.toString());
        }

        public void detailedDescription(@NotNull @NlsSafe String arg) {
            HtmlHelper.wrapWithTag(this.sb, "dd", arg);
        }

        public String toString() {
            return HtmlHelper.wrapWithTag("dl", this.sb.toString());
        }
    }

    public static class HtmlDoc
    extends HtmlItem {
        public void addText(@NotNull String arg) {
            this.sb.append(arg);
        }

        public void addItem(@NotNull HtmlItem arg) {
            this.sb.append(arg.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class HtmlItem {
        protected final StringBuilder sb = new StringBuilder();
    }
}

