/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationComponentListener;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.documentation.CidrDocumentationTarget;
import com.jetbrains.cidr.lang.documentation.CidrVirtualDocComment;
import com.jetbrains.cidr.lang.documentation.ClangdBridgeCompletionItem;
import com.jetbrains.cidr.lang.documentation.CppReferenceDocumentationUtil;
import com.jetbrains.cidr.lang.documentation.DoxygenRender;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang.math.RandomUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    @NonNls
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    private final Map<String, CodeStyleSettings> mySettings = new HashMap<String, CodeStyleSettings>();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean isNewApi() {
        return Registry.is((String)"cidr.quick.documentation.new.api", (boolean)true);
    }

    @Nls
    protected String getEvaluatedExpressionInfo(@NotNull PsiElement originalElement) throws ExecutionException {
        return null;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (CidrDocumentationProvider.isNewApi()) {
            return null;
        }
        String content = this.getQuickNavigateInfoInner(element, originalElement);
        return content != null ? CidrDocumentationProvider.wrapDocInHtml(content) : null;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfoInner(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        return this.quickDocContent(element, OCPsiFile.tryGetElementFromOCFile(originalElement), false);
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (CidrDocumentationProvider.isNewApi()) {
            return null;
        }
        String doc = this.generateDocInner(element, originalElement);
        return doc == null ? null : CidrDocumentationProvider.wrapDocInHtml(doc);
    }

    @Nullable
    @Nls
    public String generateDocInner(PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression) {
            return CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element);
        }
        return this.generateDocInnerHtml(element, OCPsiFile.tryGetElementFromOCFile(originalElement), false);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (psiManager != null) {
            if (object instanceof OCSymbol) {
                return ((OCSymbol)object).locateDefinition(psiManager.getProject());
            }
            if (object instanceof ClangdBridgeCompletionItem) {
                return ExternalResolveUtils.clangdCompletionItem2PsiElement(psiManager.getProject(), (ClangdBridgeCompletionItem)object);
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        if (link == null || psiManager == null) {
            return null;
        }
        if ((link = StringUtil.trimStart((String)link, (String)"psi_element://")).startsWith(PSI_LINK_PREFIX_METHOD)) {
            List parts2 = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",");
            if (parts2.size() == 3) {
                PsiElement elementAt;
                PsiFile file;
                String path = (String)parts2.get(1);
                String offset = (String)parts2.get(2);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid() && (elementAt = file.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                    return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
                }
            }
        } else {
            int idx = link.lastIndexOf(35);
            if (idx > -1) {
                PsiFile file;
                String path = link.substring(0, idx);
                String offset = link.substring(idx + 1);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid()) {
                    int off = Integer.parseInt(offset);
                    PsiElement elementAt = file.findElementAt(off);
                    return TargetElementUtil.getInstance().getNamedElement(elementAt, off);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(',').append(file.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    @Nls
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        OCPolyVariantReference<OCMethodSymbol> reference = sme.getReference();
        List<OCMethodSymbol> list = reference.resolveToSymbols();
        HtmlBuilder builder2 = new HtmlBuilder();
        for (OCMethodSymbol symbol : list) {
            OCClassSymbol parent = symbol.getParent();
            String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
            if (link == null) continue;
            builder2.append((HtmlChunk)HtmlChunk.link((String)link, (String)(symbol.getSignature(sme.getProject()) + " (" + parent.getPresentableName() + ")")));
            builder2.append((HtmlChunk)HtmlChunk.br());
        }
        return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(OCResolveContext.forPsi(sme)), builder2.toString()});
    }

    @Nullable
    @Nls
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        String htmlDoc = this.generateDocInnerHtml((PsiElement)comment, null, true);
        return htmlDoc == null ? (DumbService.getInstance((Project)comment.getProject()).isDumb() ? CodeInsightBundle.message((String)"doc.render.loading.text", (Object[])new Object[0]) : null) : CidrDocumentationProvider.cleanEmptyLinesInDoc(htmlDoc);
    }

    @Nls
    @NotNull
    private static String cleanEmptyLinesInDoc(@NotNull @Nls String htmlDoc) {
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)htmlDoc, (String)"<br/>"), (String)"<br/>").replace("<td> </td>", "<td></td>").replace("</td> </tr>", "</td></tr>").replace("<table><tr valign=\"top\"><td><code></code></td><td></td></tr></table>", "").trim();
    }

    @Nullable
    public PsiDocCommentBase findDocComment(@NotNull PsiFile file, @NotNull TextRange range) {
        ArrayList<PsiDocCommentBase> comments = new ArrayList<PsiDocCommentBase>();
        for (PsiElement element = file.findElementAt(range.getStartOffset()); element != null && element.getTextRange().getStartOffset() < range.getEndOffset(); element = element.getNextSibling()) {
            if (!(element instanceof PsiDocCommentBase)) continue;
            comments.add((PsiDocCommentBase)element);
        }
        Ref docComment = new Ref();
        CidrDocumentationProvider.processMergedComments(comments, base -> docComment.set(base));
        return (PsiDocCommentBase)docComment.get();
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiDocCommentBase.class);
        CidrDocumentationProvider.processMergedComments(comments, sink);
    }

    private static void processMergedComments(@NotNull Collection<? extends PsiComment> comments, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        ArrayList<PsiComment> group = new ArrayList<PsiComment>();
        for (PsiComment psiComment : comments) {
            if (group.isEmpty()) {
                group.add(psiComment);
                continue;
            }
            if (!CidrDocumentationProvider.canMergeComments((PsiComment)group.get(group.size() - 1), psiComment)) {
                sink.accept(new CidrVirtualDocComment(group));
                group = new ArrayList();
            }
            group.add(psiComment);
        }
        if (!group.isEmpty()) {
            sink.accept(new CidrVirtualDocComment(group));
        }
    }

    public static boolean canMergeComments(@NotNull PsiComment comment, @NotNull PsiComment nextComment) {
        IElementType commentType = comment.getTokenType();
        if (commentType == OCTokenTypes.BLOCK_COMMENT || commentType != nextComment.getTokenType()) {
            return false;
        }
        PsiElement nextElement = comment.getNextSibling();
        while (nextElement instanceof PsiWhiteSpace) {
            nextElement = nextElement.getNextSibling();
        }
        return nextElement == nextComment;
    }

    @Nullable
    @Nls
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        Project project = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi(originalElement != null ? originalElement : element);
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCCppNamespace) {
            HtmlBuilder answer = new HtmlBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCNamespaceSymbol symbol = (OCNamespaceSymbol)((OCCppNamespace)element).getSymbol();
            if (symbol != null) {
                if (symbol.isInlineNamespace()) {
                    answer.append(OCTokenTypes.INLINE_KEYWORD.getName()).append(" ");
                }
                answer.append(symbol.getKindLowercase(context)).append(" ");
                @NlsSafe String namespace = OCDocUtil.getNamespace(symbol, context);
                if (!namespace.isEmpty()) {
                    answer.append(namespace).append("::");
                }
                return answer.append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold()).toString();
            }
            return null;
        }
        if (element instanceof OCClassDeclaration) {
            OCFile file;
            OCInterfaceSymbol anInterface;
            HtmlBuilder answer = new HtmlBuilder();
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type = cd.getType();
            if (type != null && (anInterface = type.getInterface()) != null && (file = anInterface.getContainingOCFile(project)) != null) {
                answer.append(CidrDocumentationProvider.declaredInHint(file));
            }
            return answer.append(CidrDocumentationProvider.classHintDoc(cd)).toString();
        }
        if (element instanceof OCMethodSelectorPart) {
            HtmlBuilder answer = new HtmlBuilder();
            CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
            answer.append((HtmlChunk)HtmlChunk.text((String)StringUtil.notNullize((String)((OCMethodSelectorPart)element).getName())).bold());
            return answer.toString();
        }
        if (element instanceof OCTypeParameterDeclaration) {
            return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
        }
        if (element instanceof OCCategoryName) {
            OCCategoryName category = (OCCategoryName)element;
            PsiElement parent = category.getParent();
            if (parent instanceof OCClassDeclaration) {
                OCClassDeclaration cd = (OCClassDeclaration)parent;
                return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
            }
            return null;
        }
        if (element instanceof OCDeclarator) {
            PsiReference reference;
            OCDeclarator declarator = (OCDeclarator)element;
            OCSymbol symbol = null;
            PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
            if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
            }
            if (symbol == null) {
                symbol = declarator.getSymbol();
            }
            return this.getSymbolDoc(element, context, symbol);
        }
        if (element instanceof OCSymbolHolderVirtualPsiElement) {
            List<OCFunctionSymbol> overloads;
            Object symbol = ((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCFunctionGroupSymbol && (overloads = ((OCFunctionGroupSymbol)symbol).getOverloads()).size() == 1) {
                symbol = overloads.get(0);
            }
            return this.getSymbolDoc(element, context, (OCSymbol)symbol);
        }
        if (element instanceof OCDefineDirective) {
            PsiFile file = element.getContainingFile();
            HtmlBuilder answer = new HtmlBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(file));
            OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
            if (symbol == null) {
                return "";
            }
            answer.append("#define ").append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
            if (symbol.hasParameterList()) {
                answer.append("(").append(StringUtil.join(symbol.getParameterNames(), (String)", ")).append(")");
            }
            answer.append(" ").append(HtmlChunk.text((String)symbol.getSubstitution()));
            return answer.toString();
        }
        if (element instanceof OCCppUsingStatement) {
            HtmlBuilder answer = new HtmlBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
            if (symbol instanceof OCAliasUsingSymbol) {
                answer.append("using ").append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold()).append(" = ").appendRaw(CidrDocumentationProvider.effectiveTypeStringHtml(symbol, context));
            }
            return answer.toString();
        }
        if (element instanceof OCCppNamespaceAlias) {
            HtmlBuilder answer = new HtmlBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCCppNamespaceAlias namespaceAliasElement = (OCCppNamespaceAlias)element;
            OCNamespaceAliasSymbol symbol = (OCNamespaceAliasSymbol)namespaceAliasElement.getSymbol();
            if (OCLog.LOG.assertTrue(symbol != null)) {
                OCSymbolKind kind = symbol.getKind();
                OCSymbolReference ref = symbol.getNamespaceReference();
                answer.append(kind.getNameLowercase()).append(" ").append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold()).append(" = ").append(ref.getQualifiedName().getFullName(OCResolveContext.forPsi(element)));
            }
            return answer.toString();
        }
        if (element instanceof OCStructLike) {
            OCStructSymbol symbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            HtmlBuilder answer = new HtmlBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            if (symbol == null) {
                return answer.toString();
            }
            CidrDocumentationProvider.addNamespace(symbol, answer, context);
            CidrDocumentationProvider.addVisibility(symbol, answer);
            if (symbol.isPredeclaration()) {
                OCDocUtil.extractModifiers(symbol, answer);
            } else {
                answer.append(CidrDocumentationProvider.getTemplateParameters(symbol, context));
            }
            answer.append(symbol.getKindLowercase(context)).append(" ");
            if (symbol.isEnumClass()) {
                answer.append("class ");
            }
            answer.appendRaw(CidrDocumentationProvider.getCanonicalNamePrefixHtml(symbol, context)).append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, context);
            if (symbol.isFinal()) {
                answer.append(" ").append(OCTokenTypes.FINAL_CPP_KEYWORD.getName());
            }
            answer.appendRaw(CidrDocumentationProvider.getBaseClassesHtml(symbol, context));
            return answer.toString().replaceAll("\\s+", " ");
        }
        OCFindUsagesProvider common = new OCFindUsagesProvider();
        if (common.canFindUsagesFor(element)) {
            HtmlBuilder answer = new HtmlBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(element.getContainingFile())).append(common.getType(element)).append(" ").append((HtmlChunk)HtmlChunk.text((String)common.getDescriptiveName(element)).bold());
            return answer.toString();
        }
        return null;
    }

    @NotNull
    @Nls
    private String getSymbolDoc(@NotNull PsiElement element, @NotNull OCResolveContext context, OCSymbol symbol) {
        OCClassDeclaration container;
        PsiElement parent;
        PsiElement grandParent;
        HtmlBuilder answer = new HtmlBuilder();
        Project project = element.getProject();
        OCFile containingFile = symbol == null ? null : symbol.getContainingOCFile(project);
        OCDeclarator declarator = (OCDeclarator)ObjectUtils.tryCast((Object)element, OCDeclarator.class);
        if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            answer.append(CidrDocumentationProvider.declaredInHint(containingFile));
        }
        if (symbol != null) {
            CidrDocumentationProvider.addNamespace(symbol, answer, context);
            CidrDocumentationProvider.addVisibility(symbol, answer);
        }
        PsiElement psiElement = grandParent = (parent = element.getParent()) != null ? parent.getParent() : null;
        if (grandParent instanceof OCProperty) {
            OCProperty property = (OCProperty)grandParent;
            String iVarDoc = this.propertyIVarDoc(property);
            if (iVarDoc != null) {
                return iVarDoc;
            }
            OCClassDeclaration container2 = property.getContainingClass();
            if (container2 != null) {
                answer.append(CidrDocumentationProvider.classHintDoc(container2)).append((HtmlChunk)HtmlChunk.br());
            }
            answer.append("@property ");
            OCPropertyAttributesList attrs = property.getPropertyAttributesList();
            if (attrs != null) {
                String attrsStr = StringUtil.join(attrs.getAttributes(), attribute2 -> attribute2.getText(), (String)", ");
                answer.append("(").append(attrsStr).append(") ");
            }
        } else if (grandParent instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append((HtmlChunk)HtmlChunk.br());
        }
        if (symbol != null) {
            if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                answer.append("ivar ");
            } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                answer.append("typedef ");
            }
        }
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol definition;
            OCFunctionSymbol func = (OCFunctionSymbol)symbol;
            if (func.isFriend() && (definition = (OCFunctionSymbol)func.getDefinitionSymbol(project)) != null) {
                func = definition;
            }
            answer.append(CidrDocumentationProvider.getTemplateParameters(func, context));
            OCFunctionDeclaration functionDeclaration = func.locateFunctionDefinition(project);
            OCDocUtil.extractModifiers(func, functionDeclaration, answer);
            if (!func.isCppConstructor() && !func.isCppDestructor()) {
                answer.appendRaw(CidrDocumentationProvider.effectiveTypeStringHtml(func, context)).append(OCDocUtil.delimiter(CidrDocumentationProvider.effectiveTypeStringHtml(func, context)));
            }
            answer.appendRaw(CidrDocumentationProvider.getCanonicalNamePrefixHtml(func, context)).append((HtmlChunk)HtmlChunk.text((String)func.getName()).bold());
            this.extractFunctionSignature(declarator, func, answer, context);
        } else if (symbol instanceof OCDeclaratorSymbol) {
            answer.append(CidrDocumentationProvider.getTemplateParameters(symbol, context));
            OCDocUtil.extractModifiers((OCDeclaratorSymbol)symbol, answer);
            boolean isEnumConst = symbol.getKind() == OCSymbolKind.ENUM_CONST;
            answer.appendRaw(CidrDocumentationProvider.effectiveTypeStringHtml(symbol, context)).append(OCDocUtil.delimiter(CidrDocumentationProvider.effectiveTypeStringHtml(symbol, context), isEnumConst ? "::" : " "));
            if (!isEnumConst) {
                answer.appendRaw(CidrDocumentationProvider.getCanonicalNamePrefixHtml(symbol, context));
            }
            answer.append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
        } else if (declarator != null) {
            CidrDocumentationProvider.appendType(answer, declarator.getRawType(), element.getContainingFile(), false);
            answer.append(" ").append((HtmlChunk)HtmlChunk.text((String)declarator.getName()).bold());
        }
        if (declarator != null) {
            this.processInitializer(declarator, answer);
        }
        return answer.toString();
    }

    @NotNull
    @NlsSafe
    private static String getBaseClassesHtml(@NotNull OCStructSymbol symbol, @NotNull OCResolveContext context) {
        Collection<Pair<OCType, OCVisibility>> baseClasses = symbol.getBaseCppClassesWithVisibility(context);
        if (!baseClasses.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
            String baseClassesStr = StringUtil.join(baseClasses, pair -> {
                OCVisibility visibility = (OCVisibility)((Object)((Object)pair.getSecond()));
                Object visibilityStr = "";
                if (visibility != null) {
                    visibilityStr = visibility + " ";
                }
                OCType type = (OCType)pair.getFirst();
                return (String)visibilityStr + OCDocUtil.getCanonicalNameHtml(type, contextNamespace, context);
            }, (String)", ");
            return " : " + baseClassesStr;
        }
        return "";
    }

    private void processInitializer(@NotNull OCDeclarator declarator, @NotNull HtmlBuilder answer) {
        OCExpression initializer = (declarator = this.cleanAndReformat(declarator, OCDeclarator.class)).getInitializer();
        if (initializer != null) {
            answer.append(" =");
        } else {
            initializer = declarator.getInitializerList();
        }
        if (initializer != null) {
            answer.append(" ");
            CidrDocumentationProvider.processExpressionElement(initializer, answer);
        } else {
            OCArgumentList args = declarator.getArgumentList();
            if (args != null) {
                CidrDocumentationProvider.processExpressionElement(args, answer);
            }
        }
    }

    private static void processExpressionElement(@NotNull OCElement initializer, @NotNull HtmlBuilder answer) {
        String text = initializer.getTextWithMacros();
        int idx = text.indexOf(10);
        if (idx != -1) {
            String part = text.substring(0, idx).replaceAll("\\s+", " ");
            answer.append(HtmlChunk.text((String)part)).append("...");
        } else {
            answer.append(HtmlChunk.text((String)text));
        }
    }

    private void extractFunctionSignature(@Nullable OCDeclarator declarator, @NotNull OCFunctionSymbol symbol, @NotNull HtmlBuilder answer, @NotNull OCResolveContext context) {
        Collection<OCTypeArgument> substitutionTypes;
        if (declarator != null) {
            declarator = this.cleanAndReformat(declarator, OCDeclarator.class);
        }
        if ((substitutionTypes = symbol.getSubstitution().getSubstitutedTypes()) != null && !substitutionTypes.isEmpty()) {
            answer.appendRaw(OCDocUtil.getParametersSignatureHtml(symbol, false, context));
        } else {
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, context);
            answer.appendRaw(OCDocUtil.getParametersSignatureHtml(symbol, true, context));
        }
        OCDocUtil.extractFuncPostModifiers(symbol, answer);
        OCNoexceptSpecifier noexcept = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)declarator, OCNoexceptSpecifier.class);
        if (noexcept != null) {
            CidrDocumentationProvider.processExpressionElement(noexcept, answer.append(" "));
        }
    }

    @NotNull
    @NlsSafe
    private static HtmlBuilder getTemplateParameters(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        OCTemplateSymbol templateSymbol;
        HtmlBuilder sb = new HtmlBuilder();
        if (symbol instanceof OCTemplateSymbol && symbol instanceof OCSymbolWithQualifiedName && (templateSymbol = (OCTemplateSymbol)symbol).isTemplateSymbol()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)((Object)templateSymbol), context);
            List<OCTypeParameterSymbol> templateParams = templateSymbol.getTemplateParameters();
            OCDocUtil.wrapTemplateParams(templateParams, contextNamespace, context, sb);
            return sb.append((HtmlChunk)HtmlChunk.br());
        }
        return sb;
    }

    @NotNull
    private <T extends PsiElement> T cleanAndReformat(@NotNull OCElement element, Class<T> ignore) {
        Language language;
        CodeFormatterFacade formatterFacade;
        PsiElement result;
        PsiElement copy2 = element.copy();
        final ArrayList comments = new ArrayList();
        copy2.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                comments.add(comment);
            }
        });
        for (PsiElement comment : comments) {
            comment.delete();
        }
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)copy2) && (result = SourceTreeToPsiMap.treeElementToPsi((ASTNode)(formatterFacade = new CodeFormatterFacade(this.getSettings(language = copy2.getLanguage()), language)).processElement(SourceTreeToPsiMap.psiElementToTree((PsiElement)copy2)))) != null) {
            return (T)result;
        }
        return (T)copy2;
    }

    private CodeStyleSettings getSettings(@NotNull Language lang) {
        String langID = lang.getID();
        if (!this.mySettings.containsKey(langID)) {
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.getCommonSettings((Language)lang).KEEP_LINE_BREAKS = true;
            settings.getCommonSettings((Language)lang).SPACE_WITHIN_BRACES = true;
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).DO_NOT_ADD_BREAKS = true;
            this.mySettings.put(langID, settings);
        }
        return this.mySettings.get(langID);
    }

    private static void extractTemplateSpecialization(@NotNull OCSymbolWithQualifiedName symbol, @NotNull HtmlBuilder sb, @NotNull OCResolveContext context) {
        List<OCTypeArgument> specialization;
        if (symbol instanceof OCTemplateSymbol && (specialization = ((OCTemplateSymbol)((Object)symbol)).getTemplateSpecialization()) != null && !specialization.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
            OCDocUtil.wrapTemplateArgs(specialization, contextNamespace, context, sb);
        }
    }

    private static void addNamespace(@NotNull OCSymbol symbol, @NotNull HtmlBuilder answer, @NotNull OCResolveContext context) {
        String namespace;
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER && (namespace = OCDocUtil.getNamespace((OCSymbolWithQualifiedName)symbol, context)).length() > 0) {
            answer.append("namespace ").append(namespace).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br());
        }
    }

    private static void addVisibility(@NotNull OCSymbol symbol, HtmlBuilder answer) {
        OCVisibility visibility;
        if (symbol instanceof OCSymbolWithQualifiedName && (visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility()) != null && visibility != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC) {
            answer.append(visibility.toString()).append(":").append((HtmlChunk)HtmlChunk.br());
        }
    }

    @NotNull
    @NlsSafe
    private static String getCanonicalNamePrefixHtml(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER) {
            String prefix = OCDocUtil.getCanonicalPrefixHtml((OCSymbolWithQualifiedName)symbol, context);
            return prefix.isEmpty() ? "" : prefix + "::";
        }
        return "";
    }

    @NotNull
    @NlsSafe
    private static String effectiveTypeStringHtml(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        OCType effectiveType = symbol.getEffectiveType(context.getProject());
        OCType type = effectiveType.accept(new OCTypeParameterResolveVisitor(context.getFile()));
        if (type instanceof OCMagicType) {
            type = effectiveType;
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)symbol, context);
            return OCDocUtil.replaceAnonymous(OCDocUtil.getCanonicalNameHtml(type, contextNamespace, context));
        }
        return OCDocUtil.replaceAnonymous(CidrDocumentationProvider.escapeHTML(type.getBestNameInContext(context)));
    }

    @Nullable
    @NlsSafe
    private String propertyIVarDoc(@NotNull OCProperty p) {
        PsiElement iVar = CidrDocumentationProvider.getPropertyIVar(p);
        if (iVar != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        Project project = p.getProject();
        if (ps != null) {
            iVar = ps.getAssociatedIvar(project);
        }
        return iVar == null ? null : iVar.locateDefinition(project);
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        OCDeclaration pd = p.getDeclaration();
        if (pd == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.size() == 0) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    @NlsSafe
    private static HtmlBuilder declaredInHint(@NotNull PsiFile file) {
        return CidrDocumentationProvider.declaredInHint(file.getName());
    }

    @NotNull
    @Nls
    public static HtmlBuilder declaredInHint(@NotNull @NlsSafe String fileName) {
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)OCBundle.message("qdoc.declared.in", new Object[0])).bold()).append(" ").append(fileName).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br());
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        OCExpression functionRef;
        Project project = element.getProject();
        if (element instanceof OCReferenceElement) {
            OCSymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty(project);
                if (property2 != null) {
                    return property2.locateDefinition(project);
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getOriginalSymbol()) != null) {
                return property.locateDefinition(project);
            }
        } else if (element instanceof OCCallExpression && (functionRef = ((OCCallExpression)element).getFunctionReferenceExpression()) instanceof OCReferenceExpression && (element = ((OCReferenceExpression)functionRef).getReferenceElement()) != null) {
            return ((OCReferenceElement)element).resolve();
        }
        return element;
    }

    @Nullable
    @Nls
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type) {
        return type.getText();
    }

    @NotNull
    @Nls
    private static String classHintDoc(@NotNull OCClassDeclaration<?> classDeclaration) {
        return (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
    }

    @NotNull
    @Nls
    private static String methodHintDoc(@NotNull OCMethod method) {
        HtmlBuilder answer = new HtmlBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append((HtmlChunk)HtmlChunk.br());
        }
        answer.append(method.isInstanceMethod() ? "-" : "+").append(" ");
        CidrDocumentationProvider.appendType(answer, method.getRawReturnType(), method.getContainingFile(), true);
        for (OCMethodSelectorPart part : method.getParameters()) {
            String parameterName;
            answer.append((HtmlChunk)HtmlChunk.text((String)StringUtil.notNullize((String)part.getSelectorPart())).bold());
            OCType type = part.getRawType();
            if (type != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type, method.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        return answer.toString();
    }

    private static void appendType(@NotNull HtmlBuilder answer, @NotNull OCType type, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        String typeText = type.accept(new OCTypeParameterResolveVisitor(context)).getBestNameInContext((PsiElement)context);
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(HtmlChunk.text((String)typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    @Nullable
    @Nls
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        HtmlBuilder answer = new HtmlBuilder();
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (!skipQuickDoc && answer.isEmpty()) {
            this.addQuickDoc(element, originalElement, answer);
        }
        try {
            PsiElement targetElem = originalElement != null ? originalElement : element;
            String exprInfo = this.getEvaluatedExpressionInfo(targetElem);
            if (exprInfo != null && !exprInfo.isBlank()) {
                if (!answer.isEmpty()) {
                    answer.append((HtmlChunk)HtmlChunk.br());
                    answer.append((HtmlChunk)HtmlChunk.br());
                }
                answer.append(HtmlChunk.raw((String)exprInfo));
                CidrDocumentationProvider.addBreakIfRequired(answer);
            }
        }
        catch (ExecutionException targetElem) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        this.addCommentDoc(element, sb);
        if (!CidrDocumentationProvider.isNewApi() && element instanceof PsiNamedElement) {
            CidrDocumentationProvider.addManDoc(sb, (PsiNamedElement)element);
        }
        answer.appendRaw(sb.toString());
        List<String> externalDocumentation = this.getUrlFor(element, originalElement);
        if (externalDocumentation != null && externalDocumentation.size() == 1) {
            if (!answer.isEmpty()) {
                answer.append((HtmlChunk)HtmlChunk.br());
                answer.append((HtmlChunk)HtmlChunk.br());
            }
            OCSymbolWithQualifiedName symbol = CppReferenceDocumentationUtil.getSymbolWithQualifiedName(element, false);
            String symbolName = Objects.requireNonNull(symbol).getPresentableName();
            String text = OCBundle.message("qdoc.on.cppreference", symbolName);
            answer.append((HtmlChunk)HtmlChunk.link((String)externalDocumentation.get(0), (String)text));
        }
        return answer.isEmpty() ? null : answer.toString();
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull HtmlBuilder answer) {
        String quickDoc = this.quickDocContent(element, originalElement, true);
        if (quickDoc != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            answer.append((HtmlChunk)HtmlChunk.raw((String)quickDoc).code());
        }
    }

    private static void addManDoc(@NotNull StringBuilder answer, @NotNull PsiNamedElement namedElement) {
        OCSymbolWithQualifiedName parent;
        Object symbol;
        VirtualFile vFile;
        PsiFile psiFile = namedElement.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (vFile == null || !vFile.getPath().contains("/usr/include/")) {
            return;
        }
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        if (namedElement instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)namedElement).getSymbol()) instanceof OCSymbolWithQualifiedName && (parent = ((OCSymbolWithQualifiedName)symbol).getParent()) != null) {
            return;
        }
        @NlsSafe String manPlaceHolder = "<!-- man-placeholder-" + RandomUtils.nextLong() + " -->";
        answer.append(manPlaceHolder);
        Future<String> man = ProcessIOExecutorService.INSTANCE.submit(() -> CidrDocumentationProvider.getManPage(name));
        Project project = namedElement.getProject();
        Disposable disposable = Disposer.newDisposable();
        project.getMessageBus().connect(disposable).subscribe(DocumentationComponentListener.TOPIC, () -> {
            ProcessIOExecutorService.INSTANCE.execute(() -> CidrDocumentationProvider.updateQuickDoc((PsiElement)namedElement, project, manPlaceHolder, man));
            Disposer.dispose((Disposable)disposable);
        });
    }

    private static void updateQuickDoc(@NotNull PsiElement element, @NotNull Project project, @NotNull @NlsSafe String placeHolder, @NotNull Future<@Nullable @NlsSafe String> placeHolderText) {
        try {
            String man = placeHolderText.get(1000L, TimeUnit.MILLISECONDS);
            if (StringUtil.isEmpty((String)man)) {
                return;
            }
            @NlsSafe String manText = "<br/><br/>" + CidrDocumentationTarget.man2html(man);
            UIUtil.invokeLaterIfNeeded(() -> {
                String docText;
                DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
                if (component != null && (docText = component.getText()) != null) {
                    String documentation = docText.replace(placeHolder, manText);
                    component.replaceText(documentation, element);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addMacroDoc(@Nullable PsiElement originalElement, @NotNull HtmlBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file;
        CidrDocumentationProvider.addBreakIfRequired(answer);
        if (answer.isEmpty() && (file = define.getContainingFile()) != null) {
            answer.append(CidrDocumentationProvider.declaredInHint(file));
        }
        answer.append((HtmlChunk)HtmlChunk.text((String)OCBundle.message("qdoc.definition", new Object[0])).bold()).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.raw((String)HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)define, (String)this.cleanAndReformat(define, OCDefineDirective.class).getTextWithMacros()).replaceAll("[ ]+\n", "\n")).wrapWith("tt")).append((HtmlChunk)HtmlChunk.br());
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)OCPsiFile.tryGetElementFromOCFile(originalElement), (Class[])new Class[]{OCMacroCall.class});
        if (macroCall != null) {
            answer.append((HtmlChunk)HtmlChunk.text((String)OCBundle.message("qdoc.replacement", new Object[0])).bold()).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.raw((String)HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)define, (String)CidrDocumentationProvider.getFormattedText(macroCall, macroCall.getReplacementText()))).wrapWith("tt"));
        }
    }

    @NotNull
    private static String getFormattedText(@NotNull PsiElement context, @NotNull String replacement) {
        OCCodeFragment fragment = OCElementFactory.codeFragment(replacement, context.getProject(), context, PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCExpression.class, OCStatement.class}) != null ? OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT : OCTokenTypes.OC_FILE, false, true);
        Document document = FileDocumentManager.getInstance().getDocument(fragment.getViewProvider().getVirtualFile());
        String formattedText = document == null || PsiDocumentManager.getInstance((Project)fragment.getProject()).isCommitted(document) ? fragment.getText() : document.getText();
        return formattedText.replaceAll("(\n[ \t\r]*)+\n", "\n");
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String escapeHTML(@NlsSafe @NotNull String text) {
        return StringUtil.escapeXmlEntities((String)text);
    }

    private static void addBreakIfRequired(@NotNull HtmlBuilder answer) {
        if (!answer.isEmpty()) {
            answer.append((HtmlChunk)HtmlChunk.br());
        }
    }

    @Nullable
    private static String getManPage(@NotNull String name) {
        GeneralCommandLine cl = new GeneralCommandLine(new String[]{"man", "-S", "2:3", name});
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            ProcessOutput result = new CapturingProcessHandler(cl).runProcess(1000);
            if (result.isTimeout()) {
                return null;
            }
            return result.getStdout().trim();
        }
        catch (com.intellij.execution.ExecutionException e) {
            return null;
        }
    }

    @NotNull
    @Nls
    public static String wrapDocInHtml(@Nls @NotNull String doc) {
        return "<html><head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head><body>" + doc + "</body></html>";
    }

    private void addCommentDoc(@NotNull PsiElement element, @NlsSafe @NotNull StringBuilder answer) {
        boolean added = this.addCommentDocForElement(element, answer);
        if (!added) {
            List<OCSymbolWithParent> elements = OCDocUtil.getSuperSymbols(element);
            for (OCSymbolWithParent s : elements) {
                int pos = answer.length();
                PsiElement psiElement = s.locateDefinition(element.getProject());
                if (psiElement == null) continue;
                if (psiElement instanceof OCDeclarator) {
                    psiElement = psiElement.getParent();
                }
                if (!this.addCommentDocForElement(psiElement, answer)) continue;
                answer.insert(pos, "<br/><br/><b>" + OCBundle.message("qdoc.description.copied.from", new Object[0]) + " </b>" + OCDocUtil.getLinkHtml(s));
                break;
            }
        }
    }

    private boolean addCommentDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        int length = answer.length();
        DoxygenRender dxRender = new DoxygenRender(element);
        if (dxRender.hasDoxygenComments()) {
            dxRender.render(answer);
        } else {
            this.addDocForElement(element, answer);
        }
        return answer.length() > length;
    }

    protected void addDocForElement(@NotNull PsiElement element, @NlsSafe @NotNull StringBuilder answer) {
        String data;
        ArrayList<String> content = new ArrayList<String>();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiComment comment : this.findCommentsFor(element)) {
            IElementType type = comment.getTokenType();
            comments.add(comment);
            if (type == OCTokenTypes.EOL_COMMENT) continue;
            content.add(this.processComments(comments));
            comments.clear();
        }
        if (!comments.isEmpty()) {
            content.add(this.processComments(comments));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(data = StringUtil.join(content, (String)"\n")))) {
            answer.append("<pre>").append(data).append("</pre>");
        }
    }

    @NotNull
    private String processComments(@NotNull List<PsiComment> comments) {
        int commonPaddingIdx = 0x3FFFFFFF;
        ArrayList content = new ArrayList();
        for (PsiComment comment : comments) {
            String text = CidrDocumentationProvider.escapeHTML(this.stripCommentBegin(comment.getText()));
            List lines = StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false);
            if (!$assertionsDisabled && lines.size() <= 0) {
                throw new AssertionError();
            }
            String fistLine = (String)lines.get(0);
            if (!fistLine.isEmpty()) {
                lines.set(0, "  " + fistLine);
            }
            for (String line : lines) {
                int padding = CidrDocumentationProvider.indent(line, comment.getTokenType() != OCTokenTypes.EOL_COMMENT);
                if (padding >= commonPaddingIdx) continue;
                commonPaddingIdx = padding;
            }
            content.addAll(lines);
        }
        int padding = commonPaddingIdx;
        List result = ContainerUtil.map(content, s -> s.substring(Math.min(s.length(), padding)));
        return StringUtil.join((Collection)result, (String)"\n");
    }

    private static int indent(@NotNull String line, boolean processAsterisk) {
        int i;
        if (line.isEmpty()) {
            return 0x3FFFFFFF;
        }
        for (i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (!processAsterisk || ch != '*') break;
            processAsterisk = false;
        }
        return i < line.length() ? i : 0x3FFFFFFF;
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if ("/**/".equals(text)) {
            text = "";
        } else if (text.startsWith("/**") || text.startsWith("/*!") || text.startsWith("///") || text.startsWith("//!")) {
            text = text.substring(3);
        } else if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        text = StringUtil.trimEnd((String)text, (String)"*/");
        text = StringUtil.trimTrailing((String)text, (char)' ');
        return text;
    }

    @NotNull
    protected List<PsiComment> findCommentsFor(@Nullable PsiElement element) {
        List<PsiComment> comments = CidrDocumentationProvider.findOCCommentFor(element);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            PsiElement associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project);
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition(project)) != null) {
                comments = CidrDocumentationProvider.findOCCommentFor(associatedElement);
            }
        }
        return comments;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return CppReferenceDocumentationUtil.getUrlFor(element);
    }

    @NotNull
    private static List<PsiComment> findOCCommentFor(@Nullable PsiElement elt) {
        if (elt == null) {
            return Collections.emptyList();
        }
        return DoxygenFacade.getCommentScope(elt);
    }

    static {
        boolean bl = $assertionsDisabled = !CidrDocumentationProvider.class.desiredAssertionStatus();
        if (!CidrDocumentationProvider.isNewApi()) {
            QuickDocUtil.forceEnableDocumentationV1();
        }
    }
}

