/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.documentation.ClangdBridgeCompletionItem;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalResolveUtils {
    private static final ThreadLocal<Integer> ourResolveProhibited = ThreadLocal.withInitial(() -> 0);
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)ExternalResolveUtils.class.getName());

    public static void prohibitClangResolve() {
        assert (ourResolveProhibited.get() >= 0) : "Unbalanced prohibitClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() + 1);
    }

    public static void allowClangResolve() {
        assert (ourResolveProhibited.get() > 0) : "Unbalanced allowClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() - 1);
    }

    @Nullable
    public static List<OCSymbol> resolveSymbols(@NotNull PsiReference ref) {
        if (!ExternalResolveUtils.canDoExternalResolve(ref)) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(ref);
        return elements != null ? ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).collect(Collectors.toList()) : null;
    }

    @Nullable
    public static OCSymbol resolveSymbol(@NotNull PsiReference ref) {
        if (!ExternalResolveUtils.canDoExternalResolve(ref)) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(ref);
        return elements != null ? ExternalResolveUtils.chooseBestSymbol(elements, ref) : null;
    }

    @Nullable
    public static List<Pair<PsiFile, Integer>> resolveLocations(@NotNull PsiFile file, int offset) {
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        String url = file.getViewProvider().getVirtualFile().getUrl();
        Project project = file.getProject();
        for (OCExternalResolver resolver : OCExternalResolver.EP_NAME.getExtensionList()) {
            List<OCExternalResolver.Resolved> resolvedList = resolver.resolve(file, offset);
            if (ContainerUtil.isEmpty(resolvedList)) continue;
            return resolvedList.stream().map(resolved -> ExternalResolveUtils.toLocation(project, resolved, url)).filter(location -> location != null).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    public static Pair<PsiFile, Integer> resolveLocation(@NotNull PsiFile file, int offset) {
        List<Pair<PsiFile, Integer>> locations = ExternalResolveUtils.resolveLocations(file, offset);
        return !ContainerUtil.isEmpty(locations) ? locations.get(0) : null;
    }

    public static PsiElement @Nullable [] resolveElements(@NotNull PsiFile file, int offset) {
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(file, offset);
        return elements != null ? elements.toArray(PsiElement.EMPTY_ARRAY) : null;
    }

    public static PsiElement @Nullable [] resolveType(@NotNull PsiFile file, int offset) {
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalTypeResolve(file, offset);
        return elements != null ? elements.toArray(PsiElement.EMPTY_ARRAY) : null;
    }

    public static <T> T findCombined(@NotNull PsiReference ref, @NotNull Function<PsiReference, T> mainResolver, @NotNull Function<PsiReference, T> secondaryResolver) {
        VirtualFile file;
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isWriteAccessAllowed() && ExternalResolveUtils.canDoExternalResolve(ref) && (file = ExternalResolveUtils.getRefFile(ref)) != null) {
            return (T)ExternalResolveUtils.findInParallel(15L, () -> mainResolver.apply(ref), () -> secondaryResolver.apply(ref), false, true);
        }
        T mainResult = mainResolver.apply(ref);
        if (mainResult != null) {
            return mainResult;
        }
        return secondaryResolver.apply(ref);
    }

    public static <T> T findInParallel(long mainResolverTimeoutMs, @NotNull Callable<? extends T> mainResolver, @NotNull Callable<? extends T> fallbackResolver) {
        return ExternalResolveUtils.findInParallel(mainResolverTimeoutMs, mainResolver, fallbackResolver, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T findInParallel(long mainResolverTimeoutMs, @NotNull Callable<? extends T> mainResolver, @NotNull Callable<? extends T> fallbackResolver, boolean acceptNullFromMainResolver, boolean acceptNullFromFallbackResolver) {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        try {
            Object ex2;
            CompletableFuture<? extends T> mainResolveFuture = ExternalResolveUtils.onPooledThread(mainResolver, (ProgressIndicator)indicator);
            CompletableFuture<? extends T> fallbackResolveFuture = ExternalResolveUtils.onPooledThread(fallbackResolver, (ProgressIndicator)indicator);
            Object result = null;
            try {
                result = CidrConcurrentUtilsKt.waitCancelAware(mainResolveFuture, (long)mainResolverTimeoutMs, (String)"main resolver");
            }
            catch (ExecutionException ex2) {
                ExternalResolveUtils.rethrowIfNeeded(ex2);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex2.getMessage(), (Throwable)ex2);
            }
            catch (TimeoutException ex2) {
                // empty catch block
            }
            if (!(result == null || result instanceof Object[] && ((Object[])result).length <= 0)) {
                ex2 = result;
                return (T)ex2;
            }
            try {
                CidrConcurrentUtilsKt.waitCancelAware(CompletableFuture.anyOf(mainResolveFuture, fallbackResolveFuture), (String)"main or fallback resolver");
            }
            catch (ExecutionException ex3) {
                ExternalResolveUtils.rethrowIfNeeded(ex3);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex3.getMessage(), (Throwable)ex3);
            }
            result = ExternalResolveUtils.takeNonNullAndNotEmpty(CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture), CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture));
            if (result != null) {
                ex2 = result;
                return (T)ex2;
            }
            if (acceptNullFromMainResolver && CidrConcurrentUtilsKt.isCompletedNormally(mainResolveFuture)) {
                ex2 = CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture);
                return (T)ex2;
            }
            if (acceptNullFromFallbackResolver && CidrConcurrentUtilsKt.isCompletedNormally(fallbackResolveFuture)) {
                ex2 = CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture);
                return (T)ex2;
            }
            try {
                CidrConcurrentUtilsKt.waitCancelAware(CompletableFuture.allOf(mainResolveFuture, fallbackResolveFuture), (String)"main and fallback resolver");
            }
            catch (ExecutionException ex4) {
                ExternalResolveUtils.rethrowIfNeeded(ex4);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex4.getMessage(), (Throwable)ex4);
            }
            Object object = ExternalResolveUtils.takeNonNullAndNotEmpty(CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture), CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture));
            return (T)object;
        }
        finally {
            indicator.cancel();
        }
    }

    public static void assertFoundSameSymbol(@NotNull Project project, @Nullable OCSymbol clangSymbol, @NotNull Supplier<OCSymbol> clionResolver) {
    }

    public static void assertFoundSameElement(@Nullable PsiElement clangElement, @NotNull Supplier<PsiElement> clionResolver) {
    }

    @Nullable
    private static <T> T takeNonNullAndNotEmpty(@Nullable T first, @Nullable T second) {
        return first != null && (!(first instanceof Object[]) || ((Object[])first).length > 0) ? first : second;
    }

    private static void rethrowIfNeeded(@NotNull ExecutionException ex) {
        Throwable thr = ex.getCause();
        while (thr instanceof ExecutionException) {
            thr = thr.getCause();
        }
        if (thr instanceof ControlFlowException) {
            ExceptionUtil.rethrow((Throwable)thr);
        }
    }

    private static Predicate<OCSymbol> getSymbolsFilter(@NotNull PsiReference ref) {
        if (ref instanceof OCReferenceElement) {
            return sym -> sym != null && !(sym instanceof OCFunctionSymbol);
        }
        if (ref instanceof OCOperatorReference) {
            return sym -> sym instanceof OCFunctionSymbol && ((OCFunctionSymbol)sym).isCppOperator();
        }
        return sym -> true;
    }

    @Nullable
    private static OCSymbol chooseBestSymbol(@NotNull List<PsiElement> elements, @NotNull PsiReference ref) {
        Optional<OCSymbol> firstOperatorOrNone;
        if (ref instanceof OCReferenceElement) {
            Optional<OCSymbol> firstSymOrNone = ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).findFirst();
            if (firstSymOrNone.isPresent()) {
                OCClassSymbol definitionSymbolSymbol;
                OCInterfaceSymbol interfaceSymbol;
                OCSymbol firstSymbol = firstSymOrNone.get();
                if (firstSymbol instanceof OCStructSymbol) {
                    OCSymbol ctor = ExternalResolveUtils.runClionOverloadResolutionForStruct((OCReferenceElement)ref, (OCStructSymbol)firstSymbol);
                    if (ctor != null) {
                        return ctor;
                    }
                } else if (firstSymbol instanceof OCInterfaceSymbol && (interfaceSymbol = (OCInterfaceSymbol)firstSymbol).isPredeclaration() && (definitionSymbolSymbol = interfaceSymbol.getDefinitionSymbol(((OCReferenceElement)ref).getProject())) != null) {
                    return definitionSymbolSymbol;
                }
                return firstSymbol;
            }
        } else if (ref instanceof OCOperatorReference && (firstOperatorOrNone = ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).findFirst()).isPresent()) {
            return firstOperatorOrNone.get();
        }
        return ExternalResolveUtils.toSymbolStream(elements).filter(sym -> sym != null).findFirst().orElse(null);
    }

    @NotNull
    private static Stream<OCSymbol> toSymbolStream(@NotNull List<PsiElement> elements) {
        return elements.stream().filter(element -> element instanceof OCSymbolDeclarator).map(element -> ((OCSymbolDeclarator)element).getSymbol());
    }

    private static boolean canDoExternalResolve(@NotNull PsiReference ref) {
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(ref.getElement().getProject())) {
            return false;
        }
        return !OCElementUtil.isPartOfMacroSubstitution(ref.getElement());
    }

    public static boolean canDoExternalResolveRelaxed(@NotNull Project project) {
        if (PluginUtils.hasAppCode()) {
            return false;
        }
        int resolveProhibitedValue = ourResolveProhibited.get();
        if (resolveProhibitedValue > 0) {
            return false;
        }
        assert (resolveProhibitedValue == 0) : "Unexpected resolve prohibited value";
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        return !OCExternalResolver.EP_NAME.getExtensionList().isEmpty();
    }

    @Nullable
    private static List<PsiElement> doExternalResolve(@NotNull PsiReference ref) {
        PsiElement refElement = ref.getElement();
        PsiFile file = refElement.getContainingFile();
        if (file == null) {
            return null;
        }
        int offset = ref.getRangeInElement().getStartOffset() + refElement.getTextOffset();
        return ExternalResolveUtils.doExternalResolve(file, offset);
    }

    @NotNull
    private static List<PsiElement> handleResolvedList(@NotNull List<OCExternalResolver.Resolved> resolvedList, @NotNull Project project, @NotNull String url) {
        if (resolvedList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (OCExternalResolver.Resolved resolved : resolvedList) {
            PsiElement elem = ExternalResolveUtils.toPsi(project, resolved, url);
            if (elem == null) continue;
            psiElements.add(elem);
        }
        return psiElements;
    }

    @Nullable
    private static List<PsiElement> doExternalResolve(@NotNull PsiFile file, int offset) {
        return ExternalResolveUtils.doExternalResolveImpl(file, r -> r.resolve(file, offset));
    }

    @Nullable
    private static List<PsiElement> doExternalTypeResolve(@NotNull PsiFile file, int offset) {
        return ExternalResolveUtils.doExternalResolveImpl(file, r -> r.resolveType(file, offset));
    }

    @Nullable
    private static List<PsiElement> doExternalResolveImpl(@NotNull PsiFile file, @NotNull Function<OCExternalResolver, List<OCExternalResolver.Resolved>> resolveFun) {
        String url = file.getViewProvider().getVirtualFile().getUrl();
        Project project = file.getProject();
        for (OCExternalResolver resolver : OCExternalResolver.EP_NAME.getExtensionList()) {
            List<PsiElement> psiElements;
            List<OCExternalResolver.Resolved> resolvedList = resolveFun.apply(resolver);
            if (ContainerUtil.isEmpty(resolvedList) || (psiElements = ExternalResolveUtils.handleResolvedList(resolvedList, project, url)).isEmpty()) continue;
            return psiElements;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getRefFile(@NotNull PsiReference ref) {
        PsiElement refElement = ref.getElement();
        PsiFile file = refElement.getContainingFile();
        if (file == null) {
            return null;
        }
        return file.getViewProvider().getVirtualFile();
    }

    @Nullable
    public static Pair<PsiFile, Integer> toLocation(@NotNull Project project, @NotNull OCExternalResolver.Resolved sym, @NotNull String requestFileUrl) {
        String path = sym.uri.getPath();
        VirtualFile targetVirtualFile = CidrLangUtil.findBestFile((Project)project, (String)path, (int)sym.line, vf -> OCSearchScope.isInProjectSourcesOrLibraries(project, vf));
        if (targetVirtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(targetVirtualFile);
        if (document == null) {
            return null;
        }
        PsiFile targetPsiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (targetPsiFile == null) {
            return null;
        }
        if (sym.line >= document.getLineCount()) {
            StringBuilder message = new StringBuilder("Requested line ").append(sym.line).append(" of ").append(document.getLineCount()).append(" in ").append(targetVirtualFile.getUrl()).append(" when looking for resolved ").append(sym);
            message.append("; ");
            message.append("request file was ").append(requestFileUrl);
            throw new IndexOutOfBoundsException(message.toString());
        }
        int offset = document.getLineStartOffset(sym.line) + sym.column;
        return Pair.create((Object)targetPsiFile, (Object)offset);
    }

    @Nullable
    public static PsiElement toPsi(@NotNull Project project, @NotNull OCExternalResolver.Resolved sym, @NotNull String requestFileUrl) {
        Pair<PsiFile, Integer> location = ExternalResolveUtils.toLocation(project, sym, requestFileUrl);
        if (location == null) {
            return null;
        }
        return ExternalResolveUtils.findAppropriateElement((PsiFile)location.getFirst(), (Integer)location.getSecond());
    }

    @Nullable
    public static PsiElement findAppropriateElement(@NotNull PsiFile file, int offset) {
        String idName;
        PsiElement clangElement = file.findElementAt(offset);
        if (clangElement == null) {
            return null;
        }
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)clangElement, OCMacroCall.class);
        if (macroCall != null && clangElement instanceof LeafPsiElement && ((LeafPsiElement)clangElement).getElementType() == OCTokenTypes.IDENTIFIER && !StringUtil.isEmpty((String)(idName = OCElementUtil.getIdentifierName(clangElement)))) {
            for (ForeignLeafPsiElement foreignLeaf : PsiTreeUtil.findChildrenOfType((PsiElement)macroCall.getNextSibling(), ForeignLeafPsiElement.class)) {
                if (foreignLeaf.getElementType() != OCTokenTypes.IDENTIFIER || !idName.contentEquals(OCElementUtil.getIdentifierName(clangElement))) continue;
                clangElement = foreignLeaf;
                break;
            }
        }
        if (clangElement instanceof OCSymbolDeclarator) {
            return clangElement;
        }
        if (clangElement.getParent() instanceof OCSymbolDeclarator) {
            return clangElement.getParent();
        }
        if (clangElement instanceof LeafPsiElement && OCTokenTypes.KEYWORDS.contains(((LeafPsiElement)clangElement).getElementType()) && clangElement.getParent() instanceof OCDeclaration) {
            OCDeclaration decl = (OCDeclaration)clangElement.getParent();
            List<OCDeclarator> declarators = decl.getDeclarators();
            PsiElement bestElement = null;
            for (OCDeclarator declarator : declarators) {
                if (bestElement == null) {
                    bestElement = declarator;
                    continue;
                }
                if (!declarator.getTextRange().contains(offset)) continue;
                bestElement = declarator;
            }
            if (bestElement == null && decl.getTypeElement() != null) {
                OCTypeElement typeElement = decl.getTypeElement();
                for (PsiElement child : typeElement.getChildren()) {
                    if (!(child instanceof OCSymbolDeclarator)) continue;
                    bestElement = child;
                    break;
                }
            }
            return bestElement != null ? bestElement : clangElement;
        }
        return clangElement;
    }

    @Nullable
    public static PsiElement clangdCompletionItem2PsiElement(@NotNull Project project, @NotNull ClangdBridgeCompletionItem item) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (item.getFromFile() == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)item.getFromFile()));
        if (virtualFile == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiManager.getProject()).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        int offset = item.getFromFileOffset();
        if (offset < 0) {
            return null;
        }
        try {
            String rawContent = new String(virtualFile.contentsToByteArray(), virtualFile.getCharset());
            LineColumn lineCol = StringUtil.offsetToLineColumn((CharSequence)rawContent, (int)offset);
            if (lineCol != null) {
                offset = StringUtil.lineColToOffset((CharSequence)document.getCharsSequence(), (int)lineCol.line, (int)lineCol.column);
            }
        }
        catch (IOException ignored) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        return ExternalResolveUtils.findAppropriateElement(psiFile, offset);
    }

    @Nullable
    private static OCSymbol runClionOverloadResolutionForStruct(@NotNull OCReferenceElement referenceElement, @NotNull OCStructSymbol clangSymbol) {
        Ref argumentsRef;
        Ref argsRef;
        OCStructType type = new OCStructType(clangSymbol);
        if (type.isEnum() || type.isEnumClass()) {
            return null;
        }
        OCResolveContext context = OCResolveContext.forPsi(referenceElement);
        if (!OCReferenceElementImpl.findArgumentsFromContext(referenceElement, context, (Ref<List<OCExpression>>)(argsRef = Ref.create()), (Ref<OCArgumentsList<OCExpression>>)(argumentsRef = Ref.create()))) {
            return null;
        }
        return OCReferenceElementImpl.resolveToConstructors(referenceElement, Collections.singleton(clangSymbol), type, (OCArgumentsList)argumentsRef.get(), context);
    }

    @NotNull
    private static String toMessageWithRef(@NotNull Throwable original, @NotNull PsiReference ref) {
        try {
            PsiElement element = ref.getElement();
            PsiFile file = element.getContainingFile();
            return "When resolving " + OCElementUtil.getElementDebugName(element) + " at " + file.getName() + ":" + (element.getTextOffset() + ref.getRangeInElement().getStartOffset()) + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            return original.getMessage();
        }
    }

    @NotNull
    private static String toMessageWithOffset(@NotNull Throwable original, @NotNull PsiFile file, int offset) {
        try {
            return "When resolving " + file.getName() + ":" + offset + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            return original.getMessage();
        }
    }

    @NotNull
    private static <T> CompletableFuture<T> onPooledThread(@NotNull Callable<? extends T> task, @NotNull ProgressIndicator indicator) {
        CompletableFuture result = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> ReadAction.run(() -> {
            try {
                ProgressManager.checkCanceled();
                result.complete(task.call());
            }
            catch (Throwable thr) {
                result.completeExceptionally(thr);
            }
        }), indicator));
        return result;
    }
}

