/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCProblemGroup
implements SuppressableProblemGroup {
    @Nullable
    private final String myProblemName;
    @Nullable
    private OCSuppressionGroup mySuppressGroup;
    private List<SuppressIntentionAction> mySuppressActions;

    public OCProblemGroup(@Nullable String problemName) {
        this.myProblemName = problemName;
    }

    public OCProblemGroup(@Nullable String problemName, @Nullable OCSuppressionGroup suppressionGroup, @Nullable OCFile file, @NotNull TextRange range) {
        this.myProblemName = problemName;
        this.mySuppressGroup = suppressionGroup;
        this.mySuppressActions = new ArrayList<OCSuppressClangDiagnosticIntentionAction>(Arrays.asList(new OCSuppressClangDiagnosticIntentionAction[]{new OCSuppressClangForStatement(file, range, suppressionGroup), new OCSuppressClangForCallable(file, range, suppressionGroup), new OCSuppressClangForFile(file, range, suppressionGroup)}));
    }

    @Nullable
    public String getProblemName() {
        return this.myProblemName;
    }

    @Nullable
    public String getSuppressOption() {
        return this.mySuppressGroup == null ? null : this.mySuppressGroup.suppressionOption;
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(@Nullable PsiElement element) {
        if (this.mySuppressActions != null) {
            return this.mySuppressActions.toArray(SuppressIntentionAction.EMPTY_ARRAY);
        }
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    public void addSuppressAction(@NotNull SuppressIntentionAction action) {
        if (this.mySuppressActions != null) {
            this.mySuppressActions.add(action);
        } else {
            this.mySuppressActions = new ArrayList<SuppressIntentionAction>(Collections.singletonList(action));
        }
    }
}

