/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.OCImplementationChecker;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCDeclareSpecificMethodInPrivateCategoryAction;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionAssociation;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSynchronizedStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeARCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodSignatureIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodStaticnessIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCDeclareMethodInInterfaceAction;
import com.jetbrains.cidr.lang.quickfixes.OCDeclareMethodInTargetInterfaceAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementMissingAccessorQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMigrateToARCIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRenameSymbolIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.resolve.references.OCCompositeResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCFileResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCObjCAnnotator
extends OCAnnotator {
    @NotNull
    private final OCImplementationChecker myImplementationChecker = new OCImplementationChecker(this);

    @Override
    protected boolean isEnabled(@NotNull PsiFile file) {
        return false;
    }

    public void visitElement(@NotNull PsiElement element) {
        Project project;
        OCClassSymbol definitionSymbol;
        OCClassSymbol symbol;
        PsiElement parent = element.getParent();
        if (!(parent instanceof OCClassDeclaration) || element != ((OCClassDeclaration)parent).getNameIdentifier()) {
            return;
        }
        if (parent instanceof OCInterface) {
            if (this.checkDuplicates((OCInterface)parent)) {
                this.myImplementationChecker.checkInterfaceDeclaration((OCInterface)parent);
            }
        } else if (parent instanceof OCImplementation) {
            if (this.checkDuplicates((OCImplementation)parent)) {
                this.myImplementationChecker.checkInterfaceImplementation((OCImplementation)parent);
            }
        } else if (parent instanceof OCProtocol) {
            if (this.checkDuplicates((OCProtocol)parent)) {
                this.myImplementationChecker.checkProtocolDeclaration((OCProtocol)parent);
            }
        } else if (parent instanceof OCClassPredeclaration && (symbol = ((OCClassPredeclaration)parent).getSymbol()) != null && (definitionSymbol = symbol.getDefinitionSymbol(project = element.getProject())) == null && OCCodeInsightUtil.isValid((PsiElement)element.getContainingFile())) {
            Annotation annotation = this.addWarningAnnotation(((OCClassPredeclaration)parent).getNameIdentifier(), OCInspections.NoClassDefinition.class, "warn_undef_protocolref", "Can't find " + symbol.getNameWithKindLowercase(OCCompilationContext.create(element)) + " in the project and external files");
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.INTERFACE, element, null, symbol.getName(), null));
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROTOCOL, element, null, symbol.getName(), null));
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, project));
        }
    }

    @Override
    public void visitSynthesizeProperty(OCSynthesizeProperty property) {
        super.visitSynthesizeProperty(property);
        this.myImplementationChecker.checkSynthesize(property);
    }

    @Override
    public void visitMethod(OCMethod method) {
        super.visitMethod(method);
        List<PsiElement> selectors = method.getSelectors();
        this.checkDuplicates(method.getSelector(), method, selectors);
        OCType returnType = method.getReturnType().resolve(method);
        OCMethodSymbol symbol = (OCMethodSymbol)method.getSymbol();
        if (!returnType.isVoid()) {
            this.checkInstanceable(returnType, method.getReturnTypeElement(), symbol, true);
        }
        if (symbol == null) {
            return;
        }
        if (!(symbol.getParent() instanceof OCImplementationSymbol)) {
            this.checkReadonlyAccess(selectors, symbol, "Declaring", method.getProject());
        }
        if (symbol.isDefinition() && OCCompilerFeaturesHelper.supportsAutosynthesis(method.getContainingOCFile())) {
            OCPropertySymbol property;
            Project project = method.getProject();
            OCMethodSymbol associatedSymbol = symbol.getAssociatedSymbol(project);
            OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            if (property != null && !property.isReadonly() && property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ATOMIC, property.getType(), method) != OCPropertySymbol.PropertyAttribute.NONATOMIC && property.processAccessorMethods((Processor<? super OCMethodSymbol>)new Processor<OCMethodSymbol>(){
                int cnt;

                public boolean process(OCMethodSymbol symbol) {
                    return ++this.cnt < 2;
                }
            }, false, project)) {
                OCResolveContext context = OCResolveContext.forPsi(method);
                String message = "Writable atomic " + property.getNameWithKindLowercase(context) + " can't have a" + (symbol.isGetter(context) ? " defined getter and a synthesized setter" : " synthesized getter and a defined setter");
                List annotations = this.addWarningAnnotations(selectors, OCInspections.AccessorsWereOverridden.class, "warn_atomic_property_rule", message);
                this.registerQuickFixes(annotations, new OCImplementMissingAccessorQuickFix(property, symbol.isGetter(context), project));
                this.registerQuickFixes(annotations, new OCChangePropertyAttributeIntentionAction(property, OCPropertySymbol.PropertyAttribute.ATOMIC, OCPropertySymbol.PropertyAttribute.NONATOMIC, null, project));
                this.registerQuickFixes(annotations, new OCRemoveElementsIntentionAction((PsiElement)method, "Remove user-defined " + (symbol.isGetter(context) ? "getter" : "setter") + " method"));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        void var6_14;
        ArrayList<Object> quickFixes;
        ProblemHighlightType highlightType;
        boolean isError;
        boolean isInfo;
        String clangID;
        Object message;
        block23: {
            OCExpression oCExpression;
            Iterator<OCMessageArgument> iterator2;
            ArrayList<OCType> argumentTypes;
            ArrayList<OCExpression> expressions;
            ArrayList<String> selectors;
            OCType returnExpectedType;
            OCResolveContext context;
            OCObjectType receiverType;
            String selector;
            block21: {
                OCMethodSymbol firstResponder;
                block26: {
                    block25: {
                        block24: {
                            block22: {
                                this.checkSendMessageExpression(expression);
                                if (expression.getArguments().size() == 0) {
                                    return;
                                }
                                OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
                                selector = expression.getMessageSelector();
                                receiverType = responders.getReceiverType();
                                OCClassSymbol clazz = receiverType != null ? receiverType.getClassSymbol() : null;
                                Object var6_6 = null;
                                message = null;
                                clangID = null;
                                isInfo = false;
                                isError = false;
                                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                                quickFixes = new ArrayList<Object>();
                                context = OCResolveContext.forPsi(expression);
                                if (responders.getAllResponders().isEmpty()) {
                                    if (receiverType != null) {
                                        OCExpression receiver;
                                        message = "Cannot resolve method '" + selector + "'" + (String)(clazz != null ? " for " + clazz.getNameWithKindLowercase(OCCompilationContext.create(clazz, expression.getProject())) : "");
                                        Class<OCInspections.UnresolvedMessage> clazz2 = OCInspections.UnresolvedMessage.class;
                                        clangID = "CIDR";
                                        isError = true;
                                        returnExpectedType = OCExpectedTypeUtil.getExpectedType(expression, true, context);
                                        if (returnExpectedType == OCUnknownType.INSTANCE) {
                                            returnExpectedType = OCVoidType.instance();
                                        }
                                        if ((receiver = expression.getReceiverExpression()) instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null) {
                                            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, OCClassDeclaration.class);
                                            OCClassSymbol oCClassSymbol = classDeclaration != null ? classDeclaration.getSymbol() : null;
                                        } else {
                                            OCInterfaceSymbol oCInterfaceSymbol = receiverType.getInterface();
                                        }
                                        String signature2 = expression.getExpectedMethodSignature(context);
                                        if (signature2 != null) {
                                            void var16_29;
                                            quickFixes.add(new OCCreateNewDefinitionIntentionAction(expression, (OCSymbol)var16_29, signature2.charAt(0) + expression.getMessageSelector(), signature2, returnExpectedType.resolve(expression), receiverType));
                                        }
                                        selectors = new ArrayList<String>();
                                        expressions = new ArrayList<OCExpression>();
                                        argumentTypes = new ArrayList<OCType>();
                                        iterator2 = expression.getArguments().iterator();
                                        break block21;
                                    } else {
                                        OCExpression receiverExpression = expression.getReceiverExpression();
                                        OCType type = receiverExpression != null ? receiverExpression.getResolvedType() : null;
                                        if (type == null) return;
                                        if (type.getTerminalType().isUnknown()) return;
                                        message = "Can't send messages to expressions of type '" + type.getName(receiverExpression) + "'";
                                        if (!type.isPointerCompatible(OCResolveContext.forPsi(expression))) {
                                            this.addErrorAnnotation(receiverExpression, "err_bad_receiver_type", (String)message);
                                            return;
                                        }
                                        if (OCCompilerFeaturesHelper.isArcEnabled(receiverExpression.getContainingFile())) {
                                            this.addErrorAnnotation(receiverExpression, "err_bad_receiver_type", (String)message);
                                            return;
                                        }
                                        this.addWarningAnnotation(receiverExpression, OCInspections.IncompatiblePointers.class, "warn_bad_receiver_type", (String)message);
                                        return;
                                    }
                                }
                                List<OCMethodSymbol> filteredResponders = responders.getFilteredByStaticnessResponders();
                                OCMethodSymbol oCMethodSymbol = firstResponder = filteredResponders.isEmpty() ? null : filteredResponders.get(0);
                                if (OCObjCAnnotator.haveSingleRoot(filteredResponders, expression.getProject())) break block22;
                                message = "Message '" + selector + "' can be resolved to several methods";
                                Class<OCInspections.SeveralTargetsMessage> clazz3 = OCInspections.SeveralTargetsMessage.class;
                                clangID = "CIDR";
                                isInfo = true;
                                break block23;
                            }
                            if (firstResponder == null || !firstResponder.isForbiddenByARC(expression)) break block24;
                            Annotation annotation = this.addErrorAnnotation(expression, OCInspections.ARCIssues.class, "CIDR", "Explicit usage of '" + selector + "' is forbidden in ARC");
                            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction(expression));
                            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction(expression.getContainingOCFile()));
                            break block23;
                        }
                        if (firstResponder == null || !firstResponder.isUnavailable()) break block25;
                        message = firstResponder.getUnavailableMessage(context);
                        Class<OCInspections.DeprecatedApi> clazz = OCInspections.DeprecatedApi.class;
                        clangID = "CIDR";
                        isError = true;
                        break block23;
                    }
                    if (firstResponder == null || !firstResponder.isDeprecated()) break block26;
                    message = firstResponder.getDeprecatedMessage(context);
                    Class<OCInspections.DeprecatedApi> clazz = OCInspections.DeprecatedApi.class;
                    clangID = "warn_deprecated";
                    highlightType = ProblemHighlightType.LIKE_DEPRECATED;
                    break block23;
                }
                if (firstResponder != null) {
                    void var6_12;
                    message = OCResolveUtil.checkAvailability(firstResponder, expression);
                    if (message != null) {
                        Class<OCInspections.UnavailableInDeploymentTarget> clazz = OCInspections.UnavailableInDeploymentTarget.class;
                        clangID = "CIDR";
                        highlightType = ProblemHighlightType.LIKE_DEPRECATED;
                    }
                    if (var6_12 == null && !OCResolveUtil.isEarlierInCode((OCSymbol)firstResponder, expression)) {
                        OCClassSymbol curClass;
                        OCClassDeclaration oCClassDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, OCClassDeclaration.class);
                        OCClassSymbol oCClassSymbol = curClass = oCClassDeclaration != null ? oCClassDeclaration.getSymbol() : null;
                        if (!Comparing.equal((Object)curClass, (Object)firstResponder.getParent())) {
                            message = "Method '" + selector + "' is declared in another category/implementation later in the scope";
                        } else if (!OCCompilerFeaturesHelper.supportsLaterMethodDeclaration()) {
                            message = "Method '" + selector + "' is declared later in the scope";
                            quickFixes.add(new OCMoveDefinitionIntentionAction(OCSymbolKind.METHOD, expression, null, firstResponder, " above"));
                            quickFixes.add(new OCDeclareSpecificMethodInPrivateCategoryAction(firstResponder.getParent(), firstResponder));
                        }
                        Class<OCInspections.MethodIsLaterInTheScope> clazz = OCInspections.MethodIsLaterInTheScope.class;
                        quickFixes.add(new OCDeclareMethodInInterfaceAction(firstResponder));
                    }
                }
                break block23;
            }
            while (iterator2.hasNext()) {
                OCMessageArgument argument = iterator2.next();
                selectors.add(argument.getArgumentSelector().getSelectorName());
                OCExpression oCExpression2 = argument.getArgumentExpression();
                expressions.add(oCExpression2);
                argumentTypes.add(oCExpression2 != null ? OCExpectedTypeUtil.getExpressionType(oCExpression2, true) : null);
            }
            OCMethodSymbol similarResponder = OCObjectTypeContext.findSimilarResponder(receiverType, selectors, argumentTypes, expression);
            if (similarResponder != null) {
                quickFixes.add(new OCChangeMethodSignatureIntentionAction(similarResponder, argumentTypes, selectors, expressions, context));
            }
            OCObjectTypeContext receiverContext = expression.getReceiverContext();
            if (OCNameSuggester.isObjCGetter(selector) && (receiverContext == null || receiverContext.getStaticMode() != OCObjectTypeContext.StaticMode.STATIC)) {
                OCType oCType = returnExpectedType.isVoid() ? OCIdType.pointerToID() : returnExpectedType;
                quickFixes.add(new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROPERTY, expression, receiverType.getInterface(), selector, oCType));
            }
            if (OCNameSuggester.isObjCSetter(selector) && OCElementUtil.startsWithWord(selector, "set") && expression.getArguments().size() == 1 && (oCExpression = expression.getArguments().get(0).getArgumentExpression()) != null) {
                String name = OCNameSuggester.getObjCGetterFromSetter(selector);
                quickFixes.add(new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROPERTY, expression, receiverType.getInterface(), name, oCExpression.getResolvedType()));
            }
        }
        if (message == null) return;
        Annotation annotation = isError ? this.addErrorAnnotation(expression, (Class)var6_14, clangID, (String)message) : this.addWarningAnnotation(expression, (Class<? extends OCInspection>)var6_14, clangID, (String)message, isInfo ? ProblemHighlightType.WEAK_WARNING : highlightType);
        Iterator iterator3 = quickFixes.iterator();
        while (iterator3.hasNext()) {
            IntentionAction intentionAction = (IntentionAction)iterator3.next();
            this.registerQuickFix(annotation, intentionAction);
        }
    }

    public void checkSendMessageExpression(OCSendMessageExpression expr) {
        OCSendMessageExpression.ProbableResponders responders = expr.getProbableResponders();
        OCExpression receiver = expr.getReceiverExpression();
        if (expr.getArguments().size() == 0) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_message_selector_missing", "Message selector expected");
            return;
        }
        if (responders.isStaticnessMismatch()) {
            String message = responders.isStaticContext() ? "Instance method is called from the class context" : "Class method is called from the instance context";
            Annotation annotation = this.addErrorAnnotation(expr, OCInspections.StaticnessMismatch.class, "CIDR", message);
            if (responders.getAllResponders().size() == 1) {
                OCMethodSymbol methodSymbol;
                OCMethodSymbol responder = responders.getAllResponders().get(0);
                this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(responder, responders.isStaticContext(), expr.getProject()));
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (receiver instanceof OCReferenceExpression && containingMethod != null && ((OCReferenceExpression)receiver).getSelfSuperToken() != null && (methodSymbol = (OCMethodSymbol)containingMethod.getSymbol()) != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(methodSymbol, !responders.isStaticContext(), expr.getProject()));
                }
            }
            return;
        }
        OCMethodSymbol knownResponder = responders.getKnownResponder();
        if (knownResponder != null && expr.isVarargCall() && !knownResponder.isVararg()) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_not_vararg_method", knownResponder.getNameWithKindUppercase(OCCompilationContext.create(knownResponder, expr.getProject())) + " is not a vararg method");
            return;
        }
        String messageSelector = expr.getMessageSelector();
        OCMethodSymbol target = OCObjCAnnotator.findTargetMethod(expr, responders.getFilteredByStaticnessResponders());
        if (target == null) {
            return;
        }
        this.checkResponderIsKnown(expr, responders, target);
        this.checkSendMessageArguments(expr, target);
        Project project = expr.getProject();
        if (!OCCompilerFeaturesHelper.isArcEnabled(expr.getContainingFile())) {
            if (messageSelector.equals("dealloc")) {
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (containingMethod != null && containingMethod.getSelector().equals("dealloc") && receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER) {
                    return;
                }
                Annotation annotation = this.addWarningAnnotation(expr, OCInspections.CallDealloc.class, "CIDR", "Sending 'dealloc' directly");
                int selectorOffset = expr.getArgumentSelectors().get(0).getTextOffset();
                String message = "Send \"release\" message instead of \"dealloc\"";
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(expr.getContainingFile(), selectorOffset, "dealloc".length(), "release", message));
            } else if (OCElementUtil.isReleaseSelector(messageSelector)) {
                OCSymbol receiverSymbol = null;
                if (receiver instanceof OCReferenceExpression) {
                    receiverSymbol = ((OCReferenceExpression)receiver).resolveToSymbol();
                } else if (receiver instanceof OCQualifiedExpression) {
                    receiverSymbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
                }
                if (receiverSymbol instanceof OCInstanceVariableSymbol) {
                    receiverSymbol = ((OCInstanceVariableSymbol)receiverSymbol).getAssociatedProperty(project);
                }
                if (receiverSymbol instanceof OCPropertySymbol && !((OCPropertySymbol)receiverSymbol).isReadonly() && ((OCPropertySymbol)receiverSymbol).getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, receiverSymbol.getResolvedType(OCResolveContext.forPsi(expr)), expr) == OCPropertySymbol.PropertyAttribute.ASSIGN) {
                    Annotation annotation = this.addWarningAnnotation(expr, OCInspections.ReleasingOfAssignProperties.class, "CIDR", "Releasing of the property with 'assign' attribute");
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.RETAIN, null, project));
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.COPY, null, project));
                }
            }
        }
        this.checkReadonlyAccess(expr.getArgumentSelectors(), target, "Calling", project);
    }

    private boolean checkReadonlyAccess(List<? extends PsiElement> elements, OCMethodSymbol symbol, String accessKind, @NotNull Project project) {
        String getter;
        OCClassSymbol parent = symbol.getParent().getInterfaceOrProtocol(project);
        if (parent == null) {
            return true;
        }
        CommonProcessors.FindFirstProcessor propFinder = new CommonProcessors.FindFirstProcessor();
        if (symbol.isSetter(OCResolveContext.forSymbol(symbol, project)) && (getter = OCNameSuggester.getObjCGetterFromSetter(symbol.getName())) != null) {
            parent.processMembers(getter, OCPropertySymbol.class, propFinder);
        }
        if (propFinder.isFound() && ((OCPropertySymbol)propFinder.getFoundValue()).isReadonly()) {
            OCClassSymbol classSymbol;
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)elements.get(0), (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && parent.equals(classSymbol.getInterface(project))) {
                return true;
            }
            String message = accessKind + " the setter method for readonly " + ((OCPropertySymbol)propFinder.getFoundValue()).getNameWithKindLowercase(OCCompilationContext.create(parent, project));
            List annotations = this.addWarningAnnotations(elements, OCInspections.SetterForReadonlyProperty.class, "CIDR", message);
            this.registerQuickFixes(annotations, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)propFinder.getFoundValue(), OCPropertySymbol.PropertyAttribute.READONLY, null, null, project));
            return false;
        }
        return true;
    }

    private void checkSendMessageArguments(OCSendMessageExpression expr, OCMethodSymbol target) {
        List<OCMessageArgument> arguments = expr.getArguments();
        boolean requiresNil = OCType.isFunctionRequiringNil(target);
        if (requiresNil && arguments.size() > 0) {
            String text;
            OCMessageArgument lastArgument = arguments.get(arguments.size() - 1);
            OCExpression expression = lastArgument.getArgumentExpression();
            String string = text = expression != null ? expression.getTextWithMacros() : null;
            if (!OCCodeInsightUtil.isLikeNull(text)) {
                Annotation annotation = this.addWarningAnnotation(lastArgument, OCInspections.LastArgumentMustBeNull.class, "CIDR", "Last argument must be \"nil\"");
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(lastArgument.getContainingOCFile(), lastArgument.getTextRange().getEndOffset(), 0, ", nil", "Append \"nil\" argument"));
            }
        }
    }

    private void checkResponderIsKnown(OCSendMessageExpression expr, OCSendMessageExpression.ProbableResponders responders, OCMethodSymbol target) {
        OCInterfaceSymbol receiverClass;
        OCFile file = expr.getContainingOCFile();
        OCExpression receiver = expr.getReceiverExpression();
        OCObjectType receiverType = responders.getReceiverType();
        OCType receiverOriginalType = responders.getReceiverOriginalType();
        OCInterfaceSymbol oCInterfaceSymbol = receiverClass = receiverType != null ? receiverType.getInterface() : null;
        if (responders.getKnownResponder() != null) {
            return;
        }
        OCCompilationContext context = OCCompilationContext.create(expr);
        Project project = expr.getProject();
        if (receiverClass != null && receiverClass.isPredeclaration()) {
            String message = receiverClass.getNameWithKindUppercase(context) + " definition is not visible";
            Annotation annotation = this.addErrorAnnotation(receiver, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", message);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, receiverClass.getDefinitionSymbol(project)));
        } else if (receiverType instanceof OCIdType || receiverOriginalType != null && receiverOriginalType.isClassType()) {
            if (!OCFileSymbols.isSymbolImported(file, target.getParent())) {
                Annotation annotation = this.addErrorAnnotation(expr, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", target.getNameWithKindUppercase(context) + " is not visible");
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, target.getParent()));
            }
        } else {
            OCClassSymbol containingClassSymbol;
            boolean isSameClassName = receiverClass != null && receiverClass.getName().equals(target.getParent().getName());
            String message = receiverClass != null && !isSameClassName && target.getParent().isSubclass(receiverClass, project) ? target.getNameWithKindUppercase(context) + " is defined in subclass '" + target.getParent().getPresentableName() + "'" : target.getNameWithKindUppercase(context) + " is defined in class '" + target.getParent().getPresentableName() + "' and is not visible";
            Annotation annotation = OCCompilerFeaturesHelper.isArcEnabled(file) ? this.addErrorAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message) : this.addWarningAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, target.getParent()));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            OCClassSymbol oCClassSymbol = containingClassSymbol = containingClass != null ? containingClass.getSymbol() : null;
            if (receiverClass != null) {
                this.registerQuickFix(annotation, new OCDeclareMethodInTargetInterfaceAction(receiverClass, target, project));
                if (receiver != null && !isSameClassName) {
                    OCPointerType targetType = OCPointerType.to(target.getParent().getType().resolve(expr));
                    this.registerQuickFix(annotation, new OCInsertCastIntentionAction(receiver, targetType));
                    OCChangeTypeIntentionAction.registerChangeTypeFix(receiver, targetType, annotation, this);
                    this.registerQuickFix(annotation, new OCConvertTypeIntentionAction(receiver, targetType));
                    OCExpression inner = OCParenthesesUtils.diveIntoParentheses(receiver);
                    if (inner != null) {
                        this.registerQuickFix(annotation, new OCConvertLiteralIntentionAction(inner, targetType, receiverType));
                    }
                }
            }
            if (receiverClass != null && containingClassSymbol != null && receiverClass.getImplementation(project) == containingClassSymbol) {
                this.registerQuickFix(annotation, new OCDeclareSpecificMethodInPrivateCategoryAction(receiverClass, target));
            }
        }
    }

    private static boolean haveSingleRoot(List<OCMethodSymbol> methods, @NotNull Project project) {
        if (methods.size() <= 1) {
            return true;
        }
        HashSet<OCMethodSymbol> set = new HashSet<OCMethodSymbol>(methods);
        OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(methods.get(0), project);
        parameters.setInheritors(true);
        parameters.setAncestors(true);
        parameters.setIncludeSelfImplementation(true);
        OCMemberInheritorsSearch.search(parameters).forEach(method -> {
            set.remove(method);
            return true;
        });
        return set.isEmpty();
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        super.visitMethodSelectorPart(part);
        this.checkDeclarator(part.getType().resolve(part), part.getType(), part, null, part.getLocalSymbol());
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression stmt) {
        OCSymbolContext context;
        String message;
        Annotation annotation;
        OCObjectType type;
        String selector;
        OCSendMessageExpression sendMessageExpression;
        if (stmt.getParent() instanceof OCMessageArgument && (sendMessageExpression = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCSendMessageExpression.class)) != null && ("respondsToSelector:".equals(selector = sendMessageExpression.getMessageSelector()) || "instancesRespondToSelector:".equals(selector))) {
            return;
        }
        OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCClassDeclaration.class);
        OCClassSymbol parent = classDeclaration != null ? classDeclaration.getSymbol() : null;
        OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(stmt);
        OCObjectType oCObjectType = type = targetContext != null ? targetContext.getType() : null;
        if (!(type == null || parent != null && parent.getName().equals(type.getClassSymbol().getName()))) {
            parent = type.getClassSymbol();
        }
        if ((annotation = this.checkReferences(stmt, message = type != null ? "Type '" + type.getName(stmt) + "' doesn't have the method" : "Cannot find the method", new OCSymbolGroupContext(context = new OCSymbolContext(null, OCSymbolKind.METHOD, parent)), null, OCInspections.UnresolvedMessage.class)) != null) {
            ArrayList<String> selectors = new ArrayList<String>();
            ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
            ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
            String selector2 = stmt.getSelector();
            int pos = selector2.indexOf(58);
            if (pos != -1) {
                int prevPos = 0;
                while (pos != -1) {
                    selectors.add(selector2.substring(prevPos, pos + 1));
                    expressions.add(null);
                    argumentTypes.add(null);
                    prevPos = pos + 1;
                    pos = selector2.indexOf(58, prevPos);
                }
            } else {
                selectors.add(selector2);
                expressions.add(null);
            }
            OCMethodSymbol similarResponder = OCObjectTypeContext.findSimilarResponder(type, selectors, argumentTypes, stmt);
            if (similarResponder != null) {
                argumentTypes.replaceAll(t -> OCIdType.pointerToID());
                this.registerQuickFix(annotation, new OCChangeMethodSignatureIntentionAction(similarResponder, argumentTypes, selectors, expressions, OCCompilationContext.create(stmt)));
            }
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(stmt, context.getParent(), "-" + selector2, stmt.getExpectedMethodSignature(), stmt.getExpectedReturnType(), type));
        }
    }

    @Override
    public void visitReferenceElement(OCReferenceElement referenceElement) {
        super.visitReferenceElement(referenceElement);
        OCSymbol symbol = referenceElement.resolveToSymbol();
        if (symbol instanceof OCInstanceVariableSymbol || symbol instanceof OCPropertySymbol) {
            OCResolveContext context = OCResolveContext.forPsi(referenceElement);
            PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{OCMethod.class, OCSynthesizeProperty.class});
            if (parent == null) {
                this.addErrorAnnotation(referenceElement, OCInspections.ConstructionIsNotAllowed.class, "CIDR", symbol.getNameWithKindUppercase(context) + " is accessed outside of a method");
            } else if (parent instanceof OCMethod && !((OCMethod)parent).isInstanceMethod()) {
                Annotation annotation = this.addErrorAnnotation(referenceElement, OCInspections.StaticnessMismatch.class, OCClangMessageFinder.getInstance().getIvarUseInClassMethod(), symbol.getNameWithKindUppercase(context) + " is accessed from the class method");
                OCMethodSymbol methodSymbol = (OCMethodSymbol)((OCMethod)parent).getSymbol();
                if (methodSymbol != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(methodSymbol, false, context.getProject()));
                }
            }
        }
        this.highlightDeprecatedAPI(referenceElement, referenceElement.resolveToSymbol());
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expr) {
        super.visitReferenceExpression(expr);
        PsiElement nonParenthesizedParent = expr.getParent();
        while (nonParenthesizedParent instanceof OCParenthesizedExpression) {
            nonParenthesizedParent = nonParenthesizedParent.getParent();
        }
        OCElementTypes.SelfSuperToken token = expr.getSelfSuperToken();
        if (token != null) {
            OCMethod method;
            if (new OCReadWriteAccessDetector().getExpressionAccess(expr) == ReadWriteAccessDetector.Access.Write && (method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, OCMethod.class)) != null && !method.getSelector().startsWith("init")) {
                this.addErrorAnnotation(expr, OCInspections.NotAssignable.class, "err_typecheck_arc_assign_self", "Assignment to self is allowed only in init methods");
                return;
            }
            if (token == OCElementTypes.SelfSuperToken.SELF) {
                return;
            }
            OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            if (clazz == null) {
                return;
            }
            OCObjectType type = clazz.getType();
            if (type != null && type.getSuperType() == null) {
                this.addErrorAnnotation(expr, "CIDR", "Class '" + type.getName(expr) + "' doesn't have a superclass");
            }
        }
    }

    @Override
    public void visitProtocolExpression(OCProtocolExpression expression) {
        OCType type;
        super.visitProtocolExpression(expression);
        OCTypeElement typeElement = expression.getTypeElement();
        if (typeElement != null && !((type = typeElement.getType().resolve(expression)) instanceof OCObjectType) && !type.isUnknown()) {
            this.addErrorAnnotation(typeElement, "CIDR", "'" + type.getName(expression) + "' isn't a protocol");
        }
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        super.visitQualifiedExpression(expression);
        OCSymbol resolvedSymbol = expression.resolveToSymbol();
        this.highlightDeprecatedAPI(expression, resolvedSymbol);
        if (resolvedSymbol == null) {
            OCObjectTypeContext typeContext = expression.getQualifier().getTypeContext();
            if (typeContext == null) {
                return;
            }
            OCClassSymbol symbol = typeContext.getType().getClassSymbol();
            Project project = expression.getProject();
            String cannotResolveMessage = expression.getSymbolContext().getCannotResolveMessagePrefix(project);
            if (symbol != null && symbol.isPredeclaration() && (symbol = symbol.getDefinitionSymbol(project)) != null) {
                Annotation annotation = this.highlightUnresolvedReference(cannotResolveMessage, expression.getReference(), null);
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(expression.getNameIdentifier(), symbol));
            }
            for (OCProtocolSymbol protocol : typeContext.getType().getAllProtocols()) {
                if (!protocol.isPredeclaration() || (symbol = protocol.getDefinitionSymbol(project)) == null) continue;
                Annotation annotation = this.highlightUnresolvedReference(cannotResolveMessage, expression.getReference(), null);
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(expression.getNameIdentifier(), symbol));
            }
        }
        OCResolveContext context = OCResolveContext.forPsi(expression);
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        expression.processTargets(expression.getSymbolName(), (Processor<OCSymbol>)finder, false, null, true, false, null, context);
        OCSymbol symbol = (OCSymbol)finder.getFoundValue();
        if (symbol == null) {
            expression.processTargets(expression.getSymbolName(), (Processor<OCSymbol>)finder, true, null, true, false, null, context);
            symbol = (OCSymbol)finder.getFoundValue();
            if (symbol != null) {
                OCMethodSymbol methodSymbol;
                boolean isStatic = symbol instanceof OCMemberSymbol && ((OCMemberSymbol)symbol).isStatic();
                String message = isStatic ? "Class " + symbol.getNameWithKindLowercase(context) + " is accessed from the instance context" : "Instance " + symbol.getNameWithKindLowercase(context) + " is accessed from the class context";
                Annotation annotation = this.addErrorAnnotation(expression, OCInspections.StaticnessMismatch.class, "CIDR", message);
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCMethod.class});
                OCExpression qualifier = expression.getQualifier();
                if (symbol instanceof OCMethodSymbol) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)symbol, !isStatic, context.getProject()));
                }
                if (containingMethod != null && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() != null && (methodSymbol = (OCMethodSymbol)containingMethod.getSymbol()) != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(methodSymbol, isStatic, context.getProject()));
                }
            }
        }
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        super.visitArraySelectionExpression(expression);
        OCExpression arrayExpr = expression.getArrayExpression();
        OCExpression indexExpr = expression.getIndexExpression();
        if (indexExpr == null) {
            return;
        }
        OCType arrayType = arrayExpr.getResolvedType();
        OCType indexType = indexExpr.getResolvedType();
        PsiReference reference = expression.getReference();
        OCResolveContext context = OCResolveContext.forPsi(expression);
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            if (arrayType instanceof OCCppReferenceType) {
                arrayType = ((OCCppReferenceType)arrayType).getRefType();
            }
            if (arrayType.isPointerToObject() && OCCompilerFeaturesHelper.supportsSubscripting(expression.getContainingOCFile())) {
                ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(expression);
                String accessorName = expression.getArraySubscriptAccessorName(indexType, accessType);
                if (accessorName != null) {
                    OCSymbol symbol;
                    String message = "Type '" + arrayType.getName(context) + "' doesn't respond to '-" + accessorName + "'";
                    Annotation annotation = this.addErrorAnnotation(expression.getArrayExpression(), OCInspections.UnresolvedMessage.class, "err_objc_subscript_method_not_found", message);
                    OCObjectType receiverType = (OCObjectType)arrayType.getTerminalType();
                    OCClassSymbol parentClass = receiverType.getClassSymbol();
                    String signature2 = expression.getArraySubscriptMethodSignature(indexType, accessType);
                    OCType returnType = accessType == ReadWriteAccessDetector.Access.Read ? OCIdType.pointerToID() : OCVoidType.instance();
                    this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(expression, parentClass, "-" + accessorName, signature2, returnType, receiverType));
                    if (arrayType.getName().equals("NSArray *") && accessorName.equals("setObject:atIndexedSubscript:")) {
                        OCSymbol symbol2 = OCGetSymbolVisitor.getSymbol(arrayExpr);
                        if (symbol2 != null && symbol2.getResolvedType(context).equals(arrayType, context)) {
                            OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableArray", arrayExpr));
                            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol2, newType, context));
                        }
                    } else if (arrayType.getName().equals("NSDictionary *") && accessorName.equals("setObject:forKeyedSubscript:") && (symbol = OCGetSymbolVisitor.getSymbol(arrayExpr)) != null && symbol.getResolvedType(context).equals(arrayType, context)) {
                        OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableDictionary", arrayExpr));
                        this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, newType, context));
                    }
                } else {
                    this.addErrorAnnotation(indexExpr, OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Index expression must be an integer or an object pointer");
                }
            } else if (!arrayType.isSubclassOfMagic(context)) {
                if (!arrayType.isUnknown() && !(arrayType instanceof OCPointerType)) {
                    this.addErrorAnnotation(expression.getArrayExpression(), OCInspections.ArrayIssues.class, "err_typecheck_subscript_value", "Subscripted value is not an array");
                    ((OCOperatorReference)reference).resolveToSymbols();
                } else if (!(indexType.isUnknown() || indexType.isIntegerCompatible(context) || arrayType.isMagicInside(context))) {
                    Annotation annotation = this.addErrorAnnotation(expression.getIndexExpression(), OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Array index is not integer");
                    OCChangeTypeIntentionAction.registerChangeTypeFix(expression.getIndexExpression(), OCIntType.CHAR, annotation, this);
                }
            }
        }
    }

    private Annotation checkReferences(@NotNull PsiElement psiElement, @Nullable String cannotResolveMessage, @Nullable OCSymbolGroupContext groupContext, @Nullable String newName, @Nullable Class<? extends OCInspection> inspectionClass) {
        PsiReference[] refs;
        for (PsiReference reference : refs = psiElement.getReferences()) {
            OCSymbol symbol = null;
            Annotation annotation = null;
            if (reference instanceof OCPolyVariantReference) {
                List symbols = ((OCPolyVariantReference)reference).resolveToSymbols();
                if (symbols.size() == 0) {
                    if (!reference.isSoft()) {
                        annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                    }
                } else {
                    symbol = (OCSymbol)symbols.get(0);
                }
            } else if (reference instanceof OCReference) {
                PsiElement context;
                symbol = ((OCReference)reference).resolveToSymbol();
                if (symbol == null && !((context = psiElement.getContext()) instanceof OCStructLike) && !reference.isSoft() && PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])new Class[]{OCDirectiveImpl.class}) == null) {
                    annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                }
            } else if (reference.resolve() == null) {
                if (reference instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)reference).multiResolve(false).length > 0) continue;
                if (!reference.isSoft()) {
                    annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                }
            }
            if (symbol != null) {
                annotation = this.highlightDeprecatedAPI(psiElement, symbol);
            } else if (groupContext != null) {
                for (OCSymbolContext context : groupContext.getSymbolContexts()) {
                    String name = newName != null ? newName : reference.getCanonicalText();
                    this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(context, psiElement, name));
                }
            }
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private Annotation highlightDeprecatedAPI(@NotNull PsiElement psiElement, @Nullable OCSymbol symbol) {
        Annotation annotation = null;
        if (symbol instanceof OCFunctionGroupSymbol) {
            symbol = (OCSymbol)ContainerUtil.getFirstItem(((OCFunctionGroupSymbol)symbol).getOverloads());
        }
        if (symbol == null) {
            return null;
        }
        if (symbol.isForbiddenByARC(psiElement)) {
            annotation = this.addErrorAnnotation(psiElement, OCInspections.ARCIssues.class, "CIDR", "Explicit usage of '" + symbol.getName() + "' is forbidden in ARC");
            if (psiElement instanceof OCReferenceElement) {
                this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction((OCReferenceElement)psiElement));
            }
            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction((OCFile)psiElement.getContainingFile()));
        } else {
            OCCompilationContext context = OCCompilationContext.create(psiElement);
            if (symbol.isUnavailable()) {
                this.addErrorAnnotation(psiElement, OCInspections.DeprecatedApi.class, "CIDR", symbol.getUnavailableMessage(context));
            } else if (symbol.isDeprecated()) {
                this.addWarningAnnotation(psiElement, OCInspections.DeprecatedApi.class, "warn_deprecated", symbol.getDeprecatedMessage(context), ProblemHighlightType.LIKE_DEPRECATED);
            }
        }
        String unavailableMessage = OCResolveUtil.checkAvailability(symbol, psiElement);
        if (unavailableMessage != null) {
            this.addWarningAnnotation(psiElement, OCInspections.UnavailableInDeploymentTarget.class, "CIDR", unavailableMessage, ProblemHighlightType.LIKE_DEPRECATED);
        }
        return annotation;
    }

    @Nullable
    private Annotation highlightUnresolvedReference(String cannotResolveMessage, PsiReference reference, @Nullable Class<? extends OCInspection> inspectionClass) {
        TextRange refRange = reference.getRangeInElement();
        TextRange range = TextRange.from((int)(reference.getElement().getTextOffset() + refRange.getStartOffset()), (int)refRange.getLength());
        if (inspectionClass != null) {
            return this.addWarningAnnotation(reference.getElement(), range, inspectionClass, "CIDR", cannotResolveMessage + " '" + reference.getCanonicalText() + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(reference.getElement(), range, OCInspections.CannotResolve.class, "CIDR", cannotResolveMessage + " '" + reference.getCanonicalText() + "'", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        String typeName;
        OCType type;
        OCClassSymbol receiverClass = null;
        String referencedName = null;
        String message = null;
        Class inspectionClass = null;
        IntentionAction quickFix = null;
        for (PsiReference ref : expression.getReferences()) {
            while (ref instanceof OCCompositeResourceReference) {
                ref = ((OCCompositeResourceReference)ref).getRepresentative();
            }
            boolean processed = false;
            for (OCAnnotatorHelper each : OCAnnotator.getAnnotatorHelpers()) {
                Ref referencedNameRef;
                Ref inspectionClassRef = Ref.create();
                Ref quickFixRef = Ref.create();
                Ref receiverClassRef = Ref.create();
                Ref messageRef = Ref.create();
                if (!each.customizeResolveErrorForReference(ref, (Ref<Class<? extends OCInspection>>)inspectionClassRef, (Ref<IntentionAction>)quickFixRef, (Ref<String>)messageRef, (Ref<OCClassSymbol>)receiverClassRef, (Ref<String>)(referencedNameRef = Ref.create()))) continue;
                inspectionClass = (Class)inspectionClassRef.get();
                quickFix = (IntentionAction)quickFixRef.get();
                message = (String)messageRef.get();
                receiverClass = (OCClassSymbol)receiverClassRef.get();
                referencedName = (String)referencedNameRef.get();
                processed = true;
                break;
            }
            if (processed || !(ref instanceof OCFileResourceReference)) continue;
            inspectionClass = OCInspections.ResourceNotFoundInspection.class;
            message = "Can't find the resource";
        }
        OCSymbolContext context = receiverClass != null ? new OCSymbolContext(new OCExpectedTypeUtil.Expectable(){

            @Override
            public OCType getExpectedType() {
                return OCIdType.pointerToID();
            }
        }, OCSymbolKind.PROPERTY, receiverClass) : null;
        Annotation annotation = this.checkReferences(expression, message, context != null ? new OCSymbolGroupContext(context) : null, referencedName, inspectionClass);
        if (annotation != null && quickFix != null) {
            this.registerQuickFix(annotation, quickFix);
        }
        if (!OCCompilerFeaturesHelper.supportsObjectLiterals(expression.getContainingOCFile()) && (type = expression.getResolvedType()) instanceof OCPointerType && ("NSNumber".equals(typeName = ((OCPointerType)type).getRefType().getName()) || "NSArray".equals(typeName) || "NSDictionary".equals(typeName)) && this.getHolder() != null) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, OCBundle.message("annotator.type.literals.are.not.supported", typeName)).create();
        }
    }

    @Override
    public void visitImportDirective(OCIncludeDirective directive) {
        if (directive.getText().isEmpty()) {
            return;
        }
        VirtualFile containingFile = directive.getContainingFile().getVirtualFile();
        if (containingFile == null) {
            return;
        }
        Annotation annotation = this.checkReferences(directive, "Cannot find", null, null, null);
        PsiReference[] references = directive.getReferences();
        if (annotation != null && references.length == 1) {
            String fileNameToImport = references[0].getCanonicalText();
            for (OCAutoImportHelper each : OCAutoImportHelper.EP_NAME.getExtensionList()) {
                for (IntentionAction eachAction : each.getAddHeaderSearchPathFixes(directive.getProject(), containingFile, fileNameToImport)) {
                    this.registerQuickFix(annotation, eachAction);
                }
            }
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        super.visitDeclarator(declarator);
        this.checkDeclarator(declarator.getResolvedType(), declarator.getType(), declarator, declarator, declarator.getSymbol());
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        OCDeclarator declarator;
        OCSymbol symbol;
        super.visitDeclaration(declaration);
        PsiElement parent = declaration.getParent();
        if (!(!(parent instanceof OCInterface) && !(parent instanceof OCProtocol) || declaration.getDeclarators().isEmpty() || declaration.isTypedef() || declaration instanceof OCFunctionDeclaration || (symbol = (declarator = declaration.getDeclarators().get(0)).getSymbol()) instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern())) {
            Annotation annotation = this.addErrorAnnotation(declaration, OCInspections.ConstructionIsNotAllowed.class, "err_objc_var_decl_inclass", "Can't declare variables inside @interface or @protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration, "Remove declaration"));
        }
    }

    private void checkDeclarator(@Nullable OCType lType, @Nullable OCType unresolvedLType, @NotNull PsiNameIdentifierOwner element, @Nullable OCDeclarator declarator, OCSymbol symbol) {
        Annotation annotation;
        if (lType == null || symbol == null) {
            return;
        }
        OCFile file = (OCFile)element.getContainingFile();
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            this.checkPropertyDeclarator(element, property);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            Project project = element.getProject();
            OCPropertySymbol property = ivar.getAssociatedProperty(project);
            if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
                this.checkARCCompatibleAttributes(element, ivar, ivar.getARCAttribute(file, project), property);
            }
        }
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
        String name = OCElementUtil.getSymbolName((PsiElement)element);
        this.checkDeclaratorARCTypes(element, symbol, file);
        if (declarator != null) {
            this.checkDeclaratorInitializer(declarator);
        }
        if (declarator != null && declarator.getInitializers().isEmpty() && symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE && lType instanceof OCCppReferenceType) {
            annotation = this.addErrorAnnotation((PsiElement)element, "err_ivar_reference_type", "Instance variables can't have reference type");
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, ((OCCppReferenceType)lType).getRefType(), context));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockExpression.class) == null && OCElementUtil.getSelfSuperToken(name, (PsiElement)element, context) != null) {
            annotation = this.addErrorAnnotation((PsiElement)element, "err_redefinition_different_type", "Can't create a variable with name '" + name + "' inside the method");
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, context.getProject()));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol, context.getProject()));
        }
    }

    private void checkDeclaratorARCTypes(PsiNameIdentifierOwner element, OCSymbol symbol, OCFile file) {
        if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
            OCType type = symbol.getResolvedType(context);
            if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD && type.isPointerToObject() && !context.isCpp()) {
                while (type instanceof OCCppReferenceType) {
                    type = ((OCCppReferenceType)type).getRefType();
                }
                if (type instanceof OCPointerType && ((OCPointerType)type).getARCAttribute() == null) {
                    String clangID = OCClangMessageFinder.getInstance().getUsageOfArcObjectInStruct();
                    Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.ARCIssues.class, clangID, "Object struct fields must have an attribute in ARC");
                    for (ARCAttribute attribute2 : ARCAttribute.values()) {
                        this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, attribute2, OCCompilationContext.create((PsiElement)element)));
                    }
                }
            }
        }
    }

    private void checkDeclaratorInitializer(OCDeclarator declarator) {
        List<OCExpression> initializers = declarator.getInitializers();
        OCExpression initializer = (OCExpression)ContainerUtil.getFirstItem(initializers);
        if (initializer == null) {
            return;
        }
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCProperty.class, OCInstanceVariablesList.class, OCCallable.class, OCParameterList.class, OCStructLike.class});
        if (parent instanceof OCProperty) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_expected_semi_decl_list", "Property can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove initializer"));
            return;
        }
        if (parent instanceof OCInstanceVariablesList) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Instance variable can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove initializer"));
        }
    }

    public boolean checkDuplicates(@NotNull PsiNameIdentifierOwner element) {
        return this.checkDuplicates(OCElementUtil.getSymbolName((PsiElement)element), (PsiElement)element, Collections.singletonList(element.getNameIdentifier()));
    }

    public boolean checkDuplicates(String symbolName, PsiElement contextOwner, List<? extends PsiElement> navigationElements) {
        OCSymbol declaratorSymbol = null;
        if (symbolName == null) {
            return true;
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(contextOwner);
        List<OCSymbol> result = OCSymbolReference.getLocalReference(symbolName, contextOwner).resolveToSymbols(false, false, resolveContext);
        result.sort(Comparator.comparingLong(s -> ((OCSymbol)s).getComplexOffset()).reversed());
        for (OCSymbol symbol : result) {
            if (symbol.getComplexOffset() != OCSymbolOffsetUtil.getVirtualComplexOffset(contextOwner) || !Comparing.equal((Object)symbol.getContainingFile(), (Object)contextOwner.getContainingFile().getVirtualFile())) continue;
            declaratorSymbol = symbol;
            break;
        }
        if (declaratorSymbol == null) {
            return true;
        }
        OCSymbolKind declaratorKind = declaratorSymbol.getKind();
        for (OCSymbol symbol : result) {
            OCSymbolKind symbolKind;
            if (symbol.equals(declaratorSymbol) || (symbolKind = symbol.getKind()).isStructLike() != declaratorKind.isStructLike()) continue;
            if (symbolKind == OCSymbolKind.UNDEF_MACRO) break;
            List annotations = null;
            if (OCResolveUtil.isDuplicate(symbol, declaratorSymbol, contextOwner.getProject())) {
                VirtualFile symbolFile = symbol.getContainingFile();
                Object previousFile = "";
                if (symbolFile != null && !symbolFile.equals(contextOwner.getContainingFile().getVirtualFile())) {
                    previousFile = " in '" + symbolFile.getName() + "'";
                }
                if (OCObjCAnnotator.cantBeDuplicated(declaratorSymbol, contextOwner) && OCObjCAnnotator.cantBeDuplicated(symbol, contextOwner)) {
                    boolean symbolIsTypedef;
                    boolean declaratorIsTypedef = declaratorKind == OCSymbolKind.TYPEDEF;
                    boolean bl = symbolIsTypedef = symbolKind == OCSymbolKind.TYPEDEF;
                    if (!(declaratorIsTypedef && symbolIsTypedef || declaratorIsTypedef && symbolKind.isStructLike() || symbolIsTypedef && declaratorKind.isStructLike())) {
                        String message = "Duplicate declaration of " + declaratorSymbol.getNameWithKindLowercase(resolveContext) + (String)(!((String)previousFile).isEmpty() ? "; previous one was" + (String)previousFile : "");
                        annotations = symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null ? this.addWarningAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "warn_dup_category_def", message) : this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition", message);
                    }
                }
            } else if (declaratorSymbol instanceof OCDeclaratorSymbol) {
                annotations = this.checkDeclaratorAlias(navigationElements, declaratorSymbol, symbol, contextOwner);
            } else if (contextOwner instanceof OCMethod && declaratorSymbol instanceof OCMethodSymbol && symbol instanceof OCMethodSymbol) {
                this.checkMethodAlias((OCMethod)contextOwner, (OCMethodSymbol)declaratorSymbol, (OCMethodSymbol)symbol);
            } else if (declaratorSymbol instanceof OCPropertySymbol && symbol instanceof OCPropertySymbol && ((OCPropertySymbol)declaratorSymbol).getParent() != ((OCPropertySymbol)symbol).getParent()) {
                this.checkPropertyAlias((OCDeclaration)contextOwner.getParent(), (OCPropertySymbol)declaratorSymbol, (OCPropertySymbol)symbol);
            } else if (declaratorSymbol instanceof OCPropertySymbol && symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getGeneratedFromProperty() == null) {
                PsiElement definition = symbol.locateDefinition(contextOwner.getProject());
                final OCPropertySymbol property = (OCPropertySymbol)declaratorSymbol;
                CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                    protected boolean accept(OCMethodSymbol accessor) {
                        return accessor.getGeneratedFromProperty() == property;
                    }
                };
                property.getParent().processMembers(symbol.getName(), OCMethodSymbol.class, finder);
                if (definition instanceof OCMethod && finder.isFound()) {
                    this.checkMethodAlias((OCMethod)definition, (OCMethodSymbol)symbol, (OCMethodSymbol)finder.getFoundValue());
                }
            } else if (declaratorSymbol instanceof OCInstanceVariableSymbol && symbol instanceof OCInstanceVariableSymbol) {
                OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
                OCInstanceVariableSymbol declaratorIvar = (OCInstanceVariableSymbol)declaratorSymbol;
                if (!ivar.isClang4ImplicitIvar(resolveContext.getFile()) && !ivar.getParent().isSameClass(declaratorIvar.getParent()) && ivar.getVisibility() != OCVisibility.PRIVATE) {
                    String message = declaratorIvar.getNameWithKindUppercase(resolveContext) + " overrides " + ivar.getNameWithKindLowercase(resolveContext) + " in inherited " + ivar.getParent().getNameWithKindLowercase(resolveContext);
                    annotations = this.addErrorAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "err_duplicate_member", message);
                }
            }
            if (annotations == null) continue;
            return false;
        }
        return true;
    }

    private static boolean cantBeDuplicated(OCSymbol symbol, PsiElement context) {
        return !symbol.isPredeclaration() || symbol instanceof OCMethodSymbol || symbol instanceof OCDeclaratorSymbol && !OCCodeInsightUtil.isInPlainOldC(context) && (!((OCDeclaratorSymbol)symbol).isExtern() || ((OCDeclaratorSymbol)symbol).getInitializer() != null) || (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isFriend() || symbol instanceof OCDeclaratorSymbol) && ((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol;
    }

    @Nullable
    private List<Annotation> checkDeclaratorAlias(List<? extends PsiElement> navigationElements, OCSymbol declaratorSymbol, OCSymbol symbol, @NotNull PsiElement element) {
        List annotations = null;
        OCCompilationContext compilationContext = OCCompilationContext.create(element);
        if ((!(symbol instanceof OCDeclaratorSymbol) || declaratorSymbol.getKind() == OCSymbolKind.STRUCT_FIELD || declaratorSymbol.getKind() == OCSymbolKind.PARAMETER) && symbol instanceof OCInstanceVariableSymbol) {
            OCClassSymbol ivarParent;
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCMethod.class});
            if (containingMethod == null) {
                return null;
            }
            OCMethodSymbol method = (OCMethodSymbol)containingMethod.getSymbol();
            Object suffixMessage = "";
            if (method == null || method.isStatic() || !(method.getParent() instanceof OCImplementationSymbol)) {
                return null;
            }
            OCClassSymbol methodParent = method.getParent();
            if (!methodParent.isSameSymbol((OCSymbol)(ivarParent = ivar.getParent()), element.getProject())) {
                suffixMessage = " declared in " + ivarParent.getNameWithKindLowercase(compilationContext);
                if (ivar.getVisibility() == OCVisibility.PRIVATE) {
                    return null;
                }
            }
            String message = declaratorSymbol.getNameWithKindUppercase(compilationContext) + " hides the " + symbol.getKind().getNameLowercase() + " with the same name" + (String)suffixMessage;
            annotations = this.addWarningAnnotations(navigationElements, OCInspections.HidesClassScope.class, "warn_ivar_use_hidden", message);
        }
        this.registerQuickFixes(annotations, new OCRenameSymbolIntentionAction(declaratorSymbol, compilationContext));
        return annotations;
    }

    private void checkMethodAlias(@NotNull OCMethod method, OCMethodSymbol declaratorMethod, OCMethodSymbol baseMethod) {
        Object message;
        Project project = method.getProject();
        if (baseMethod.equals(declaratorMethod.getAssociatedSymbol(project))) {
            return;
        }
        if (declaratorMethod.isStatic() != baseMethod.isStatic()) {
            return;
        }
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        Object messageSuffix = "";
        OCCompilationContext compilationContext = OCCompilationContext.create(method);
        if (!Comparing.equal((Object)declaratorMethod.getParent(), (Object)baseMethod.getParent())) {
            messageSuffix = "; " + (property != null ? "property" : "base method") + " was declared in " + baseMethod.getParent().getNameWithKindLowercase(compilationContext);
        }
        OCType declReturnType = declaratorMethod.getReturnType(project);
        OCType baseReturnType = baseMethod.getEffectiveType(method);
        if (!baseReturnType.isSuperType(declReturnType, method)) {
            if (property != null && OCNameSuggester.isObjCGetter(declaratorMethod.getName())) {
                message = "Return type (" + declReturnType.getName(method) + ") of getter method for " + property.getNameWithKindLowercase(compilationContext) + " doesn't match the type (" + property.getType().getName(method) + ") of property" + (String)messageSuffix;
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declaratorMethod, property.getType(), compilationContext));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, declReturnType, compilationContext));
            } else if (property != null && OCNameSuggester.isObjCSetter(declaratorMethod.getName())) {
                message = "Return type of setter method must be 'void'";
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declaratorMethod, OCVoidType.instance(), compilationContext));
            } else {
                message = "Return type (" + declReturnType.getName(method) + ") of overridden method doesn't match the return type (" + baseReturnType.getName(method) + ") of base method";
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.OverriddenTypeMismatch.class, "warn_non_covariant_overriding_ret_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)declaratorMethod, baseReturnType, "overridden " + declaratorMethod.getNameWithKindLowercase(compilationContext), compilationContext));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseMethod, declReturnType, "base " + baseMethod.getNameWithKindLowercase(compilationContext), compilationContext));
            }
        }
        for (int i = 0; i < declaratorMethod.getSelectors().size(); ++i) {
            Annotation annotation;
            OCType baseParamType;
            OCType declParamType;
            OCDeclaratorSymbol declParameter = declaratorMethod.getSelectors().get(i).getParameter();
            OCDeclaratorSymbol baseParameter = baseMethod.getSelectors().get(i).getParameter();
            if (declParameter == null || baseParameter == null || (declParamType = declParameter.getType()).isSuperType(baseParamType = baseParameter.getEffectiveType(method), method)) continue;
            OCTypeElement typeElement = method.getParameters().get(i).getTypeElement();
            if (property != null) {
                message = "Parameter type (" + declParamType.getName(method) + ") of setter method for " + property.getNameWithKindLowercase(compilationContext) + " doesn't match the type (" + property.getType().getName(method) + ") of property" + (String)messageSuffix;
                annotation = this.addWarningAnnotation(typeElement, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declParameter, property.getType(), compilationContext));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, declParamType, compilationContext));
                continue;
            }
            message = "Parameter type (" + declParamType.getName(method) + ") of overridden method doesn't match the parameter type (" + baseParamType.getName(method) + ") of base method";
            annotation = this.addWarningAnnotation(typeElement, OCInspections.OverriddenTypeMismatch.class, "warn_non_contravariant_overriding_param_types", (String)message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)declParameter, baseParamType, "overridden " + declParameter.getNameWithKindLowercase(compilationContext), compilationContext));
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseParameter, declParamType, "base " + baseParameter.getNameWithKindLowercase(compilationContext), compilationContext));
        }
    }

    private void checkPropertyAlias(OCDeclaration property, OCPropertySymbol declaratorProperty, OCPropertySymbol baseProperty) {
        OCResolveContext context = OCResolveContext.forPsi(property);
        OCType declaratorPropType = declaratorProperty.getResolvedType(context);
        OCType basePropType = baseProperty.getResolvedType(context);
        OCPropertySymbol.FlagAttribute[] attrGroups = new OCPropertySymbol.FlagAttribute[]{OCPropertySymbol.PropertyAttribute.ATOMIC, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.STRONG};
        OCClassSymbol declParent = declaratorProperty.getParent();
        OCClassSymbol baseParent = baseProperty.getParent();
        PsiElement attributesHighlightElement = property.getParent();
        Project project = property.getProject();
        Annotation annotation = null;
        if (((OCProperty)attributesHighlightElement).getPropertyAttributesList() != null) {
            attributesHighlightElement = ((OCProperty)attributesHighlightElement).getPropertyAttributesList();
        }
        for (OCPropertySymbol.FlagAttribute attrGroup : attrGroups) {
            OCPropertySymbol.FlagAttribute declValue = declaratorProperty.getAttributeOfGroup(attrGroup, declaratorPropType, property);
            OCPropertySymbol.FlagAttribute baseValue = baseProperty.getAttributeOfGroup(attrGroup, basePropType, property);
            boolean incompatibility = false;
            boolean isError = false;
            Object message = "Overridden property is " + declValue.getTokenName() + "; the base property is " + baseValue.getTokenName();
            String clangID = "err_objc_property_attr_mutually_exclusive";
            List<OCChangePropertyAttributeIntentionAction> quickFixes = Arrays.asList(new OCChangePropertyAttributeIntentionAction(declaratorProperty, declValue, (OCPropertySymbol.PropertyAttribute)baseValue, null, "overridden property", project), new OCChangePropertyAttributeIntentionAction(baseProperty, baseValue, (OCPropertySymbol.PropertyAttribute)declValue, null, "base property", project));
            if (attrGroup == OCPropertySymbol.PropertyAttribute.ATOMIC) {
                incompatibility = declValue != baseValue;
            } else if (attrGroup == OCPropertySymbol.PropertyAttribute.READWRITE) {
                if ("".equals(declParent.getCategoryName()) && baseParent.getCategoryName() == null && declParent.getName().equals(baseParent.getName())) {
                    if (!baseProperty.isReadonly()) {
                        quickFixes = Collections.singletonList(new OCChangePropertyAttributeIntentionAction(baseProperty, OCPropertySymbol.PropertyAttribute.READWRITE, (OCPropertySymbol.PropertyAttribute)OCPropertySymbol.PropertyAttribute.READONLY, null, "base property", project));
                        message = "Overridden properties must be 'readonly' in the interface";
                        clangID = "err_use_continuation_class_redeclaration_readwrite";
                        isError = true;
                        incompatibility = true;
                    } else if (declaratorProperty.isReadonly()) {
                        quickFixes = Collections.singletonList(new OCChangePropertyAttributeIntentionAction(declaratorProperty, OCPropertySymbol.PropertyAttribute.READONLY, (OCPropertySymbol.PropertyAttribute)OCPropertySymbol.PropertyAttribute.READWRITE, null, "category property", project));
                        message = "Overridden properties must be 'readwrite' in the private category";
                        isError = true;
                        incompatibility = true;
                    }
                } else {
                    incompatibility = declaratorProperty.isReadonly() && !baseProperty.isReadonly();
                }
            } else if (attrGroup == OCPropertySymbol.PropertyAttribute.STRONG) {
                boolean bl = incompatibility = declValue.getSemanticsGroup() != baseValue.getSemanticsGroup();
            }
            if (!incompatibility) continue;
            annotation = isError ? this.addErrorAnnotation(attributesHighlightElement, OCInspections.OverriddenAttributeMismatch.class, clangID, (String)message) : this.addWarningAnnotation(attributesHighlightElement, OCInspections.OverriddenAttributeMismatch.class, clangID, (String)message);
            for (IntentionAction intentionAction : quickFixes) {
                this.registerQuickFix(annotation, intentionAction);
            }
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("overridden part", declaratorProperty, project));
        }
    }

    private void checkPropertyDeclarator(PsiNameIdentifierOwner element, OCPropertySymbol property) {
        OCPropertySymbol categoryProperty;
        PsiFile file = element.getContainingFile();
        OCType type = property.getType().resolve((PsiElement)element);
        if (type instanceof OCArrayType || type instanceof OCFunctionType) {
            this.addErrorAnnotation((PsiElement)element, "err_property_type", "Properties can't have the array or function type");
            return;
        }
        Project project = element.getProject();
        if (!(OCCompilerFeaturesHelper.supportsExplicitAtomic(element.getContainingFile()) || !type.isPointerToObject() || property.hasAttribute(OCPropertySymbol.PropertyAttribute.STRONG) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.WEAK) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.ASSIGN) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.UNSAFE_UNRETAINED) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.READONLY))) {
            Annotation annotation = this.addWarningAnnotation(element.getParent().getParent(), OCInspections.NoAttributeForProperty.class, "warn_objc_property_no_assignment_attribute", "No 'strong', 'weak', 'assign', 'retain', or 'copy' attribute is specified - 'assign' is assumed");
            if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.STRONG, null, project));
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.WEAK, null, project));
            }
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.ASSIGN, null, project));
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.RETAIN, null, project));
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.COPY, null, project));
        }
        if (property.getParent().getCategoryName() == null && (categoryProperty = property.getAssociatedPropertyInPrivateCategory(project)) != null) {
            this.checkPropertyAlias((OCDeclaration)element.getParent(), categoryProperty, property);
        }
        OCInstanceVariableSymbol ivar = property.getAssociatedIvar(project);
        if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
            if (ivar != null) {
                this.checkARCCompatibleAttributes(element, ivar, ivar.getARCAttribute((PsiElement)file, project), property);
            }
            if (type instanceof OCPointerType) {
                this.checkARCCompatibleAttributes(element, property, ((OCPointerType)type).getARCAttribute(), property);
            }
        }
    }

    private void checkARCCompatibleAttributes(PsiNameIdentifierOwner element, OCSymbol symbol, ARCAttribute arcAttribute, OCPropertySymbol property) {
        OCType type;
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
        OCType oCType = type = property != null ? property.getResolvedType(context) : null;
        if (property != null && symbol != null && arcAttribute != null && type.isPointerToObjectCompatible()) {
            OCPropertySymbol.FlagAttribute propAttr = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)element);
            Project project = element.getProject();
            if (!(arcAttribute == propAttr.getIvarCompatibleARCAttribute() || propAttr == OCPropertySymbol.PropertyAttribute.ASSIGN && property.isReadonly())) {
                String clangID;
                String message;
                if (symbol instanceof OCInstanceVariableSymbol) {
                    message = "Ivar for " + propAttr.getTokenName() + " " + property.getNameWithKindLowercase(context) + " must be " + propAttr.getIvarCompatibleARCAttribute().getTokenName();
                    clangID = OCClangMessageFinder.getInstance().getWeakProperty();
                } else if (symbol instanceof OCPropertySymbol) {
                    message = "Attributes '" + propAttr.getTokenName() + "' and '" + arcAttribute.getTokenName() + "' are mutually exclusive";
                    clangID = "err_objc_property_attr_mutually_exclusive";
                } else {
                    return;
                }
                if (!OCAnnotator.isAnnotatedAsUserCode(project, symbol.getContainingFile())) {
                    return;
                }
                Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.ARCIssues.class, clangID, message);
                this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, propAttr.getIvarCompatibleARCAttribute(), context));
                OCPropertySymbol.PropertyAttribute attribute2 = arcAttribute.getPropertyCompatibleSemantics(type, (PsiElement)element).getPropertyAttribute();
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, propAttr, attribute2, null, project));
            }
        }
    }

    @Override
    public void visitProperty(OCProperty property) {
        super.visitProperty(property);
        if (PsiTreeUtil.getContextOfType((PsiElement)property, (Class[])new Class[]{OCInterface.class, OCProtocol.class}) == null) {
            Annotation annotation = this.addErrorAnnotation(property, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Property is declared outside of an interface/protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)property, "Remove property"));
        }
    }

    @Override
    public void visitPropertyAttributesList(OCPropertyAttributesList attributes) {
        super.visitPropertyAttributesList(attributes);
        HashSet<OCPropertySymbol.PropertyAttribute> processedAttrs = new HashSet<OCPropertySymbol.PropertyAttribute>();
        for (OCPropertyAttribute attributeNode : attributes.getAttributes()) {
            String name = attributeNode.getName();
            if (name == null) continue;
            Annotation annotation = null;
            OCPropertySymbol.PropertyAttribute attribute2 = OCPropertySymbolImpl.parseAttribute(name);
            if (!OCCompilerFeaturesHelper.supportsNullability(attributes.getContainingFile()) && attribute2 != null && attribute2.getGroup() == OCPropertySymbol.PropertyAttribute.Group.NULLABILITY) {
                attribute2 = null;
            }
            if (!OCCompilerFeaturesHelper.supportsClassProperty(attributes.getContainingFile()) && attribute2 != null && attribute2.getGroup() == OCPropertySymbol.PropertyAttribute.Group.STATICNESS) {
                attribute2 = null;
            }
            if (attributes.getParent() instanceof OCSynthesizePropertiesList && attribute2 != OCPropertySymbol.PropertyAttribute.CLASS) {
                attribute2 = null;
            }
            if (attribute2 != null) {
                List<OCDeclarator> declarators;
                OCProperty property;
                OCDeclaration declaration;
                for (OCPropertySymbol.PropertyAttribute processedAttr : processedAttrs) {
                    if (processedAttr == attribute2) {
                        annotation = this.addWarningAnnotation(attributeNode.getNameIdentifier(), OCInspections.DuplicateAttribute.class, "CIDR", "Attribute '" + name + "' was already declared");
                        continue;
                    }
                    if (processedAttr.getGroup() != attribute2.getGroup()) continue;
                    annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_attr_mutually_exclusive", "Attributes '" + processedAttr.getTokenName() + "' and '" + name + "' are mutually exclusive");
                }
                if (OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains(attribute2) && attributeNode.getValue() == null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name + "' requires a value");
                } else if (!OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains(attribute2) && attributeNode.getValue() != null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name + "' mustn't have a value");
                } else if (OCPropertySymbol.PROPERTY_ATTRIBUTES_FOR_OBJECT.contains(attribute2) && attributeNode.getParent().getParent() instanceof OCProperty && (declaration = (property = (OCProperty)attributeNode.getParent().getParent()).getDeclaration()) != null && !(declarators = declaration.getDeclarators()).isEmpty()) {
                    OCDeclarator declarator = declarators.get(0);
                    OCType type = declarator.getResolvedType();
                    OCSymbol symbol = declarator.getSymbol();
                    if (!(declarators.size() <= 0 || type.isPointerToObjectCompatible() || symbol != null && symbol.hasAttribute("NSObject"))) {
                        String message = "Attribute '" + name + "' requires the property of object type instead of '" + type.getName(attributes) + "'";
                        this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_requires_object", message);
                    }
                }
                processedAttrs.add(attribute2);
            } else {
                annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_expected_property_attr", "Unknown attribute '" + name + "'");
            }
            if (attributeNode.getColon() != null) {
                if ("getter".equals(name)) {
                    this.addErrorAnnotation(attributeNode.getColon(), "CIDR", "Colon is only allowed for 'setter' attribute");
                }
            } else if ("setter".equals(name)) {
                this.addErrorAnnotation(attributeNode.getValueElement(), "CIDR", "Colon is required for 'setter' attribute");
            }
            if (annotation == null) continue;
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)attributeNode, "Remove attribute"));
        }
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        if (stmt.getCatchSections().isEmpty() && stmt.getFinallySection() == null) {
            this.addErrorAnnotation(stmt, "err_missing_catch_finally", stmt.getContainingOCFile().isCpp() ? "Missing catch or finally" : "Missing @catch or @finally");
        }
    }

    @Override
    public void visitCatchSection(OCCatchSection catchSection) {
        super.visitCatchSection(catchSection);
        OCParameterList paramList = catchSection.getParameters();
        if (paramList == null) {
            return;
        }
        if (paramList.getParameterDeclarations().size() != 1) {
            Annotation annotation = this.addErrorAnnotation(paramList, "CIDR", "Only one variable declaration is allowed");
            for (int i = paramList.getParameterDeclarations().size() - 1; i >= 1; --i) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)paramList.getParameterDeclarations().get(i), "Remove extra declarators"));
            }
            return;
        }
        OCDeclarator declarator = paramList.getParameterDeclarations().get(0).getDeclarator();
        if (declarator == null || catchSection.isCppStatement()) {
            return;
        }
        OCType type = declarator.getResolvedType();
        if (!(type.isUnknown() || type.isPointerToObject() || type.isClassType())) {
            this.addErrorAnnotation(declarator.getNameIdentifier(), OCInspections.PointerTypeRequired.class, "err_catch_param_not_objc_type", "Variable type ('" + type.getName(catchSection) + "') is not a pointer to object");
        }
    }

    private void checkExceptionExpression(OCExpression expression) {
        if (expression == null) {
            return;
        }
        OCType type = expression.getResolvedType();
        if (!(type.isUnknown() || type.isPointerToObject() || type.isClassType())) {
            this.addErrorAnnotation(expression, OCInspections.PointerTypeRequired.class, OCClangMessageFinder.getInstance().getObjcThrowExpectsObject(), "Expression type '" + type.getName(expression) + "' is not a pointer to object");
        }
    }

    @Override
    public void visitSynchronizedStatement(OCSynchronizedStatement stmt) {
        super.visitSynchronizedStatement(stmt);
        this.checkExceptionExpression(stmt.getLockExpression());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression) {
        super.visitThrowExpression(expression);
        if (expression.isCppStatement()) {
            return;
        }
        this.checkExceptionExpression(expression.getExceptionExpression());
        if (expression.getExceptionExpression() == null && PsiTreeUtil.getParentOfType((PsiElement)expression, OCCatchSection.class, (boolean)true, (Class[])new Class[]{OCCallable.class}) == null) {
            this.addErrorAnnotation(expression, OCClangMessageFinder.getInstance().getRethrowUsedOutsideCatch(), "@throw (rethrow) is used outside of a @catch block");
        }
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression expression) {
        if (!OCCompilerFeaturesHelper.supportsObjectLiterals(expression.getContainingOCFile())) {
            this.addErrorAnnotation(expression, "CIDR", "Expression literals are not supported by the compiler");
        } else {
            OCType type;
            OCExpression operand = expression.getOperand();
            if (!(operand == null || (type = operand.getResolvedType()).isNumberCompatible(OCResolveContext.forPsi(expression)) || type.isPointerToChar() || type instanceof OCMagicType)) {
                this.addErrorAnnotation(operand, "err_objc_illegal_boxed_expression_type", "Type '" + type.getName(operand) + "' is illegal for a boxed expression");
            }
        }
        super.visitBoxedExpression(expression);
    }

    @Override
    public void visitGenericSelectionExpression(OCGenericSelectionExpression genericExpression) {
        OCExpression expr;
        boolean containsError = this.checkAssociationList(genericExpression);
        if (!containsError && (expr = genericExpression.getControllingExpression()) != null) {
            boolean noneMatch;
            OCType type = expr.getResolvedType();
            boolean bl = noneMatch = genericExpression.getAssociationByType(type) == null;
            if (noneMatch) {
                this.addErrorAnnotation(expr, "err_generic_sel_no_match", "Controlling expression type '" + OCObjCAnnotator.getTypeName(type, genericExpression) + "' not compatible with any generic association type");
            }
        }
        super.visitGenericSelectionExpression(genericExpression);
    }

    public boolean checkAssociationList(OCGenericSelectionExpression genericExpression) {
        List<OCGenericSelectionAssociation> associations = genericExpression.getAssociations();
        int size = associations.size();
        boolean containsError = false;
        for (int i = size - 1; i >= 0; --i) {
            Optional<OCGenericSelectionAssociation> result;
            OCGenericSelectionAssociation association = associations.get(i);
            boolean isDefaultAssoc = association.isDefault();
            OCType type = isDefaultAssoc ? null : association.getAssociationResolvedType();
            OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.findChildOfType((PsiElement)association, OCTypeElement.class);
            if (type != null && type.isUnresolved(association)) {
                this.addErrorAnnotation(typeElement, "err_assoc_type_incomplete", "Type '" + type.getBestNameInContext(association) + "' in generic association incomplete");
                containsError = true;
            }
            OCType t = type;
            while (t instanceof OCArrayType) {
                if (!((OCArrayType)t).hasLength()) {
                    this.addErrorAnnotation(typeElement, "err_assoc_type_incomplete", "Type '" + t.getBestNameInContext(association) + "' in generic association incomplete");
                    containsError = true;
                    break;
                }
                t = ((OCArrayType)t).getRefType();
            }
            if (!(result = associations.subList(0, i).stream().filter(a -> {
                if (isDefaultAssoc && a.isDefault()) {
                    return true;
                }
                return type != null && type.equals(a.getAssociationResolvedType(), OCResolveContext.forPsi(a));
            }).findFirst()).isPresent()) continue;
            OCGenericSelectionAssociation duplicate = result.get();
            if (duplicate.isDefault()) {
                this.addErrorAnnotation(association, null, "Duplicate default generic association");
            } else {
                this.addErrorAnnotation(typeElement, "err_assoc_compatible_types", "Type '" + OCObjCAnnotator.getTypeName(association) + "' in generic association compatible with previously specified type '" + OCObjCAnnotator.getTypeName(duplicate) + "'");
            }
            containsError = true;
        }
        return containsError;
    }

    @Nullable
    private static String getTypeName(@NotNull OCGenericSelectionAssociation a) {
        if (a.isDefault()) {
            return OCLexerTokenTypes.DEFAULT_KEYWORD.getName();
        }
        OCType type = a.getAssociationResolvedType();
        return type != null ? type.getBestNameInContext(a) : null;
    }

    private static String getTypeName(@NotNull OCType type, @NotNull PsiElement context) {
        type = OCTypeUtils.decayType(type, context.getProject());
        return type.getBestNameInContext(context);
    }

    @Nullable
    public static OCMethodSymbol findTargetMethod(OCSendMessageExpression expr, List<OCMethodSymbol> targets) {
        List<OCMessageArgument> arguments = expr.getArguments();
        OCMethodSymbol best = null;
        int minValue = 0;
        OCResolveContext context = OCResolveContext.forPsi(expr);
        block0: for (OCMethodSymbol target : targets) {
            int argPos = 0;
            int value = 0;
            for (OCMessageArgument arg : arguments) {
                OCDeclaratorSymbol parameter;
                OCExpression argument = arg.getArgumentExpression();
                if (argument == null) continue;
                OCType argumentType = argument.getResolvedType().getGuessedType();
                List<OCMethodSymbol.SelectorPartSymbol> parameters = target.getSelectors();
                if (target.isVararg()) {
                    if (argPos >= parameters.size()) {
                        continue;
                    }
                } else if (parameters.size() != arguments.size()) continue block0;
                if ((parameter = parameters.get(argPos).getParameter()) == null) continue;
                OCType declType = parameter.getType().resolve(context);
                OCTypeCheckState state = declType.checkCompatible(argumentType, argument, argument, context).getState();
                if (state.isError(expr)) {
                    value += 2000;
                } else if (state != OCTypeCheckState.OK) {
                    ++value;
                }
                ++argPos;
            }
            if (!OCFileSymbols.isSymbolImported(expr.getContainingOCFile(), target.getParent())) {
                value += 1000;
            }
            if (best != null && (value == -1 || value >= minValue)) continue;
            minValue = value;
            best = target;
        }
        return best;
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement) {
        super.visitForeachStatement(statement);
        OCExpression collExpr = statement.getCollectionExpression();
        if (collExpr == null) {
            return;
        }
        OCResolveContext context = OCResolveContext.forPsi(collExpr);
        OCType rType = collExpr.getResolvedType(context).getGuessedType();
        if (rType.isUnknown()) {
            return;
        }
        if (!statement.isCpp11Foreach()) {
            if (rType.isPointerToObjectCompatible()) {
                OCType refType = ((OCPointerType)rType).getRefType();
                if (!(refType instanceof OCObjectType)) {
                    return;
                }
                OCObjectType objectType = (OCObjectType)refType;
                String enumFunction = "countByEnumeratingWithState:objects:count:";
                if (!(objectType instanceof OCIdType && objectType.getAllProtocols().isEmpty() || objectType.findMember("countByEnumeratingWithState:objects:count:", OCMethodSymbol.class) != null)) {
                    String message = "Collection expression of type '" + rType.getName(context) + "' doesn't respond to 'countByEnumeratingWithState:objects:count:'";
                    Annotation annotation = this.addWarningAnnotation(collExpr, OCInspections.UnresolvedCollectionMessage.class, "warn_collection_expr_type", message);
                    if (objectType.getInterface() != null) {
                        this.registerQuickFix(annotation, new OCAddSuperProtocolIntentionAction(objectType.getInterface(), "NSFastEnumeration", false, context.getProject()));
                    }
                }
            } else {
                this.addErrorAnnotation(collExpr, "CIDR", "Expression has non-object type '" + rType.getName(context) + "'");
            }
        }
    }

    @Override
    public void visitOCFile(OCFile file) {
        super.visitOCFile(file);
        this.annotateUnusedImports(file);
    }

    private void annotateUnusedImports(@NotNull OCFile file) {
        OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file.getProject()).forFile(file);
        this.processUndefinedClasses(file, symbols.getUndefinedClasses(), OCSymbolKind.INTERFACE);
        this.processUndefinedClasses(file, symbols.getUndefinedProtocols(), OCSymbolKind.PROTOCOL);
    }

    private void processUndefinedClasses(OCFile file, Map<String, Pair<OCSymbol, VirtualFile>> undefinedClasses, OCSymbolKind symbolKind) {
        for (String className : undefinedClasses.keySet()) {
            OCClassSymbol definition;
            Pair<OCSymbol, VirtualFile> pair = undefinedClasses.get(className);
            OCIncludeDirective directive = file.findIncludeDirective((VirtualFile)pair.getSecond());
            OCSymbol symbol = (OCSymbol)pair.getFirst();
            if (directive == null || !OCAnnotator.isAnnotatedAsUserCode(file.getProject(), symbol.getContainingFile())) continue;
            Annotation annotation = null;
            if (symbolKind == OCSymbolKind.INTERFACE) {
                message = "Cannot find class '" + className + "', superclass of " + symbol.getNameWithKindLowercase(OCCompilationContext.create(file));
                annotation = this.addErrorAnnotation(directive, OCInspections.CannotResolve.class, "CIDR", message);
            } else if (symbolKind == OCSymbolKind.PROTOCOL) {
                message = "Cannot find protocol '" + className + "', conformed by " + symbol.getNameWithKindLowercase(OCCompilationContext.create(file));
                annotation = this.addWarningAnnotation(directive, OCInspections.NotVisibleClass.class, "CIDR", message);
            }
            if ((definition = (OCClassSymbol)OCSymbolBase.findSymbolDefinition(className, symbolKind, file.getProject(), file.getVirtualFile())) == null || annotation == null) continue;
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(directive, definition));
        }
    }

    public boolean checkInstanceable(OCType type, @Nullable PsiElement errorElement, OCSymbol symbol, boolean returnTypeMode) {
        if (errorElement == null) {
            return true;
        }
        if (type instanceof OCBlockPointerType && !(((OCBlockPointerType)type).getRefType() instanceof OCFunctionType)) {
            this.addErrorAnnotation(errorElement, "err_nonfunction_block_type", "Block pointer to non-function is invalid");
            return false;
        }
        if (symbol != null && symbol.getKind() != OCSymbolKind.TYPEDEF && !type.isUnknown() && !type.isInstanceable() && (!(type instanceof OCEllipsisType) && !(type instanceof OCVariadicType) || symbol.getKind() != OCSymbolKind.PARAMETER && symbol.getKind() != OCSymbolKind.TEMPLATE_VALUE_PARAMETER)) {
            String clangID;
            String message;
            OCResolveContext context = OCResolveContext.forPsi(errorElement);
            if (symbol.isCallable()) {
                message = "Can't return type '" + type.getName(context) + "'";
                clangID = "err_object_cannot_be_passed_returned_by_value";
            } else {
                message = "Can't instantiate the variables of type '" + type.getName(context) + "'";
                clangID = "err_statically_allocated_object";
            }
            if (type instanceof OCObjectType || type instanceof OCFunctionType) {
                message = message + " (probably you forgot '*')";
            }
            Annotation annotation = this.addErrorAnnotation(errorElement, OCInspections.PointerTypeRequired.class, clangID, message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, (OCType)OCPointerType.to(type), returnTypeMode, (OCCompilationContext)context));
            return false;
        }
        return true;
    }
}

