/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighter;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighterFactory;
import com.jetbrains.cidr.lang.daemon.OCAddToProjectFixProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.OCUnloadedResolveContextsManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileWideHighlighter
implements FileWideHighlighter {
    @Nullable
    private static String findTooLongInlineHeader(@NotNull ASTNode node) {
        for (ASTNode child : node.getChildren(null)) {
            if (child.getElementType() == OCTokenTypes.HEADER_TOO_LONG_INLINED_PATH_LITERAL) {
                return child.getText();
            }
            String header = OCFileWideHighlighter.findTooLongInlineHeader(child);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    @Override
    @Nullable
    public HighlightInfo annotate(@NotNull Project project, @NotNull PsiFile file, @NotNull ProgressIndicator progress) {
        if (!OCLanguageUtils.isSupported(file)) {
            return null;
        }
        HighlightInfo info = this.annotateTooLarge(project, file);
        if (info != null) {
            return info;
        }
        info = OCFileWideHighlighter.annotateNonProject(project, file);
        if (info != null) {
            return info;
        }
        return null;
    }

    public static boolean isProjectFile(@NotNull Project project, @NotNull VirtualFile file) {
        return !file.isValid() || !(file instanceof VirtualFileWithId) || ScratchUtil.isScratch((VirtualFile)file) || OCSearchScope.isInProjectSourcesOrLibraries(project, file);
    }

    @Nullable
    private static HighlightInfo annotateNonProject(@NotNull Project project, @NotNull PsiFile file) {
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        OCWorkspace workspace = OCWorkspace.getInstance((Project)project);
        if (workspace.getConfigurations().isEmpty() && OCUnloadedResolveContextsManager.Companion.getAllUnloadedContexts(project).isEmpty()) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (OCFileWideHighlighter.isProjectFile(project, virtualFile)) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)file).fileLevelAnnotation().description(OCFileWideHighlighter.getNonProjectText()).create();
        if (highlightInfo != null) {
            List<IntentionAction> actions = OCAddToProjectFixProvider.getAllActions(file);
            for (IntentionAction action : actions) {
                highlightInfo.registerFix(action, ContainerUtil.emptyList(), null, file.getTextRange(), null);
            }
        }
        return highlightInfo;
    }

    @Nullable
    public HighlightInfo annotateTooLarge(@NotNull Project project, @NotNull PsiFile file) {
        String message;
        if (!(file instanceof OCFile)) {
            return null;
        }
        long textLength = file.getViewProvider().getVirtualFile().getLength();
        boolean isCodeInsightLimit = true;
        String languageName = file.getLanguage().getDisplayName();
        if (!OCCodeInsightUtil.isCodeInsightAvailable(file)) {
            int maxFileLength = OCCodeInsightUtil.getMaxFileLength();
            message = OCBundle.message("inspections.fileChecks.sourceTooLarge", StringUtil.formatFileSize((long)textLength), languageName, StringUtil.formatFileSize((long)maxFileLength));
        } else {
            if (DumbService.isDumb((Project)project) || !FileSymbolTablesCache.areSymbolsLoaded(project)) {
                return null;
            }
            String tooLongInlineHeader = OCFileWideHighlighter.findTooLongInlineHeader((ASTNode)file.getNode());
            if (tooLongInlineHeader != null) {
                String[] comps = tooLongInlineHeader.split(":");
                OCLog.LOG.assertTrue(comps.length == 3, (Object)comps.length);
                tooLongInlineHeader = comps[0];
                int length = Integer.parseInt(comps[1]);
                isCodeInsightLimit = Boolean.parseBoolean(comps[2]);
                tooLongInlineHeader = OCInclusionContext.extractPath(tooLongInlineHeader, false).getPath();
                message = isCodeInsightLimit ? OCBundle.message("inspections.fileChecks.headerTooLarge", StringUtil.formatFileSize((long)length), languageName, StringUtil.formatFileSize((long)OCCodeInsightUtil.getMaxFileLength()), tooLongInlineHeader) : OCBundle.message("inspections.fileChecks.headerTooLargePlatform", StringUtil.formatFileSize((long)length), StringUtil.formatFileSize((long)PersistentFSConstants.getMaxIntellisenseFileSize()), tooLongInlineHeader);
            } else {
                return null;
            }
        }
        TextRange range = file.getTextRange();
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(range).fileLevelAnnotation().description(message).create();
        if (info == null) {
            return null;
        }
        if (!isCodeInsightLimit) {
            return info;
        }
        ChangeMaximumFileLengthAction fix = new ChangeMaximumFileLengthAction(languageName);
        info.registerFix((IntentionAction)fix, Collections.emptyList(), fix.getText(), range, null);
        return info;
    }

    private static void adjustMaxFileSize(@NotNull Project project, @Nullable Document document, @NotNull String languageName) {
        OCSymbolTablesBuildingActivity activity;
        int initialValue = OCCodeInsightUtil.getMaxFileLength();
        String result = Messages.showInputDialog((Project)project, (String)OCBundle.message("highlighter.change.file.length.limit.input", languageName), (String)OCBundle.message("highlighter.max.file.length.title", new Object[0]), null, (String)String.valueOf(initialValue), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return StringUtil.parseInt((String)inputString, (int)-1) > 0;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        int newValue = StringUtil.parseInt((String)result, (int)initialValue);
        if (initialValue == newValue) {
            return;
        }
        OCCodeInsightUtil.setMaxFileLength(newValue);
        if (document != null) {
            FileWideHighlighterFactory.clearHighlightings(project, document);
        }
        if ((activity = OCSymbolTablesBuildingActivity.getInstance(project)) != null) {
            activity.rebuildSymbols(OCSymbolTablesBuildingMode.FULL);
        }
    }

    @NlsContexts.DetailedDescription
    public static String getNonProjectText() {
        return OCBundle.message("inspections.fileChecks.outOfProject", new Object[0]);
    }

    private static class ChangeMaximumFileLengthAction
    extends UserDataHolderBase
    implements IntentionAction {
        @NotNull
        @NlsSafe
        private final String myLanguageName;

        private ChangeMaximumFileLengthAction(@NotNull @NlsSafe String languageName) {
            this.myLanguageName = languageName;
            this.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, Boolean.FALSE);
        }

        @NotNull
        public String getText() {
            return OCBundle.message("highlighter.change.file.length.limit", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.myLanguageName;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            OCFileWideHighlighter.adjustMaxFileSize(project, editor != null ? editor.getDocument() : null, this.myLanguageName);
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

