/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class FileWideHighlighterPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private Collection<HighlightInfo> myHighlightInfos = Collections.emptyList();

    public FileWideHighlighterPass(@NotNull PsiFile file, @NotNull Document document) {
        super(file.getProject(), document);
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHighlightInfos = Collections.emptyList();
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        ContainerUtil.addIfNotNull(infos, (Object)FileWideHighlighter.annotateFirst(this.myProject, this.myFile, progress));
        this.myHighlightInfos = infos;
    }

    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), this.myHighlightInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @NotNull
    @TestOnly
    public Collection<HighlightInfo> getHighlightInfos() {
        return this.myHighlightInfos;
    }
}

