/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighterPass;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileWideHighlighterFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Key<Integer> PASS_ID = Key.create((String)"cidr.FileWideHighlighterFactory.passId");

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        int passId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
        PASS_ID.set((UserDataHolder)project, (Object)passId);
    }

    public static void clearHighlightings(@NotNull Project project, @NotNull Document document) {
        Integer passId = (Integer)PASS_ID.get((UserDataHolder)project);
        if (passId == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)project, (Document)document, (int)0, (int)document.getTextLength(), Collections.emptyList(), null, (int)passId);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (FileSymbolTableHelper.isSourceFile(file)) {
            return new FileWideHighlighterPass(file, editor.getDocument());
        }
        return null;
    }
}

