/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandler;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewFileLangBackendHandlerImpl
implements OCNewFileLangBackendHandler {
    private static final String DEFAULT_H_EXT = "h";

    public boolean isProjectLoaded(@NotNull Project project) {
        return FileSymbolTablesCache.areSymbolsLoaded(project);
    }

    @Nullable
    public VirtualFile getVirtualFile(@Nullable PsiFile file) {
        return OCFileUtil.getVirtualFile(file);
    }

    public void handleCreatedFile(@NotNull PsiFile file) {
        if (file instanceof OCFile) {
            FileSymbolTable.forFile(file, OCHeaderContextCache.headerContext(file).derive());
        }
    }

    @Nullable
    public LanguageFileType getFileType() {
        return OCFileType.INSTANCE;
    }

    @Nullable
    public Language getLanguage() {
        return OCLanguageUtils.getConfigLanguage();
    }

    public boolean isCppFileExtension(@NotNull String extension, @NotNull Project project) {
        OCLanguageKind kind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project, extension);
        return kind != null && kind.isCpp();
    }

    @NotNull
    public Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        Project project = sampleFile.getProject();
        if (!(sampleFile instanceof OCFile)) {
            return Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
        }
        OCFile ocFile = (OCFile)sampleFile;
        if (preferredSourceExt == null && preferredHeaderExt == null) {
            if (ocFile.isHeader()) {
                preferredHeaderExt = FileUtilRt.getExtension((String)ocFile.getName());
                OCFile implFile = ocFile.getAssociatedFile();
                if (implFile != null) {
                    preferredSourceExt = FileUtilRt.getExtension((String)implFile.getName());
                }
            } else {
                preferredSourceExt = FileUtilRt.getExtension((String)ocFile.getName());
            }
        }
        if (preferredSourceExt == null) {
            preferredSourceExt = OCNewFileLangBackendHandlerImpl.findSourceExt(project, preferredHeaderExt, ocFile.getKind());
        } else if (preferredHeaderExt == null) {
            preferredHeaderExt = OCNewFileLangBackendHandlerImpl.findHeaderExt(project, preferredSourceExt);
        }
        return Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
    }

    @NotNull
    public String getHeaderGuardStylePattern(@NotNull String filePath, @NotNull Project project) {
        return ((OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class)).HEADER_GUARD_STYLE_PATTERN;
    }

    @NotNull
    private static String findSourceExt(@NotNull Project project, @NotNull String headerExt, @NotNull OCLanguageKind headerKind) {
        for (FileExtensionPair pair : ((OCFileExtensionsSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED) {
            OCLanguageKind sourceKind;
            if (!pair.myHeaderExt.equals(headerExt) || headerKind != (sourceKind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project, "." + pair.mySourceExt))) continue;
            return pair.mySourceExt;
        }
        return headerKind.getDefaultSourceExtension();
    }

    @NotNull
    private static String findHeaderExt(@NotNull Project project, @NotNull String sourceExt) {
        for (FileExtensionPair pair : ((OCFileExtensionsSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED) {
            if (!pair.mySourceExt.equals(sourceExt)) continue;
            return pair.myHeaderExt;
        }
        return DEFAULT_H_EXT;
    }
}

