/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCNewClassSettings;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class OCNewClassAction<T extends CreateClassDialog>
extends OCNewFileActionBase<T> {
    private static final String PUT_IVARS_TO_IMPLEMENTATION_TEMPLATE_PROPERTY = "PUT_IVARS_TO_IMPLEMENTATION";
    public static final String DEFAULT_M_EXT = ".m";
    public static final String DEFAULT_MM_EXT = ".mm";
    public static final String DEFAULT_H_EXT = ".h";

    public OCNewClassAction() {
        this(OCBundle.message("create.class.title", new Object[0]), OCBundle.message("create.class.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
    }

    public OCNewClassAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon) {
        super((FileType)OCFileType.INSTANCE, text, description, icon);
    }

    public OCNewClassAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, Icon icon) {
        super((FileType)OCFileType.INSTANCE, dynamicText, dynamicDescription, icon);
    }

    @NotNull
    protected String getDefaultName() {
        return this.getDefaultClassPrefix();
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(selectedName + ((CreateClassDialog)this.getState().dialogPeer).getImplementationExtension(), selectedName + DEFAULT_H_EXT);
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        OCFile implFile = ((OCFile)sampleFile).isHeader() ? ((OCFile)sampleFile).getAssociatedFile() : (OCFile)sampleFile;
        String extension = implFile != null && implFile.getName().endsWith(DEFAULT_MM_EXT) ? DEFAULT_MM_EXT : DEFAULT_M_EXT;
        return new OCNewFileActionBase.NewFileNames(selectedName + extension, selectedName + DEFAULT_H_EXT);
    }

    protected String getFileTemplate(String fileName) {
        if (fileName.endsWith(DEFAULT_M_EXT) || fileName.endsWith(DEFAULT_MM_EXT)) {
            return "Objective-C Class.m";
        }
        if (fileName.endsWith(DEFAULT_H_EXT)) {
            return "Objective-C Header File.h";
        }
        assert (false);
        return null;
    }

    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        properties.setProperty("HEADER_FILENAME", this.mySelectedName + DEFAULT_H_EXT);
        boolean putToImplementation = OCCompilerFeaturesHelper.supportsIvarsInImplementation() && settings.PUT_IVARS_TO_IMPLEMENTATION;
        properties.setProperty(PUT_IVARS_TO_IMPLEMENTATION_TEMPLATE_PROPERTY, putToImplementation ? "true" : "false");
    }

    @NotNull
    protected T createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return (T)((Object)new CreateClassDialog(defaultName));
    }

    protected class CreateClassDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        private JComboBox<String> myLanguageCombo;

        public CreateClassDialog(String defaultName) {
            super((OCNewFileActionBase)OCNewClassAction.this, OCBundle.message("create.class.dialog.title", new Object[0]), defaultName, null);
        }

        public CreateClassDialog(@NlsContexts.Label String title, String nameFieldTitle, String defaultName) {
            super((OCNewFileActionBase)OCNewClassAction.this, title, nameFieldTitle, defaultName, null);
        }

        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.myLanguageCombo = new ComboBox((Object[])new String[]{OCBundle.message("create.class.objc", new Object[0]), OCBundle.message("create.class.objcpp", new Object[0])});
            formBuilder.addLabeledComponent(OCBundle.message("create.field.language", new Object[0]), this.myLanguageCombo);
            this.myLanguageCombo.setSelectedIndex(OCNewClassSettings.getInstance().myLanguageIndex);
            this.myLanguageCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OCNewClassSettings.getInstance().myLanguageIndex = CreateClassDialog.this.myLanguageCombo.getSelectedIndex();
                    CreateClassDialog.this.validateOkAction();
                }
            });
        }

        protected String getImplementationExtension() {
            return this.myLanguageCombo.getSelectedIndex() == 0 ? OCNewClassAction.DEFAULT_M_EXT : OCNewClassAction.DEFAULT_MM_EXT;
        }
    }
}

